/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class ApplyLU
extends MatrixOperation {
    public static final ApplyLU SETUP = new ApplyLU();
    public static int THRESHOLD = 256;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers, int iterationPoint) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, 1, data[iterationPoint + j * structure].negate(), multipliers, 0, 1, iterationPoint + 1, structure);
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int columnLimit, ComplexNumber[] multipliers, int iterationPoint) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke((Number[])data, (int)(j * structure), (int)1, (Number)data[iterationPoint + j * structure].negate(), (Number[])multipliers, (int)0, (int)1, (int)(iterationPoint + 1), (int)structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers, int iterationPoint) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, 1, -data[iterationPoint + j * structure], multipliers, 0, 1, iterationPoint + 1, structure);
        }
    }

    private ApplyLU() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

