/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.ops.gravitino;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.ObjectIdentifier;
import com.lancedb.lance.namespace.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DeregisterTableResponse;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.namespace.model.RegisterTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableResponse;
import com.lancedb.lance.namespace.util.CommonUtil;
import com.lancedb.lance.namespace.util.JsonArrowSchemaConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.lance.common.ops.LanceTableOperations;
import org.apache.gravitino.lance.common.ops.gravitino.GravitinoLanceNamespaceWrapper;
import org.apache.gravitino.lance.common.ops.gravitino.LanceDataTypeConverter;
import org.apache.gravitino.lance.common.utils.ArrowUtils;
import org.apache.gravitino.lance.common.utils.LancePropertiesUtils;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.types.Type;

public class GravitinoLanceTableOperations
implements LanceTableOperations {
    private final GravitinoLanceNamespaceWrapper namespaceWrapper;

    public GravitinoLanceTableOperations(GravitinoLanceNamespaceWrapper namespaceWrapper) {
        this.namespaceWrapper = namespaceWrapper;
    }

    @Override
    public DescribeTableResponse describeTable(String tableId, String delimiter, Optional<Long> version) {
        if (!version.isEmpty()) {
            throw new UnsupportedOperationException("Describing specific table version is not supported. It should be null to indicate the latest version.");
        }
        ObjectIdentifier nsId = ObjectIdentifier.of((String)tableId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 3 ? 1 : 0) != 0, (String)"Expected at 3-level namespace but got: %s", (int)nsId.levels());
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        NameIdentifier tableIdentifier = NameIdentifier.of((String[])new String[]{nsId.levelAtListPos(1), nsId.levelAtListPos(2)});
        Table table = catalog.asTableCatalog().loadTable(tableIdentifier);
        DescribeTableResponse response = new DescribeTableResponse();
        response.setProperties(table.properties());
        response.setLocation((String)table.properties().get("location"));
        response.setSchema(this.toJsonArrowSchema(table.columns()));
        response.setVersion(null);
        response.setStorageOptions(LancePropertiesUtils.getLanceStorageOptions(table.properties()));
        return response;
    }

    @Override
    public CreateTableResponse createTable(String tableId, CreateTableRequest.ModeEnum mode, String delimiter, String tableLocation, Map<String, String> tableProperties, byte[] arrowStreamBody) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)tableId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 3 ? 1 : 0) != 0, (String)"Expected at 3-level namespace but got: %s", (int)nsId.levels());
        List<Object> columns = Lists.newArrayList();
        if (arrowStreamBody != null) {
            Schema schema = ArrowUtils.parseArrowIpcStream(arrowStreamBody);
            columns = this.extractColumns(schema);
        }
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        NameIdentifier tableIdentifier = NameIdentifier.of((String[])new String[]{nsId.levelAtListPos(1), nsId.levelAtListPos(2)});
        HashMap createTableProperties = Maps.newHashMap(tableProperties);
        if (tableLocation != null) {
            createTableProperties.put("location", tableLocation);
        }
        createTableProperties.put("format", "lance");
        createTableProperties.put("external", "true");
        createTableProperties.put("lance.creation-mode", mode.name());
        Table t = catalog.asTableCatalog().createTable(tableIdentifier, columns.toArray(new Column[0]), null, (Map)createTableProperties);
        CreateTableResponse response = new CreateTableResponse();
        response.setProperties(t.properties());
        response.setLocation(tableLocation);
        response.setStorageOptions(LancePropertiesUtils.getLanceStorageOptions(t.properties()));
        response.setVersion(null);
        response.setLocation((String)t.properties().get("location"));
        response.setProperties(t.properties());
        return response;
    }

    @Override
    public CreateEmptyTableResponse createEmptyTable(String tableId, String delimiter, String tableLocation, Map<String, String> tableProperties) {
        CreateTableResponse response = this.createTable(tableId, CreateTableRequest.ModeEnum.CREATE, delimiter, tableLocation, tableProperties, null);
        CreateEmptyTableResponse emptyTableResponse = new CreateEmptyTableResponse();
        emptyTableResponse.setProperties(response.getProperties());
        emptyTableResponse.setLocation(response.getLocation());
        emptyTableResponse.setStorageOptions(response.getStorageOptions());
        return emptyTableResponse;
    }

    @Override
    public RegisterTableResponse registerTable(String tableId, RegisterTableRequest.ModeEnum mode, String delimiter, Map<String, String> tableProperties) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)tableId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 3 ? 1 : 0) != 0, (String)"Expected at 3-level namespace but got: %s", (int)nsId.levels());
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        NameIdentifier tableIdentifier = NameIdentifier.of((String[])new String[]{nsId.levelAtListPos(1), nsId.levelAtListPos(2)});
        HashMap copiedTableProperties = Maps.newHashMap(tableProperties);
        copiedTableProperties.put("format", "lance");
        copiedTableProperties.put("external", "true");
        copiedTableProperties.put("lance.creation-mode", mode.name());
        Table t = catalog.asTableCatalog().createTable(tableIdentifier, new Column[0], null, (Map)copiedTableProperties);
        RegisterTableResponse response = new RegisterTableResponse();
        response.setProperties(t.properties());
        response.setLocation((String)t.properties().get("location"));
        return response;
    }

    @Override
    public DeregisterTableResponse deregisterTable(String tableId, String delimiter) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)tableId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 3 ? 1 : 0) != 0, (String)"Expected at 3-level namespace but got: %s", (int)nsId.levels());
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        NameIdentifier tableIdentifier = NameIdentifier.of((String[])new String[]{nsId.levelAtListPos(1), nsId.levelAtListPos(2)});
        Table t = catalog.asTableCatalog().loadTable(tableIdentifier);
        Map properties = t.properties();
        boolean result = catalog.asTableCatalog().dropTable(tableIdentifier);
        if (!result) {
            throw LanceNamespaceException.notFound((String)("Table not found: " + tableId), (String)NoSuchTableException.class.getSimpleName(), (String)tableId, (String)CommonUtil.formatCurrentStackTrace());
        }
        DeregisterTableResponse response = new DeregisterTableResponse();
        response.setProperties(properties);
        response.setLocation((String)properties.get("location"));
        response.setId(nsId.listStyleId());
        return response;
    }

    @Override
    public boolean tableExists(String tableId, String delimiter) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)tableId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 3 ? 1 : 0) != 0, (String)"Expected at 3-level namespace but got: %s", (int)nsId.levels());
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        NameIdentifier tableIdentifier = NameIdentifier.of((String[])new String[]{nsId.levelAtListPos(1), nsId.levelAtListPos(2)});
        return catalog.asTableCatalog().tableExists(tableIdentifier);
    }

    @Override
    public DropTableResponse dropTable(String tableId, String delimiter) {
        Table table;
        ObjectIdentifier nsId = ObjectIdentifier.of((String)tableId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 3 ? 1 : 0) != 0, (String)"Expected at 3-level namespace but got: %s", (int)nsId.levels());
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        NameIdentifier tableIdentifier = NameIdentifier.of((String[])new String[]{nsId.levelAtListPos(1), nsId.levelAtListPos(2)});
        try {
            table = catalog.asTableCatalog().loadTable(tableIdentifier);
        }
        catch (NoSuchTableException e) {
            throw LanceNamespaceException.notFound((String)("Table not found: " + tableId), (String)NoSuchTableException.class.getSimpleName(), (String)tableId, (String)CommonUtil.formatCurrentStackTrace());
        }
        boolean deleted = catalog.asTableCatalog().purgeTable(tableIdentifier);
        if (!deleted) {
            throw LanceNamespaceException.notFound((String)("Table not found: " + tableId), (String)NoSuchTableException.class.getSimpleName(), (String)tableId, (String)CommonUtil.formatCurrentStackTrace());
        }
        DropTableResponse response = new DropTableResponse();
        response.setId(nsId.listStyleId());
        response.setLocation((String)table.properties().get("location"));
        response.setProperties(table.properties());
        response.setTransactionId(List.of());
        return response;
    }

    private List<Column> extractColumns(Schema arrowSchema) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Field field : arrowSchema.getFields()) {
            columns.add((Column)Column.of((String)field.getName(), (Type)LanceDataTypeConverter.CONVERTER.toGravitino(field), null, (boolean)field.isNullable(), (boolean)false, (Expression)Column.DEFAULT_VALUE_NOT_SET));
        }
        return columns;
    }

    private JsonArrowSchema toJsonArrowSchema(Column[] columns) {
        List fields = Arrays.stream(columns).map(col -> LanceDataTypeConverter.CONVERTER.toArrowField(col.name(), col.dataType(), col.nullable())).collect(Collectors.toList());
        return JsonArrowSchemaConverter.convertToJsonArrowSchema((Schema)new Schema(fields));
    }
}

