/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.abs.credential;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Context;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import com.azure.storage.file.datalake.sas.PathSasPermission;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.abs.credential.ADLSLocationUtils;
import org.apache.gravitino.credential.ADLSTokenCredential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialGenerator;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.credential.config.AzureCredentialConfig;

public class ADLSTokenGenerator
implements CredentialGenerator<ADLSTokenCredential> {
    private String storageAccountName;
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String endpoint;
    private Integer tokenExpireSecs;

    public void initialize(Map<String, String> properties) {
        AzureCredentialConfig azureCredentialConfig = new AzureCredentialConfig(properties);
        this.storageAccountName = azureCredentialConfig.storageAccountName();
        this.tenantId = azureCredentialConfig.tenantId();
        this.clientId = azureCredentialConfig.clientId();
        this.clientSecret = azureCredentialConfig.clientSecret();
        this.endpoint = String.format("https://%s.%s", this.storageAccountName, "dfs.core.windows.net");
        this.tokenExpireSecs = azureCredentialConfig.adlsTokenExpireInSecs();
    }

    public ADLSTokenCredential generate(CredentialContext context) {
        if (!(context instanceof PathBasedCredentialContext)) {
            return null;
        }
        PathBasedCredentialContext pathContext = (PathBasedCredentialContext)context;
        Set writePaths = pathContext.getWritePaths();
        Set readPaths = pathContext.getReadPaths();
        HashSet combinedPaths = new HashSet(writePaths);
        combinedPaths.addAll(readPaths);
        if (combinedPaths.size() != 1) {
            throw new IllegalArgumentException("ADLS should contain exactly one unique path, but found: " + combinedPaths.size() + " paths: " + String.valueOf(combinedPaths));
        }
        String uniquePath = (String)combinedPaths.iterator().next();
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(this.tenantId)).clientId(this.clientId)).clientSecret(this.clientSecret).build();
        DataLakeServiceClient dataLakeServiceClient = new DataLakeServiceClientBuilder().endpoint(this.endpoint).credential((TokenCredential)clientSecretCredential).buildClient();
        OffsetDateTime start = OffsetDateTime.now();
        OffsetDateTime expiry = OffsetDateTime.now().plusSeconds(this.tokenExpireSecs.intValue());
        UserDelegationKey userDelegationKey = dataLakeServiceClient.getUserDelegationKey(start, expiry);
        PathSasPermission pathSasPermission = new PathSasPermission().setReadPermission(true).setListPermission(true);
        if (!writePaths.isEmpty()) {
            pathSasPermission.setWritePermission(true).setDeletePermission(true).setCreatePermission(true).setAddPermission(true);
        }
        DataLakeServiceSasSignatureValues signatureValues = new DataLakeServiceSasSignatureValues(expiry, pathSasPermission);
        ADLSLocationUtils.ADLSLocationParts locationParts = ADLSLocationUtils.parseLocation(uniquePath);
        String sasToken = new DataLakeSasImplUtil(signatureValues, locationParts.getContainer(), ADLSLocationUtils.trimSlashes(locationParts.getPath()), true).generateUserDelegationSas(userDelegationKey, locationParts.getAccountName(), Context.NONE);
        return new ADLSTokenCredential(locationParts.getAccountName(), sasToken, expiry.toInstant().toEpochMilli());
    }

    public void close() throws IOException {
    }
}

