/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.io.StorageCredential;
import org.apache.iceberg.util.SerializableMap;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableStorageCredential
implements StorageCredential {
    private final String prefix;
    private final Map<String, String> config;

    private ImmutableStorageCredential(String prefix, Map<String, String> config) {
        this.prefix = prefix;
        this.config = config;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public Map<String, String> config() {
        return this.config;
    }

    public final ImmutableStorageCredential withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return ImmutableStorageCredential.validate(new ImmutableStorageCredential(newValue, this.config));
    }

    public final ImmutableStorageCredential withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableStorageCredential.createSerializableMap(true, false, entries);
        return ImmutableStorageCredential.validate(new ImmutableStorageCredential(this.prefix, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStorageCredential && this.equalTo(0, (ImmutableStorageCredential)another);
    }

    private boolean equalTo(int synthetic, ImmutableStorageCredential another) {
        return this.prefix.equals(another.prefix) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.prefix.hashCode();
        h += (h << 5) + this.config.hashCode();
        return h;
    }

    public String toString() {
        return "StorageCredential{prefix=" + this.prefix + ", config=" + String.valueOf(this.config) + "}";
    }

    private static ImmutableStorageCredential validate(ImmutableStorageCredential instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableStorageCredential copyOf(StorageCredential instance) {
        if (instance instanceof ImmutableStorageCredential) {
            return (ImmutableStorageCredential)instance;
        }
        return ImmutableStorageCredential.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableStorageCredential.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createSerializableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>();
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return SerializableMap.copyOf(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private String prefix;
        private Map<String, String> config = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StorageCredential instance) {
            Objects.requireNonNull(instance, "instance");
            this.prefix(instance.prefix());
            this.putAllConfig(instance.config());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(Objects.requireNonNull(key, "config key"), Objects.requireNonNull(value, value == null ? "config value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "config value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config.clear();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "config value for key: " + k : null));
            }
            return this;
        }

        public ImmutableStorageCredential build() {
            if (null == this.prefix) {
                throw new IllegalStateException("Cannot build StorageCredential, some of required attributes are not set: prefix");
            }
            return ImmutableStorageCredential.validate(new ImmutableStorageCredential(this.prefix, ImmutableStorageCredential.createSerializableMap(false, false, this.config)));
        }
    }
}

