/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.runtime.function.internal.CatchHandlerFunction;
import com.googlecode.aviator.runtime.function.internal.IfCallccFunction;
import com.googlecode.aviator.runtime.function.internal.NewInstanceFunction;
import com.googlecode.aviator.runtime.function.internal.ReducerBreakFunction;
import com.googlecode.aviator.runtime.function.internal.ReducerContFunction;
import com.googlecode.aviator.runtime.function.internal.ReducerFunction;
import com.googlecode.aviator.runtime.function.internal.ReducerReturnFunction;
import com.googlecode.aviator.runtime.function.internal.ThrowFunction;
import com.googlecode.aviator.runtime.function.internal.TryCatchFunction;
import com.googlecode.aviator.runtime.function.internal.UseFunction;
import com.googlecode.aviator.runtime.function.system.LoadFunction;
import com.googlecode.aviator.runtime.function.system.RequireFunction;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.utils.IdentityHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public enum Feature {
    Assignment,
    Return(Feature.asList(ReducerReturnFunction.INSTANCE)),
    If(Feature.asList(IfCallccFunction.INSTANCE)),
    ForLoop(Feature.asList(ReducerFunction.INSTANCE, ReducerBreakFunction.INSTANCE, ReducerContFunction.INSTANCE, ReducerReturnFunction.INSTANCE)),
    WhileLoop(Feature.asList(ReducerFunction.INSTANCE, ReducerBreakFunction.INSTANCE, ReducerContFunction.INSTANCE, ReducerReturnFunction.INSTANCE)),
    Let(Feature.asSet(Assignment)),
    LexicalScope,
    Lambda,
    Fn(Feature.asSet(Assignment, Lambda)),
    InternalVars,
    Module(Feature.asList(LoadFunction.INSTANCE, RequireFunction.INSTANCE)),
    ExceptionHandle(Feature.asList(TryCatchFunction.INSTANCE, CatchHandlerFunction.INSTANCE, ThrowFunction.INSTANCE)),
    NewInstance(Feature.asList(NewInstanceFunction.INSTANCE)),
    StringInterpolation(Feature.asSet(InternalVars)),
    Use(Feature.asList(UseFunction.INSTANCE)),
    StaticFields,
    StaticMethods;

    private Set<Feature> prequires = Collections.emptySet();
    private List<AviatorFunction> functions = Collections.emptyList();

    private Feature() {
    }

    private static List<AviatorFunction> asList(AviatorFunction ... args) {
        ArrayList<AviatorFunction> ret = new ArrayList<AviatorFunction>(args.length);
        for (AviatorFunction f : args) {
            ret.add(f);
        }
        return ret;
    }

    private Feature(Set<Feature> prequires) {
        this.prequires = prequires;
    }

    private Feature(List<AviatorFunction> funcs) {
        this.functions = funcs;
    }

    private Feature(Set<Feature> prequires, List<AviatorFunction> funcs) {
        this.prequires = prequires;
        this.functions = funcs;
    }

    public List<AviatorFunction> getFunctions() {
        return this.functions;
    }

    public static Set<Feature> asSet(Feature ... args) {
        IdentityHashSet<Feature> set = new IdentityHashSet<Feature>();
        for (Feature f : args) {
            set.addAll(f.prequires);
            set.add(f);
        }
        return set;
    }

    public Set<Feature> getPrequires() {
        return this.prequires;
    }

    public static Set<Feature> getFullFeatures() {
        return Feature.asSet(Feature.values());
    }

    public static Set<Feature> getCompatibleFeatures() {
        return Feature.asSet(Assignment, Lambda, InternalVars);
    }
}

