/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.autoscaler.state;

import org.apache.flink.api.common.JobID;
import org.apache.flink.autoscaler.JobAutoScalerContext;

import static org.apache.flink.autoscaler.TestingAutoscalerUtils.createDefaultJobAutoScalerContext;

/** Test for {@link InMemoryAutoScalerStateStore}. */
class InMemoryAutoScalerStateStoreTest
        extends AbstractAutoScalerStateStoreTest<JobID, JobAutoScalerContext<JobID>> {

    private InMemoryAutoScalerStateStore<JobID, JobAutoScalerContext<JobID>> stateStore;

    @Override
    protected void preSetup() {
        stateStore = new InMemoryAutoScalerStateStore<>();
    }

    @Override
    protected AutoScalerStateStore<JobID, JobAutoScalerContext<JobID>>
            createPhysicalAutoScalerStateStore() {
        return stateStore;
    }

    @Override
    protected JobAutoScalerContext<JobID> createJobContext() {
        return createDefaultJobAutoScalerContext();
    }
}
