/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.trace;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeLocator;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceTypeRegistry
implements ServiceTypeLocator {
    private final IntHashMap<ServiceType> codeLookupTable;
    private final Map<String, ServiceType> nameLookupTable;
    private final Map<String, List<ServiceType>> descLookupTable;

    private ServiceTypeRegistry(Map<Integer, ServiceType> buildMap) {
        Objects.requireNonNull(buildMap, "buildMap");
        this.codeLookupTable = IntHashMapUtils.copy(buildMap);
        this.nameLookupTable = this.buildNameLookupTable(buildMap.values());
        this.descLookupTable = this.buildDescLookupTable(buildMap.values());
    }

    private Map<String, ServiceType> buildNameLookupTable(Collection<ServiceType> serviceTypes) {
        HashMap<String, ServiceType> copy = new HashMap<String, ServiceType>();
        for (ServiceType serviceType : serviceTypes) {
            ServiceType duplicated = copy.put(serviceType.getName(), serviceType);
            if (duplicated == null) continue;
            throw new IllegalStateException("duplicated ServiceType " + serviceType + " / " + duplicated);
        }
        return copy;
    }

    public ServiceType findServiceType(short code) {
        ServiceType serviceType = (ServiceType)this.codeLookupTable.get((int)code);
        if (serviceType == null) {
            return ServiceType.UNDEFINED;
        }
        return serviceType;
    }

    public ServiceType findServiceTypeByName(String name) {
        ServiceType serviceType = this.nameLookupTable.get(name);
        if (serviceType == null) {
            return ServiceType.UNDEFINED;
        }
        return serviceType;
    }

    public List<ServiceType> findDesc(String desc) {
        Objects.requireNonNull(desc, "desc");
        return this.descLookupTable.get(desc);
    }

    private Map<String, List<ServiceType>> buildDescLookupTable(Collection<ServiceType> serviceTypes) {
        HashMap<String, List<ServiceType>> table = new HashMap<String, List<ServiceType>>();
        for (ServiceType serviceType : serviceTypes) {
            if (!serviceType.isRecordStatistics() && !serviceType.isAlias()) continue;
            List serviceTypeList = table.computeIfAbsent(serviceType.getDesc(), k -> new ArrayList());
            serviceTypeList.add(serviceType);
        }
        return ServiceTypeRegistry.unmodifiableMap(table);
    }

    private static Map<String, List<ServiceType>> unmodifiableMap(Map<String, List<ServiceType>> table) {
        HashMap<String, List<ServiceType>> copy = new HashMap<String, List<ServiceType>>(table.size());
        for (Map.Entry<String, List<ServiceType>> entry : table.entrySet()) {
            List<ServiceType> newValue = Collections.unmodifiableList(entry.getValue());
            copy.put(entry.getKey(), newValue);
        }
        return copy;
    }

    static class Builder {
        private final Map<Integer, ServiceType> buildMap = new HashMap<Integer, ServiceType>();

        Builder() {
        }

        void addServiceType(ServiceType serviceType) {
            Objects.requireNonNull(serviceType, "serviceType");
            short code = serviceType.getCode();
            ServiceType exist = this.buildMap.put(Integer.valueOf(code), serviceType);
            if (exist != null) {
                throw new IllegalStateException("already exist. serviceType:" + serviceType + ", exist:" + exist);
            }
        }

        ServiceTypeRegistry build() {
            return new ServiceTypeRegistry(this.buildMap);
        }
    }
}

