/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.jaeger.KeyValueMarshaler;
import io.opentelemetry.exporter.jaeger.proto.api_v2.internal.Process;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.List;

final class ProcessMarshaler
extends MarshalerWithSize {
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey((String)"service.name");
    private final byte[] serviceNameUtf8;
    private final List<KeyValueMarshaler> tags;

    static ProcessMarshaler create(Resource resource) {
        String serviceName = (String)resource.getAttribute(SERVICE_NAME);
        if (serviceName == null || serviceName.isEmpty()) {
            serviceName = (String)Resource.getDefault().getAttribute(SERVICE_NAME);
        }
        return new ProcessMarshaler(MarshalerUtil.toBytes((String)serviceName), KeyValueMarshaler.createRepeated(resource.getAttributes()));
    }

    ProcessMarshaler(byte[] serviceNameUtf8, List<KeyValueMarshaler> tags) {
        super(ProcessMarshaler.calculateSize(serviceNameUtf8, tags));
        this.serviceNameUtf8 = serviceNameUtf8;
        this.tags = tags;
    }

    protected void writeTo(Serializer output) throws IOException {
        output.serializeString(Process.SERVICE_NAME, this.serviceNameUtf8);
        output.serializeRepeatedMessage(Process.TAGS, this.tags);
    }

    private static int calculateSize(byte[] serviceNameUtf8, List<KeyValueMarshaler> tags) {
        int size = 0;
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)Process.SERVICE_NAME, (byte[])serviceNameUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Process.TAGS, tags);
    }
}

