/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.calcite;

import com.alibaba.druid.DbType;
import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.TDDLHint;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLExtractExpr;
import com.alibaba.druid.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimeExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnnestTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLValuesQuery;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExplainStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.support.calcite.CalciteSqlBasicCall;
import com.alibaba.druid.support.calcite.TDDLSqlSelect;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;

public class CalciteMySqlNodeVisitor
extends MySqlASTVisitorAdapter {
    static Map<Long, SqlOperator> operators = new HashMap<Long, SqlOperator>();
    private SqlNode sqlNode;
    private static Map<Long, SqlTypeName> nameHashCode64SqlTypeNameMapping;
    static long JSON_VALUE;
    static long JSON_OBJECT;
    static long JSON_ARRAY;
    static long JSON_SCALAR;

    static SqlOperator func(long hash) {
        return operators.get(hash);
    }

    public SqlNode getSqlNode() {
        return this.sqlNode;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        SqlNode source;
        SqlNodeList keywords = new SqlNodeList(new ArrayList(), SqlParserPos.ZERO);
        SQLExprTableSource tableSource = x.getTableSource();
        SqlNode targetTable = this.convertToSqlNode(tableSource.getExpr());
        SQLSelect query = x.getQuery();
        if (query != null) {
            query.accept(this);
            source = this.sqlNode;
        } else {
            List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
            SqlNode[] rows = new SqlNode[valuesList.size()];
            for (int j = 0; j < valuesList.size(); ++j) {
                List<SQLExpr> values = valuesList.get(j).getValues();
                SqlNode[] valueNodes = new SqlNode[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    SqlNode valueNode;
                    valueNodes[i] = valueNode = this.convertToSqlNode(values.get(i));
                }
                SqlBasicCall row = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.ROW, valueNodes, SqlParserPos.ZERO);
                rows[j] = row;
            }
            source = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.VALUES, rows, SqlParserPos.ZERO);
        }
        SqlNodeList columnList = x.getColumns().size() > 0 ? this.convertToSqlNodeList(x.getColumns()) : null;
        this.sqlNode = new SqlInsert(SqlParserPos.ZERO, keywords, targetTable, source, columnList);
        return false;
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    private boolean visit(List<SQLInsertStatement.ValuesClause> valuesList) {
        boolean isBatch = false;
        List<SQLInsertStatement.ValuesClause> newValuesList = CalciteMySqlNodeVisitor.convertToSingleValuesIfNeed(valuesList);
        if (newValuesList.size() < valuesList.size()) {
            isBatch = true;
            valuesList = newValuesList;
        }
        SqlNode[] rows = new SqlNode[valuesList.size()];
        for (int j = 0; j < valuesList.size(); ++j) {
            List<SQLExpr> values = valuesList.get(j).getValues();
            SqlNode[] valueNodes = new SqlNode[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                SqlNode valueNode;
                valueNodes[i] = valueNode = this.convertToSqlNode(values.get(i));
            }
            SqlBasicCall row = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.ROW, valueNodes, SqlParserPos.ZERO);
            rows[j] = row;
        }
        this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.VALUES, rows, SqlParserPos.ZERO);
        return isBatch;
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        if (x.getTableSource().getClass() != SQLExprTableSource.class) {
            throw new UnsupportedOperationException("Support single table only for SqlUpdate statement of calcite.");
        }
        SQLExprTableSource tableSource = (SQLExprTableSource)x.getTableSource();
        SqlNode targetTable = this.convertToSqlNode(tableSource.getExpr());
        ArrayList<SqlNode> columns = new ArrayList<SqlNode>();
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        for (SQLUpdateSetItem item : x.getItems()) {
            columns.add(this.convertToSqlNode(item.getColumn()));
            values.add(this.convertToSqlNode(item.getValue()));
        }
        SqlNodeList targetColumnList = new SqlNodeList(columns, SqlParserPos.ZERO);
        SqlNodeList sourceExpressList = new SqlNodeList(values, SqlParserPos.ZERO);
        SqlNode condition = this.convertToSqlNode(x.getWhere());
        SqlIdentifier alias = null;
        if (x.getTableSource().getAlias() != null) {
            alias = new SqlIdentifier(tableSource.getAlias(), SqlParserPos.ZERO);
        }
        this.sqlNode = new SqlUpdate(SqlParserPos.ZERO, targetTable, targetColumnList, sourceExpressList, condition, null, alias);
        return false;
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        SQLExprTableSource tableSource = (SQLExprTableSource)x.getTableSource();
        SqlNode targetTable = this.convertToSqlNode(tableSource.getExpr());
        SqlNode condition = this.convertToSqlNode(x.getWhere());
        SqlIdentifier alias = null;
        if (x.getTableSource().getAlias() != null) {
            alias = new SqlIdentifier(tableSource.getAlias(), SqlParserPos.ZERO);
        }
        this.sqlNode = new SqlDelete(SqlParserPos.ZERO, targetTable, condition, null, alias);
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        SqlNode[] nodes;
        if (x.getRelations().size() > 2) {
            nodes = new SqlNode[x.getRelations().size()];
            for (int i = 0; i < x.getRelations().size(); ++i) {
                nodes[i] = this.convertToSqlNode(x.getRelations().get(i));
            }
        } else {
            SqlNode left = this.convertToSqlNode(x.getLeft());
            SqlNode right = this.convertToSqlNode(x.getRight());
            nodes = new SqlNode[]{left, right};
        }
        SqlNodeList orderBySqlNode = null;
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            orderBySqlNode = this.convertOrderby(orderBy);
        }
        SqlNode offset = null;
        SqlNode fetch = null;
        SQLLimit limit = x.getLimit();
        if (limit != null) {
            offset = this.convertToSqlNode(limit.getOffset());
            fetch = this.convertToSqlNode(limit.getRowCount());
        }
        SQLUnionOperator operator = x.getOperator();
        SqlBasicCall union = null;
        switch (operator) {
            case UNION_ALL: {
                union = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.UNION_ALL, nodes, SqlParserPos.ZERO);
                break;
            }
            case UNION: 
            case DISTINCT: {
                union = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.UNION, nodes, SqlParserPos.ZERO);
                break;
            }
            case INTERSECT: {
                union = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.INTERSECT, nodes, SqlParserPos.ZERO);
                break;
            }
            case EXCEPT: {
                union = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.EXCEPT, nodes, SqlParserPos.ZERO);
                break;
            }
            default: {
                throw new FastsqlException("unsupported join type: " + (Object)((Object)operator));
            }
        }
        if (null == orderBy && null == offset && null == fetch) {
            this.sqlNode = union;
        } else {
            if (orderBySqlNode == null) {
                orderBySqlNode = SqlNodeList.EMPTY;
            }
            this.sqlNode = new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)union, orderBySqlNode, offset, fetch);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        return this.visit((SQLSelectQueryBlock)x);
    }

    public boolean visit(SQLTableSource x) {
        Class<?> clazz = x.getClass();
        if (clazz == SQLJoinTableSource.class) {
            this.visit((SQLJoinTableSource)x);
        } else if (clazz == SQLExprTableSource.class) {
            this.visit((SQLExprTableSource)x);
        } else if (clazz == SQLSubqueryTableSource.class) {
            this.visit((SQLSubqueryTableSource)x);
        } else {
            x.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SqlIdentifier table;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIdentifierExpr) {
            table = this.buildIdentifier((SQLIdentifierExpr)expr);
        } else if (expr instanceof SQLPropertyExpr) {
            table = this.buildIdentifier((SQLPropertyExpr)expr);
        } else {
            throw new FastsqlException("not support : " + expr);
        }
        if (x.getAlias() != null) {
            SqlIdentifier alias = new SqlIdentifier(x.computeAlias(), SqlParserPos.ZERO);
            SqlBasicCall as = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{table, alias}, SqlParserPos.ZERO);
            this.sqlNode = as;
        } else {
            this.sqlNode = table;
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        SqlLiteral conditionType;
        SQLJoinTableSource.JoinType joinType = x.getJoinType();
        SqlNode left = this.convertToSqlNode(x.getLeft());
        SqlNode right = this.convertToSqlNode(x.getRight());
        SqlNode condition = this.convertToSqlNode(x.getCondition());
        SqlLiteral sqlLiteral = conditionType = condition == null ? JoinConditionType.NONE.symbol(SqlParserPos.ZERO) : JoinConditionType.ON.symbol(SqlParserPos.ZERO);
        if (condition == null && !x.getUsing().isEmpty()) {
            List<SQLExpr> using = x.getUsing();
            conditionType = JoinConditionType.USING.symbol(SqlParserPos.ZERO);
            condition = this.convertToSqlNodeList(x.getUsing());
        }
        switch (joinType) {
            case COMMA: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                break;
            }
            case JOIN: 
            case INNER_JOIN: {
                if (condition == null) {
                    this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), right, conditionType, null);
                    break;
                }
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.INNER.symbol(SqlParserPos.ZERO), right, conditionType, condition);
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.LEFT.symbol(SqlParserPos.ZERO), right, conditionType, condition);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.RIGHT.symbol(SqlParserPos.ZERO), right, conditionType, condition);
                break;
            }
            case NATURAL_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                break;
            }
            case CROSS_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.CROSS.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                break;
            }
            case NATURAL_CROSS_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO), JoinType.CROSS.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                break;
            }
            case FULL_OUTER_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.FULL.symbol(SqlParserPos.ZERO), right, condition == null ? JoinConditionType.NONE.symbol(SqlParserPos.ZERO) : conditionType, condition);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported : " + (Object)((Object)joinType));
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.sqlNode = this.convertToSqlNode(x.getSelect());
        String alias = x.getAlias();
        if (alias != null) {
            SqlNode[] operands;
            SqlIdentifier aliasIdentifier = new SqlIdentifier(alias, SqlParserPos.ZERO);
            List<SQLName> columns = x.getColumns();
            if (columns.isEmpty()) {
                operands = new SqlNode[]{this.sqlNode, aliasIdentifier};
            } else {
                operands = new SqlNode[columns.size() + 2];
                operands[0] = this.sqlNode;
                operands[1] = aliasIdentifier;
                for (int i = 0; i < columns.size(); ++i) {
                    SQLName column = columns.get(i);
                    operands[i + 2] = new SqlIdentifier(SQLUtils.normalize(column.getSimpleName()), SqlParserPos.ZERO);
                }
            }
            this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, operands, SqlParserPos.ZERO);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        x.getUnion().accept(this);
        String alias = x.getAlias();
        if (alias != null) {
            SqlIdentifier aliasIdentifier = new SqlIdentifier(alias, SqlParserPos.ZERO);
            this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{this.sqlNode, aliasIdentifier}, SqlParserPos.ZERO);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        SqlNode left = this.convertToSqlNode(x.getExpr());
        SqlBinaryOperator subOperator = SqlStdOperatorTable.IN;
        if (x.isNot()) {
            subOperator = SqlStdOperatorTable.NOT_IN;
        }
        SqlNode right = this.convertToSqlNode(x.subQuery);
        this.sqlNode = new SqlBasicCall((SqlOperator)subOperator, new SqlNode[]{left, right}, SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SqlNodeList keywordList = null;
        ArrayList<SqlLiteral> keywordNodes = new ArrayList<SqlLiteral>(5);
        int option = x.getDistionOption();
        if (option != 0) {
            if (option == 2 || option == 4) {
                keywordNodes.add(SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO));
            } else if (option == 1) {
                keywordNodes.add(SqlSelectKeyword.ALL.symbol(SqlParserPos.ZERO));
            }
            keywordList = new SqlNodeList(keywordNodes, SqlParserPos.ZERO);
        }
        ArrayList<SqlNode> columnNodes = new ArrayList<SqlNode>(x.getSelectList().size());
        for (SQLSelectItem selectItem : x.getSelectList()) {
            SqlNode column = this.convertToSqlNode(selectItem);
            columnNodes.add(column);
        }
        SqlNodeList selectList = new SqlNodeList(columnNodes, SqlParserPos.ZERO);
        SqlNode from = null;
        SQLTableSource tableSource = x.getFrom();
        if (tableSource != null) {
            from = this.convertToSqlNode(tableSource);
        }
        SqlNode where = this.convertToSqlNode(x.getWhere());
        SqlNodeList orderBySqlNode = null;
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            orderBySqlNode = this.convertOrderby(orderBy);
        }
        SqlNodeList groupBySqlNode = null;
        SqlNode having = null;
        SQLSelectGroupByClause groupBys = x.getGroupBy();
        if (groupBys != null) {
            if (groupBys.getHaving() != null) {
                having = this.convertToSqlNode(groupBys.getHaving());
            }
            if (groupBys.getItems().size() > 0) {
                ArrayList<SqlNode> groupByNodes = new ArrayList<SqlNode>(groupBys.getItems().size());
                for (SQLExpr groupBy : groupBys.getItems()) {
                    SqlNode groupByNode = this.convertToSqlNode(groupBy);
                    groupByNodes.add(groupByNode);
                }
                groupBySqlNode = new SqlNodeList(groupByNodes, SqlParserPos.ZERO);
            }
            SqlInternalOperator op = null;
            if (groupBys.isWithRollUp()) {
                op = SqlStdOperatorTable.ROLLUP;
            } else if (groupBys.isWithCube()) {
                op = SqlStdOperatorTable.CUBE;
            }
            if (op != null) {
                ArrayList<SqlCall> rollupNodes = new ArrayList<SqlCall>(1);
                boolean isRow = false;
                for (SqlNode node : groupBySqlNode.getList()) {
                    if (!(node instanceof SqlBasicCall) || ((SqlBasicCall)node).getOperator() != SqlStdOperatorTable.ROW) continue;
                    isRow = true;
                    break;
                }
                if (isRow) {
                    rollupNodes.add(op.createCall(SqlParserPos.ZERO, groupBySqlNode.toArray()));
                    groupBySqlNode = new SqlNodeList(rollupNodes, SqlParserPos.ZERO);
                } else {
                    rollupNodes.add(op.createCall(SqlParserPos.ZERO, new SqlNode[]{groupBySqlNode}));
                    groupBySqlNode = new SqlNodeList(rollupNodes, SqlParserPos.ZERO);
                }
            }
        }
        SqlNode offset = null;
        SqlNode fetch = null;
        SQLLimit limit = x.getLimit();
        if (limit != null) {
            offset = this.convertToSqlNode(limit.getOffset());
            fetch = this.convertToSqlNode(limit.getRowCount());
        }
        SqlNodeList hints = this.convertHints(x.getHints());
        if (orderBy != null && x.getParent() instanceof SQLUnionQuery) {
            this.sqlNode = new TDDLSqlSelect(SqlParserPos.ZERO, keywordList, selectList, from, where, groupBySqlNode, having, null, null, offset, fetch, hints, null);
            this.sqlNode = new SqlOrderBy(SqlParserPos.ZERO, this.sqlNode, orderBySqlNode, null, fetch);
        } else {
            if (orderBySqlNode == null) {
                orderBySqlNode = SqlNodeList.EMPTY;
            }
            if (hints == null || SqlNodeList.isEmptyList((SqlNode)hints)) {
                this.sqlNode = new SqlSelect(SqlParserPos.ZERO, keywordList, selectList, from, where, groupBySqlNode, having, null, SqlNodeList.EMPTY, null, null, null);
                if (!SqlNodeList.isEmptyList((SqlNode)orderBySqlNode) || offset != null || fetch != null) {
                    this.sqlNode = new SqlOrderBy(SqlParserPos.ZERO, this.sqlNode, orderBySqlNode, offset, fetch);
                }
            } else {
                this.sqlNode = new TDDLSqlSelect(SqlParserPos.ZERO, keywordList, selectList, from, where, groupBySqlNode, having, null, orderBySqlNode, offset, fetch, hints, null);
            }
        }
        return false;
    }

    private SqlTypeName toSqlTypeName(SQLDataType dataType) {
        long nameHashCode64 = dataType.nameHashCode64();
        SqlTypeName sqlTypeName = nameHashCode64SqlTypeNameMapping.get(nameHashCode64);
        if (sqlTypeName != null) {
            return sqlTypeName;
        }
        throw new FastsqlException("TODO");
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        SqlLiteral functionQualifier = null;
        SqlNode sqlNode = this.convertToSqlNode(x.getExpr());
        SQLDataType dataType = x.getDataType();
        String typeName = dataType.getName().toUpperCase();
        if (dataType.nameHashCode64() == FnvHash.Constants.INT) {
            typeName = "INTEGER";
        } else if (dataType.nameHashCode64() == FnvHash.Constants.NUMERIC) {
            typeName = "DECIMAL";
        }
        SqlIdentifier dataTypeNode = (SqlIdentifier)this.convertToSqlNode(new SQLIdentifierExpr(typeName));
        int scale = -1;
        int precision = -1;
        List<SQLExpr> arguments = dataType.getArguments();
        if (arguments != null && !arguments.isEmpty()) {
            scale = ((SQLNumericLiteralExpr)arguments.get(0)).getNumber().intValue();
            if (arguments.size() > 1) {
                precision = ((SQLNumericLiteralExpr)arguments.get(1)).getNumber().intValue();
            }
        }
        SqlDataTypeSpec sqlDataTypeSpec = new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(this.toSqlTypeName(dataType), scale, precision, SqlParserPos.ZERO), SqlParserPos.ZERO);
        SqlCastFunction sqlOperator = new SqlCastFunction();
        this.sqlNode = new CalciteSqlBasicCall((SqlOperator)sqlOperator, new SqlNode[]{sqlNode, sqlDataTypeSpec}, SqlParserPos.ZERO, false, functionQualifier);
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        SQLExpr valueExpr = x.getValueExpr();
        SqlNode nodeValue = null;
        SqlNodeList nodeWhen = new SqlNodeList(SqlParserPos.ZERO);
        SqlNodeList nodeThen = new SqlNodeList(SqlParserPos.ZERO);
        if (valueExpr != null) {
            nodeValue = this.convertToSqlNode(valueExpr);
        }
        List<SQLCaseExpr.Item> items = x.getItems();
        int size = items.size();
        for (int elExpr = 0; elExpr < size; ++elExpr) {
            this.visit(items.get(elExpr));
            if (this.sqlNode == null || !(this.sqlNode instanceof SqlNodeList)) continue;
            SqlNodeList nodeListTemp = (SqlNodeList)this.sqlNode;
            nodeWhen.add(nodeListTemp.get(0));
            nodeThen.add(nodeListTemp.get(1));
        }
        SQLExpr elseExpr = x.getElseExpr();
        SqlNode nodeElse = this.convertToSqlNode(elseExpr);
        SqlNodeList sqlNodeList = new SqlNodeList(SqlParserPos.ZERO);
        sqlNodeList.add(nodeValue);
        sqlNodeList.add((SqlNode)nodeWhen);
        sqlNodeList.add((SqlNode)nodeThen);
        sqlNodeList.add(nodeElse);
        this.sqlNode = SqlCase.createSwitched((SqlParserPos)SqlParserPos.ZERO, (SqlNode)nodeValue, (SqlNodeList)nodeWhen, (SqlNodeList)nodeThen, (SqlNode)nodeElse);
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr.Item x) {
        SQLExpr conditionExpr = x.getConditionExpr();
        SqlNode sqlNode1 = this.convertToSqlNode(conditionExpr);
        SQLExpr valueExpr = x.getValueExpr();
        SqlNode sqlNode2 = this.convertToSqlNode(valueExpr);
        SqlNodeList sqlNodeList = new SqlNodeList(SqlParserPos.ZERO);
        sqlNodeList.add(sqlNode1);
        sqlNodeList.add(sqlNode2);
        this.sqlNode = sqlNodeList;
        return false;
    }

    @Override
    public boolean visit(SQLListExpr x) {
        List<SQLExpr> items = x.getItems();
        ArrayList<SqlNode> objects = new ArrayList<SqlNode>();
        for (int i = 0; i < items.size(); ++i) {
            SQLExpr sqlExpr = items.get(i);
            SqlNode sqlNode = this.convertToSqlNode(sqlExpr);
            objects.add(sqlNode);
        }
        this.sqlNode = SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, objects);
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            SqlNodeList withList = new SqlNodeList(SqlParserPos.ZERO);
            List<SQLWithSubqueryClause.Entry> entries = with.getEntries();
            for (SQLWithSubqueryClause.Entry entry : entries) {
                this.visit(entry);
                withList.add(this.sqlNode);
            }
            SqlNode query = this.convertToSqlNode(x.getQuery());
            if (query instanceof SqlOrderBy) {
                SqlOrderBy orderBy = (SqlOrderBy)query;
                SqlWith w = new SqlWith(SqlParserPos.ZERO, withList, orderBy.query);
                this.sqlNode = new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)w, orderBy.orderList, orderBy.offset, orderBy.fetch);
            } else {
                this.sqlNode = new SqlWith(SqlParserPos.ZERO, withList, query);
            }
            if (query instanceof SqlSelect) {
                SqlSelect select = (SqlSelect)query;
                SqlNode fetch = select.getFetch();
                SqlNodeList orderList = select.getOrderList();
                if (fetch != null || orderList != null && orderList.size() > 0) {
                    SqlNodeList orderByList = null;
                    if (orderList != null) {
                        orderByList = new SqlNodeList((Collection)orderList.getList(), SqlParserPos.ZERO);
                        orderList.getList().clear();
                    } else {
                        orderByList = SqlNodeList.EMPTY;
                    }
                    this.sqlNode = new SqlOrderBy(SqlParserPos.ZERO, this.sqlNode, orderByList, null, fetch);
                    if (fetch != null) {
                        select.setFetch(null);
                    }
                }
            }
        } else {
            this.sqlNode = this.convertToSqlNode(x.getQuery());
        }
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        SqlNodeList columnList = null;
        List<SQLName> columns = x.getColumns();
        if (columns.size() > 0) {
            columnList = new SqlNodeList(SqlParserPos.ZERO);
            for (SQLName column : columns) {
                columnList.add((SqlNode)new SqlIdentifier(column.getSimpleName(), SqlParserPos.ZERO));
            }
        }
        SqlNode query = this.convertToSqlNode(x.getSubQuery());
        SqlIdentifier name = new SqlIdentifier(x.getAlias(), SqlParserPos.ZERO);
        this.sqlNode = new SqlWithItem(SqlParserPos.ZERO, name, columnList, query);
        return false;
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        SqlNode sqlNode = this.convertToSqlNode(x.getSelect());
        if (sqlNode instanceof TDDLSqlSelect) {
            TDDLSqlSelect select = (TDDLSqlSelect)sqlNode;
            SqlNodeList headHints = this.convertHints(x.getHeadHintsDirect());
            select.setHeadHints(headHints);
            this.sqlNode = select;
        } else {
            this.sqlNode = sqlNode;
        }
        return false;
    }

    protected void visit(SQLSelectQuery x) {
        Class<?> clazz = x.getClass();
        if (clazz == MySqlSelectQueryBlock.class) {
            this.visit((MySqlSelectQueryBlock)x);
        } else if (clazz == SQLUnionQuery.class) {
            this.visit((SQLUnionQuery)x);
        } else {
            x.accept(this);
        }
    }

    @Override
    public boolean visit(SQLAllExpr x) {
        this.sqlNode = this.convertToSqlNode(x.getSubQuery());
        return false;
    }

    @Override
    public boolean visit(SQLAnyExpr x) {
        this.sqlNode = this.convertToSqlNode(x.getSubQuery());
        return false;
    }

    private boolean isSqlAllExpr(SQLExpr x) {
        return x.getClass() == SQLAllExpr.class;
    }

    private boolean isAnyOrSomeExpr(SQLExpr x) {
        return x.getClass() == SQLAnyExpr.class || x.getClass() == SQLSomeExpr.class;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIdentifierExpr) {
            this.visit((SQLIdentifierExpr)expr);
        } else if (expr instanceof SQLPropertyExpr) {
            this.visit((SQLPropertyExpr)expr);
        } else if (expr instanceof SQLAggregateExpr) {
            this.visit((SQLAggregateExpr)expr);
        } else {
            expr.accept(this);
        }
        String alias = x.getAlias();
        if (alias != null && alias.length() > 0) {
            String alias2 = x.getAlias2();
            this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{this.sqlNode, new SqlIdentifier(SQLUtils.normalize(alias2, DbType.mysql), SqlParserPos.ZERO)}, SqlParserPos.ZERO);
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        if (x.getName().equalsIgnoreCase("unknown")) {
            this.sqlNode = SqlLiteral.createUnknown((SqlParserPos)SqlParserPos.ZERO);
            return false;
        }
        this.sqlNode = this.buildIdentifier(x);
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        this.sqlNode = this.buildIdentifier(x);
        return false;
    }

    SqlIdentifier buildIdentifier(SQLIdentifierExpr x) {
        return new SqlIdentifier(SQLUtils.normalize(x.getName()), SqlParserPos.ZERO);
    }

    SqlIdentifier buildIdentifier(SQLPropertyExpr x) {
        List<String> names;
        SQLExpr owner;
        String name = SQLUtils.normalize(x.getName());
        if ("*".equals(name)) {
            name = "";
        }
        if ((owner = x.getOwner()) instanceof SQLIdentifierExpr) {
            names = Arrays.asList(((SQLIdentifierExpr)owner).normalizedName(), name);
        } else if (owner instanceof SQLPropertyExpr) {
            names = new ArrayList<String>();
            this.buildIdentifier((SQLPropertyExpr)owner, names);
            names.add(name);
        } else {
            throw new FastsqlException("not support : " + owner);
        }
        return new SqlIdentifier(names, SqlParserPos.ZERO);
    }

    void buildIdentifier(SQLPropertyExpr x, List<String> names) {
        String name = SQLUtils.normalize(x.getName());
        SQLExpr owner = x.getOwner();
        if (owner instanceof SQLIdentifierExpr) {
            names.add(((SQLIdentifierExpr)owner).normalizedName());
        } else if (owner instanceof SQLPropertyExpr) {
            this.buildIdentifier((SQLPropertyExpr)owner, names);
        } else {
            throw new FastsqlException("not support : " + owner);
        }
        names.add(name);
    }

    @Override
    public boolean visit(SQLBinaryOpExprGroup x) {
        SqlBinaryOperator operator = null;
        switch (x.getOperator()) {
            case BooleanAnd: {
                operator = SqlStdOperatorTable.AND;
                break;
            }
            case BooleanOr: {
                operator = SqlStdOperatorTable.OR;
                break;
            }
        }
        List<SQLExpr> items = x.getItems();
        Object group = null;
        for (int i = 0; i < items.size(); ++i) {
            SQLExpr item = items.get(i);
            SqlNode calciteNode = this.convertToSqlNode(item);
            group = group == null ? calciteNode : new SqlBasicCall((SqlOperator)operator, new SqlNode[]{group, calciteNode}, SqlParserPos.ZERO);
        }
        this.sqlNode = group;
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SqlBinaryOperator operator = null;
        SqlQuantifyOperator someOrAllOperator = null;
        SqlNode left = this.convertToSqlNode(x.getLeft());
        SQLExpr rightExpr = x.getRight();
        SqlNode right = this.convertToSqlNode(rightExpr);
        switch (x.getOperator()) {
            case Equality: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_EQ;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_EQ;
                    break;
                }
                operator = SqlStdOperatorTable.EQUALS;
                break;
            }
            case GreaterThan: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_GT;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_GT;
                    break;
                }
                operator = SqlStdOperatorTable.GREATER_THAN;
                break;
            }
            case GreaterThanOrEqual: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_GE;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_GE;
                    break;
                }
                operator = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                break;
            }
            case LessThan: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_LT;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_LT;
                    break;
                }
                operator = SqlStdOperatorTable.LESS_THAN;
                break;
            }
            case LessThanOrEqual: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_LE;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_LE;
                    break;
                }
                operator = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_NE;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_NE;
                    break;
                }
                operator = SqlStdOperatorTable.NOT_EQUALS;
                break;
            }
            case Add: {
                operator = SqlStdOperatorTable.PLUS;
                break;
            }
            case Subtract: {
                operator = SqlStdOperatorTable.MINUS;
                break;
            }
            case Multiply: {
                operator = SqlStdOperatorTable.MULTIPLY;
                break;
            }
            case Divide: {
                operator = SqlStdOperatorTable.DIVIDE;
                break;
            }
            case Modulus: {
                operator = SqlStdOperatorTable.MOD;
                break;
            }
            case Like: {
                operator = SqlStdOperatorTable.LIKE;
                break;
            }
            case NotLike: {
                operator = SqlStdOperatorTable.NOT_LIKE;
                break;
            }
            case BooleanAnd: {
                operator = SqlStdOperatorTable.AND;
                break;
            }
            case BooleanOr: {
                operator = SqlStdOperatorTable.OR;
                break;
            }
            case Concat: {
                operator = SqlStdOperatorTable.CONCAT;
                break;
            }
            case Is: {
                if (rightExpr instanceof SQLNullExpr) {
                    operator = SqlStdOperatorTable.IS_NULL;
                    break;
                }
                if (rightExpr instanceof SQLIdentifierExpr) {
                    long hashCode64 = ((SQLIdentifierExpr)rightExpr).nameHashCode64();
                    if (hashCode64 == FnvHash.Constants.JSON || hashCode64 == JSON_VALUE) {
                        operator = SqlStdOperatorTable.IS_JSON_VALUE;
                        break;
                    }
                    if (hashCode64 == JSON_OBJECT) {
                        operator = SqlStdOperatorTable.IS_JSON_OBJECT;
                        break;
                    }
                    if (hashCode64 == JSON_ARRAY) {
                        operator = SqlStdOperatorTable.IS_JSON_ARRAY;
                        break;
                    }
                    if (hashCode64 == JSON_SCALAR) {
                        operator = SqlStdOperatorTable.IS_JSON_SCALAR;
                        break;
                    }
                    if (hashCode64 != FnvHash.Constants.UNKNOWN) break;
                    operator = SqlStdOperatorTable.IS_UNKNOWN;
                    break;
                }
                if (!(rightExpr instanceof SQLBooleanExpr)) break;
                if (((SQLBooleanExpr)rightExpr).getValue().booleanValue()) {
                    operator = SqlStdOperatorTable.IS_TRUE;
                    break;
                }
                operator = SqlStdOperatorTable.IS_FALSE;
                break;
            }
            case IsNot: {
                if (rightExpr instanceof SQLNullExpr) {
                    operator = SqlStdOperatorTable.IS_NOT_NULL;
                    break;
                }
                if (rightExpr instanceof SQLIdentifierExpr) {
                    long hashCode64 = ((SQLIdentifierExpr)rightExpr).nameHashCode64();
                    if (hashCode64 == FnvHash.Constants.JSON || hashCode64 == JSON_VALUE) {
                        operator = SqlStdOperatorTable.IS_NOT_JSON_VALUE;
                        break;
                    }
                    if (hashCode64 == JSON_OBJECT) {
                        operator = SqlStdOperatorTable.IS_NOT_JSON_OBJECT;
                        break;
                    }
                    if (hashCode64 == JSON_ARRAY) {
                        operator = SqlStdOperatorTable.IS_NOT_JSON_ARRAY;
                        break;
                    }
                    if (hashCode64 == JSON_SCALAR) {
                        operator = SqlStdOperatorTable.IS_NOT_JSON_SCALAR;
                        break;
                    }
                    if (hashCode64 != FnvHash.Constants.UNKNOWN) break;
                    operator = SqlStdOperatorTable.IS_NOT_UNKNOWN;
                    break;
                }
                if (!(rightExpr instanceof SQLBooleanExpr)) break;
                if (((SQLBooleanExpr)rightExpr).getValue().booleanValue()) {
                    operator = SqlStdOperatorTable.IS_NOT_TRUE;
                    break;
                }
                operator = SqlStdOperatorTable.IS_NOT_FALSE;
                break;
            }
            case Escape: {
                SqlBasicCall like = (SqlBasicCall)left;
                this.sqlNode = new SqlBasicCall(like.getOperator(), new SqlNode[]{like.operands[0], like.operands[1], right}, SqlParserPos.ZERO);
                return false;
            }
            default: {
                throw new FastsqlException("not support " + (Object)((Object)x.getOperator()));
            }
        }
        this.sqlNode = someOrAllOperator != null ? new SqlBasicCall((SqlOperator)someOrAllOperator, new SqlNode[]{left, right}, SqlParserPos.ZERO) : (operator == SqlStdOperatorTable.IS_NULL || operator == SqlStdOperatorTable.IS_NOT_NULL || operator == SqlStdOperatorTable.IS_TRUE || operator == SqlStdOperatorTable.IS_NOT_TRUE ? new SqlBasicCall((SqlOperator)operator, new SqlNode[]{left}, SqlParserPos.ZERO) : new SqlBasicCall((SqlOperator)operator, new SqlNode[]{left, right}, SqlParserPos.ZERO));
        return false;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        SQLExpr testExpr = x.getTestExpr();
        SqlBetweenOperator sqlOperator = SqlStdOperatorTable.BETWEEN;
        if (x.isNot()) {
            sqlOperator = SqlStdOperatorTable.NOT_BETWEEN;
        }
        SqlNode sqlNode = this.convertToSqlNode(testExpr);
        SqlNode sqlNodeBegin = this.convertToSqlNode(x.getBeginExpr());
        SqlNode sqlNodeEnd = this.convertToSqlNode(x.getEndExpr());
        ArrayList<SqlNode> sqlNodes = new ArrayList<SqlNode>(3);
        sqlNodes.add(sqlNode);
        sqlNodes.add(sqlNodeBegin);
        sqlNodes.add(sqlNodeEnd);
        this.sqlNode = new SqlBasicCall((SqlOperator)sqlOperator, SqlParserUtil.toNodeArray(sqlNodes), SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        SqlPrefixOperator sqlOperator = SqlStdOperatorTable.EXISTS;
        SqlCall sqlNode = sqlOperator.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNode(x.getSubQuery())});
        if (x.isNot()) {
            sqlNode = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, new SqlNode[]{sqlNode});
        }
        this.sqlNode = sqlNode;
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.sqlNode = new SqlIdentifier(Arrays.asList(""), SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        String text = x.getText();
        text = text.replaceAll("\\\\", "\\\\\\\\");
        this.sqlNode = SqlLiteral.createCharString((String)text, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        String text = x.getText();
        text = text.replaceAll("\\\\", "\\\\\\\\");
        this.sqlNode = SqlLiteral.createCharString((String)text, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.sqlNode = SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        this.sqlNode = SqlLiteral.createExactNumeric((String)x.getNumber().toString(), (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLBooleanExpr x) {
        this.sqlNode = SqlLiteral.createBoolean((boolean)x.getBooleanValue(), (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        String str = x.toString();
        this.sqlNode = str.indexOf(69) > 0 || str.indexOf(101) > 0 ? SqlLiteral.createApproxNumeric((String)str, (SqlParserPos)SqlParserPos.ZERO) : SqlLiteral.createExactNumeric((String)str, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLTimestampExpr x) {
        char c3;
        String literal = x.getLiteral();
        int precision = 0;
        if (literal.endsWith("00") && (c3 = literal.charAt(literal.length() - 3)) >= '0' && c3 <= '9') {
            literal = literal.substring(0, literal.length() - 2);
            precision = 3;
        }
        TimestampString ts = new TimestampString(literal);
        this.sqlNode = SqlLiteral.createTimestamp((TimestampString)ts, (int)precision, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLDateExpr x) {
        String literal = x.getLiteral();
        DateString ds = new DateString(literal);
        this.sqlNode = SqlLiteral.createDate((DateString)ds, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLTimeExpr x) {
        String literal = ((SQLCharExpr)x.getLiteral()).getText();
        TimeString ds = new TimeString(literal);
        this.sqlNode = SqlLiteral.createTime((TimeString)ds, (int)0, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLCurrentTimeExpr x) {
        this.sqlNode = new SqlIdentifier(x.getType().name, SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        SQLExpr filter;
        SQLOver over;
        String methodName = x.getMethodName();
        long hashCode64 = x.methodNameHashCode64();
        SqlOperator functionOperator = CalciteMySqlNodeVisitor.func(hashCode64);
        if (functionOperator == null) {
            functionOperator = new SqlUnresolvedFunction(new SqlIdentifier(methodName, SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }
        SqlLiteral functionQualifier = null;
        if (x.getOption() == SQLAggregateOption.DISTINCT) {
            functionQualifier = SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO);
        }
        List<SQLExpr> arguments = x.getArguments();
        ArrayList<SqlNode> argNodes = new ArrayList<SqlNode>(arguments.size());
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            argNodes.add(this.convertToSqlNode(arguments.get(i)));
        }
        this.sqlNode = functionOperator.createCall(functionQualifier, SqlParserPos.ZERO, SqlParserUtil.toNodeArray(argNodes));
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            SqlNodeList orderByItems = this.convertOrderby(orderBy);
            this.sqlNode = SqlStdOperatorTable.WITHIN_GROUP.createCall(SqlParserPos.ZERO, new SqlNode[]{this.sqlNode, orderByItems});
        }
        if ((over = x.getOver()) != null) {
            SqlNode lowerBound;
            boolean isRow;
            SqlNode aggNode = this.sqlNode;
            SQLOver.WindowingBound windowingBetweenBeginBound = over.getWindowingBetweenBeginBound();
            SQLOver.WindowingBound windowingBetweenEndBound = over.getWindowingBetweenEndBound();
            boolean bl = isRow = over.getWindowingType() != SQLOver.WindowingType.RANGE;
            if (over.getWindowingBetweenBegin() != null) {
                over.getWindowingBetweenBegin().accept(this);
                lowerBound = SqlWindow.createPreceding((SqlNode)this.sqlNode, (SqlParserPos)SqlParserPos.ZERO);
            } else {
                lowerBound = CalciteMySqlNodeVisitor.createSymbol(windowingBetweenBeginBound);
            }
            SqlNode upperBound = CalciteMySqlNodeVisitor.createSymbol(windowingBetweenEndBound);
            SqlWindow window = new SqlWindow(SqlParserPos.ZERO, null, null, this.convertToSqlNodeList(over.getPartitionBy()), this.convertOrderby(over.getOrderBy()), SqlLiteral.createBoolean((boolean)isRow, (SqlParserPos)SqlParserPos.ZERO), lowerBound, upperBound, null);
            this.sqlNode = SqlStdOperatorTable.OVER.createCall(SqlParserPos.ZERO, new SqlNode[]{aggNode, window});
        }
        if ((filter = x.getFilter()) != null) {
            SqlNode aggNode = this.sqlNode;
            filter.accept(this);
            this.sqlNode = SqlStdOperatorTable.FILTER.createCall(SqlParserPos.ZERO, new SqlNode[]{aggNode, this.sqlNode});
        }
        return false;
    }

    protected static SqlNode createSymbol(SQLOver.WindowingBound bound) {
        if (bound == null) {
            return null;
        }
        switch (bound) {
            case CURRENT_ROW: {
                return SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO);
            }
            case UNBOUNDED_FOLLOWING: {
                return SqlWindow.createUnboundedFollowing((SqlParserPos)SqlParserPos.ZERO);
            }
            case UNBOUNDED_PRECEDING: {
                return SqlWindow.createUnboundedPreceding((SqlParserPos)SqlParserPos.ZERO);
            }
        }
        return null;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        ArrayList<Object> argNodes = new ArrayList<Object>(arguments.size());
        long nameHashCode64 = x.methodNameHashCode64();
        SqlOperator functionOperator = CalciteMySqlNodeVisitor.func(nameHashCode64);
        String methodName = x.getMethodName();
        if (functionOperator == null) {
            if (nameHashCode64 == FnvHash.Constants.TRIM) {
                functionOperator = SqlStdOperatorTable.TRIM;
                if (arguments.size() == 1) {
                    SqlNode sqlNode = this.convertToSqlNode(arguments.get(0));
                    this.sqlNode = new CalciteSqlBasicCall(functionOperator, new SqlNode[]{SqlLiteral.createSymbol((Enum)SqlTrimFunction.Flag.BOTH, (SqlParserPos)SqlParserPos.ZERO), SqlCharStringLiteral.createCharString((String)" ", (SqlParserPos)SqlParserPos.ZERO), sqlNode}, SqlParserPos.ZERO, false, null);
                    return false;
                }
            } else {
                functionOperator = new SqlUnresolvedFunction(new SqlIdentifier(methodName, SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
            }
        }
        SqlLiteral functionQualifier = null;
        for (SQLExpr exp : arguments) {
            argNodes.add(this.convertToSqlNode(exp));
        }
        if ((nameHashCode64 == FnvHash.Constants.TIMESTAMPDIFF || nameHashCode64 == FnvHash.Constants.TIMESTAMPADD) && argNodes.size() > 0 && argNodes.get(0) instanceof SqlIdentifier) {
            SqlIdentifier arg0 = (SqlIdentifier)argNodes.get(0);
            TimeUnit timeUnit = TimeUnit.valueOf((String)arg0.toString().toUpperCase());
            argNodes.set(0, SqlLiteral.createSymbol((Enum)timeUnit, (SqlParserPos)SqlParserPos.ZERO));
        }
        this.sqlNode = new CalciteSqlBasicCall(functionOperator, SqlParserUtil.toNodeArray(argNodes), SqlParserPos.ZERO, false, functionQualifier);
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        SqlNodeList sqlNodes = this.convertToSqlNodeList(x.getTargetList());
        SqlBinaryOperator sqlOperator = x.isNot() ? SqlStdOperatorTable.NOT_IN : SqlStdOperatorTable.IN;
        this.sqlNode = new SqlBasicCall((SqlOperator)sqlOperator, new SqlNode[]{this.convertToSqlNode(x.getExpr()), sqlNodes}, SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        if ("?".equals(x.getName())) {
            this.sqlNode = new SqlDynamicParam(x.getIndex(), SqlParserPos.ZERO);
            return false;
        }
        System.out.println("end");
        return false;
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        SQLUnaryOperator operator = x.getOperator();
        switch (operator) {
            case NOT: {
                this.sqlNode = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNode(x.getExpr())});
                break;
            }
            case Negative: {
                this.sqlNode = SqlStdOperatorTable.UNARY_MINUS.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNode(x.getExpr())});
                break;
            }
            default: {
                super.visit(x);
            }
        }
        return false;
    }

    protected SqlNodeList convertToSqlNodeList(SQLExpr expr) {
        if (expr instanceof SQLListExpr) {
            return this.convertToSqlNodeList(((SQLListExpr)expr).getItems());
        }
        ArrayList nodes = new ArrayList(1);
        return new SqlNodeList(nodes, SqlParserPos.ZERO);
    }

    protected SqlNodeList convertToSqlNodeList(List<? extends SQLExpr> exprList) {
        int size = exprList.size();
        ArrayList<SqlNode> nodes = new ArrayList<SqlNode>(size);
        for (int i = 0; i < size; ++i) {
            SQLExpr expr = exprList.get(i);
            Object node = expr instanceof SQLListExpr ? this.convertToSqlNodeList(((SQLListExpr)expr).getItems()) : this.convertToSqlNode(expr);
            nodes.add((SqlNode)node);
        }
        return new SqlNodeList(nodes, SqlParserPos.ZERO);
    }

    protected SqlNode convertToSqlNode(SQLObject ast) {
        if (ast == null) {
            return null;
        }
        CalciteMySqlNodeVisitor visitor = new CalciteMySqlNodeVisitor();
        ast.accept(visitor);
        return visitor.getSqlNode();
    }

    private SqlNodeList convertOrderby(SQLOrderBy orderBy) {
        if (orderBy == null) {
            return new SqlNodeList(new ArrayList(), SqlParserPos.ZERO);
        }
        List<SQLSelectOrderByItem> items = orderBy.getItems();
        ArrayList<SqlNode> orderByNodes = new ArrayList<SqlNode>(items.size());
        for (SQLSelectOrderByItem item : items) {
            SQLSelectOrderByItem.NullsOrderType nullsOrderType;
            SqlNode node = this.convertToSqlNode(item.getExpr());
            if (item.getType() == SQLOrderingSpecification.DESC) {
                node = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.DESC, new SqlNode[]{node}, SqlParserPos.ZERO);
            }
            if ((nullsOrderType = item.getNullsOrderType()) != null) {
                switch (nullsOrderType) {
                    case NullsFirst: {
                        node = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, new SqlNode[]{node}, SqlParserPos.ZERO);
                        break;
                    }
                    case NullsLast: {
                        node = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.NULLS_LAST, new SqlNode[]{node}, SqlParserPos.ZERO);
                        break;
                    }
                }
            }
            orderByNodes.add(node);
        }
        return new SqlNodeList(orderByNodes, SqlParserPos.ZERO);
    }

    private SqlNodeList convertHints(List<SQLCommentHint> hints) {
        if (hints == null) {
            return null;
        }
        ArrayList<SqlNodeList> nodes = new ArrayList<SqlNodeList>(hints.size());
        for (SQLCommentHint hint : hints) {
            if (!(hint instanceof TDDLHint)) continue;
            nodes.add(this.convertTDDLHint((TDDLHint)hint));
        }
        return new SqlNodeList(nodes, SqlParserPos.ZERO);
    }

    private SqlNodeList convertTDDLHint(TDDLHint hint) {
        List<TDDLHint.Function> functions = hint.getFunctions();
        ArrayList<SqlBasicCall> funNodes = new ArrayList<SqlBasicCall>(functions.size());
        for (TDDLHint.Function function : functions) {
            String functionName = function.getName();
            List<TDDLHint.Argument> arguments = function.getArguments();
            SqlNode[] argNodes = new SqlNode[arguments.size()];
            for (int i = 0; i < arguments.size(); ++i) {
                TDDLHint.Argument argument = arguments.get(i);
                SqlNode argName = this.convertToSqlNode(argument.getName());
                SqlNode argValue = this.convertToSqlNode(argument.getValue());
                ArrayList<SqlNode> arg = new ArrayList<SqlNode>();
                if (argName != null) {
                    arg.add(argName);
                }
                if (argValue != null) {
                    arg.add(argValue);
                }
                SqlCall argNode = null;
                if (arg.size() == 2) {
                    argNode = SqlStdOperatorTable.EQUALS.createCall(SqlParserPos.ZERO, arg);
                } else if (arg.size() == 1) {
                    argNode = argName;
                }
                argNodes[i] = argNode;
            }
            SqlBasicCall funNode = new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), argNodes, SqlParserPos.ZERO);
            funNodes.add(funNode);
        }
        return new SqlNodeList(funNodes, SqlParserPos.ZERO);
    }

    public static List<SQLInsertStatement.ValuesClause> convertToSingleValuesIfNeed(List<SQLInsertStatement.ValuesClause> valuesClauseList) {
        if (valuesClauseList.size() <= 1) {
            return valuesClauseList;
        }
        for (SQLInsertStatement.ValuesClause clause : valuesClauseList) {
            for (SQLExpr expr : clause.getValues()) {
                if (expr instanceof SQLVariantRefExpr && ((SQLVariantRefExpr)expr).getName().equals("?")) continue;
                return valuesClauseList;
            }
        }
        return Arrays.asList(valuesClauseList.get(0));
    }

    @Override
    public boolean visit(SQLIntervalExpr x) {
        TimeUnit[] timeUnits = CalciteMySqlNodeVisitor.getTimeUnit(x.getUnit());
        ArrayList convertedArgs = new ArrayList(2);
        SqlIntervalQualifier unitNode = new SqlIntervalQualifier(timeUnits[0], timeUnits[1], SqlParserPos.ZERO);
        SqlLiteral valueNode = (SqlLiteral)this.convertToSqlNode(x.getValue());
        this.sqlNode = SqlIntervalLiteral.createInterval((int)1, (String)valueNode.toValue(), (SqlIntervalQualifier)unitNode, (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    public static TimeUnit[] getTimeUnit(SQLIntervalUnit unit) {
        TimeUnit[] timeUnits = new TimeUnit[2];
        switch (unit) {
            case SECOND: {
                timeUnits[0] = TimeUnit.SECOND;
                timeUnits[1] = TimeUnit.SECOND;
                break;
            }
            case MINUTE: {
                timeUnits[0] = TimeUnit.MINUTE;
                timeUnits[1] = TimeUnit.MINUTE;
                break;
            }
            case HOUR: {
                timeUnits[0] = TimeUnit.HOUR;
                timeUnits[1] = TimeUnit.HOUR;
                break;
            }
            case DAY: {
                timeUnits[0] = TimeUnit.DAY;
                timeUnits[1] = TimeUnit.DAY;
                break;
            }
            case WEEK: {
                timeUnits[0] = TimeUnit.WEEK;
                timeUnits[1] = TimeUnit.WEEK;
                break;
            }
            case MONTH: {
                timeUnits[0] = TimeUnit.MONTH;
                timeUnits[1] = TimeUnit.MONTH;
                break;
            }
            case QUARTER: {
                timeUnits[0] = TimeUnit.QUARTER;
                timeUnits[1] = TimeUnit.QUARTER;
                break;
            }
            case YEAR: {
                timeUnits[0] = TimeUnit.YEAR;
                timeUnits[1] = TimeUnit.YEAR;
                break;
            }
            case MINUTE_SECOND: {
                timeUnits[0] = TimeUnit.MINUTE;
                timeUnits[1] = TimeUnit.SECOND;
                break;
            }
            case HOUR_SECOND: {
                timeUnits[0] = TimeUnit.HOUR;
                timeUnits[1] = TimeUnit.SECOND;
                break;
            }
            case HOUR_MINUTE: {
                timeUnits[0] = TimeUnit.HOUR;
                timeUnits[1] = TimeUnit.MINUTE;
                break;
            }
            case DAY_SECOND: {
                timeUnits[0] = TimeUnit.DAY;
                timeUnits[1] = TimeUnit.SECOND;
                break;
            }
            case DAY_MINUTE: {
                timeUnits[0] = TimeUnit.DAY;
                timeUnits[1] = TimeUnit.MINUTE;
                break;
            }
            case DAY_HOUR: {
                timeUnits[0] = TimeUnit.DAY;
                timeUnits[1] = TimeUnit.HOUR;
                break;
            }
            case YEAR_MONTH: {
                timeUnits[0] = TimeUnit.YEAR;
                timeUnits[1] = TimeUnit.MONTH;
                break;
            }
            default: {
                throw new ParserException("Unsupported time unit");
            }
        }
        return timeUnits;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        long hashCode64;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIdentifierExpr && (hashCode64 = ((SQLIdentifierExpr)expr).nameHashCode64()) == FnvHash.Constants.UNKNOWN) {
            this.sqlNode = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createUnknown((SqlParserPos)SqlParserPos.ZERO)});
            return false;
        }
        expr.accept(this);
        this.sqlNode = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, new SqlNode[]{this.sqlNode});
        return false;
    }

    @Override
    public boolean visit(SQLExtractExpr x) {
        x.getValue().accept(this);
        TimeUnit[] timeUnits = CalciteMySqlNodeVisitor.getTimeUnit(x.getUnit());
        this.sqlNode = SqlStdOperatorTable.EXTRACT.createCall(SqlParserPos.ZERO, new SqlNode[]{new SqlIntervalQualifier(timeUnits[0], timeUnits[1], SqlParserPos.ZERO), this.sqlNode});
        return false;
    }

    @Override
    public boolean visit(SQLGroupingSetExpr x) {
        this.sqlNode = SqlStdOperatorTable.GROUPING_SETS.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNodeList(x.getParameters())});
        return false;
    }

    @Override
    public boolean visit(SQLValuesQuery x) {
        ArrayList<SqlCall> valuesNodes = new ArrayList<SqlCall>();
        for (SQLExpr value : x.getValues()) {
            valuesNodes.add(SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNodeList(value)}));
        }
        this.sqlNode = SqlStdOperatorTable.VALUES.createCall(SqlParserPos.ZERO, valuesNodes);
        return false;
    }

    @Override
    public boolean visit(SQLUnnestTableSource x) {
        this.sqlNode = SqlStdOperatorTable.UNNEST.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNodeList(x.getItems())});
        String alias = x.getAlias();
        if (alias != null) {
            this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{this.sqlNode, new SqlIdentifier(alias, SqlParserPos.ZERO)}, SqlParserPos.ZERO);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDefaultExpr x) {
        this.sqlNode = SqlStdOperatorTable.DEFAULT.createCall(SqlParserPos.ZERO, new SqlNode[0]);
        return false;
    }

    @Override
    public boolean visit(MySqlExplainStatement x) {
        x.getStatement().accept(this);
        SqlNode explicandum = this.sqlNode;
        this.sqlNode = new SqlExplain(SqlParserPos.ZERO, explicandum, SqlLiteral.createSymbol((Enum)SqlExplainLevel.EXPPLAN_ATTRIBUTES, (SqlParserPos)SqlParserPos.ZERO), SqlLiteral.createSymbol((Enum)SqlExplain.Depth.PHYSICAL, (SqlParserPos)SqlParserPos.ZERO), SqlLiteral.createSymbol((Enum)SqlExplainFormat.TEXT, (SqlParserPos)SqlParserPos.ZERO), 0);
        return false;
    }

    static {
        List list = SqlStdOperatorTable.instance().getOperatorList();
        for (SqlOperator op : list) {
            long h = FnvHash.hashCode64(op.getName());
            if (h == FnvHash.Constants.TRIM) continue;
            operators.put(h, op);
        }
        operators.put(FnvHash.Constants.CEILING, (SqlOperator)SqlStdOperatorTable.CEIL);
        nameHashCode64SqlTypeNameMapping = new HashMap<Long, SqlTypeName>();
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.BIT, SqlTypeName.BOOLEAN);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.BOOLEAN, SqlTypeName.BOOLEAN);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.TINYINT, SqlTypeName.TINYINT);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.SMALLINT, SqlTypeName.SMALLINT);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.INT, SqlTypeName.INTEGER);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.INTEGER, SqlTypeName.INTEGER);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.BIGINT, SqlTypeName.BIGINT);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.DECIMAL, SqlTypeName.DECIMAL);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.FLOAT, SqlTypeName.FLOAT);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.REAL, SqlTypeName.REAL);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.DOUBLE, SqlTypeName.DOUBLE);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.DATE, SqlTypeName.DATE);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.TIME, SqlTypeName.TIME);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.TIMESTAMP, SqlTypeName.TIMESTAMP);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.CHAR, SqlTypeName.CHAR);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.VARCHAR, SqlTypeName.VARCHAR);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.BINARY, SqlTypeName.BINARY);
        nameHashCode64SqlTypeNameMapping.put(FnvHash.Constants.VARBINARY, SqlTypeName.VARBINARY);
        JSON_VALUE = FnvHash.fnv1a_64_lower("JSON VALUE");
        JSON_OBJECT = FnvHash.fnv1a_64_lower("JSON OBJECT");
        JSON_ARRAY = FnvHash.fnv1a_64_lower("JSON ARRAY");
        JSON_SCALAR = FnvHash.fnv1a_64_lower("JSON SCALAR");
    }
}

