/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.request.DeleteHTTPClientRequest;
import org.apache.eventmesh.runtime.admin.response.v1.GetClientResponse;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/client/http")
public class HTTPClientHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPClientHandler.class);
    private final EventMeshHTTPServer eventMeshHTTPServer;

    public HTTPClientHandler(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    protected void delete(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map<String, Object> body = HttpRequestUtil.parseHttpRequestBody(httpRequest);
        if (!Objects.isNull(body)) {
            DeleteHTTPClientRequest deleteHTTPClientRequest = (DeleteHTTPClientRequest)JsonUtils.mapToObject(body, DeleteHTTPClientRequest.class);
            String url = Objects.requireNonNull(deleteHTTPClientRequest).getUrl();
            for (List<Client> clientList : this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().values()) {
                clientList.removeIf(client -> Objects.equals(client.getUrl(), url));
            }
            this.writeText(ctx, "");
        }
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        ArrayList<GetClientResponse> getClientResponseList = new ArrayList<GetClientResponse>();
        for (List<Client> clientList : this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().values()) {
            for (Client client : clientList) {
                GetClientResponse getClientResponse = new GetClientResponse(Optional.ofNullable(client.getEnv()).orElse(""), Optional.ofNullable(client.getSys()).orElse(""), Optional.ofNullable(client.getUrl()).orElse(""), "0", Optional.ofNullable(client.getHostname()).orElse(""), 0, Optional.ofNullable(client.getApiVersion()).orElse(""), Optional.ofNullable(client.getIdc()).orElse(""), Optional.ofNullable(client.getConsumerGroup()).orElse(""), "", "http".toUpperCase());
                getClientResponseList.add(getClientResponse);
            }
        }
        getClientResponseList.sort((lhs, rhs) -> {
            if (lhs.getHost().equals(rhs.getHost())) {
                return lhs.getHost().compareTo(rhs.getHost());
            }
            return Integer.compare(rhs.getPort(), lhs.getPort());
        });
        String result = JsonUtils.toJSONString(getClientResponseList);
        this.writeJson(ctx, result);
    }
}

