/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.admin.handler;

import com.alibaba.otter.canal.admin.CanalAdmin;
import com.alibaba.otter.canal.admin.netty.AdminNettyUtils;
import com.alibaba.otter.canal.protocol.AdminPacket;
import com.google.protobuf.ByteString;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class SessionHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(SessionHandler.class);
    private CanalAdmin canalAdmin;

    public SessionHandler() {
    }

    public SessionHandler(CanalAdmin canalAdmin) {
        this.canalAdmin = canalAdmin;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        logger.info("message receives in session handler...");
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        AdminPacket.Packet packet = AdminPacket.Packet.parseFrom((byte[])buffer.readBytes(buffer.readableBytes()).array());
        try {
            String action = null;
            String message = null;
            String destination = null;
            switch (packet.getType()) {
                case SERVER: {
                    AdminPacket.ServerAdmin serverAdmin = AdminPacket.ServerAdmin.parseFrom((ByteString)packet.getBody());
                    switch (action = serverAdmin.getAction()) {
                        case "check": {
                            message = this.canalAdmin.check() ? "1" : "0";
                            break;
                        }
                        case "start": {
                            message = this.canalAdmin.start() ? "1" : "0";
                            break;
                        }
                        case "stop": {
                            message = this.canalAdmin.stop() ? "1" : "0";
                            break;
                        }
                        case "restart": {
                            message = this.canalAdmin.restart() ? "1" : "0";
                            break;
                        }
                        case "list": {
                            message = this.canalAdmin.getRunningInstances();
                            break;
                        }
                        default: {
                            byte[] errorBytes = AdminNettyUtils.errorPacket(301, MessageFormatter.format((String)"ServerAdmin action={} is unknown", (Object)action).getMessage());
                            AdminNettyUtils.write(ctx.getChannel(), errorBytes);
                        }
                    }
                    AdminNettyUtils.write(ctx.getChannel(), AdminNettyUtils.ackPacket(message));
                    break;
                }
                case INSTANCE: {
                    AdminPacket.InstanceAdmin instanceAdmin = AdminPacket.InstanceAdmin.parseFrom((ByteString)packet.getBody());
                    destination = instanceAdmin.getDestination();
                    switch (action = instanceAdmin.getAction()) {
                        case "check": {
                            message = this.canalAdmin.checkInstance(destination) ? "1" : "0";
                            break;
                        }
                        case "start": {
                            message = this.canalAdmin.startInstance(destination) ? "1" : "0";
                            break;
                        }
                        case "stop": {
                            message = this.canalAdmin.stopInstance(destination) ? "1" : "0";
                            break;
                        }
                        case "release": {
                            message = this.canalAdmin.releaseInstance(destination) ? "1" : "0";
                            break;
                        }
                        case "restart": {
                            message = this.canalAdmin.restartInstance(destination) ? "1" : "0";
                            break;
                        }
                        default: {
                            byte[] errorBytes = AdminNettyUtils.errorPacket(301, MessageFormatter.format((String)"InstanceAdmin action={} is unknown", (Object)action).getMessage());
                            AdminNettyUtils.write(ctx.getChannel(), errorBytes);
                        }
                    }
                    AdminNettyUtils.write(ctx.getChannel(), AdminNettyUtils.ackPacket(message));
                    break;
                }
                case LOG: {
                    AdminPacket.LogAdmin logAdmin = AdminPacket.LogAdmin.parseFrom((ByteString)packet.getBody());
                    action = logAdmin.getAction();
                    destination = logAdmin.getDestination();
                    String type = logAdmin.getType();
                    String file = logAdmin.getFile();
                    int count = logAdmin.getCount();
                    switch (type) {
                        case "server": {
                            if ("list".equalsIgnoreCase(action)) {
                                message = this.canalAdmin.listCanalLog();
                                break;
                            }
                            message = this.canalAdmin.canalLog(count);
                            break;
                        }
                        case "instance": {
                            if ("list".equalsIgnoreCase(action)) {
                                message = this.canalAdmin.listInstanceLog(destination);
                                break;
                            }
                            message = this.canalAdmin.instanceLog(destination, file, count);
                            break;
                        }
                        default: {
                            byte[] errorBytes = AdminNettyUtils.errorPacket(301, MessageFormatter.format((String)"LogAdmin type={} is unknown", (Object)type).getMessage());
                            AdminNettyUtils.write(ctx.getChannel(), errorBytes);
                        }
                    }
                    AdminNettyUtils.write(ctx.getChannel(), AdminNettyUtils.ackPacket(message));
                    break;
                }
                default: {
                    byte[] errorBytes = AdminNettyUtils.errorPacket(300, MessageFormatter.format((String)"packet type={} is NOT supported!", (Object)packet.getType()).getMessage());
                    AdminNettyUtils.write(ctx.getChannel(), errorBytes);
                    break;
                }
            }
        }
        catch (Throwable exception) {
            byte[] errorBytes = AdminNettyUtils.errorPacket(400, MessageFormatter.format((String)"something goes wrong with channel:{}, exception={}", (Object)ctx.getChannel(), (Object)ExceptionUtils.getStackTrace((Throwable)exception)).getMessage());
            AdminNettyUtils.write(ctx.getChannel(), errorBytes);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.error("something goes wrong with channel:{}, exception={}", (Object)ctx.getChannel(), (Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
        ctx.getChannel().close();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
    }

    public void setCanalAdmin(CanalAdmin canalAdmin) {
        this.canalAdmin = canalAdmin;
    }
}

