/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonKeys;
import org.redisson.RedissonMultiLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.bucket.BucketSetOperation;
import org.redisson.transaction.operation.bucket.BucketsTrySetOperation;

public class RedissonTransactionalBuckets
extends RedissonBuckets {
    static final Object NULL = new Object();
    private final long timeout;
    private final AtomicBoolean executed;
    private final List<TransactionalOperation> operations;
    private final Map<String, Object> state = new HashMap<String, Object>();
    private final String transactionId;

    public RedissonTransactionalBuckets(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(commandExecutor);
        this.timeout = timeout;
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
    }

    public RedissonTransactionalBuckets(Codec codec, CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(codec, commandExecutor);
        this.timeout = timeout;
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        this.checkState();
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Map<String, V>>(Collections.emptyMap());
        }
        HashSet<String> keysToLoad = new HashSet<String>();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            Object value = this.state.get(key);
            if (value != null) {
                if (value == NULL) continue;
                map.put(key, value);
                continue;
            }
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return new CompletableFutureWrapper<Map<String, V>>(map);
        }
        CompletionStage<Map> f = super.getAsync(keysToLoad.toArray(new String[0])).thenApply(res -> {
            map.putAll((Map<String, Object>)res);
            return map;
        });
        return new CompletableFutureWrapper<Map<String, V>>(f);
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            for (Map.Entry entry : buckets.entrySet()) {
                this.operations.add(new BucketSetOperation((String)entry.getKey(), this.getLockName((String)entry.getKey()), this.codec, entry.getValue(), this.transactionId, currentThreadId));
                if (entry.getValue() == null) {
                    this.state.put((String)entry.getKey(), NULL);
                    continue;
                }
                this.state.put((String)entry.getKey(), entry.getValue());
            }
            return CompletableFuture.completedFuture(null);
        }, buckets.keySet());
    }

    @Override
    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        this.checkState();
        return this.executeLocked(() -> {
            HashSet<String> keysToSet = new HashSet<String>();
            for (String key : buckets.keySet()) {
                Object value = this.state.get(key);
                if (value != null) {
                    if (value == NULL) continue;
                    this.operations.add(new BucketsTrySetOperation(this.codec, buckets, this.transactionId));
                    return CompletableFuture.completedFuture(false);
                }
                keysToSet.add(key);
            }
            if (keysToSet.isEmpty()) {
                this.operations.add(new BucketsTrySetOperation(this.codec, buckets, this.transactionId));
                this.state.putAll(buckets);
                return CompletableFuture.completedFuture(true);
            }
            RedissonKeys keys = new RedissonKeys(this.commandExecutor);
            String[] ks = keysToSet.toArray(new String[keysToSet.size()]);
            return keys.countExistsAsync(ks).thenApply(res -> {
                this.operations.add(new BucketsTrySetOperation(this.codec, buckets, this.transactionId));
                if (res == 0L) {
                    this.state.putAll(buckets);
                    return true;
                }
                return false;
            });
        }, buckets.keySet());
    }

    protected <R> RFuture<R> executeLocked(Supplier<CompletionStage<R>> runnable, Collection<String> keys) {
        ArrayList<RLock> locks = new ArrayList<RLock>(keys.size());
        for (String key : keys) {
            RLock lock = this.getLock(key);
            locks.add(lock);
        }
        RedissonMultiLock multiLock = new RedissonMultiLock(locks.toArray(new RLock[0]));
        long threadId = Thread.currentThread().getId();
        CompletionStage<Object> f = multiLock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).thenCompose(res -> (CompletionStage)runnable.get()).whenComplete((r, e) -> {
            if (e != null) {
                multiLock.unlockAsync(threadId);
            }
        });
        return new CompletableFutureWrapper<Object>(f);
    }

    private RLock getLock(String name) {
        return new RedissonTransactionalLock(this.commandExecutor, this.getLockName(name), this.transactionId);
    }

    private String getLockName(String name) {
        return name + ":transaction_lock";
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

