/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.client.tables.IteratorItem;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.List;
import lombok.Generated;

public class HashTableIteratorItem<T>
extends IteratorItem<T> {
    private final State state;

    public HashTableIteratorItem(State state, List<T> items) {
        super(items);
        this.state = state;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashTableIteratorItem)) {
            return false;
        }
        HashTableIteratorItem other = (HashTableIteratorItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HashTableIteratorItem;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public State getState() {
        return this.state;
    }

    public static class State {
        public static final State EMPTY = new State(Unpooled.EMPTY_BUFFER);
        private final ByteBuf token;

        public ByteBuffer toBytes() {
            return this.token.copy().nioBuffer();
        }

        public boolean isEmpty() {
            return this.token.readableBytes() == 0;
        }

        public static State fromBytes(ByteBuf serializedState) {
            if (serializedState == null || serializedState.readableBytes() == 0) {
                return EMPTY;
            }
            return new State(serializedState);
        }

        public static State fromBytes(ByteBuffer serializedState) {
            if (serializedState == null) {
                return EMPTY;
            }
            return State.fromBytes(Unpooled.wrappedBuffer((ByteBuffer)serializedState));
        }

        public static State copyOf(State source) {
            if (source == null || source == EMPTY) {
                return EMPTY;
            }
            return State.fromBytes(source.toBytes());
        }

        @ConstructorProperties(value={"token"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private State(ByteBuf token) {
            this.token = token;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ByteBuf this$token = this.getToken();
            ByteBuf other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuf $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getToken() {
            return this.token;
        }
    }
}

