/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.notifications.notifier;

import io.pravega.client.stream.notifications.Listener;
import io.pravega.client.stream.notifications.Notification;
import io.pravega.client.stream.notifications.NotificationSystem;
import io.pravega.client.stream.notifications.Observable;
import java.util.concurrent.ScheduledExecutorService;

public abstract class AbstractNotifier<T extends Notification>
implements Observable<T> {
    protected final NotificationSystem notifySystem;
    protected final ScheduledExecutorService executor;

    protected AbstractNotifier(NotificationSystem notifySystem, ScheduledExecutorService executor) {
        this.notifySystem = notifySystem;
        this.executor = executor;
    }

    @Override
    public void unregisterListener(Listener<T> listener) {
        this.notifySystem.removeListener(this.getType(), listener);
    }

    @Override
    public void unregisterAllListeners() {
        this.notifySystem.removeListeners(this.getType());
    }

    @Override
    public void registerListener(Listener<T> listener) {
        this.notifySystem.addListeners(this.getType(), listener, this.executor);
    }
}

