/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.profiler.sender.grpc.DefaultStreamEventListener;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.profiler.sender.grpc.ResponseStreamObserver;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.ClientStreamingProvider;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamJob;
import io.grpc.stub.ClientCallStreamObserver;
import java.util.Objects;

public class ClientStreamingService<ReqT, ResT> {
    private final ClientStreamingProvider<ReqT, ResT> clientStreamingProvider;
    private final Reconnector reconnector;

    public ClientStreamingService(ClientStreamingProvider<ReqT, ResT> clientStreamingProvider, Reconnector reconnector) {
        this.clientStreamingProvider = Objects.requireNonNull(clientStreamingProvider, "clientStreamingProvider");
        this.reconnector = Objects.requireNonNull(reconnector, "reconnector");
    }

    public ClientCallStreamObserver<ReqT> newStream(StreamJob<ReqT> streamJob) {
        ResponseStreamObserver<ReqT, ResT> response = this.newResponse(streamJob);
        return this.clientStreamingProvider.newStream(response);
    }

    private ResponseStreamObserver<ReqT, ResT> newResponse(StreamJob<ReqT> streamJob) {
        DefaultStreamEventListener<ReqT> listener = new DefaultStreamEventListener<ReqT>(this.reconnector, streamJob);
        return new ResponseStreamObserver(listener);
    }
}

