/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.service.monitor;

import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.request.ReportMonitorRequest;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.openconnect.api.monitor.Monitor;
import org.apache.eventmesh.openconnect.api.monitor.MonitorRegistry;
import org.apache.eventmesh.runtime.service.monitor.SinkMonitor;
import org.apache.eventmesh.runtime.service.monitor.SourceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    private final ScheduledExecutorService scheduler;
    private StreamObserver<Payload> requestObserver;
    private StreamObserver<Payload> responseObserver;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;

    public MonitorService(AdminServiceGrpc.AdminServiceStub adminServiceStub, AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub) {
        this.adminServiceStub = adminServiceStub;
        this.adminServiceBlockingStub = adminServiceBlockingStub;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.responseObserver = new StreamObserver<Payload>(){

            public void onNext(Payload response) {
                log.debug("monitor service receive message: {}|{} ", (Object)response.getMetadata(), (Object)response.getBody());
            }

            public void onError(Throwable t) {
                log.error("monitor service receive error message: {}", (Object)t.getMessage());
            }

            public void onCompleted() {
                log.info("monitor service finished receive message and completed");
            }
        };
        this.requestObserver = this.adminServiceStub.invokeBiStream(this.responseObserver);
    }

    public void registerMonitor(Monitor monitor) {
        MonitorRegistry.registerMonitor((Monitor)monitor);
    }

    public void start() {
        this.startReporting();
    }

    public void startReporting() {
        this.scheduler.scheduleAtFixedRate(() -> {
            List monitors = MonitorRegistry.getMonitors();
            for (Monitor monitor : monitors) {
                monitor.printMetrics();
                this.reportToAdminService(monitor);
            }
        }, 5L, 30L, TimeUnit.SECONDS);
    }

    private void reportToAdminService(Monitor monitor) {
        ReportMonitorRequest request = new ReportMonitorRequest();
        if (monitor instanceof SourceMonitor) {
            SourceMonitor sourceMonitor = (SourceMonitor)monitor;
            request.setTaskID(sourceMonitor.getTaskId());
            request.setJobID(sourceMonitor.getJobId());
            request.setAddress(sourceMonitor.getIp());
            request.setConnectorStage(sourceMonitor.getConnectorStage());
            request.setTotalReqNum(sourceMonitor.getTotalRecordNum().longValue());
            request.setTotalTimeCost(sourceMonitor.getTotalTimeCost().longValue());
            request.setMaxTimeCost(sourceMonitor.getMaxTimeCost().longValue());
            request.setAvgTimeCost(sourceMonitor.getAverageTime());
            request.setTps(sourceMonitor.getTps());
        } else if (monitor instanceof SinkMonitor) {
            SinkMonitor sinkMonitor = (SinkMonitor)monitor;
            request.setTaskID(sinkMonitor.getTaskId());
            request.setJobID(sinkMonitor.getJobId());
            request.setAddress(sinkMonitor.getIp());
            request.setConnectorStage(sinkMonitor.getConnectorStage());
            request.setTotalReqNum(sinkMonitor.getTotalRecordNum().longValue());
            request.setTotalTimeCost(sinkMonitor.getTotalTimeCost().longValue());
            request.setMaxTimeCost(sinkMonitor.getMaxTimeCost().longValue());
            request.setAvgTimeCost(sinkMonitor.getAverageTime());
            request.setTps(sinkMonitor.getTps());
        } else {
            throw new IllegalArgumentException("Unsupported monitor: " + monitor);
        }
        Metadata metadata = Metadata.newBuilder().setType(ReportMonitorRequest.class.getSimpleName()).build();
        Payload payload = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)request)))).build()).build();
        this.requestObserver.onNext((Object)payload);
    }

    public void stop() {
        this.scheduler.shutdown();
        if (this.requestObserver != null) {
            this.requestObserver.onCompleted();
        }
    }
}

