/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.api.RLock;
import org.redisson.api.RLockReactive;
import org.redisson.api.RMap;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RPermitExpirableSemaphoreReactive;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RReadWriteLockReactive;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSemaphoreReactive;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.MapReactiveIterator;
import org.redisson.reactive.ReactiveProxyBuilder;
import reactor.core.publisher.Flux;

public class RedissonMapReactive<K, V> {
    private final RMap<K, V> map;
    private final CommandReactiveExecutor commandExecutor;

    public RedissonMapReactive(RMap<K, V> map, CommandReactiveExecutor commandExecutor) {
        this.map = map;
        this.commandExecutor = commandExecutor;
    }

    public Publisher<Map.Entry<K, V>> entryIterator() {
        return this.entryIterator(null);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(int count) {
        return this.entryIterator(null, count);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern) {
        return this.entryIterator(pattern, 10);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return Flux.create(new MapReactiveIterator((RedissonMap)this.map, pattern, count));
    }

    public Publisher<V> valueIterator() {
        return this.valueIterator(null);
    }

    public Publisher<V> valueIterator(String pattern) {
        return this.valueIterator(pattern, 10);
    }

    public Publisher<V> valueIterator(int count) {
        return this.valueIterator(null, count);
    }

    public Publisher<V> valueIterator(String pattern, int count) {
        return Flux.create((Consumer)new MapReactiveIterator<K, V, V>((RedissonMap)this.map, pattern, count){

            @Override
            V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        });
    }

    public Publisher<K> keyIterator() {
        return this.keyIterator(null);
    }

    public Publisher<K> keyIterator(String pattern) {
        return this.keyIterator(pattern, 10);
    }

    public Publisher<K> keyIterator(int count) {
        return this.keyIterator(null, count);
    }

    public Publisher<K> keyIterator(String pattern, int count) {
        return Flux.create((Consumer)new MapReactiveIterator<K, V, K>((RedissonMap)this.map, pattern, count){

            @Override
            K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        });
    }

    public RPermitExpirableSemaphoreReactive getPermitExpirableSemaphore(K key) {
        RPermitExpirableSemaphore s = this.map.getPermitExpirableSemaphore(key);
        return ReactiveProxyBuilder.create(this.commandExecutor, s, RPermitExpirableSemaphoreReactive.class);
    }

    public RSemaphoreReactive getSemaphore(K key) {
        RSemaphore s = this.map.getSemaphore(key);
        return ReactiveProxyBuilder.create(this.commandExecutor, s, RSemaphoreReactive.class);
    }

    public RLockReactive getFairLock(K key) {
        RLock lock = this.map.getFairLock(key);
        return ReactiveProxyBuilder.create(this.commandExecutor, lock, RLockReactive.class);
    }

    public RReadWriteLockReactive getReadWriteLock(K key) {
        RReadWriteLock lock = this.map.getReadWriteLock(key);
        return ReactiveProxyBuilder.create(this.commandExecutor, lock, RReadWriteLockReactive.class);
    }

    public RLockReactive getLock(K key) {
        RLock lock = this.map.getLock(key);
        return ReactiveProxyBuilder.create(this.commandExecutor, lock, RLockReactive.class);
    }
}

