/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AviatorString
extends AviatorObject {
    final String lexeme;

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.String;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.lexeme;
    }

    public AviatorString(String lexeme) {
        this.lexeme = lexeme;
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                AviatorString otherString = (AviatorString)other;
                return new AviatorString(this.lexeme + otherString.lexeme);
            }
            case Boolean: {
                AviatorBoolean otherBoolean = (AviatorBoolean)other;
                return new AviatorString(this.lexeme + otherBoolean.value);
            }
            case Long: 
            case Double: {
                AviatorNumber otherNumber = (AviatorNumber)other;
                return new AviatorString(this.lexeme + otherNumber.number);
            }
            case Nil: 
            case JavaType: {
                return new AviatorString(this.lexeme + other.getValue(env));
            }
            case Pattern: {
                AviatorPattern otherPatterh = (AviatorPattern)other;
                return new AviatorString(this.lexeme + otherPatterh.pattern.pattern());
            }
        }
        return super.add(other, env);
    }

    private int tryCompareDate(Date otherDate) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
            Date thisDate = simpleDateFormat.parse(this.lexeme);
            return thisDate.compareTo(otherDate);
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Compare date error", t);
        }
    }

    @Override
    public int compare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case String: {
                AviatorString otherString = (AviatorString)other;
                return this.lexeme.compareTo(otherString.lexeme);
            }
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object otherJavaValue = javaType.getValue(env);
                if (otherJavaValue == null) {
                    return 1;
                }
                if (TypeUtils.isString(otherJavaValue)) {
                    return this.lexeme.compareTo(String.valueOf(otherJavaValue));
                }
                if (otherJavaValue instanceof Date) {
                    return this.tryCompareDate((Date)otherJavaValue);
                }
                throw new ExpressionRuntimeException("Could not compare " + this + " with " + other);
            }
            case Nil: {
                return 1;
            }
        }
        throw new ExpressionRuntimeException("Could not compare " + this + " with " + other);
    }

    public String getLexeme() {
        return this.lexeme;
    }
}

