/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.config.PersistedConfiguration;
import org.apache.activemq.artemis.json.JsonObject;

public class PersistedSecuritySetting
extends PersistedConfiguration {
    private SimpleString addressMatch;
    private SimpleString sendRoles;
    private SimpleString consumeRoles;
    private SimpleString createDurableQueueRoles;
    private SimpleString deleteDurableQueueRoles;
    private SimpleString createNonDurableQueueRoles;
    private SimpleString deleteNonDurableQueueRoles;
    private SimpleString manageRoles;
    private SimpleString browseRoles;
    private SimpleString createAddressRoles;
    private SimpleString deleteAddressRoles;
    private SimpleString viewRoles;
    private SimpleString editRoles;

    public PersistedSecuritySetting() {
    }

    public PersistedSecuritySetting(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles, String viewRoles, String editRoles) {
        this.addressMatch = SimpleString.of((String)addressMatch);
        this.sendRoles = SimpleString.of((String)sendRoles);
        this.consumeRoles = SimpleString.of((String)consumeRoles);
        this.createDurableQueueRoles = SimpleString.of((String)createDurableQueueRoles);
        this.deleteDurableQueueRoles = SimpleString.of((String)deleteDurableQueueRoles);
        this.createNonDurableQueueRoles = SimpleString.of((String)createNonDurableQueueRoles);
        this.deleteNonDurableQueueRoles = SimpleString.of((String)deleteNonDurableQueueRoles);
        this.manageRoles = SimpleString.of((String)manageRoles);
        this.browseRoles = SimpleString.of((String)browseRoles);
        this.createAddressRoles = SimpleString.of((String)createAddressRoles);
        this.deleteAddressRoles = SimpleString.of((String)deleteAddressRoles);
        this.viewRoles = SimpleString.of((String)viewRoles);
        this.editRoles = SimpleString.of((String)editRoles);
    }

    public PersistedSecuritySetting(String addressMatch, JsonObject o) {
        this(addressMatch, JsonUtil.arrayToString((JsonObject)o, (String)"send"), JsonUtil.arrayToString((JsonObject)o, (String)"consume"), JsonUtil.arrayToString((JsonObject)o, (String)"createDurableQueue"), JsonUtil.arrayToString((JsonObject)o, (String)"deleteDurableQueue"), JsonUtil.arrayToString((JsonObject)o, (String)"createNonDurableQueue"), JsonUtil.arrayToString((JsonObject)o, (String)"deleteNonDurableQueue"), JsonUtil.arrayToString((JsonObject)o, (String)"manage"), JsonUtil.arrayToString((JsonObject)o, (String)"browse"), JsonUtil.arrayToString((JsonObject)o, (String)"createAddress"), JsonUtil.arrayToString((JsonObject)o, (String)"deleteAddress"), JsonUtil.arrayToString((JsonObject)o, (String)"view"), JsonUtil.arrayToString((JsonObject)o, (String)"edit"));
    }

    @Override
    public String getName() {
        return this.addressMatch.toString();
    }

    @Override
    public byte getRecordType() {
        return 26;
    }

    public SimpleString getAddressMatch() {
        return this.addressMatch;
    }

    public String getSendRoles() {
        return Objects.toString(this.sendRoles, null);
    }

    public String getConsumeRoles() {
        return Objects.toString(this.consumeRoles, null);
    }

    public String getCreateDurableQueueRoles() {
        return Objects.toString(this.createDurableQueueRoles, null);
    }

    public String getDeleteDurableQueueRoles() {
        return Objects.toString(this.deleteDurableQueueRoles, null);
    }

    public String getCreateNonDurableQueueRoles() {
        return Objects.toString(this.createNonDurableQueueRoles, null);
    }

    public String getDeleteNonDurableQueueRoles() {
        return Objects.toString(this.deleteNonDurableQueueRoles, null);
    }

    public String getManageRoles() {
        return Objects.toString(this.manageRoles, null);
    }

    public String getBrowseRoles() {
        return Objects.toString(this.browseRoles, null);
    }

    public String getCreateAddressRoles() {
        return Objects.toString(this.createAddressRoles, null);
    }

    public String getDeleteAddressRoles() {
        return Objects.toString(this.deleteAddressRoles, null);
    }

    public String getViewRoles() {
        return Objects.toString(this.viewRoles, null);
    }

    public String getEditRoles() {
        return Objects.toString(this.editRoles, null);
    }

    public void encode(ActiveMQBuffer buffer) {
        if (this.addressMatch == null) {
            this.addressMatch = SimpleString.of((String)"");
        }
        buffer.writeSimpleString(this.addressMatch);
        buffer.writeNullableSimpleString(this.sendRoles);
        buffer.writeNullableSimpleString(this.consumeRoles);
        buffer.writeNullableSimpleString(this.createDurableQueueRoles);
        buffer.writeNullableSimpleString(this.deleteDurableQueueRoles);
        buffer.writeNullableSimpleString(this.createNonDurableQueueRoles);
        buffer.writeNullableSimpleString(this.deleteNonDurableQueueRoles);
        buffer.writeNullableSimpleString(this.manageRoles);
        buffer.writeNullableSimpleString(this.browseRoles);
        buffer.writeNullableSimpleString(this.createAddressRoles);
        buffer.writeNullableSimpleString(this.deleteAddressRoles);
        buffer.writeNullableSimpleString(this.viewRoles);
        buffer.writeNullableSimpleString(this.editRoles);
    }

    public int getEncodeSize() {
        return (this.addressMatch == null ? 4 : this.addressMatch.sizeof()) + (this.sendRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.sendRoles)) + (this.consumeRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.consumeRoles)) + (this.createDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.createDurableQueueRoles)) + (this.deleteDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.deleteDurableQueueRoles)) + (this.createNonDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.createNonDurableQueueRoles)) + (this.deleteNonDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.deleteNonDurableQueueRoles)) + (this.manageRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.manageRoles)) + (this.browseRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.browseRoles)) + (this.createAddressRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.createAddressRoles)) + (this.deleteAddressRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.deleteAddressRoles)) + (this.viewRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.viewRoles)) + (this.editRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.editRoles));
    }

    public void decode(ActiveMQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.sendRoles = buffer.readNullableSimpleString();
        this.consumeRoles = buffer.readNullableSimpleString();
        this.createDurableQueueRoles = buffer.readNullableSimpleString();
        this.deleteDurableQueueRoles = buffer.readNullableSimpleString();
        this.createNonDurableQueueRoles = buffer.readNullableSimpleString();
        this.deleteNonDurableQueueRoles = buffer.readNullableSimpleString();
        this.manageRoles = buffer.readNullableSimpleString();
        this.browseRoles = buffer.readNullableSimpleString();
        this.createAddressRoles = buffer.readNullableSimpleString();
        this.deleteAddressRoles = buffer.readNullableSimpleString();
        if (buffer.readableBytes() > 0) {
            this.viewRoles = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.editRoles = buffer.readNullableSimpleString();
        }
    }

    public int hashCode() {
        return Objects.hash(this.addressMatch, this.consumeRoles, this.createDurableQueueRoles, this.createNonDurableQueueRoles, this.deleteDurableQueueRoles, this.deleteNonDurableQueueRoles, this.manageRoles, this.browseRoles, this.createAddressRoles, this.deleteAddressRoles, this.sendRoles, this.viewRoles, this.editRoles, this.storeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistedSecuritySetting)) {
            return false;
        }
        PersistedSecuritySetting other = (PersistedSecuritySetting)obj;
        return Objects.equals(this.addressMatch, other.addressMatch) && Objects.equals(this.consumeRoles, other.consumeRoles) && Objects.equals(this.createDurableQueueRoles, other.createDurableQueueRoles) && Objects.equals(this.createNonDurableQueueRoles, other.createNonDurableQueueRoles) && Objects.equals(this.deleteDurableQueueRoles, other.deleteDurableQueueRoles) && Objects.equals(this.deleteNonDurableQueueRoles, other.deleteNonDurableQueueRoles) && Objects.equals(this.manageRoles, other.manageRoles) && Objects.equals(this.browseRoles, other.browseRoles) && Objects.equals(this.createAddressRoles, other.createAddressRoles) && Objects.equals(this.deleteAddressRoles, other.deleteAddressRoles) && Objects.equals(this.sendRoles, other.sendRoles) && Objects.equals(this.viewRoles, other.viewRoles) && Objects.equals(this.editRoles, other.editRoles) && this.storeId == other.storeId;
    }

    public String toString() {
        return "PersistedSecuritySetting [storeId=" + this.storeId + ", addressMatch=" + String.valueOf(this.addressMatch) + ", sendRoles=" + String.valueOf(this.sendRoles) + ", consumeRoles=" + String.valueOf(this.consumeRoles) + ", createDurableQueueRoles=" + String.valueOf(this.createDurableQueueRoles) + ", deleteDurableQueueRoles=" + String.valueOf(this.deleteDurableQueueRoles) + ", createNonDurableQueueRoles=" + String.valueOf(this.createNonDurableQueueRoles) + ", deleteNonDurableQueueRoles=" + String.valueOf(this.deleteNonDurableQueueRoles) + ", manageRoles=" + String.valueOf(this.manageRoles) + ", browseRoles=" + String.valueOf(this.browseRoles) + ", createAddressRoles=" + String.valueOf(this.createAddressRoles) + ", deleteAddressRoles=" + String.valueOf(this.deleteAddressRoles) + ", viewRoles=" + String.valueOf(this.viewRoles) + ", editRoles=" + String.valueOf(this.editRoles) + "]";
    }
}

