/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import org.mozilla.javascript.BuiltInSlot;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SerializableCallable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XmlProcessor;

class XMLCtor
extends IdFunctionObject {
    static final long serialVersionUID = -8708195078359817341L;
    private static final Object XMLCTOR_TAG = "XMLCtor";
    private XmlProcessor options;
    private XMLLibImpl lib;
    private static final String[] propNames = new String[]{"ignoreComments", "ignoreProcessingInstructions", "ignoreWhitespace", "prettyIndent", "prettyPrinting"};

    public XMLCtor(Context cx, ScriptableObject scope, XML xml, Object tag, int id, int arity) {
        super((IdFunctionCall)xml, tag, id, arity);
        this.options = xml.getProcessor();
        XMLCtor.createProperties(cx, scope, this);
    }

    public static IdFunctionObject init() {
        return null;
    }

    private static void createProperties(Context cx, ScriptableObject scope, XMLCtor obj) {
        XMLCtor.defineMethod((ScriptableObject)obj, scope, "defaultSettings", 0, (SerializableCallable & Serializable)(lcx, lscope, lthisObj, largs) -> {
            obj.options.setDefault();
            Scriptable res = lcx.newObject(lscope);
            XMLCtor.writeSetting(obj, res);
            return res;
        });
        XMLCtor.defineMethod((ScriptableObject)obj, scope, "settings", 0, (SerializableCallable & Serializable)(lcx, lscope, lthisObj, largs) -> {
            Scriptable res = lcx.newObject(lscope);
            XMLCtor.writeSetting(obj, res);
            return res;
        });
        XMLCtor.defineMethod((ScriptableObject)obj, scope, "setSettings", 1, (SerializableCallable & Serializable)(lcx, lscope, lthisObj, largs) -> {
            if (largs.length == 0 || largs[0] == null || largs[0] == Undefined.instance) {
                obj.options.setDefault();
            } else if (largs[0] instanceof Scriptable) {
                XMLCtor.readSettings(obj, (Scriptable)largs[0]);
            }
            return Undefined.instance;
        });
        ScriptableObject.defineBuiltInProperty((ScriptableObject)obj, (String)"prettyPrinting", (int)0, (BuiltInSlot.Getter & Serializable)(b, s) -> ScriptRuntime.wrapBoolean((boolean)b.options.isPrettyPrinting()), (BuiltInSlot.Setter & Serializable)(b, v, o, s, t) -> {
            b.options.setPrettyPrinting(ScriptRuntime.toBoolean((Object)v));
            return true;
        });
        ScriptableObject.defineBuiltInProperty((ScriptableObject)obj, (String)"prettyIndent", (int)0, (BuiltInSlot.Getter & Serializable)(b, s) -> ScriptRuntime.wrapInt((int)b.options.getPrettyIndent()), (BuiltInSlot.Setter & Serializable)(b, v, o, s, t) -> {
            b.options.setPrettyIndent(ScriptRuntime.toInt32((Object)v));
            return true;
        });
        ScriptableObject.defineBuiltInProperty((ScriptableObject)obj, (String)"ignoreWhitespace", (int)0, (BuiltInSlot.Getter & Serializable)(b, s) -> ScriptRuntime.wrapBoolean((boolean)b.options.isIgnoreWhitespace()), (BuiltInSlot.Setter & Serializable)(b, v, o, s, t) -> {
            b.options.setIgnoreWhitespace(ScriptRuntime.toBoolean((Object)v));
            return true;
        });
        ScriptableObject.defineBuiltInProperty((ScriptableObject)obj, (String)"ignoreProcessingInstructions", (int)0, (BuiltInSlot.Getter & Serializable)(b, s) -> ScriptRuntime.wrapBoolean((boolean)b.options.isIgnoreProcessingInstructions()), (BuiltInSlot.Setter & Serializable)(b, v, o, s, t) -> {
            b.options.setIgnoreProcessingInstructions(ScriptRuntime.toBoolean((Object)v));
            return true;
        });
        ScriptableObject.defineBuiltInProperty((ScriptableObject)obj, (String)"ignoreComments", (int)0, (BuiltInSlot.Getter & Serializable)(b, s) -> ScriptRuntime.wrapBoolean((boolean)b.options.isIgnoreComments()), (BuiltInSlot.Setter & Serializable)(b, v, o, s, t) -> {
            b.options.setIgnoreComments(ScriptRuntime.toBoolean((Object)v));
            return true;
        });
    }

    private static void defineMethod(ScriptableObject obj, ScriptableObject scope, String name, int length, SerializableCallable target) {
        XMLCtor.defineMethod(obj, (Scriptable)scope, name, length, target, 2, 3, true);
    }

    private static void defineMethod(ScriptableObject obj, Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes, boolean defaultPrototype) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target, defaultPrototype);
        f.setStandardPropertyAttributes(propertyAttributes);
        obj.defineProperty(name, (Object)f, attributes);
    }

    private static void writeSetting(XMLCtor thisObj, Scriptable target) {
        for (String p : propNames) {
            Object value = thisObj.get(p, (Scriptable)thisObj);
            ScriptableObject.putProperty((Scriptable)target, (String)p, (Object)value);
        }
    }

    private static void readSettings(XMLCtor thisObj, Scriptable source) {
        block11: for (String p : propNames) {
            Object value = ScriptableObject.getProperty((Scriptable)source, (String)p);
            if (value == Scriptable.NOT_FOUND) continue;
            switch (p) {
                case "ignoreComments": 
                case "ignoreProcessingInstructions": 
                case "ignoreWhitespace": 
                case "prettyPrinting": {
                    if (value instanceof Boolean) break;
                    continue block11;
                }
                case "prettyIndent": {
                    if (value instanceof Number) break;
                    continue block11;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ScriptableObject.putProperty((Scriptable)thisObj, (String)p, (Object)value);
        }
    }

    public boolean hasInstance(Scriptable instance) {
        return instance instanceof XML || instance instanceof XMLList;
    }
}

