/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.LockAwareSlotMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;
import org.mozilla.javascript.SlotMapOwner;

class ThreadSafeCompoundOperationMap
extends CompoundOperationMap {
    private boolean closed = false;
    private long lockStamp = 0L;

    public ThreadSafeCompoundOperationMap(SlotMapOwner owner, LockAwareSlotMap map, long lockStamp) {
        super(owner);
        this.map = map;
        this.lockStamp = lockStamp;
    }

    @Override
    public void add(SlotMapOwner owner, Slot newSlot) {
        ((LockAwareSlotMap)this.map).addWithLock(owner, newSlot);
        this.touched = true;
    }

    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, Object key, int index, SlotMap.SlotComputer<S> compute) {
        this.updateMap(true);
        S res = ((LockAwareSlotMap)this.map).computeWithLock(owner, this, key, index, compute);
        this.touched = true;
        return res;
    }

    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap compoundOp, Object key, int index, SlotMap.SlotComputer<S> compute) {
        assert (compoundOp == this);
        this.updateMap(true);
        S res = ((LockAwareSlotMap)this.map).computeWithLock(owner, this, key, index, compute);
        this.touched = true;
        return res;
    }

    @Override
    public boolean isEmpty() {
        this.updateMap(false);
        return ((LockAwareSlotMap)this.map).isEmptyWithLock();
    }

    @Override
    public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
        this.updateMap(true);
        Slot res = ((LockAwareSlotMap)this.map).modifyWithLock(owner, key, index, attributes);
        this.touched = true;
        return res;
    }

    @Override
    public Slot query(Object key, int index) {
        this.updateMap(false);
        return ((LockAwareSlotMap)this.map).queryWithLock(key, index);
    }

    @Override
    public int size() {
        this.updateMap(false);
        return ((LockAwareSlotMap)this.map).sizeWithLock();
    }

    @Override
    public Iterator<Slot> iterator() {
        this.updateMap(false);
        return new Iter(this.map.iterator());
    }

    @Override
    public void close() {
        if (!this.closed) {
            ((LockAwareSlotMap)this.owner.getMap()).releaseLock(this.lockStamp);
            this.closed = true;
        }
    }

    private static class Iter
    implements Iterator<Slot> {
        private final Iterator<Slot> mapIterator;

        private Iter(Iterator<Slot> mapIterator) {
            this.mapIterator = mapIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        @Override
        public Slot next() {
            return this.mapIterator.next();
        }
    }
}

