/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.CookieAttributes;
import io.undertow.server.session.SessionConfig;

public class SessionCookieConfig
extends CookieAttributes<SessionCookieConfig>
implements SessionConfig {
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    public static final String DEFAULT_PATH = "/";
    private String cookieName = "JSESSIONID";

    @Override
    public String rewriteUrl(String originalUrl, String sessionId) {
        return originalUrl;
    }

    public SessionCookieConfig() {
        this.kernel.setPath(DEFAULT_PATH);
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        CookieImpl cookie = new CookieImpl(this.cookieName, sessionId, this.kernel);
        exchange.setResponseCookie(cookie);
        UndertowLogger.SESSION_LOGGER.tracef("Setting session cookie session id %s on %s", sessionId, exchange);
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        CookieImpl cookie = new CookieImpl(this.cookieName, sessionId, this.kernel).setMaxAge(0);
        exchange.setResponseCookie(cookie);
        UndertowLogger.SESSION_LOGGER.tracef("Clearing session cookie session id %s on %s", sessionId, exchange);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Cookie cookie = exchange.getRequestCookie(this.cookieName);
        if (cookie != null) {
            UndertowLogger.SESSION_LOGGER.tracef("Found session cookie session id %s on %s", cookie, exchange);
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.findSessionId(exchange) != null ? SessionConfig.SessionCookieSource.COOKIE : SessionConfig.SessionCookieSource.NONE;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public SessionCookieConfig setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }
}

