/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.core.server.routing.policies.RoundRobinPolicy;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastConnectionsPolicy
extends RoundRobinPolicy {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NAME = "LEAST_CONNECTIONS";
    public static final String UPDATE_CONNECTION_COUNT_PROBE_NAME = "UPDATE_CONNECTION_COUNT_PROBE";
    public static final String CONNECTION_COUNT_THRESHOLD = "CONNECTION_COUNT_THRESHOLD";
    private final Map<Target, Integer> connectionCountCache = new ConcurrentHashMap<Target, Integer>();
    private int connectionCountThreshold = 0;
    private final TargetProbe targetProbe = new TargetProbe("UPDATE_CONNECTION_COUNT_PROBE"){

        @Override
        public boolean check(Target target) {
            try {
                Integer connectionCount = target.getAttribute("broker", "ConnectionCount", Integer.class, 3000);
                if (connectionCount < LeastConnectionsPolicy.this.connectionCountThreshold) {
                    logger.debug("Updating the connection count to 0/{} for the target {}", (Object)connectionCount, (Object)target);
                    connectionCount = 0;
                } else {
                    logger.debug("Updating the connection count to {} for the target {}", (Object)connectionCount, (Object)target);
                }
                LeastConnectionsPolicy.this.connectionCountCache.put(target, connectionCount);
                return true;
            }
            catch (Exception e) {
                logger.warn("Error on updating the connectionCount for the target {}", (Object)target, (Object)e);
                return false;
            }
        }
    };

    @Override
    public TargetProbe getTargetProbe() {
        return this.targetProbe;
    }

    public LeastConnectionsPolicy() {
        super(NAME);
    }

    @Override
    public void init(Map<String, String> properties) {
        super.init(properties);
        if (properties != null && properties.containsKey(CONNECTION_COUNT_THRESHOLD)) {
            this.connectionCountThreshold = Integer.parseInt(properties.get(CONNECTION_COUNT_THRESHOLD));
        }
    }

    @Override
    public Target selectTarget(List<Target> targets, String key) {
        if (targets.size() > 1) {
            TreeMap<Integer, ArrayList<Target>> sortedTargets = new TreeMap<Integer, ArrayList<Target>>();
            for (Target target : targets) {
                ArrayList<Target> leastTargets;
                Integer connectionCount = this.connectionCountCache.get(target);
                if (connectionCount == null) {
                    connectionCount = Integer.MAX_VALUE;
                }
                if ((leastTargets = (ArrayList<Target>)sortedTargets.get(connectionCount)) == null) {
                    leastTargets = new ArrayList<Target>();
                    sortedTargets.put(connectionCount, leastTargets);
                }
                leastTargets.add(target);
            }
            logger.debug("LeastConnectionsPolicy.sortedTargets: {}", sortedTargets);
            List selectedTargets = (List)sortedTargets.firstEntry().getValue();
            if (selectedTargets.size() > 1) {
                return super.selectTarget(selectedTargets, key);
            }
            return (Target)selectedTargets.get(0);
        }
        if (targets.size() > 0) {
            return targets.get(0);
        }
        return null;
    }
}

