/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.dsig.Reference;
import org.apache.wss4j.common.EncryptionActionToken;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.SignatureEncryptionActionToken;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.action.AbstractDerivedAction;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureDerivedAction
extends AbstractDerivedAction
implements Action {
    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = reqData.getCallbackHandler();
        if (callbackHandler == null) {
            callbackHandler = handler.getPasswordCallbackHandler(reqData);
        }
        SignatureActionToken signatureToken = null;
        if (actionToken instanceof SignatureActionToken) {
            signatureToken = (SignatureActionToken)actionToken;
        }
        if (signatureToken == null) {
            signatureToken = reqData.getSignatureToken();
        }
        WSPasswordCallback passwordCallback = handler.getPasswordCB(signatureToken.getUser(), 32768, callbackHandler, reqData);
        WSSecDKSign wsSign = new WSSecDKSign(reqData.getSecHeader());
        wsSign.setIdAllocator(reqData.getWssConfig().getIdAllocator());
        wsSign.setAddInclusivePrefixes(reqData.isAddInclusivePrefixes());
        wsSign.setWsDocInfo(reqData.getWsDocInfo());
        wsSign.setExpandXopInclude(reqData.isExpandXopInclude());
        if (signatureToken.getSignatureAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(signatureToken.getSignatureAlgorithm());
        }
        if (signatureToken.getDigestAlgorithm() != null) {
            wsSign.setDigestAlgorithm(signatureToken.getDigestAlgorithm());
        }
        if (signatureToken.getC14nAlgorithm() != null) {
            wsSign.setSigCanonicalization(signatureToken.getC14nAlgorithm());
        }
        wsSign.setUserInfo(signatureToken.getUser(), passwordCallback.getPassword());
        if (reqData.isUse200512Namespace()) {
            wsSign.setWscVersion(2);
        } else {
            wsSign.setWscVersion(1);
        }
        if (signatureToken.getDerivedKeyLength() > 0) {
            wsSign.setDerivedKeyLength(signatureToken.getDerivedKeyLength());
        }
        Document doc = reqData.getSecHeader().getSecurityHeaderElement().getOwnerDocument();
        String derivedKeyTokenReference = signatureToken.getDerivedKeyTokenReference();
        Element tokenElement = null;
        SecretKey symmetricKey = null;
        if ("EncryptedKey".equals(derivedKeyTokenReference)) {
            if (reqData.getEncryptionToken() == null || reqData.getEncryptionToken().getKey() == null || reqData.getEncryptionToken().getKeyIdentifier() == null) {
                String symmetricKeyAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)symmetricKeyAlgorithm);
                symmetricKey = keyGen.generateKey();
            }
            tokenElement = this.setupEncryptedKeyTokenReference(reqData, signatureToken, wsSign, symmetricKey);
        } else if ("SecurityContextToken".equals(derivedKeyTokenReference)) {
            tokenElement = this.setupSCTTokenReference(reqData, signatureToken, wsSign, passwordCallback, doc);
        } else {
            if (signatureToken.getDerivedKeyIdentifier() != 0) {
                wsSign.setKeyIdentifierType(signatureToken.getDerivedKeyIdentifier());
            } else {
                wsSign.setKeyIdentifierType(8);
            }
            wsSign.setCrypto(signatureToken.getCrypto());
        }
        wsSign.setAttachmentCallbackHandler(reqData.getAttachmentCallbackHandler());
        wsSign.setStoreBytesInAttachment(reqData.isStoreBytesInAttachment());
        try {
            List parts = signatureToken.getParts();
            if (parts != null && !parts.isEmpty()) {
                wsSign.getParts().addAll(parts);
            } else {
                wsSign.getParts().add(WSSecurityUtil.getDefaultEncryptionPart(doc));
            }
            byte[] key = this.getKey(signatureToken, reqData.getEncryptionToken(), passwordCallback, symmetricKey);
            wsSign.prepare(key);
            List<Reference> referenceList = wsSign.addReferencesToSign(wsSign.getParts());
            Node nextSibling = null;
            if (tokenElement == null && "EncryptedKey".equals(signatureToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findEncryptedKeySibling(reqData);
            } else if (tokenElement == null && "SecurityContextToken".equals(signatureToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findSCTSibling(reqData);
            }
            if (nextSibling == null) {
                wsSign.computeSignature(referenceList);
            } else {
                wsSign.computeSignature(referenceList, true, (Element)nextSibling);
            }
            if (nextSibling == null) {
                wsSign.prependDKElementToHeader();
            } else {
                reqData.getSecHeader().getSecurityHeaderElement().insertBefore(wsSign.getdktElement(), wsSign.getSignatureElement());
            }
            if (tokenElement != null) {
                WSSecurityUtil.prependChildElement(reqData.getSecHeader().getSecurityHeaderElement(), tokenElement);
            }
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
            wsSign.clean();
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "empty", new Object[]{"Error during Signature: "});
        }
    }

    private Element setupEncryptedKeyTokenReference(RequestData reqData, SignatureActionToken signatureToken, WSSecDKSign wsSign, SecretKey symmetricKey) throws WSSecurityException {
        if (symmetricKey == null) {
            this.setupEKReference(wsSign, (SignatureEncryptionActionToken)reqData.getEncryptionToken());
            return null;
        }
        return this.setupEKReference(wsSign, reqData.getSecHeader(), (SignatureEncryptionActionToken)signatureToken, null, null, symmetricKey);
    }

    private Element setupSCTTokenReference(RequestData reqData, SignatureActionToken signatureToken, WSSecDKSign wsSign, WSPasswordCallback passwordCallback, Document doc) throws WSSecurityException {
        if (reqData.getEncryptionToken() != null && reqData.getEncryptionToken().getKey() != null && reqData.getEncryptionToken().getKeyIdentifier() != null) {
            this.setupSCTReference(wsSign, (SignatureEncryptionActionToken)reqData.getEncryptionToken(), reqData.isUse200512Namespace());
            return null;
        }
        return this.setupSCTReference(wsSign, passwordCallback, (SignatureEncryptionActionToken)signatureToken, reqData.isUse200512Namespace(), doc);
    }

    private byte[] getKey(SignatureActionToken signatureToken, EncryptionActionToken encryptionToken, WSPasswordCallback passwordCallback, SecretKey symmetricKey) throws WSSecurityException {
        boolean directReference;
        String derivedKeyTokenReference = signatureToken.getDerivedKeyTokenReference();
        boolean bl = directReference = !"EncryptedKey".equals(derivedKeyTokenReference) && !"SecurityContextToken".equals(derivedKeyTokenReference);
        if (symmetricKey != null) {
            return symmetricKey.getEncoded();
        }
        if (directReference) {
            byte[] key = null;
            if (passwordCallback.getKey() != null) {
                key = passwordCallback.getKey();
            } else if (signatureToken.getKey() != null) {
                key = signatureToken.getKey();
            } else if (signatureToken.getCrypto() != null) {
                Crypto crypto = signatureToken.getCrypto();
                key = crypto.getPrivateKey(signatureToken.getUser(), passwordCallback.getPassword()).getEncoded();
            }
            return key;
        }
        if (encryptionToken != null && encryptionToken.getKey() != null && encryptionToken.getKeyIdentifier() != null) {
            return encryptionToken.getKey();
        }
        return passwordCallback.getKey();
    }
}

