/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.outbound;

import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionMetaData;
import jakarta.xml.ws.BindingProvider;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jca.core.logging.LoggerHelper;
import org.apache.cxf.jca.outbound.CXFConnection;
import org.apache.cxf.jca.outbound.CXFConnectionSpec;
import org.apache.cxf.jca.outbound.CXFManagedConnectionMetaData;
import org.apache.cxf.jca.outbound.ManagedConnectionFactoryImpl;

public class ManagedConnectionImpl
implements ManagedConnection {
    private static final Logger LOG = LogUtils.getL7dLogger(ManagedConnectionImpl.class);
    private Set<ConnectionEventListener> listeners = Collections.synchronizedSet(new HashSet());
    private Map<Object, Subject> handles = Collections.synchronizedMap(new HashMap());
    private PrintWriter printWriter;
    private ManagedConnectionFactoryImpl mcf;
    private ConnectionRequestInfo connReqInfo;
    private boolean isClosed;
    private Bus bus;
    private Object associatedHandle;
    private Object clientProxy;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl mcf, ConnectionRequestInfo connReqInfo, Subject subject) {
        this.mcf = mcf;
        this.connReqInfo = connReqInfo;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("add listener : " + listener);
        }
        this.listeners.add(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("associate handle : " + connection);
        }
        this.associatedHandle = connection;
    }

    public void cleanup() throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("cleanup");
        }
        this.handles.clear();
        this.isClosed = false;
    }

    public void destroy() throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("destroy");
        }
        Client client = ClientProxy.getClient((Object)this.clientProxy);
        client.destroy();
        this.handles.clear();
        this.isClosed = false;
        this.bus = null;
        this.connReqInfo = null;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("get handle for subject=" + subject + " cxRequestInfo=" + cxRequestInfo);
        }
        if (this.isClosed) {
            throw new ResourceException("connection has been closed");
        }
        if (!this.connReqInfo.equals((Object)cxRequestInfo)) {
            throw new ResourceException("connection request info: " + cxRequestInfo + " does not match " + this.connReqInfo);
        }
        CXFConnectionSpec spec = (CXFConnectionSpec)cxRequestInfo;
        Object handle = this.createConnectionHandle(spec);
        this.handles.put(handle, subject);
        this.associatedHandle = handle;
        return handle;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("LocalTransaction is not supported.");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new CXFManagedConnectionMetaData(this.getUserName());
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XAResource is not supported.");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.printWriter = out;
        if (this.printWriter != null) {
            LoggerHelper.initializeLoggingOnWriter(this.printWriter);
        }
    }

    public ConnectionRequestInfo getRequestInfo() {
        return this.connReqInfo;
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactoryImpl() {
        return this.mcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConnectionEvent coEvent) {
        Set<ConnectionEventListener> set = this.listeners;
        synchronized (set) {
            Iterator<ConnectionEventListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                this.sendEventToListener(iterator.next(), coEvent);
            }
        }
    }

    private void sendEventToListener(ConnectionEventListener listener, ConnectionEvent coEvent) {
        if (coEvent.getId() == 1) {
            listener.connectionClosed(coEvent);
        }
        if (coEvent.getId() == 3) {
            listener.localTransactionCommitted(coEvent);
        }
        if (coEvent.getId() == 4) {
            listener.localTransactionRolledback(coEvent);
        }
        if (coEvent.getId() == 2) {
            listener.localTransactionStarted(coEvent);
        }
        if (coEvent.getId() == 5) {
            listener.connectionErrorOccurred(coEvent);
        }
    }

    private String getUserName() {
        Subject subject;
        if (this.associatedHandle != null && (subject = this.handles.get(this.associatedHandle)) != null) {
            return subject.toString();
        }
        return null;
    }

    private Object createConnectionHandle(CXFConnectionSpec spec) {
        Class[] interfaces = new Class[]{CXFConnection.class, BindingProvider.class, spec.getServiceClass()};
        return Proxy.newProxyInstance(spec.getServiceClass().getClassLoader(), interfaces, (InvocationHandler)new ConnectionInvocationHandler(this.createClientProxy(spec), spec));
    }

    private synchronized Object createClientProxy(CXFConnectionSpec spec) {
        if (this.clientProxy == null) {
            this.validateConnectionSpec(spec);
            Object factory = EndpointUtils.hasWebServiceAnnotation(spec.getServiceClass()) ? new JaxWsProxyFactoryBean() : new ClientProxyFactoryBean();
            factory.setBus(this.getBus(spec.getBusConfigURL()));
            factory.setServiceClass(spec.getServiceClass());
            factory.getServiceFactory().setEndpointName(spec.getEndpointName());
            factory.getServiceFactory().setServiceName(spec.getServiceName());
            factory.getServiceFactory().setWsdlURL(spec.getWsdlURL());
            if (spec.getAddress() != null) {
                factory.setAddress(spec.getAddress());
            }
            this.configureObject(spec.getEndpointName().toString() + ".jaxws-client.proxyFactory", factory);
            this.clientProxy = factory.create();
        }
        return this.clientProxy;
    }

    private void validateConnectionSpec(CXFConnectionSpec spec) {
        if (spec.getServiceClass() == null) {
            throw new IllegalArgumentException("no serviceClass in connection spec");
        }
        if (spec.getEndpointName() == null) {
            throw new IllegalArgumentException("no endpointName in connection spec");
        }
        if (spec.getServiceName() == null) {
            throw new IllegalArgumentException("no serviceName in connection spec");
        }
        if (spec.getWsdlURL() == null) {
            throw new IllegalArgumentException("no wsdlURL in connection spec");
        }
    }

    private void configureObject(String name, Object instance) {
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, instance);
        }
    }

    private synchronized Bus getBus(URL busConfigLocation) {
        if (this.bus == null) {
            if (busConfigLocation != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Create bus from location " + busConfigLocation);
                }
                this.bus = new SpringBusFactory().createBus(busConfigLocation);
            } else if (this.mcf.getBusConfigURL() != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Create bus from URL " + this.mcf.getBusConfigURL());
                }
                URL url = null;
                try {
                    url = new URL(this.mcf.getBusConfigURL());
                }
                catch (MalformedURLException e) {
                    LOG.warning("Malformed URL " + this.mcf.getBusConfigURL());
                }
                if (url != null) {
                    this.bus = new SpringBusFactory().createBus(url);
                }
            }
            if (this.bus == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Create default bus");
                }
                this.bus = BusFactory.getDefaultBus();
            }
        }
        return this.bus;
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private Object target;
        private CXFConnectionSpec spec;

        ConnectionInvocationHandler(Object target, CXFConnectionSpec spec) {
            this.target = target;
            this.spec = spec;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("invoke connection spec:" + this.spec + " method=" + method);
            }
            if ("hashCode".equals(method.getName())) {
                return method.invoke((Object)Proxy.getInvocationHandler(proxy), args);
            }
            if ("equals".equals(method.getName())) {
                boolean result = false;
                try {
                    result = proxy == args[0] && this == Proxy.getInvocationHandler(args[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
            if ("toString".equals(method.getName())) {
                return "ManagedConnection: " + this.spec;
            }
            if (!ManagedConnectionImpl.this.handles.containsKey(proxy)) {
                throw new IllegalArgumentException("Stale connection");
            }
            if ("getService".equals(method.getName())) {
                return this.handleGetServiceMethod(proxy, method, args);
            }
            if ("close".equals(method.getName())) {
                return this.handleCloseMethod(proxy, method, args);
            }
            throw new IllegalArgumentException("Unhandled method " + method);
        }

        private Object handleGetServiceMethod(Object proxy, Method method, Object[] args) {
            if (!this.spec.getServiceClass().equals(args[0])) {
                throw new IllegalArgumentException("serviceClass " + args[0] + " does not match " + this.spec.getServiceClass());
            }
            return this.target;
        }

        private Object handleCloseMethod(Object proxy, Method method, Object[] args) {
            ManagedConnectionImpl.this.handles.remove(proxy);
            ManagedConnectionImpl.this.associatedHandle = null;
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)ManagedConnectionImpl.this, 1);
            event.setConnectionHandle(proxy);
            ManagedConnectionImpl.this.sendEvent(event);
            return null;
        }
    }
}

