/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.util;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyData(SequentialFile from, SequentialFile to, ByteBuffer buffer) throws Exception {
        boolean fromIsOpen = from.isOpen();
        boolean toIsOpen = to.isOpen();
        from.close();
        from.open();
        if (!toIsOpen) {
            to.open();
        }
        to.position(to.size());
        from.position(0L);
        try {
            int bytesRead;
            do {
                buffer.clear();
                bytesRead = from.read(buffer);
                if (logger.isTraceEnabled()) {
                    logger.trace("appending {} bytes on {}", (Object)bytesRead, (Object)to.getFileName());
                }
                if (bytesRead <= 0) continue;
                to.writeDirect(buffer, false);
            } while (bytesRead >= buffer.capacity());
            logger.trace("Interrupting reading as the whole thing was sent on {}", (Object)to.getFileName());
        }
        finally {
            if (!fromIsOpen) {
                from.close();
            } else {
                from.position(from.size());
            }
            if (!toIsOpen) {
                to.close();
            } else {
                to.position(to.size());
            }
        }
    }
}

