/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.function;

import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionFunction;

@FunctionalInterface
public interface ExceptionUnaryOperator<T, E extends Exception>
extends ExceptionFunction<T, T, E> {
    @Override
    default public ExceptionUnaryOperator<T, E> andThen(ExceptionUnaryOperator<T, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.apply(this.apply(t));
    }

    @Override
    default public ExceptionUnaryOperator<T, E> compose(ExceptionUnaryOperator<T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return t -> this.apply(before.apply(t));
    }

    public static <T, E extends Exception> ExceptionUnaryOperator<T, E> of(ExceptionFunction<T, T, E> func) {
        return func instanceof ExceptionUnaryOperator ? (ExceptionUnaryOperator)func : func::apply;
    }

    public static <T, E extends Exception> ExceptionUnaryOperator<T, E> identity() {
        return t -> t;
    }
}

