/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class InterfaceInvocationHandler
implements InvocationHandler {
    private Map<Object, Object> attributes = new HashMap<Object, Object>();

    InterfaceInvocationHandler() {
    }

    public void writeProperty(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object readProperty(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.getMethod("hashCode", null).equals(method)) {
            return this.proxyHashCode(proxy);
        }
        if (Object.class.getMethod("equals", Object.class).equals(method)) {
            return this.proxyEquals(proxy, args[0]);
        }
        if (Object.class.getMethod("toString", null).equals(method)) {
            return this.proxyToString(proxy);
        }
        if (this.isGetterMethod(method, args)) {
            return this.doGetter(method, args);
        }
        if (this.isSetterMethod(method, args)) {
            return this.doSetter(method, args);
        }
        throw new IllegalAccessError(method.getName() + " is not delegated.");
    }

    protected boolean isGetterMethod(Method method, Object[] args) {
        if (args != null && args.length > 0) {
            return false;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return true;
        }
        return methodName.length() > 2 && methodName.startsWith("is");
    }

    protected boolean isSetterMethod(Method method, Object[] args) {
        if (args == null || args.length != 1) {
            return false;
        }
        if (!"void".equals(method.getReturnType().getName())) {
            return false;
        }
        String methodName = method.getName();
        return methodName.startsWith("set") && methodName.length() > 3;
    }

    protected Object doGetter(Method method, Object[] args) throws Throwable {
        String attrName;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            attrName = this.convertMethodName(methodName, 3);
        } else if (methodName.startsWith("is")) {
            attrName = this.convertMethodName(methodName, 2);
        } else {
            throw new IllegalAccessError(methodName + " is not a valid getter method.");
        }
        Object prop = this.readProperty(attrName);
        if (prop == null && method.getReturnType().isPrimitive()) {
            if (method.getReturnType() == Integer.TYPE) {
                prop = 0;
            } else if (method.getReturnType() == Boolean.TYPE) {
                prop = Boolean.FALSE;
            } else if (method.getReturnType() == Long.TYPE) {
                prop = 0L;
            } else if (method.getReturnType() == Double.TYPE) {
                prop = 0.0;
            } else if (method.getReturnType() == Short.TYPE) {
                prop = (short)0;
            } else if (method.getReturnType() == Byte.TYPE) {
                prop = (byte)0;
            } else if (method.getReturnType() == Character.TYPE) {
                prop = Character.valueOf('\u0000');
            }
        }
        return prop;
    }

    protected Object doSetter(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!methodName.startsWith("set")) {
            throw new IllegalAccessError(methodName + " is not a valid setter method.");
        }
        String attrName = this.convertMethodName(methodName, 3);
        this.writeProperty(attrName, args[0]);
        return null;
    }

    private String convertMethodName(String methodName, int firstCharacter) {
        if (methodName.length() >= firstCharacter + 2) {
            if (!Character.isUpperCase(methodName.charAt(firstCharacter + 1))) {
                return Character.toLowerCase(methodName.charAt(firstCharacter)) + methodName.substring(firstCharacter + 1);
            }
            return methodName.substring(3);
        }
        return Character.toLowerCase(methodName.charAt(firstCharacter)) + methodName.substring(firstCharacter + 1);
    }

    protected Integer proxyHashCode(Object proxy) {
        return System.identityHashCode(proxy);
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + proxy.hashCode();
    }
}

