/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.bval.jsr.valueextraction;

import java.util.Map;

import jakarta.validation.valueextraction.ExtractedValue;
import jakarta.validation.valueextraction.ValueExtractor;

public abstract class MapExtractor {
    public static class ForKey implements ValueExtractor<Map<@ExtractedValue ?, ?>> {

        @Override
        public void extractValues(Map<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            originalValue.keySet().forEach(k -> receiver.keyedValue("<map key>", k, k));
        }
    }

    public static class ForValue implements ValueExtractor<Map<?, @ExtractedValue ?>> {

        @Override
        public void extractValues(Map<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            originalValue.entrySet().forEach(e -> receiver.keyedValue("<map value>", e.getKey(), e.getValue()));
        }
    }
}
