/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.autorecovery;

import com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class TriggerAuditCommand
extends BookieCommand<CliFlags> {
    private static final String NAME = "triggeraudit";
    private static final String DESC = "Force trigger the Audit by resetting the lostBookieRecoveryDelay.";

    public TriggerAuditCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            return this.handler(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handler(ServerConfiguration configuration) throws Exception {
        ClientConfiguration adminConf = new ClientConfiguration(configuration);
        try (BookKeeperAdmin admin = new BookKeeperAdmin(adminConf);){
            admin.triggerAudit();
        }
        return true;
    }
}

