/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.language.spel.SpelExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.RegistryBeanResolver;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;

@Language(value="spel")
public class SpelLanguage
extends TypedLanguageSupport
implements StaticService {
    private BeanResolver beanResolver;

    public Predicate createPredicate(String expression) {
        return this.createSpelExpression(expression, Boolean.class);
    }

    public Expression createExpression(String expression) {
        return this.createSpelExpression(expression, Object.class);
    }

    private SpelExpression createSpelExpression(String expression, Class<?> type) {
        SpelExpression answer = new SpelExpression(this.loadResource(expression), type, this.beanResolver);
        answer.init(this.getCamelContext());
        return answer;
    }

    public void init() {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)((Object)this));
        if (this.getCamelContext() instanceof SpringCamelContext) {
            ApplicationContext applicationContext = ((SpringCamelContext)this.getCamelContext()).getApplicationContext();
            this.beanResolver = new BeanFactoryResolver((BeanFactory)applicationContext);
        } else {
            this.beanResolver = new RegistryBeanResolver(this.getCamelContext().getRegistry());
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

