/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="4.11.0", label="dataformat,transformation", title="DFDL")
@XmlRootElement(name="dfdl")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DfdlDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(required=true, description="The path to the DFDL schema file.")
    private String schemaUri;
    @XmlAttribute
    @Metadata(description="The root element name of the schema to use. If not specified, the first root element in the schema will be used.", label="advanced")
    private String rootElement;
    @XmlAttribute
    @Metadata(description="The root namespace of the schema to use.", label="advanced")
    private String rootNamespace;

    public DfdlDataFormat() {
        super("dfdl");
    }

    protected DfdlDataFormat(DfdlDataFormat source) {
        super(source);
        this.schemaUri = source.schemaUri;
        this.rootElement = source.rootElement;
        this.rootNamespace = source.rootNamespace;
    }

    public DfdlDataFormat(String schemaUri) {
        this();
        this.setSchemaUri(schemaUri);
    }

    private DfdlDataFormat(Builder builder) {
        this();
        this.schemaUri = builder.schemaUri;
        this.rootElement = builder.rootElement;
        this.rootNamespace = builder.rootNamespace;
    }

    @Override
    public DfdlDataFormat copyDefinition() {
        return new DfdlDataFormat(this);
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public String getRootNamespace() {
        return this.rootNamespace;
    }

    public void setRootNamespace(String rootNamespace) {
        this.rootNamespace = rootNamespace;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<DfdlDataFormat> {
        private String schemaUri;
        private String rootElement;
        private String rootNamespace;

        public Builder schemaUri(String schemaUri) {
            this.schemaUri = schemaUri;
            return this;
        }

        public Builder rootElement(String rootElement) {
            this.rootElement = rootElement;
            return this;
        }

        public Builder rootNamespace(String rootNamespace) {
            this.rootNamespace = rootNamespace;
            return this;
        }

        @Override
        public DfdlDataFormat end() {
            return new DfdlDataFormat(this);
        }
    }
}

