/*                                                                
**  Copyright (C) 1996,2007,2010,2019  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* f77.c
**
**
**
**/



#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "f77.h"

#define MAX_ARGC	 512
#define MAX_LINE	4096

static int F77argc;
static char **F77argv = 0;

#define CStringLength	1024

char CString1[CStringLength];
char CString2[CStringLength];


extern int IARGC_F77 (void);
extern void GETARG_F77 (int *, char *, int);

char *
strf2c (int length, char *string, char *cstring)
{
  while (length && string[--length] == ' ');
  if (string[length] != ' ')
    length++;

  strncpy (cstring, string, length);
  cstring[length] = '\0';

  return cstring;
}

void
strc2f (char *cstring, char *fstring, int length)
{
  int i;

  /* Copy the C string, then padd with ' ' */
  for (i = 0; *cstring; i++)
    *fstring++ = *cstring++;
  for (; i < length; i++)
    *fstring++ = ' ';
}


char **
GetF77argv (int *argc)
{
  int i;

  if (F77argv)
    {
      *argc = F77argc;
      return F77argv;
    }
  F77argv = (char **) malloc (sizeof (char *) * MAX_ARGC);

  *argc = F77argc = IARGC_F77 () + 1;

  for (i = 0; i < F77argc; i++)
    {
      F77argv[i] = (char *) malloc (MAX_LINE);
      GETARG_F77 (&i, F77argv[i], MAX_LINE);
      strf2c (MAX_LINE, F77argv[i], F77argv[i]);
      F77argv[i] = (char *) realloc (F77argv[i], strlen (F77argv[i]) + 1);
    }

  F77argv = (char **) realloc (F77argv, sizeof (char *) * i);

  return F77argv;
}
