package Lido::XML::LIDO_1_0::coverage;

use Moo;

our $VERSION = '0.07';

sub content {
	my @lines = <DATA>;
	join '' , @lines;
}

1;
__DATA__
<?xml version="1.0" encoding="UTF-8"?>
<schema targetNamespace="http://www.opengis.net/gml" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2001/XMLSchema" xmlns:gml="http://www.opengis.net/gml" elementFormDefault="qualified" version="3.1.1.2">
	<annotation>
		<appinfo source="urn:opengis:specification:gml:schema-xsd:coverage:3.1.1">coverage.xsd</appinfo>
		<documentation xml:lang="en">GML Coverage schema.
			
			GML is an OGC Standard.
			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
		</documentation>
	</annotation>
	<!-- ==============================================================
       includes and imports
	============================================================== -->
	<include schemaLocation="gml.xsd"/>
	<include schemaLocation="feature.xsd"/>
	<include schemaLocation="valueObjects.xsd"/>
	<include schemaLocation="grids.xsd"/>
	<include schemaLocation="geometryAggregates.xsd"/>
	<!-- ==============================================================
       global types and elements
	============================================================== -->
	<!-- ================= Abstract coverage definition ================== -->
	<!-- =========================================================== -->
	<!-- =========================================================== -->
	<element name="_Coverage" type="gml:AbstractCoverageType" abstract="true" substitutionGroup="gml:_Feature"/>
	<!-- =========================================================== -->
	<complexType name="AbstractCoverageType" abstract="true">
		<annotation>
			<documentation>Abstract element which acts as the head of a substitution group for coverages. Note that a coverage is a GML feature.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractFeatureType">
				<sequence>
					<element ref="gml:domainSet"/>
					<element ref="gml:rangeSet"/>
				</sequence>
				<attribute name="dimension" type="positiveInteger" use="optional"/>
			</extension>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="_ContinuousCoverage" type="gml:AbstractContinuousCoverageType" abstract="true" substitutionGroup="gml:_Coverage"/>
	<!-- =========================================================== -->
	<complexType name="AbstractContinuousCoverageType" abstract="true">
		<annotation>
			<documentation>A continuous coverage as defined in ISO 19123 is a coverage that can return different values for the same feature attribute at different direct positions within a single spatiotemporal object in its spatiotemporal domain</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractCoverageType">
				<sequence>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="_DiscreteCoverage" type="gml:AbstractDiscreteCoverageType" abstract="true" substitutionGroup="gml:_Coverage"/>
	<!-- =========================================================== -->
	<complexType name="AbstractDiscreteCoverageType" abstract="true">
		<annotation>
			<documentation>A discrete coverage consists of a domain set, range set and optionally a coverage function. The domain set consists of either geometry or temporal objects, finite in number. The range set is comprised of a finite number of attribute values each of which is associated to every direct position within any single spatiotemporal object in the domain. In other words, the range values are constant on each spatiotemporal object in the domain. This coverage function maps each element from the coverage domain to an element in its range. This definition conforms to ISO 19123.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractCoverageType">
				<sequence>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="domainSet" type="gml:DomainSetType"/>
	<!-- =========================================================== -->
	<complexType name="DomainSetType">
		<annotation>
			<documentation>The spatiotemporal domain of a coverage.  
  Typically 
  * a geometry collection, 
  * an implicit geometry (e.g. a grid), 
  * an explicit or implicit collection of time instances or periods, or

N.B. Temporal geometric complexes and temporal grids are not yet implemented in GML.</documentation>
		</annotation>
		<sequence minOccurs="0">
			<choice>
				<element ref="gml:_Geometry"/>
				<element ref="gml:_TimeObject"/>
			</choice>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =========================================================== -->
	<element name="rangeSet" type="gml:RangeSetType"/>
	<!-- =========================================================== -->
	<complexType name="RangeSetType">
		<choice>
			<element ref="gml:ValueArray" maxOccurs="unbounded">
				<annotation>
					<documentation>each member _Value holds a tuple or "row" from the equivalent table</documentation>
				</annotation>
			</element>
			<group ref="gml:ScalarValueList" maxOccurs="unbounded">
				<annotation>
					<documentation>each list holds the complete set of one scalar component from the values - i.e. a "column" from the equivalent table</documentation>
				</annotation>
			</group>
			<element ref="gml:DataBlock">
				<annotation>
					<documentation>Its tuple list holds the values as space-separated tuples each of which contains comma-separated components, and the tuple structure is specified using the rangeParameters property.</documentation>
				</annotation>
			</element>
			<element ref="gml:File">
				<annotation>
					<documentation>a reference to an external source for the data, together with a description of how that external source is structured</documentation>
				</annotation>
			</element>
		</choice>
	</complexType>
	<!-- =========================================================== -->
	<element name="coverageFunction" type="gml:CoverageFunctionType"/>
	<!-- =========================================================== -->
	<complexType name="CoverageFunctionType">
		<annotation>
			<documentation>The function or rule which defines the map from members of the domainSet to the range.  
      More functions will be added to this list</documentation>
		</annotation>
		<choice>
			<element ref="gml:MappingRule"/>
			<element ref="gml:GridFunction"/>
		</choice>
	</complexType>
	<!-- =========================================================== -->
	<!-- ============== Components for encoding the rangeSet ============= -->
	<!-- =========================================================== -->
	<element name="DataBlock" type="gml:DataBlockType"/>
	<!-- =========================================================== -->
	<complexType name="DataBlockType">
		<sequence>
			<element ref="gml:rangeParameters"/>
			<choice>
				<element ref="gml:tupleList"/>
				<element ref="gml:doubleOrNullTupleList"/>
			</choice>
		</sequence>
	</complexType>
	<!-- =========================================================== -->
	<element name="tupleList" type="gml:CoordinatesType"/>
	<!-- =========================================================== -->
	<element name="doubleOrNullTupleList" type="gml:doubleOrNullList"/>
	<!-- =========================================================== -->
	<element name="File" type="gml:FileType"/>
	<!-- =========================================================== -->
	<complexType name="FileType">
		<sequence>
			<element ref="gml:rangeParameters"/>
			<element name="fileName" type="anyURI"/>
			<element name="fileStructure" type="gml:FileValueModelType"/>
			<element name="mimeType" type="anyURI" minOccurs="0"/>
			<element name="compression" type="anyURI" minOccurs="0"/>
		</sequence>
	</complexType>
	<!-- =========================================================== -->
	<simpleType name="FileValueModelType">
		<annotation>
			<documentation>List of codes that identifies the file structure model for records stored in files.</documentation>
		</annotation>
		<restriction base="string">
			<enumeration value="Record Interleaved"/>
		</restriction>
	</simpleType>
	<!-- =========================================================== -->
	<element name="rangeParameters" type="gml:RangeParametersType"/>
	<!-- =========================================================== -->
	<complexType name="RangeParametersType">
		<annotation>
			<documentation>Metadata about the rangeSet.  Definition of record structure.   
      This is required if the rangeSet is encoded in a DataBlock.  
      We use a gml:_Value with empty values as a map of the composite value structure.</documentation>
		</annotation>
		<sequence minOccurs="0">
			<group ref="gml:ValueObject"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =========================================================== -->
	<!-- ============= Components for coverageFunctions ================ -->
	<!-- =========================================================== -->
	<element name="MappingRule" type="gml:StringOrRefType">
		<annotation>
			<documentation>Description of a rule for associating members from the domainSet with members of the rangeSet.</documentation>
		</annotation>
	</element>
	<!-- =========================================================== -->
	<element name="GridFunction" type="gml:GridFunctionType"/>
	<!-- =========================================================== -->
	<complexType name="GridFunctionType">
		<annotation>
			<documentation>Defines how values in the domain are mapped to the range set. The start point and the sequencing rule are specified here.</documentation>
		</annotation>
		<sequence>
			<element name="sequenceRule" type="gml:SequenceRuleType" minOccurs="0">
				<annotation>
					<documentation>If absent, the implied value is "Linear".</documentation>
				</annotation>
			</element>
			<element name="startPoint" type="gml:integerList" minOccurs="0">
				<annotation>
					<documentation>Index position of the first grid post, which must lie somwhere in the GridEnvelope.  If absent, the startPoint is equal to the value of gridEnvelope::low from the grid definition.</documentation>
				</annotation>
			</element>
		</sequence>
	</complexType>
	<!-- =========================================================== -->
	<element name="IndexMap" type="gml:IndexMapType" substitutionGroup="gml:GridFunction"/>
	<!-- =========================================================== -->
	<complexType name="IndexMapType">
		<annotation>
			<documentation>Exends GridFunctionType with a lookUpTable.  This contains a list of indexes of members within the rangeSet corresponding with the members of the domainSet.  The domainSet is traversed in list order if it is enumerated explicitly, or in the order specified by a SequenceRule if the domain is an implicit set.    The length of the lookUpTable corresponds with the length of the subset of the domainSet for which the coverage is defined.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:GridFunctionType">
				<sequence>
					<element name="lookUpTable" type="gml:integerList"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<complexType name="SequenceRuleType">
		<simpleContent>
			<extension base="gml:SequenceRuleNames">
				<attribute name="order" type="gml:IncrementOrder" use="optional"/>
			</extension>
		</simpleContent>
	</complexType>
	<!-- =========================================================== -->
	<simpleType name="SequenceRuleNames">
		<annotation>
			<documentation>List of codes (adopted from ISO 19123 Annex C) that identifies the rule for traversing a grid to correspond with the sequence of members of the rangeSet.</documentation>
		</annotation>
		<restriction base="string">
			<enumeration value="Linear"/>
			<enumeration value="Boustrophedonic"/>
			<enumeration value="Cantor-diagonal"/>
			<enumeration value="Spiral"/>
			<enumeration value="Morton"/>
			<enumeration value="Hilbert"/>
		</restriction>
	</simpleType>
	<!-- =========================================================== -->
	<simpleType name="IncrementOrder">
		<annotation>
			<documentation>The enumeration value here indicates the incrementation order  to be used on the first 2 axes, i.e. "+x-y" means that the points on the first axis are to be traversed from lowest to highest and  the points on the second axis are to be traversed from highest to lowest. The points on all other axes (if any) beyond the first 2 are assumed to increment from lowest to highest.</documentation>
		</annotation>
		<restriction base="string">
			<enumeration value="+x+y"/>
			<enumeration value="+y+x"/>
			<enumeration value="+x-y"/>
			<enumeration value="-x-y"/>
		</restriction>
	</simpleType>
	<!-- =========================================================== -->
	<!-- == Specialised Coverage types - typed by the structure of the domain set == -->
	<!-- =========================================================== -->
	<element name="MultiPointCoverage" type="gml:MultiPointCoverageType" substitutionGroup="gml:_DiscreteCoverage"/>
	<!-- =========================================================== -->
	<complexType name="MultiPointCoverageType">
		<annotation>
			<documentation>A discrete coverage type whose domain is defined by a collection of point</documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:AbstractDiscreteCoverageType">
				<sequence>
					<group ref="gml:StandardObjectProperties"/>
					<element ref="gml:boundedBy" minOccurs="0"/>
					<element ref="gml:multiPointDomain"/>
					<element ref="gml:rangeSet"/>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="multiPointDomain" type="gml:MultiPointDomainType" substitutionGroup="gml:domainSet"/>
	<!-- =========================================================== -->
	<complexType name="MultiPointDomainType">
		<complexContent>
			<restriction base="gml:DomainSetType">
				<sequence minOccurs="0">
					<element ref="gml:MultiPoint"/>
				</sequence>
				<attributeGroup ref="gml:AssociationAttributeGroup"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="MultiCurveCoverage" type="gml:MultiCurveCoverageType" substitutionGroup="gml:_DiscreteCoverage"/>
	<!-- =========================================================== -->
	<complexType name="MultiCurveCoverageType">
		<annotation>
			<documentation>A discrete coverage type whose domain is defined by a collection of curves.</documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:AbstractDiscreteCoverageType">
				<sequence>
					<group ref="gml:StandardObjectProperties"/>
					<element ref="gml:boundedBy" minOccurs="0"/>
					<element ref="gml:multiCurveDomain"/>
					<element ref="gml:rangeSet"/>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="multiCurveDomain" type="gml:MultiCurveDomainType" substitutionGroup="gml:domainSet"/>
	<!-- =========================================================== -->
	<complexType name="MultiCurveDomainType">
		<complexContent>
			<restriction base="gml:DomainSetType">
				<sequence minOccurs="0">
					<element ref="gml:MultiCurve"/>
				</sequence>
				<attributeGroup ref="gml:AssociationAttributeGroup"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="MultiSurfaceCoverage" type="gml:MultiSurfaceCoverageType" substitutionGroup="gml:_DiscreteCoverage"/>
	<!-- =========================================================== -->
	<complexType name="MultiSurfaceCoverageType">
		<annotation>
			<documentation>A discrete coverage type whose domain is defined by a collection of surface patches (includes polygons, triangles, rectangles, etc).</documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:AbstractDiscreteCoverageType">
				<sequence>
					<group ref="gml:StandardObjectProperties"/>
					<element ref="gml:boundedBy" minOccurs="0"/>
					<element ref="gml:multiSurfaceDomain"/>
					<element ref="gml:rangeSet"/>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="multiSurfaceDomain" type="gml:MultiSurfaceDomainType" substitutionGroup="gml:domainSet"/>
	<!-- =========================================================== -->
	<complexType name="MultiSurfaceDomainType">
		<complexContent>
			<restriction base="gml:DomainSetType">
				<sequence minOccurs="0">
					<element ref="gml:MultiSurface"/>
				</sequence>
				<attributeGroup ref="gml:AssociationAttributeGroup"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="MultiSolidCoverage" type="gml:MultiSolidCoverageType" substitutionGroup="gml:_DiscreteCoverage"/>
	<!-- =========================================================== -->
	<complexType name="MultiSolidCoverageType">
		<annotation>
			<documentation>A discrete coverage type whose domain is defined by a collection of Solids.</documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:AbstractDiscreteCoverageType">
				<sequence>
					<group ref="gml:StandardObjectProperties"/>
					<element ref="gml:boundedBy" minOccurs="0"/>
					<element ref="gml:multiSolidDomain"/>
					<element ref="gml:rangeSet"/>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="multiSolidDomain" type="gml:MultiSolidDomainType" substitutionGroup="gml:domainSet"/>
	<!-- =========================================================== -->
	<complexType name="MultiSolidDomainType">
		<complexContent>
			<restriction base="gml:DomainSetType">
				<sequence minOccurs="0">
					<element ref="gml:MultiSolid"/>
				</sequence>
				<attributeGroup ref="gml:AssociationAttributeGroup"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="GridCoverage" type="gml:GridCoverageType" substitutionGroup="gml:_DiscreteCoverage"/>
	<!-- =========================================================== -->
	<complexType name="GridCoverageType">
		<complexContent>
			<restriction base="gml:AbstractDiscreteCoverageType">
				<sequence>
					<group ref="gml:StandardObjectProperties"/>
					<element ref="gml:boundedBy" minOccurs="0"/>
					<element ref="gml:gridDomain"/>
					<element ref="gml:rangeSet"/>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="gridDomain" type="gml:GridDomainType" substitutionGroup="gml:domainSet"/>
	<!-- =========================================================== -->
	<complexType name="GridDomainType">
		<complexContent>
			<restriction base="gml:DomainSetType">
				<sequence minOccurs="0">
					<element ref="gml:Grid"/>
				</sequence>
				<attributeGroup ref="gml:AssociationAttributeGroup"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="RectifiedGridCoverage" type="gml:RectifiedGridCoverageType" substitutionGroup="gml:_DiscreteCoverage"/>
	<!-- =========================================================== -->
	<complexType name="RectifiedGridCoverageType">
		<complexContent>
			<restriction base="gml:AbstractDiscreteCoverageType">
				<sequence>
					<group ref="gml:StandardObjectProperties"/>
					<element ref="gml:boundedBy" minOccurs="0"/>
					<element ref="gml:rectifiedGridDomain"/>
					<element ref="gml:rangeSet"/>
					<element ref="gml:coverageFunction" minOccurs="0"/>
				</sequence>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="rectifiedGridDomain" type="gml:RectifiedGridDomainType" substitutionGroup="gml:domainSet"/>
	<!-- =========================================================== -->
	<complexType name="RectifiedGridDomainType">
		<complexContent>
			<restriction base="gml:DomainSetType">
				<sequence minOccurs="0">
					<element ref="gml:RectifiedGrid"/>
				</sequence>
				<attributeGroup ref="gml:AssociationAttributeGroup"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
</schema>
