package Task::Tags;

# Pragmas.
use strict;
use warnings;

# Version.
our $VERSION = 0.06;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Tags - Install the Tags modules.

=head1 SYNOPSIS

 cpanm Task::Tags

=head1 SEE ALSO

=over

=item L<Tags>

Structure oriented SGML/XML/HTML/etc. elements manipulation.

=item L<Tags::Element>

Element utilities for 'Tags'.

=item L<Tags::Output>

Base class for Tags::Output::*.

=item L<Tags::Output::Indent>

Indent class for Tags.

=item L<Tags::Output::LibXML>

LibXML output for Tags.

=item L<Tags::Output::PYX>

PYX class for line oriented output for 'Tags'.

=item L<Tags::Output::Raw>

Raw printing 'Tags' structure to tags code.

=item L<Tags::Output::Structure>

Structure class for 'Tags' output.

=item L<Tags::Output::LibXML>

Printing 'Tags' structure by LibXML library.

=item L<Tags::Utils>

Utils module for Tags.

=item L<Tags::Utils::Preserve>

Class to check if content in element is preserved?

=back

=head1 REPOSITORY

L<https://github.com/tupinek/Task-Tags>

=head1 AUTHOR

Michal Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

 © 2015 Michal Špaček
 Artistic License
 BSD 2-Clause License

=head1 VERSION

0.06

=cut
