/*
 * Decompiled with CFR 0.152.
 */
package gma.gsa;

import gma.AxisTick;
import gma.MapPoint;

public class Segment
implements Comparable {
    private int index;
    private float startPosition;
    private float endPosition;
    private float length;

    public Segment(int index, float startPosition, float endPosition, float length) {
        this.index = index;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.length = length;
    }

    public int getIndex() {
        return this.index;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public float getEndPosition() {
        return this.endPosition;
    }

    public float getLength() {
        return this.length;
    }

    public float getDistance() {
        return this.endPosition - this.startPosition;
    }

    public int contains(MapPoint mapPoint, boolean isXAxis) {
        AxisTick axisTick = null;
        axisTick = isXAxis ? mapPoint.getXAxisTick() : mapPoint.getYAxisTick();
        if (axisTick.getPosition() >= this.startPosition && axisTick.getPosition() <= this.endPosition) {
            return 0;
        }
        if (axisTick.getPosition() < this.startPosition) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Object segment) {
        if (this.startPosition == ((Segment)segment).getStartPosition()) {
            return 0;
        }
        if (this.startPosition < ((Segment)segment).getStartPosition()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object segment) {
        return this.startPosition == ((Segment)segment).getStartPosition();
    }

    public String toString() {
        return String.valueOf(this.index);
    }
}

