/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.MimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBodyDescriptorBuilder
implements BodyDescriptorBuilder {
    private static final String CONTENT_TYPE = "Content-Type".toLowerCase(Locale.US);
    private static final String US_ASCII = "us-ascii";
    private static final String SUB_TYPE_EMAIL = "rfc822";
    private static final String MEDIA_TYPE_TEXT = "text";
    private static final String MEDIA_TYPE_MESSAGE = "message";
    private static final String EMAIL_MESSAGE_MIME_TYPE = "message/rfc822";
    private static final String DEFAULT_SUB_TYPE = "plain";
    private static final String DEFAULT_MEDIA_TYPE = "text";
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private final String parentMimeType;
    private final DecodeMonitor monitor;
    private final FieldParser<? extends ParsedField> fieldParser;
    private final Map<String, ParsedField> fields;

    public DefaultBodyDescriptorBuilder() {
        this(null);
    }

    public DefaultBodyDescriptorBuilder(String parentMimeType) {
        this(parentMimeType, null, null);
    }

    public DefaultBodyDescriptorBuilder(String parentMimeType, FieldParser<? extends ParsedField> fieldParser, DecodeMonitor monitor) {
        this.parentMimeType = parentMimeType;
        this.fieldParser = fieldParser != null ? fieldParser : DefaultFieldParser.getParser();
        this.monitor = monitor != null ? monitor : DecodeMonitor.SILENT;
        this.fields = new HashMap<String, ParsedField>();
    }

    @Override
    public void reset() {
        this.fields.clear();
    }

    @Override
    public Field addField(RawField rawfield) throws MimeException {
        ParsedField field = this.fieldParser.parse(rawfield, this.monitor);
        String name = field.getName().toLowerCase(Locale.US);
        if (!this.fields.containsKey(name)) {
            this.fields.put(name, field);
        }
        return field;
    }

    @Override
    public BodyDescriptor build() {
        String actualMimeType = null;
        String actualMediaType = null;
        String actualSubType = null;
        String actualCharset = null;
        String actualBoundary = null;
        ContentTypeField contentTypeField = (ContentTypeField)this.fields.get(CONTENT_TYPE);
        if (contentTypeField != null) {
            actualMimeType = contentTypeField.getMimeType();
            actualMediaType = contentTypeField.getMediaType();
            actualSubType = contentTypeField.getSubType();
            actualCharset = contentTypeField.getCharset();
            actualBoundary = contentTypeField.getBoundary();
        }
        if (actualMimeType == null) {
            if (MimeUtil.isSameMimeType("multipart/digest", this.parentMimeType)) {
                actualMimeType = EMAIL_MESSAGE_MIME_TYPE;
                actualMediaType = MEDIA_TYPE_MESSAGE;
                actualSubType = SUB_TYPE_EMAIL;
            } else {
                actualMimeType = DEFAULT_MIME_TYPE;
                actualMediaType = "text";
                actualSubType = DEFAULT_SUB_TYPE;
            }
        }
        if (actualCharset == null && "text".equals(actualMediaType)) {
            actualCharset = US_ASCII;
        }
        if (!MimeUtil.isMultipart(actualMimeType)) {
            actualBoundary = null;
        }
        return new MaximalBodyDescriptor(actualMimeType, actualMediaType, actualSubType, actualBoundary, actualCharset, this.fields);
    }

    @Override
    public BodyDescriptorBuilder newChild() {
        ContentTypeField contentTypeField = (ContentTypeField)this.fields.get(CONTENT_TYPE);
        String actualMimeType = contentTypeField != null ? contentTypeField.getMimeType() : (MimeUtil.isSameMimeType("multipart/digest", this.parentMimeType) ? EMAIL_MESSAGE_MIME_TYPE : DEFAULT_MIME_TYPE);
        return new DefaultBodyDescriptorBuilder(actualMimeType, this.fieldParser, this.monitor);
    }
}

