/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionName
extends SystemFunction
implements CallableExpression {
    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        FunctionItem f = (FunctionItem)this.getArguments()[0].evaluateItem(context);
        assert (f != null);
        StructuredQName name = f.getFunctionName();
        if (name == null) {
            return null;
        }
        return new QNameValue(name, BuiltInAtomicType.QNAME);
    }

    public SequenceIterator<AtomicValue> call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        FunctionItem f = (FunctionItem)arguments[0].next();
        assert (f != null);
        StructuredQName name = f.getFunctionName();
        if (name == null) {
            return EmptyIterator.emptyIterator();
        }
        return Value.asIterator(new QNameValue(name, BuiltInAtomicType.QNAME));
    }
}

