package Daje::Controller::ToolsObjects;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Controller::Tools - Mojolicious Plugin
#
# SYNOPSIS
# ========
#
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Tools is a Mojolicious plugin.
#
# METHODS
# =======
#
# Register plugin in L<Mojolicious> application.
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

use Data::Dumper;

sub load_object ($self) {

    $self->app->log->debug('Daje::Controller::ToolsObjects::load_object');
    $self->render_later;
    # my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
    #     $self->req->headers->header('X-Token-Check')
    # );
    my $tools_objects_pkey = $self->param('tools_objects_pkey');

    $self->app->log->debug($self->req->headers->header('X-Token-Check'));
    # my $setting = $self->param('setting');
    $self->tools_objects->load_tools_object_pkey_p($tools_objects_pkey)->then(sub($result) {
        $self->render(json => { data => $result->{data}, result => => 1 });
    })->catch(sub($err) {
        $self->render(json => { 'result' => 0, data => $err });
    })->wait;
}

sub load_objects ($self) {

    $self->app->log->debug('Daje::Controller::ToolsObjects::load_objects');
    $self->render_later;
    # my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
    #     $self->req->headers->header('X-Token-Check')
    # );

    $self->app->log->debug($self->req->headers->header('X-Token-Check'));
    # my $setting = $self->param('setting');
    $self->tools_objects->load_full_list_p()->then(sub($result) {
        $self->render(json => { data => $result->{data}, result => => 1 });
    })->catch(sub($err) {
        $self->render(json => { 'result' => 0, data => $err });
    })->wait;
}



1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Controller::Tools - Mojolicious Plugin



=head1 SYNOPSIS






=head1 DESCRIPTION


Daje::Controller::Tools is a Mojolicious plugin.



=head1 REQUIRES

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS


Register plugin in L<Mojolicious> application.



=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.com



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

