
#
# generated by genmod v1.0
#
# style generic
#

$record_number = 0;

sub conv_generic {
  local(%can) = @_;
  $record_number++;

  if (!defined $can{'CiteType'}) {
    &bib'gotwarn("required field CiteType is not defined");
    $can{'CiteType'} = 'misc';
  }
  local($edname) = '';
  if (defined $can{'Editors'}) {
    $edname = $can{'Editors'};
    if ($can{'Editors'} =~ /$bib'cs_sep/) {
      $edname = 'eds.';
    } else {
      $edname = 'ed.';
    }
  }

  local($date) = undef;
  if (defined $can{'Month'}) {
    local($mo) = &bp_util'output_month($can{'Month'}, 'short');
    if (defined $can{'Year'}) {
      $date = "$mo $can{'Year'}";
    } else {
      $date = $mo;
    }
  } else {
    $date = $can{'Year'} if defined $can{'Year'};
  }

  local($pp, $wp) = (undef,undef);
  $pp = $can{'Pages'}      if defined $can{'Pages'};
  $wp = $can{'PagesWhole'} if defined $can{'PagesWhole'};
  if ( (!defined $wp) && (defined $pp) && ($pp !~ /-|,/) ) {
    $wp = $pp;
    $pp = undef;
  }
  # set default type using the CiteType field
  $type = &generic_default_type($can{'CiteType'});

  # Initialize output string
  $str = '';
  $str .= "m1100";


  if      ($type eq 'article') {
    if (!defined $can{'Journal'}) {
      &bib'gotwarn("No Journal field in $type citation");
    }
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'plain');
      $str .= "$tAuthors, ";
    }
    $str .= "\"$can{'Title'},\" "        if defined $can{'Title'};
    if (defined $can{'Journal'}) {
      $str .= "m2101$can{'Journal'}m2111, ";
    }
    if (defined $can{'Editors'}) {
      local($tEditors);
      $tEditors = &bp_util'canon_to_name($can{'Editors'}, 'plain');
      $str .= "($tEditors, ${edname}), ";
    }
    $str .= "vol. $can{'Volume'}, "      if defined $can{'Volume'};
    $str .= "no. $can{'Number'}, "       if defined $can{'Number'};
    $str .= "pp. ${pp}, "                if defined ${pp};
    $str .= "$can{'Publisher'}, "        if defined $can{'Publisher'};
    $str .= "${date}, "                  if defined ${date};
  } elsif ($type eq 'report') {
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'plain');
      $str .= "$tAuthors, ";
    }
    $str .= "\"$can{'Title'},\" "        if defined $can{'Title'};
    if (defined $can{'ReportType'}) {
      $str .= "$can{'ReportType'}";
      $str .= " $can{'ReportNumber'}"    if defined $can{'ReportNumber'};
      $str .= ", ";
    }
    $str .= "$can{'Organization'}, "     if defined $can{'Organization'};
    $str .= "$can{'School'}, "           if defined $can{'School'};
    $str .= "$can{'PubAddress'}, "       if defined $can{'PubAddress'};
    $str .= "pp. ${pp}, "                if defined ${pp};
    $str .= "${date}, "                  if defined ${date};
    $str .= "${wp} pages, "              if defined ${wp};
  } elsif ($type eq 'book') {
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'plain');
      $str .= "$tAuthors, ";
    }
    if (defined $can{'Title'}) {
      $str .= "m2101$can{'Title'}m2111, ";
    }
    if (defined $can{'Editors'}) {
      local($tEditors);
      $tEditors = &bp_util'canon_to_name($can{'Editors'}, 'plain');
      $str .= "($tEditors, ${edname}), ";
    }
    $str .= "vol. $can{'Volume'}, "      if defined $can{'Volume'};
    $str .= "pp. ${pp}, "                if defined ${pp};
    $str .= "$can{'Publisher'}, "        if defined $can{'Publisher'};
    $str .= "$can{'Edition'} ed., "      if defined $can{'Edition'};
    $str .= "${date}, "                  if defined ${date};
    $str .= "${wp} pages, "              if defined ${wp};
  } elsif ($type eq 'inproceedings') {
    if (!defined $can{'SuperTitle'}) {
      &bib'gotwarn("No SuperTitle field in $type citation");
    }
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'plain');
      $str .= "$tAuthors, ";
    }
    $str .= "\"$can{'Title'},\" "        if defined $can{'Title'};
    if (defined $can{'SuperTitle'}) {
      $str .= "in m2101$can{'SuperTitle'}m2111, ";
    }
    if (defined $can{'Editors'}) {
      local($tEditors);
      $tEditors = &bp_util'canon_to_name($can{'Editors'}, 'plain');
      $str .= "($tEditors, ${edname}), ";
    }
    $str .= "($can{'PubAddress'}), "     if defined $can{'PubAddress'};
    $str .= "pp. ${pp}, "                if defined ${pp};
    $str .= "$can{'Organization'}, "     if defined $can{'Organization'};
    if (defined $can{'Journal'}) {
      $str .= "published as m2101$can{'Journal'}m2111, ";
      $str .= "vol. $can{'Volume'}, "    if defined $can{'Volume'};
      $str .= "no. $can{'Number'}"       if defined $can{'Number'};
    }
    $str .= "${date}, "                  if defined ${date};
  } elsif ($type eq 'inbook') {
    if (!defined $can{'SuperTitle'}) {
      &bib'gotwarn("No SuperTitle field in $type citation");
    }
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'plain');
      $str .= "$tAuthors, ";
    }
    $str .= "\"$can{'Title'},\" "        if defined $can{'Title'};
    if (defined $can{'SuperTitle'}) {
      $str .= "in m2101$can{'SuperTitle'}m2111, ";
    }
    $str .= "vol. $can{'Volume'}, "      if defined $can{'Volume'};
    $str .= "no. $can{'Number'}"         if defined $can{'Number'};
    if (defined $can{'Editors'}) {
      local($tEditors);
      $tEditors = &bp_util'canon_to_name($can{'Editors'}, 'plain');
      $str .= "($tEditors, ${edname}), ";
    }
    $str .= "($can{'PubAddress'}), "     if defined $can{'PubAddress'};
    $str .= "pp. ${pp}, "                if defined ${pp};
    $str .= "$can{'Organization'}, "     if defined $can{'Organization'};
    $str .= "${date}, "                  if defined ${date};
  } elsif ( ($type eq 'misc') || ($type eq 'unpublished') || ($type eq 'manual') || ($type eq 'avmaterial') || ($type eq 'proceedings') || ($type eq 'thesis') || ($type eq 'map') ) {
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'plain');
      $str .= "$tAuthors, ";
    }
    $str .= "\"$can{'Title'}\", "        if defined $can{'Title'};
    if (defined $can{'Journal'}) {
      $str .= "m2101$can{'Journal'}m2111, ";
      $str .= "v$can{'Volume'}, "        if defined $can{'Volume'};
      $str .= "n$can{'Number'}, "        if defined $can{'Number'};
    }
    if (defined $can{'SuperTitle'}) {
      $str .= "in m2101$can{'SuperTitle'}m2111, ";
    }
    if (defined $can{'Editors'}) {
      local($tEditors);
      $tEditors = &bp_util'canon_to_name($can{'Editors'}, 'plain');
      $str .= "edited by $tEditors, ";
    }
    $str .= "$can{'Publisher'}, "        if defined $can{'Publisher'};
    $str .= "${date}, "                  if defined ${date};
    $str .= "pp. ${pp}, "                if defined ${pp};
    $str .= "${wp} pages, "              if defined ${wp};
  } 
  $str =~ s/,\s*$/./ || $str =~ s/,"\s*$/."/;
    if (defined $can{'Abstract'}) {
      $str .= "\nm1103m0103Abstract:  m0113\n$can{'Abstract'}m1113";
    }
    if (defined $can{'Keywords'}) {
      $str .= "\nm1103m0103Keywords:  m0113\n$can{'Keywords'}m1113";
    }
    if (defined $can{'Annotation'}) {
      $str .= "\nm1103m0103Annotation:  m0113\n$can{'Annotation'}m1113";
    }

  $str .= "\n";

  $str;
}

sub generic_default_type {
  local($citetype) = @_;
  local($type) = 'misc';

  if (defined $citetype) {
    if ($citetype =~ /^(article|report|book|inproceedings|inbook|misc|unpublished|manual|avmaterial|proceedings|thesis|map)$/) {
      $type = $citetype;
    } else {
      &bib'gotwarn("Type '$can{'CiteType'}' not recognized -- using default type 'misc'");
    }
  }
  $type;
}

1;
