package App::BPOMUtils::Table::FoodIngredientRBA;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2025-02-25'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodIngredient'; # DIST
our $VERSION = '0.022'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_ingredients_rba
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_bahan_baku_pangan_rba varname=meta_idn_bpom_bahan_baku_pangan_rba
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_baku_pangan_rba/meta.yaml
# src-revision: b611a9d128c23c9252082cf91b450d1899d9961c (Mon Feb 13 19:52:04 2023 +0700)
# generate-date: Tue Feb 25 03:08:27 2025 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_bahan_baku_pangan_rba = {
  "fields" => {
    country_of_origin => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Country of origin",
      "summary.alt.lang.id" => "Negara asal",
      "unique" => "No",
    },
    id => {
      "pos" => 0,
      "schema" => "uint*",
      "sortable" => "Yes",
      "summary" => "ID",
      "summary.alt.lang.id" => "ID",
      "unique" => "Yes",
    },
    name => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Name of ingredient",
      "summary.alt.lang.id" => "Nama bahan",
      "unique" => "No",
    },
    origin => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Country of origin",
      "summary.alt.lang.id" => "Negara asal",
      "unique" => "No",
    },
    status => {
      "filterable_regex" => "No",
      "pos" => 4,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Status",
      "summary.alt.lang.id" => "Status",
      "unique" => "No",
    },
  },
  "pk" => "id",
  "summary" => "Ingredients in BPOM processed food division (RBA version)",
  "summary.alt.lang.id_ID" => "Bahan baku di BPOM pangan olahan (versi RBA)",
};
# END FRAGMENT id=meta-idn_bpom_bahan_baku_pangan_rba

# BEGIN FRAGMENT id=data-idn_bpom_bahan_baku_pangan_rba varname=data_idn_bpom_bahan_baku_pangan_rba
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_baku_pangan_rba/data.csv
# src-revision: b611a9d128c23c9252082cf91b450d1899d9961c (Mon Feb 13 19:52:04 2023 +0700)
# generate-date: Tue Feb 25 03:08:27 2025 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_bahan_baku_pangan_rba = [
  [
    1,
    "1,4-a-glukan 6-aglukosiltransferase (1,4-Alpha-glucan 6- Alphaglucosyltransferase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2, "2-Fukosilaktosa", "No", "No", "Nonaktif"],
  [3, "3-Fitase (3-Phytase) (Bahan Penolong)", "No", "No", "Aktif"],
  [4, "4-Fitase (4-Phytase) (Bahan Penolong)", "No", "No", "Aktif"],
  [
    5,
    "a-amilase (tahan panas) (Alphaamylase (thermostable)) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    6,
    "a-amilase dan glukoamilase (Alphaamylase and Glucoamylase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    7,
    "a-Asetolaktat dekarboksilase (Alpha-Acetolactate decarboxylase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    8,
    "a-galaktosidase (Alpha-galactosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    9,
    "a-Glukosidase (Alpha-Glucosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [10, "Abalon (Abalone)", "No", "No", "Aktif"],
  [11, "Abon Ayam (Chicken Floss)", "No", "No", "Aktif"],
  [12, "Abon Babi (Pork Floss)", "No", "No", "Aktif"],
  [13, "ABON CAKALANG (SKIPJACK TUNA FLOSS)", "No", "No", "Aktif"],
  [14, "Abon Sapi  (Beef Floss)", "No", "No", "Aktif"],
  [15, "Abon Sapi Pedas (Hot Beef Floss)", "No", "No", "Aktif"],
  [16, "Acar (Pickles)", "No", "No", "Aktif"],
  [17, "Acar Bawang Putih (Garlic Pickles)", "No", "No", "Aktif"],
  [18, "Acar Cabe (Chili Pickles)", "No", "No", "Aktif"],
  [19, "Acar Jahe (Ginger Pickles)", "No", "No", "Aktif"],
  [
    20,
    "Acar Mentimun-Ketimun (Cucumber Pickles)",
    "No",
    "No",
    "Aktif",
  ],
  [21, "ACEROLA (ACEROLA)", "No", "No", "Nonaktif"],
  [
    22,
    "ACEROLA (MALPIGHIA GLABRA)- BARBADOS CHERRY-WEST INDIAN CHERRY-CEREZA-CERESIER-SEMERUCO-WILD CRAPEMYRTLE",
    "No",
    "No",
    "Aktif",
  ],
  [23, "ACEROLA BUBUK (ACEROLA POWDER)", "No", "No", "Nonaktif"],
  [24, "ACEROLA EKSTRAK (ACEROLA EXTRACT)", "No", "No", "Nonaktif"],
  [25, "Actinidin (Bahan Penolong)", "No", "No", "Aktif"],
  [26, "ADAS (FENNEL)", "No", "No", "Nonaktif"],
  [
    27,
    "ADAS MANIS BUBUK-ANIS POWDER (PIMPINELLA ANISUM)",
    "No",
    "No",
    "Aktif",
  ],
  [28, "Adas Manis-Anis (Pimpinella anisum)", "No", "No", "Aktif"],
  [
    29,
    "ADAS PEDAS - ADAS - FENNEL (FOENICULUM VULGARE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    30,
    "ADAS PEDAS BUBUK-ADAS BUBUK-FENNEL POWDER (FOENICULUM VULGARE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    31,
    "ADAS SOWA-DILL (ANETHUM GRAVEOLENS L.)",
    "No",
    "No",
    "Aktif",
  ],
  [
    32,
    "ADENOSIN 5-MONOFOSFAT (ADENOSINE 5-MONOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [33, "Adonan (Dough)", "No", "No", "Aktif"],
  [34, "AGAR-AGAR (AGAR)", "No", "No", "Nonaktif"],
  [35, "AGAR-AGAR BUBUK  (AGAR POWDER)", "No", "No", "Aktif"],
  [36, "Air (Water)", "No", "No", "Aktif"],
  [37, "Air Berkarbonat (Carbonated Water)", "No", "No", "Aktif"],
  [38, "Air Dadih (Whey)", "No", "No", "Aktif"],
  [39, "Air Deionisasi (Deionized Water)", "No", "No", "Aktif"],
  [
    40,
    "AIR DEMINERALISASI (DEMINERALIZED WATER)",
    "No",
    "No",
    "Aktif",
  ],
  [41, "Air Es (Cold Water)", "No", "No", "Aktif"],
  [42, "Air Kaldu (Broth)", "No", "No", "Aktif"],
  [
    43,
    "AIR KELAPA (COCONUT WATER-COCONUT JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [44, "Air Mineral (Mineral Water)", "No", "No", "Aktif"],
  [45, "Air Soda (Soda Water)", "No", "No", "Aktif"],
  [46, "Air Suling (Distilled Water)", "No", "No", "Aktif"],
  [47, "Ajwain (Carom seed)", "No", "No", "Aktif"],
  [48, "AKAR BUNGA TERATAI (LOTUS ROOT)", "No", "No", "Nonaktif"],
  [49, "Akar Chicory (Chicory Root)", "No", "No", "Aktif"],
  [
    50,
    "Akar Ginseng (Ginseng Root / Panax Ginseng C.A Meyer)",
    "No",
    "No",
    "Aktif",
  ],
  [
    51,
    "Akar Ginseng (Ginseng Root / Panax Quinquefolius-American Ginseng)",
    "No",
    "No",
    "Aktif",
  ],
  [52, "Akar Ketumbar (Coriander Root)", "No", "No", "Aktif"],
  [
    53,
    "AKAR TERATAI BUBUK -LOTUS ROOT POWDER(NELUMBIUM NELUMBO DRUCE; NELUMBIUM NUCIFERUM) ",
    "No",
    "No",
    "Aktif",
  ],
  [54, "Alanin (Alanine)", "No", "No", "Aktif"],
  [55, "Albumin (Albumine)", "No", "No", "Aktif"],
  [56, "ALFA KAROTEN", "No", "No", "Aktif"],
  [57, "Alfa Laktalbumin (Alpha-Lactalbumin)", "No", "No", "Aktif"],
  [58, "Alfa Tokoferol (Alpha-Tocopherol)", "No", "No", "Aktif"],
  [59, "ALFALFA (ALFALFA)", "No", "No", "Nonaktif"],
  [60, "Alga Merah (Red Algae)", "No", "No", "Aktif"],
  [61, "ALGINAT (ALGINATE)", "No", "No", "Aktif"],
  [62, "Alkohol (Alcohol)", "No", "No", "Aktif"],
  [
    63,
    "Allulosa (Allulose) (Hanya untuk produk gula langka/rare sugar)",
    "No",
    "No",
    "Aktif",
  ],
  [64, "Almond Bubuk (Almond Powder)", "No", "No", "Aktif"],
  [65, "Almond Butiran (Almond Granules)", "No", "No", "Aktif"],
  [66, "Almond Panggang (Roasted Almond)", "No", "No", "Aktif"],
  [67, "Alpukat (Avocado)", "No", "No", "Aktif"],
  [68, "Alpukat Bubuk (Avocado Powder)", "No", "No", "Aktif"],
  [69, "Alpukat Pasta (Avocado Paste)", "No", "No", "Aktif"],
  [
    70,
    "Amilomaltase (Amylomaltase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    71,
    "Aminopeptidase (Aminopeptidase (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [72, "AMONIAK (AMMONIA)", "No", "No", "Nonaktif"],
  [73, "AMONIAK CAIR (LIQUID AMMONIA)", "No", "No", "Nonaktif"],
  [74, "Ampela (Gizzard)", "No", "No", "Aktif"],
  [75, "ANDALIMAN (ZANTHOXYLUM ACANTHOPODIUM)", "No", "No", "Aktif"],
  [
    76,
    "ANDALIMAN BUBUK - ANDALIMAN POWDER (ZANTHOXYLUM ACANTHOPODIUM)",
    "No",
    "No",
    "Aktif",
  ],
  [77, "ANEKA BUAH BERI (MIX BERRIES)", "No", "No", "Aktif"],
  [78, "Anggur (Wine)", "No", "No", "Aktif"],
  [79, "Anggur Beras (Rice Wine)", "No", "No", "Aktif"],
  [80, "Anggur Merah (Red Wine)", "No", "No", "Aktif"],
  [81, "Anggur Putih (White Wine)", "No", "No", "Aktif"],
  [82, "ANGGUR PUTIH BUBUK", "No", "No", "Nonaktif"],
  [83, "Apel Bubuk (Apple Powder)", "No", "No", "Aktif"],
  [84, "Apel Kering (Dried Apple)", "No", "No", "Aktif"],
  [85, "Aprikot (Apricot)", "No", "No", "Aktif"],
  [86, "Aquamin F", "No", "No", "Nonaktif"],
  [87, "Arak Beras (Rice Wine)", "No", "No", "Aktif"],
  [
    88,
    "ARAK BERAS KETAN (GLUTINOUS RICE WINE)",
    "No",
    "No",
    "Aktif",
  ],
  [89, "Arak Masak", "No", "No", "Nonaktif"],
  [90, "ARANG AKTIF (ACTIVATED CARBON)", "No", "No", "Nonaktif"],
  [91, "ARGININ (ARGININE)", "No", "No", "Aktif"],
  [92, "Artichoke (Artichoke)", "No", "No", "Aktif"],
  [93, "Arugula (Eruca Sativa)", "No", "No", "Aktif"],
  [94, "Asafoetida", "No", "No", "Aktif"],
  [
    95,
    "Asam a-linolenat (Alpha Linolenic acid)",
    "No",
    "No",
    "Aktif",
  ],
  [
    96,
    "Asam Amino Premiks (Amino Acid Premix)",
    "No",
    "No",
    "Aktif",
  ],
  [
    97,
    "ASAM ARAKHIDONAT -ARA-AA (DARI MINYAK LAIN)",
    "No",
    "No",
    "Aktif",
  ],
  [
    98,
    "ASAM ARAKHIDONAT-ARA-AA (DARI MINYAK SEL TUNGGAL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    99,
    "Asam Arakidonat (Arachidonic Acid/ARA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    100,
    "ASAM ASETAT GLASIAL (GLACIAL ACETIC ACID)",
    "No",
    "No",
    "Aktif",
  ],
  [
    101,
    "Asam Dokosaheksaenoat (Docosahexaenoic Acid/DHA)",
    "No",
    "No",
    "Aktif",
  ],
  [102, "Asam eikosapentaenoat (EPA)", "No", "No", "Aktif"],
  [103, "Asam Folat (Folic Acid)", "No", "No", "Aktif"],
  [104, "Asam Fosfat (Acid Phosphoric)", "No", "No", "Aktif"],
  [105, "ASAM GELUGUR (GARCINIA ATROVIRIDIS)", "No", "No", "Aktif"],
  [
    106,
    "ASAM JAWA BUBUK-TAMARIND POWDER (TAMARINDUS INDICA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    107,
    "ASAM JAWA-TAMARIND (TAMARINDUS INDICA)",
    "No",
    "No",
    "Aktif",
  ],
  [108, "ASAM KANDIS (GARCINIA XANTHOCHYMUS)", "No", "No", "Aktif"],
  [109, "Asam Laktat (Lactic acid)", "No", "No", "Aktif"],
  [
    110,
    "Asam Laurat/Asam dodekanoat (Lauric acid)",
    "No",
    "No",
    "Aktif",
  ],
  [111, "Asam Linoleat (Linoleic Acid)", "No", "No", "Aktif"],
  [
    112,
    "Asam Linoleat Terkonjugasi (Conjugated Linoleic Acid)",
    "No",
    "No",
    "Aktif",
  ],
  [113, "Asam Nukleat (Nucleic Acid)", "No", "No", "Aktif"],
  [114, "Asam Oktanoat (Octanoate Acid)", "No", "No", "Aktif"],
  [115, "ASAM OLEAT (OLEIC ACID)", "No", "No", "Aktif"],
  [
    116,
    "Asam Oleat/Asam 9-oktadekenoat (Oleic acid)",
    "No",
    "No",
    "Aktif",
  ],
  [117, "Asam Palmitat (Palmitic Acid)", "No", "No", "Aktif"],
  [
    118,
    "Asam Palmitat/Asam heksadekanoat (Palmitic acid)",
    "No",
    "No",
    "Aktif",
  ],
  [119, "Asam Stearat (Stearic Acid)", "No", "No", "Aktif"],
  [120, "Asam Sulfat (Sulfic Acid)", "No", "No", "Aktif"],
  [
    121,
    "Asilgliserol lipase (Acylglycerol lipase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    122,
    "ASKORBIL PALMITAT (ASCORBYL PALMITATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    123,
    "Asparaginase (Asparaginase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [124, "ASPARAGUS (ASPARAGUS OFFICINALIS)", "No", "No", "Aktif"],
  [125, "Asparagus Laut (Sea Asparagus)", "No", "No", "Aktif"],
  [126, "Asparagus Putih (White Asparagus)", "No", "No", "Aktif"],
  [
    127,
    "Aspergillopepsin I (Aspergillopepsin I) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [128, "ASPERGILLUS ORYZAE", "No", "No", "Aktif"],
  [129, "Astaxanthin (dengan batasan)", "No", "No", "Aktif"],
  [130, "ASTRAGALI", "No", "No", "Nonaktif"],
  [131, "ASTRAGALUS", "No", "No", "Nonaktif"],
  [132, "Ayam Bubuk (Chicken Powder)", "No", "No", "Aktif"],
  [133, "Ayam Suwir", "No", "No", "Aktif"],
  [
    134,
    "a\x{2013} arabinofuranosidase (Alpha\x{2013} arabinofuranosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    135,
    "a\x{2013}amilase (Alphaamylase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [136, "B-hydroxy-Bmethylbutyrate (HMB)", "No", "No", "Aktif"],
  [137, "Babat Sapi", "No", "No", "Aktif"],
  [
    138,
    "Bacillolisin (Bacillolysin) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    139,
    "BACILLUS COAGULANS GBI-30 6086 (GANEDEN BC30)",
    "No",
    "No",
    "Aktif",
  ],
  [140, "BACILLUS COAGULANS MTCC 5856", "No", "No", "Aktif"],
  [141, "BAHAN HERBAL LAINNYA", "No", "No", "Nonaktif"],
  [
    142,
    "Bahan Perisa (Flavoring Substances)",
    "No",
    "No",
    "Nonaktif",
  ],
  [143, "Bakso Ayam (Chicken Meatball)", "No", "No", "Aktif"],
  [144, "Bakso Ikan (Fish Meatball)", "No", "No", "Aktif"],
  [145, "Bakso Sapi (Beef Meatball)", "No", "No", "Aktif"],
  [146, "BALM (MELISSA OFFICINALIS L)", "No", "No", "Nonaktif"],
  [147, "Barley (Barley)", "No", "No", "Aktif"],
  [148, "BARLEY (KOJI)", "No", "Yes", "Nonaktif"],
  [149, "Barley grass ( Hordeum vulgare L)", "No", "No", "Aktif"],
  [150, "Barley Malt (Barley Malt)", "No", "No", "Aktif"],
  [151, "Barley Panggang (Roasted Barley)", "No", "No", "Aktif"],
  [152, "Barley Serpihan (Barley Flakes)", "No", "No", "Aktif"],
  [153, "BASIL (BASIL)", "No", "No", "Nonaktif"],
  [
    154,
    "BASIL BUBUK-BASIL POWDER (OCIMUM BASILICUM)",
    "No",
    "No",
    "Aktif",
  ],
  [155, "Bawang Bombay (Onion)", "No", "No", "Aktif"],
  [156, "Bawang Bombay Bubuk (Onion Powder)", "No", "No", "Aktif"],
  [157, "Bawang Bombay Kering (Dried Onion)", "No", "No", "Aktif"],
  [158, "BAWANG DAUN (CHIVES)", "No", "No", "Nonaktif"],
  [159, "Bawang Hitam (Black Garlic)", "No", "No", "Aktif"],
  [160, "BAWANG MERAH (RED ONION-SHALLOT)", "No", "No", "Aktif"],
  [
    161,
    "BAWANG MERAH BUBUK  (RED ONION POWDER - SHALLOT POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    162,
    "BAWANG MERAH GORENG  (FRIED RED ONION - FRIED SHALLOT)",
    "No",
    "No",
    "Aktif",
  ],
  [163, "Bawang Putih (Garlic)", "No", "No", "Aktif"],
  [164, "Bawang Putih Bubuk (Garlic Powder)", "No", "No", "Aktif"],
  [165, "BAWANG PUTIH GILING (GRINDED GARLIC)", "No", "No", "Aktif"],
  [166, "Bawang Putih Goreng (Fried Garlic)", "No", "No", "Aktif"],
  [167, "Bawang Putih Kering (Dried Garlic)", "No", "No", "Aktif"],
  [
    168,
    "Bawang Putih Serpihan (Garlic Flakes)",
    "No",
    "No",
    "Aktif",
  ],
  [169, "Bayam (Spinach)", "No", "No", "Aktif"],
  [170, "Bayam Bubuk (Spinach Powder)", "No", "No", "Aktif"],
  [171, "BEE POLLEN (KHUSUS MADU)", "No", "No", "Aktif"],
  [172, "Bekatul Beras (Rice Bran)", "No", "No", "Aktif"],
  [173, "BEKICOT (SNAIL)", "No", "No", "Aktif"],
  [174, "BELIMBING WULUH (AVERRHOA BILIMBI)", "No", "No", "Aktif"],
  [175, "Belut (Eel)", "No", "No", "Aktif"],
  [176, "benang sari teratai", "No", "No", "Nonaktif"],
  [177, "Bengkuang - Sengkuang (Yam Bean)", "No", "No", "Aktif"],
  [178, "BERANGAN (MALAYAN CHESTNUT)", "No", "No", "Aktif"],
  [179, "Beras (Rice)", "No", "No", "Aktif"],
  [180, "Beras Butiran (Rice Grains)", "No", "No", "Aktif"],
  [181, "Beras Cokelat (Brown Rice)", "No", "No", "Aktif"],
  [182, "Beras Hitam (Black Rice)", "No", "No", "Aktif"],
  [183, "Beras Instan (Instant Rice)", "No", "No", "Aktif"],
  [184, "BERAS KEPALA", "No", "No", "Aktif"],
  [185, "Beras Ketan (Glutinous Rice)", "No", "No", "Aktif"],
  [
    186,
    "Beras Ketan Hitam (Black Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    187,
    "Beras Ketan Putih (White Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [188, "Beras Merah (Brown Rice)", "No", "No", "Aktif"],
  [
    189,
    "Beras Merah Krispi (Brown Rice Crispy)",
    "No",
    "No",
    "Aktif",
  ],
  [190, "Beras Merah Utuh (Whole Brown Rice)", "No", "No", "Aktif"],
  [191, "Beras Pandan Wangi", "No", "No", "Aktif"],
  [192, "Beras Panggang (Roasted Rice)", "No", "No", "Aktif"],
  [193, "Beras Utuh (Whole Rice)", "No", "No", "Aktif"],
  [194, "BESI FOSFAT (FERROUS PHOSPHATE)", "No", "No", "Aktif"],
  [195, "BESI FUMARAT (FERROUS FUMARATE)", "No", "No", "Aktif"],
  [196, "Besi Glukonat", "No", "No", "Aktif"],
  [197, "BESI LAKTAT (FERROUS LACTATE)", "No", "No", "Aktif"],
  [
    198,
    "BESI ORTOFOSFAT (FERROUS ORTHOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    199,
    "BESI PIROFOSFAT (FERROUS PYROPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [200, "Besi Sitrat (Ferrous Citrate)", "No", "No", "Aktif"],
  [201, "BESI SULFAT  (FERROUS SULPHATE)", "No", "No", "Aktif"],
  [202, "BESI SULFATE (FERROUS SULPHATE)", "No", "No", "Nonaktif"],
  [203, "BESI TRIOKSIDA (FERROUS TRIOXIDE)", "No", "No", "Aktif"],
  [204, "Beta Glukan (Beta-Glucan)", "No", "No", "Aktif"],
  [
    205,
    "BETA GLUKAN DARI SACCHAROMYCES CEREVISIAE",
    "No",
    "No",
    "Aktif",
  ],
  [206, "BETA KAROTEN (BETA-CAROTENE)", "No", "No", "Aktif"],
  [207, "Beta Palmitat (sn-2 palmitic acid)", "No", "No", "Aktif"],
  [208, "Bifidobacterium Animalis", "No", "No", "Aktif"],
  [209, "Bifidobacterium longum", "No", "No", "Aktif"],
  [210, "Bifidobakterium Breve", "No", "No", "Aktif"],
  [211, "Bifidobakterium Laktis", "No", "No", "Aktif"],
  [212, "Bifidobakterium Longum", "No", "No", "Aktif"],
  [213, "Bihun (Vermicelli)", "No", "No", "Aktif"],
  [214, "Bihun Kentang (Potato Vermicelli)", "No", "No", "Aktif"],
  [215, "Biji Amaranthus hypochondriacus", "No", "No", "Aktif"],
  [216, "BIJI ANGGUR (GRAPE SEED)", "No", "No", "Aktif"],
  [217, "Biji Aprikot (Apricot Seed)", "No", "No", "Aktif"],
  [
    218,
    "Biji Blond Grain Husk (Semen Triticum aestivum)",
    "No",
    "No",
    "Aktif",
  ],
  [219, "BIJI BUNCIS (BAKED BEAN)", "No", "No", "Nonaktif"],
  [220, "Biji Bunga Matahari (Sunflower Seed)", "No", "No", "Aktif"],
  [
    221,
    "BIJI BUNGA TERATAI-LOTUS SEED (NELUMBIUM NELUMBO DRUCE; NELUMBIUM NUCIFERUM)",
    "No",
    "No",
    "Aktif",
  ],
  [222, "Biji Cabe (Chili Seed)", "No", "No", "Aktif"],
  [223, "BIJI CARAWAY (CARAWAY SEED)", "No", "No", "Nonaktif"],
  [224, "BIJI CHIA (SALVIA HISPANICA)", "No", "No", "Aktif"],
  [225, "BIJI COKELAT-BIJI KAKAO (COCOA BEAN)", "No", "No", "Aktif"],
  [226, "Biji Delima (Pomegranate Seed)", "No", "No", "Aktif"],
  [227, "Biji Kopi (Coffee Bean)", "No", "No", "Aktif"],
  [
    228,
    "Biji Kopi Arabika (Arabica Coffee Bean)",
    "No",
    "No",
    "Aktif",
  ],
  [229, "Biji Kopi Hijau (Green Coffee Bean)", "No", "No", "Aktif"],
  [
    230,
    "Biji Kopi Panggang (Roasted Coffee Bean)",
    "No",
    "No",
    "Aktif",
  ],
  [
    231,
    "Biji Kopi Robusta (Robusta Coffee Bean)",
    "No",
    "No",
    "Aktif",
  ],
  [232, "Biji Labu (Pumpkin Seed)", "No", "No", "Aktif"],
  [233, "Biji Labu Putih", "No", "No", "Aktif"],
  [234, "Biji Leci (Lychee Seed)", "No", "No", "Aktif"],
  [235, "Biji Lin (Lin Seed)", "No", "No", "Aktif"],
  [236, "BIJI LUPIN (LUPIN BEAN)", "No", "No", "Aktif"],
  [
    237,
    "Biji Melinjo - Belinjo (Gnetum gnemon)",
    "No",
    "No",
    "Aktif",
  ],
  [238, "Biji Melon (Melon Seeds)", "No", "No", "Aktif"],
  [239, "Biji Mustard (Mustard Seed)", "No", "No", "Aktif"],
  [240, "Biji Pala (Nutmeg)", "No", "No", "Aktif"],
  [241, "BIJI PERILLA - PERILLA SEED", "No", "No", "Aktif"],
  [242, "Biji Pinus (Pinecone)", "No", "No", "Aktif"],
  [243, "Biji Plantago", "No", "No", "Nonaktif"],
  [244, "BIJI POPPY (PAPAVER SOMNIFERUM)", "No", "No", "Nonaktif"],
  [
    245,
    "BIJI QUINOA (CHENOPODIUM QUINOA WILLDENOW)",
    "No",
    "No",
    "Aktif",
  ],
  [246, "Biji Rami (Flaxseed)", "No", "No", "Aktif"],
  [247, "Biji Rami Bubuk (Flaxseed Powder)", "No", "No", "Aktif"],
  [248, "BIJI SAFFLOWER", "No", "No", "Nonaktif"],
  [249, "Biji Sawi (Mustard Green Seed)", "No", "No", "Aktif"],
  [250, "Biji Selasih (Basil Seed)", "No", "No", "Aktif"],
  [251, "Biji Seledri (Celery Seed)", "No", "No", "Aktif"],
  [252, "Biji Semangka (Watermelon Seed)", "No", "No", "Aktif"],
  [253, "Biji Teff (Teff Grain)", "No", "No", "Aktif"],
  [254, "BIJI VANILA (VANILA BEAN)", "No", "No", "Aktif"],
  [255, "BIOTIN", "No", "No", "Nonaktif"],
  [256, "Bir (Beer)", "No", "No", "Aktif"],
  [257, "BISKUIT (BISCUIT)", "No", "No", "Aktif"],
  [258, "Bit (Beetroot)", "No", "No", "Aktif"],
  [259, "Bit Bubuk (Beetroot Powder)", "No", "No", "Aktif"],
  [260, "Bit Merah (Red Beetroot)", "No", "No", "Aktif"],
  [
    261,
    "Bit Merah Bubuk (Red Beetroot Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    262,
    "BLACKCURRANT BUBUK (BLACKCURRANT POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [263, "Blondo / Galendo", "No", "No", "Aktif"],
  [264, "BLUEBERRY KERING (DRIED BLUEBERRY)", "No", "No", "Aktif"],
  [265, "BLUEBERRY PASTA (BLUEBERRY PASTE)", "No", "No", "Aktif"],
  [266, "Bonggol Pisang", "No", "No", "Aktif"],
  [267, "Brandy (Brandy)", "No", "No", "Aktif"],
  [268, "Brem", "No", "No", "Aktif"],
  [269, "Brokoli (Brocoli)", "No", "No", "Aktif"],
  [270, "BROKOLI BUBUK (BROCCOLI POWDER)", "No", "No", "Aktif"],
  [271, "BUAH ACAI BERRY (EUTERPE OLERACEA)", "No", "No", "Aktif"],
  [272, "Buah Anggur (Grape)", "No", "No", "Aktif"],
  [273, "Buah Anggur Bubuk (Grape Powder)", "No", "No", "Aktif"],
  [274, "BUAH ANGGUR KERING (DRIED GRAPES)", "No", "No", "Aktif"],
  [
    275,
    "Buah Anggur Merah Bubuk (Red Grape Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [276, "Buah Apel (Apple)", "No", "No", "Aktif"],
  [277, "Buah Apel Hijau (Green Apple)", "No", "No", "Aktif"],
  [278, "Buah Apel Merah (Red Apple)", "No", "No", "Aktif"],
  [279, "BUAH ARA (BUAH FIG, BUAH TIN)", "No", "No", "Aktif"],
  [
    280,
    "BUAH ARONIA BUBUK - ARONIA BERRY POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [281, "BUAH ATAP", "No", "No", "Nonaktif"],
  [282, "BUAH BAKU", "No", "No", "Nonaktif"],
  [283, "Buah Belimbing (Starfruit)", "No", "No", "Aktif"],
  [284, "Buah Beri (Berry)", "No", "No", "Aktif"],
  [285, "Buah Beri Hitam (Blackberry)", "No", "No", "Aktif"],
  [286, "Buah Beri Merah (Redberry)", "No", "No", "Aktif"],
  [287, "BUAH BILBERRY (BILBERRY)", "No", "No", "Aktif"],
  [288, "Buah Blackcurrant (Blackcurrant)", "No", "No", "Aktif"],
  [289, "BUAH BLUEBERRY (BLUEBERRY)", "No", "No", "Aktif"],
  [290, "Buah Boysenberry (Boysenberry)", "No", "No", "Aktif"],
  [291, "BUAH BUBUK (FRUIT POWDER)", "No", "No", "Aktif"],
  [292, "Buah Ceri (Cherry)", "No", "No", "Aktif"],
  [293, "Buah Ceri Hitam (Black Cherry)", "No", "No", "Aktif"],
  [294, "Buah Ceri Merah (Red Cherry)", "No", "No", "Aktif"],
  [295, "BUAH CRANBERRY (CRANBERRY)", "No", "No", "Aktif"],
  [296, "Buah Delima (Pomegranate)", "No", "No", "Aktif"],
  [297, "BUAH DHAL BUBUK (DHAL POWDER)", "No", "No", "Nonaktif"],
  [298, "Buah Durian (Durian)", "No", "No", "Aktif"],
  [
    299,
    "BUAH DURIAN MONTHONG (DURIAN MONTHONG)",
    "No",
    "No",
    "Nonaktif",
  ],
  [300, "BUAH ELDERBERRY (ELDERBERRY)", "No", "No", "Aktif"],
  [301, "BUAH FRAMBOZEN (FRAMBOZEN)", "No", "No", "Nonaktif"],
  [302, "BUAH GAC (MOMORDICA COCHINCHINENSIS)", "No", "No", "Aktif"],
  [303, "BUAH GOJI BERRY - BARBARY WOLFBERRY", "No", "No", "Aktif"],
  [304, "BUAH HAW (HAWTHORN BERRY)", "No", "No", "Aktif"],
  [305, "BUAH KERING (DRIED FRUIT)", "No", "No", "Aktif"],
  [306, "Buah Kesemek", "No", "No", "Aktif"],
  [307, "Buah Kundur", "No", "No", "Aktif"],
  [308, "Buah Leci (Lychee)", "No", "No", "Aktif"],
  [309, "Buah Leci Bubuk (Lychee Powder)", "No", "No", "Aktif"],
  [310, "Buah Mulberry (Mulberry)", "No", "No", "Aktif"],
  [311, "Buah Naga (Dragonfruit)", "No", "No", "Aktif"],
  [312, "Buah Pala (Myristica Fragran)", "No", "No", "Aktif"],
  [313, "BUAH PAW PAW (ASIMINA TRILOBA)", "No", "No", "Aktif"],
  [314, "Buah Pepaya (Papaya)", "No", "No", "Aktif"],
  [315, "Buah Pepaya Kuning (Golden Papaya)", "No", "No", "Aktif"],
  [316, "Buah Pepaya Merah (Red Papaya)", "No", "No", "Aktif"],
  [317, "Buah Persik (Peach)", "No", "No", "Aktif"],
  [318, "Buah Prickly pear/Opuntia/Nopal", "No", "No", "Aktif"],
  [319, "Buah Prune (Prune)", "No", "No", "Aktif"],
  [320, "Buah Prune Kering (Dried Prune)", "No", "No", "Aktif"],
  [321, "BUAH RASPBERRY (FRAMBOZEN)", "No", "No", "Aktif"],
  [322, "Buah Redcurrant (Redcurrant)", "No", "No", "Aktif"],
  [323, "Buah Stroberi (Strawberry)", "No", "No", "Aktif"],
  [
    324,
    "Buah Stroberi Bubuk (Strawberry Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [325, "Buah Sukun (Breadfruit)", "No", "No", "Aktif"],
  [326, "Buah Zaitun (Olive)", "No", "No", "Aktif"],
  [327, "Buah Zaitun Hijau (Green Olive)", "No", "No", "Aktif"],
  [
    328,
    "Buah Zaitun Hijau Tanpa Biji (Seedless Green Olive)",
    "No",
    "No",
    "Aktif",
  ],
  [329, "Buah Zaitun Hitam (Black Olive)", "No", "No", "Aktif"],
  [
    330,
    "Buah Zaitun Hitam Tanpa Biji (Seedless Black Olive)",
    "No",
    "No",
    "Aktif",
  ],
  [
    331,
    "Buah Zaitun Kalamata (Kalamata Olive)",
    "No",
    "No",
    "Aktif",
  ],
  [
    332,
    "Buah Zukini (Zucchini atau Courgette)",
    "No",
    "No",
    "Aktif",
  ],
  [
    333,
    "Bubuk Ayam (maltodextrin, garam, bubuk kaldu ayam)",
    "No",
    "No",
    "Nonaktif",
  ],
  [334, "Bubuk Buih", "No", "No", "Nonaktif"],
  [
    335,
    "Bubuk campuran buah dan sayur (Blend of Fruit and Vegetable Powders)",
    "No",
    "No",
    "Aktif",
  ],
  [
    336,
    "Bubuk Custard (Susu Bubuk, Gula, Lemak Nabati, Pati Tapioka, Maltodekstrin)",
    "No",
    "No",
    "Nonaktif",
  ],
  [337, "Bubuk Ekstrak Pizza ", "No", "No", "Nonaktif"],
  [
    338,
    "Bubuk Ekstrak Tulang Sapi (Ekstrack tulang sapi, Garam)",
    "No",
    "No",
    "Nonaktif",
  ],
  [339, "Bubuk jahe", "No", "No", "Nonaktif"],
  [
    340,
    "Bubuk kecap (kedelai, garam, tepung)",
    "No",
    "No",
    "Nonaktif",
  ],
  [341, "Bubuk Kelapa", "No", "No", "Nonaktif"],
  [342, "Bubuk lada putih ", "No", "No", "Nonaktif"],
  [343, "BUBUK LECI ", "No", "No", "Nonaktif"],
  [344, "Bubuk Salmon (Salmon Powder)", "No", "No", "Aktif"],
  [
    345,
    "Bubuk Sayuran (tomat, wortel, sawi, kentang, paprika hijau, bawang putih, seledri)",
    "No",
    "No",
    "Nonaktif",
  ],
  [346, "Bubuk Teh Hijau", "No", "No", "Nonaktif"],
  [347, "Bubur Beras (Rice Porridge)", "No", "No", "Aktif"],
  [
    348,
    "Bubur Beras Merah (Brown Rice Porridge)",
    "No",
    "No",
    "Aktif",
  ],
  [349, "Bubur Buah Apel (Apple Pulp)", "No", "No", "Aktif"],
  [350, "Bubur Buah Aprikot (Apricot Pulp)", "No", "No", "Aktif"],
  [351, "Bubur Buah Arbei (Arbei Pulp)", "No", "No", "Aktif"],
  [352, "Bubur Buah Jambu (Guava Pulp)", "No", "No", "Aktif"],
  [353, "Bubur Buah Jambu Merah", "No", "No", "Aktif"],
  [354, "Bubur Buah Jeruk (Orange Pulp)", "No", "No", "Aktif"],
  [355, "Bubur Buah Lemon (Lemon Pulp)", "No", "No", "Aktif"],
  [356, "Bubur Buah Mangga (Mango Pulp)", "No", "No", "Aktif"],
  [357, "Bubur Buah Mulberry (Mulberry Pulp)", "No", "No", "Aktif"],
  [358, "Bubur Buah Nanas (Pineapple Pulp)", "No", "No", "Aktif"],
  [359, "Bubur Buah Persik (Peach Pulp)", "No", "No", "Aktif"],
  [360, "Bubur Buah Sirsak (Soursop Pulp)", "No", "No", "Aktif"],
  [
    361,
    "Bubur Buah Stroberi (Strawberry Pulp)",
    "No",
    "No",
    "Aktif",
  ],
  [362, "Bubur Buah Tomat (Tomato Pulp)", "No", "No", "Aktif"],
  [363, "BUBUR GANDUM (WHEAT PORRIDGE)", "No", "No", "Aktif"],
  [364, "BUBUR KACANG (PEANUT PORRIDGE)", "No", "No", "Aktif"],
  [
    365,
    "BUBUR KACANG HIJAU (MUNGBEAN PORRIDGE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    366,
    "Bubur Kacang Merah (Red Bean Porridge)",
    "No",
    "No",
    "Aktif",
  ],
  [367, "Bubur Kentang  (Potato Pulp)", "No", "No", "Aktif"],
  [368, "BUBUR KULIT JERUK (ORANGE PEEL PULP)", "No", "No", "Aktif"],
  [369, "Bubur Labu Kuning (Pumpkin Porridge)", "No", "No", "Aktif"],
  [370, "Bubur Susu (Milk Porridge)", "No", "No", "Aktif"],
  [371, "BUCKWHEAT (BUCKWHEAT)", "No", "No", "Nonaktif"],
  [
    372,
    "BUCKWHEAT (BUCKWHEAT-FAGOPYRUM ESCULENTUM)",
    "No",
    "No",
    "Aktif",
  ],
  [373, "Bulir Jeruk (Orange Pulp)", "No", "No", "Aktif"],
  [
    374,
    "Bulir Jeruk Valencia (Valencia Orange Pulp)",
    "No",
    "No",
    "Aktif",
  ],
  [
    375,
    "BUMBU  RASA KEJU (CHEESE FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    376,
    "BUMBU ABON AYAM (CHICKEN FLOSS SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    377,
    "BUMBU ASAM MANIS (SWEET AND SOUR SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [378, "Bumbu Ayam (Chicken Seasoning)", "No", "No", "Aktif"],
  [
    379,
    "Bumbu Ayam Bawang (Garlic Chicken Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    380,
    "Bumbu Ayam Goreng (Fried Chicken Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    381,
    "Bumbu Ayam Pedas (Spicy Chicken Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [382, "Bumbu Balado (Balado Seasoning)", "No", "No", "Aktif"],
  [383, "Bumbu Barbekiu (Barbeque Seasoning)", "No", "No", "Aktif"],
  [
    384,
    "BUMBU BAWANG PEDAS (SPICY GARLIC SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    385,
    "BUMBU CUMI BAKAR (GRILLED SQUID SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [386, "Bumbu Daging Sapi (Beef Flavor)", "No", "No", "Aktif"],
  [
    387,
    "Bumbu Ekstrak Daging Ayam (Chicken Extract Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    388,
    "Bumbu Frankfurter (Frankfurter Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [389, "BUMBU GULAI (GULAI SEASONING)", "No", "No", "Aktif"],
  [
    390,
    "BUMBU IGA SAPI (SPICES OR SEASONING FOR BEEF RIBS)",
    "No",
    "No",
    "Aktif",
  ],
  [391, "BUMBU IKAN TERI (ANCHOVY SEASONING)", "No", "No", "Aktif"],
  [392, "BUMBU JAGUNG (CORN SEASONING)", "No", "No", "Aktif"],
  [
    393,
    "BUMBU JAGUNG BAKAR (ROASTED CORN SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    394,
    "BUMBU KACANG MERAH (RED BEAN SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [395, "BUMBU KARI (CURRY SEASONING)", "No", "No", "Aktif"],
  [
    396,
    "BUMBU KARI DAGING (MEAT CURRY SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    397,
    "BUMBU KARI IKAN (FISH CURRY SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    398,
    "BUMBU KEJU BURGER (CHEESEBURGER SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    399,
    "Bumbu Kentang Barbekiu (Barbeque Potato Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [400, "BUMBU KIMCHI (KIMCHI SEASONING)", "No", "No", "Aktif"],
  [
    401,
    "BUMBU KRIM ASAM (SOUR CREAM SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    402,
    "BUMBU KRIM MENTEGA (BUTTERCREAM SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [403, "Bumbu Lainnya (Seasoning)", "No", "No", "Aktif"],
  [
    404,
    "BUMBU MI GORENG (FRIED NOODLE SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    405,
    "BUMBU MINYAK UDANG (OIL SEASONING SHRIMP)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [406, "BUMBU NGOHIONG (NGOHIONG SEASONING)", "No", "No", "Aktif"],
  [407, "BUMBU OPOR (OPOR SEASONING)", "No", "No", "Aktif"],
  [
    408,
    "BUMBU OTAK-OTAK (OTAK-OTAK SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [409, "Bumbu Pasta (Paste Seasoning)", "No", "No", "Aktif"],
  [410, "Bumbu Pedas (Spicy Seasoning)", "No", "No", "Aktif"],
  [411, "BUMBU PERENDAM (MARINADE SEASONING)", "No", "No", "Aktif"],
  [412, "Bumbu Petis Bubuk", "No", "No", "Aktif"],
  [413, "Bumbu Pizza (Pizza Seasoning)", "No", "No", "Aktif"],
  [414, "BUMBU RASA (FLAVORED SEASONING)", "No", "No", "Aktif"],
  [
    415,
    "BUMBU RASA ASAM PEDAS (SOUR SPICY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    416,
    "Bumbu Rasa Ayam (Chicken Flavored Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    417,
    "Bumbu Rasa Ayam Bakar (Grilled Chicken Flavor Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    418,
    "Bumbu Rasa Ayam Panggang (Roasted Chicken Flavor Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    419,
    "BUMBU RASA BABI (PORK OR BACON FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    420,
    "BUMBU RASA BALADO (BALADO FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    421,
    "BUMBU RASA BAWANG (ONION FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    422,
    "BUMBU RASA BAWANG PUTIH (GARLIC FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    423,
    "BUMBU RASA COKELAT (CHOCOLATE FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    424,
    "BUMBU RASA DAGING SAPI (BEEF FLAVORED SEASONING )",
    "No",
    "No",
    "Aktif",
  ],
  [
    425,
    "BUMBU RASA DENDENG (JERKY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    426,
    "BUMBU RASA IKAN (FISH FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [427, "Bumbu Rasa Kacang Polong", "No", "No", "Nonaktif"],
  [
    428,
    "BUMBU RASA KALDU AYAM (CHICKEN BROTH FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    429,
    "BUMBU RASA KARAMEL (CARAMEL FLAVOURED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    430,
    "BUMBU RASA KARAMEL BAWANG (CARAMELIZED ONION FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    431,
    "BUMBU RASA KARI AYAM (CHICKEN CURRY FLAVORED  SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    432,
    "BUMBU RASA KEJU (CHEESE FLAVORED SEASONING)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    433,
    "BUMBU RASA KENTANG GORENG (FRENCH FRIES FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    434,
    "BUMBU RASA LEMON (LEMON FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    435,
    "BUMBU RASA MANIS PEDAS (SWEET AND SPICY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    436,
    "BUMBU RASA MUSTARD (MUSTARD FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    437,
    "BUMBU RASA PEDAS (SPICY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    438,
    "BUMBU RASA PEDAS MANIS ASIN (SWEET, SPICY AND SALTY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    439,
    "BUMBU RASA PEPPERONI PIZZA (PEPPERONI PIZZA FLAVOR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    440,
    "BUMBU RASA PIZZA (PIZZA FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    441,
    "BUMBU RASA RUMPUT LAUT (SEAWEED FLAVORED SEASONING )",
    "No",
    "No",
    "Aktif",
  ],
  [442, "Bumbu Rasa Salmon Teriyaki", "No", "No", "Nonaktif"],
  [
    443,
    "BUMBU RASA SAPI (SEASONING BEEF FLAVOR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    444,
    "BUMBU RASA SAPI PANGGANG ( ROASTED BEEF FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    445,
    "Bumbu Rasa Stroberi (Strawberry Flavored Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    446,
    "Bumbu Rasa Tomat (Tomato Flavored Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    447,
    "BUMBU RASA UDANG (SHRIMP FLAVORED SEASONING)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [448, "BUMBU RAWON (RAWON SEASONING)", "No", "No", "Aktif"],
  [449, "BUMBU RENDANG (RENDANG SEASONING)", "No", "No", "Aktif"],
  [
    450,
    "BUMBU RICA- RICA (RICA-RICA SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    451,
    "Bumbu Rumput Laut (Seaweed Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    452,
    "BUMBU SAMBAL LIMAU (SAMBAL LIMAU SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    453,
    "BUMBU SAPI PANGGANG (ROAST BEEF MARINADE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [454, "Bumbu Sate (Satay Seasoning)", "No", "No", "Aktif"],
  [
    455,
    "Bumbu Sate Pedas (Spicy Satay Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [456, "Bumbu Sayuran (Vegetable Seasoning)", "No", "No", "Aktif"],
  [457, "Bumbu Seafood (Seafood Seasoning)", "No", "No", "Aktif"],
  [458, "Bumbu Sosis (Sausage Seasoning)", "No", "No", "Aktif"],
  [459, "Bumbu Soto (Soto Seasoning)", "No", "No", "Aktif"],
  [460, "Bumbu Sup (Soup Seasoning)", "No", "No", "Aktif"],
  [461, "BUMBU TOM YAM (TOM YAM SEASONING)", "No", "No", "Aktif"],
  [462, "Bumbu Tomat (Tomato Seasoning)", "No", "No", "Aktif"],
  [
    463,
    "Bumbu Tomat Pedas (Spicy Tomato Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [464, "BUNCIS BUBUK (GREEN BEAN POWDER)", "No", "No", "Aktif"],
  [465, "BUNCIS HIJAU (GREEN BEAN)", "No", "No", "Aktif"],
  [466, "BUNGA CAMOMILE (CHAMOMILE FLOWER)", "No", "No", "Aktif"],
  [
    467,
    "BUNGA CORNFLOWER (CENTAUREA CYANUS LYNN)",
    "No",
    "No",
    "Aktif",
  ],
  [468, "Bunga Elder (Sambucus nigra)", "No", "No", "Aktif"],
  [469, "bunga jagung", "No", "No", "Nonaktif"],
  [
    470,
    "BUNGA JAGUNG (CORN FLOWER - CENTAURA CYANUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    471,
    "BUNGA JERUK CITRUS AURANTIUM (FLOWERS ORANGE CITRUS AURANTIUM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    472,
    "BUNGA JERUK CITRUS AURANTIUM-JERUK NIPIS (ORANGE BLOSSOMS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    473,
    "Bunga Lavender (Lavandula angustifolia)",
    "No",
    "No",
    "Aktif",
  ],
  [474, "BUNGA MATAHARI", "No", "No", "Nonaktif"],
  [475, "Bunga Matahari (Sunflower)", "No", "No", "Aktif"],
  [
    476,
    "BUNGA MAWAR ROSA CHINENSIS (ROSE BLOSSOMS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    477,
    "BUNGA MAWAR-ROSE BLOSSOM (ROSA CHINENSIS)",
    "No",
    "No",
    "Aktif",
  ],
  [
    478,
    "Bunga Osmanthus Kering (Dried Osmanthus Flower) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "No",
    "No",
    "Aktif",
  ],
  [479, "Bunga Pala", "No", "Yes", "Aktif"],
  [480, "BUNGA SAFFLOWER", "No", "No", "Nonaktif"],
  [481, "BUNGA SAKURA", "No", "No", "Nonaktif"],
  [
    482,
    "Bunga Scarlet Bee Balm (Monarda didyma L)",
    "No",
    "No",
    "Aktif",
  ],
  [483, "Bunga Sedap Malam (Lily Flower)", "No", "No", "Aktif"],
  [484, "Bunga Telang (Clitoria Ternatea)", "No", "No", "Aktif"],
  [485, "bunga teratai", "No", "No", "Nonaktif"],
  [486, "Buntut Sapi (Oxtail)", "No", "No", "Aktif"],
  [487, "BURDOCK ROOT", "No", "No", "Nonaktif"],
  [488, "Butiran Coklat", "No", "No", "Nonaktif"],
  [489, "Buttermilk (Buttermilk)", "No", "No", "Aktif"],
  [490, "Buttermilk Bubuk (Buttermilk Powder)", "No", "No", "Aktif"],
  [491, "Cabe (Chili)", "No", "No", "Aktif"],
  [492, "Cabe Bubuk (Chili Powder)", "No", "No", "Aktif"],
  [493, "Cabe Chilli Hijau  ", "No", "No", "Nonaktif"],
  [494, "Cabe Habanero (Habanero Chili)", "No", "No", "Aktif"],
  [495, "Cabe Hijau  ", "No", "No", "Nonaktif"],
  [496, "Cabe Hijau (Green Chili)", "No", "No", "Aktif"],
  [
    497,
    "Cabe Hijau Bubuk (Green Chili Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [498, "Cabe Jalapeno  ", "No", "No", "Nonaktif"],
  [499, "Cabe Jalapeno (Jalapeno Chili)", "No", "No", "Aktif"],
  [
    500,
    "CABE JALAPENO BUBUK (JALAPENO POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    501,
    "CABE JAWA (JAVANESE LONG PEPPER, PIPER RETROFRACTUM VAHL.)",
    "No",
    "No",
    "Aktif",
  ],
  [502, "Cabe Kering (Dried Chili)", "No", "No", "Aktif"],
  [503, "Cabe Kuning (Yellow Chili)", "No", "No", "Aktif"],
  [504, "Cabe Merah  ", "No", "No", "Nonaktif"],
  [505, "Cabe Merah (Red Chili)", "No", "No", "Aktif"],
  [506, "CABE MERAH BESAR", "No", "No", "Nonaktif"],
  [507, "Cabe Merah Bubuk (Red Chili Powder)", "No", "No", "Aktif"],
  [508, "Cabe Rawit (Cayenne Pepper)", "No", "No", "Aktif"],
  [
    509,
    "Cabe Rawit Bubuk (Cayenne Pepper Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    510,
    "Cabe Rawit Hijau (Green Cayenne Pepper)",
    "No",
    "No",
    "Aktif",
  ],
  [
    511,
    "Cabe Rawit Merah (Red Cayenne Pepper)",
    "No",
    "No",
    "Aktif",
  ],
  [
    512,
    "Calcium Beta Hydroxy Beta Methylbutyrate (CaHMB)",
    "No",
    "No",
    "Aktif",
  ],
  [
    513,
    "Campuran Buah Tropical Bubuk (Mixed Tropical Fruit Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    514,
    "Campuran Citrus Bubuk (Mixed Citrus Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    515,
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    "No",
    "No",
    "Aktif",
  ],
  [516, "camu-camu (Myrciaria dubia)", "No", "No", "Nonaktif"],
  [517, "Cangkang Rajungan (Crab Shells)", "No", "No", "Aktif"],
  [518, "Capers (Capers)", "No", "No", "Aktif"],
  [519, "CARAWAY (CARAWAY)", "No", "No", "Nonaktif"],
  [520, "Carob (Carob)", "No", "No", "Aktif"],
  [521, "Casein Phosphopeptida", "No", "No", "Aktif"],
  [522, "CASSIA OBTUSIFOLIA", "No", "No", "Nonaktif"],
  [523, "CASSIA TORA", "No", "No", "Nonaktif"],
  [524, "Ceker Ayam", "No", "No", "Aktif"],
  [525, "Cempedak (Artocarpus integer)", "No", "No", "Aktif"],
  [526, "Cendol", "No", "No", "Aktif"],
  [527, "Cengkeh (Clove)", "No", "No", "Aktif"],
  [528, "CENGKEH BUBUK (CLOVE POWDER)", "No", "No", "Aktif"],
  [529, "CEPOKAK (COKOWANA, TERONG PIPIT)", "No", "No", "Aktif"],
  [
    530,
    "Ceremai (Phyllanthus acidus (L.) Skeells)",
    "No",
    "No",
    "Aktif",
  ],
  [531, "Ceri Bubuk (Cherry Powder)", "No", "No", "Aktif"],
  [532, "CHAMOMILE", "No", "No", "Nonaktif"],
  [533, "Chicory (Cichorium intybus)", "No", "No", "Aktif"],
  [534, "Chlorella (Chlorella)", "No", "No", "Aktif"],
  [535, "Chutney (Chutney)", "No", "No", "Aktif"],
  [536, "CILANTRO", "No", "No", "Nonaktif"],
  [537, "CINCAU (JELLY GRASS)", "No", "No", "Aktif"],
  [538, "CINCAU HITAM (BLACK JELLY GRASS)", "No", "No", "Aktif"],
  [539, "CITRUS BIOFLAVONOID", "No", "No", "Nonaktif"],
  [540, "Citrus Fiber", "No", "No", "Aktif"],
  [541, "CO2", "No", "No", "Nonaktif"],
  [542, "COCOA BUTTER EQUIVALENT (CBE)", "No", "No", "Aktif"],
  [543, "Cocoa Butter Replacer (CBR)", "No", "No", "Aktif"],
  [544, "Cocoa Butter Substitute (CBS)", "No", "No", "Aktif"],
  [545, "Cognac (Cognac)", "No", "No", "Aktif"],
  [546, "Cokelat (Chocolate)", "No", "No", "Aktif"],
  [547, "Cokelat Batang (Chocolate Bar)", "No", "No", "Aktif"],
  [548, "COKELAT BUBUK (CHOCOLATE POWDER)", "No", "No", "Aktif"],
  [549, "Cokelat Butir (Chocolate Granules)", "No", "No", "Aktif"],
  [550, "COKELAT CAIR (MELTED CHOCOLATE)", "No", "No", "Nonaktif"],
  [551, "Cokelat Chip (Chocolate Chip)", "No", "No", "Aktif"],
  [
    552,
    "COKELAT COMPOUND BUTIR (CHOCOLATE COMPOUND GRANULE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    553,
    "COKELAT COMPOUND PUTIH (WHITE CHOCOLATE COMPOUND)",
    "No",
    "No",
    "Aktif",
  ],
  [
    554,
    "Cokelat Compound Susu (Milk Chocolate Compound)",
    "No",
    "No",
    "Aktif",
  ],
  [
    555,
    "COKELAT HITAM (DARK CHOCOLATE, BITTERSWEET CHOCOLATE))",
    "No",
    "No",
    "Aktif",
  ],
  [
    556,
    "COKELAT HITAM CHIP (DARK CHOCOLATE CHIP)",
    "No",
    "No",
    "Aktif",
  ],
  [
    557,
    "COKELAT HITAM COMPOUND (DARK CHOCOLATE COMPOUND)",
    "No",
    "No",
    "Aktif",
  ],
  [
    558,
    "Cokelat Imitasi/Hasil Olah Gula (Imitation Chocolate/Processed Sugar)",
    "No",
    "No",
    "Aktif",
  ],
  [559, "COKELAT LIQUOR (COCOA LIQUOR)", "No", "No", "Nonaktif"],
  [560, "COKELAT MASSA (CHOCOLATE MASS)", "No", "No", "Nonaktif"],
  [561, "Cokelat Paduan (Compound Chocolate)", "No", "No", "Aktif"],
  [562, "COKELAT PADUAN-COMPOUND", "No", "No", "Nonaktif"],
  [563, "COKELAT PAHIT (BITTER CHOCOLATE)", "No", "No", "Nonaktif"],
  [564, "Cokelat Pasta (Chocolate Paste)", "No", "No", "Aktif"],
  [565, "Cokelat Pelapis (Chocolate Coating)", "No", "No", "Aktif"],
  [566, "Cokelat Putih (White Chocolate)", "No", "No", "Aktif"],
  [
    567,
    "COKELAT RENDAH LEMAK (LOW FAT COCOA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [568, "Cokelat Susu (Milk Chocolate)", "No", "No", "Aktif"],
  [
    569,
    "COKELAT SUSU KOVERTUR (MILK CHOCOLATE COUVERTURE)",
    "No",
    "No",
    "Aktif",
  ],
  [570, "COKLAT MASSA", "No", "No", "Nonaktif"],
  [
    571,
    "Combrang - Kecombrang (Etlingera elatior)",
    "No",
    "No",
    "Aktif",
  ],
  [572, "COMPOUND PUTIH (WHITE COMPOUND)", "No", "No", "Nonaktif"],
  [573, "CORNFLOWER (CENTAURA CYANUS)", "No", "No", "Nonaktif"],
  [574, "CORNFLOWER (CENTAUREA CYANUS)", "No", "No", "Nonaktif"],
  [575, "Couscous", "No", "No", "Aktif"],
  [576, "CRANBERRY BUBUK (CRANBERRY POWDER)", "No", "No", "Aktif"],
  [577, "Cuka Anggur (Grape Vinegar)", "No", "No", "Aktif"],
  [
    578,
    "Cuka Anggur Putih (White Wine Vinegar)",
    "No",
    "No",
    "Aktif",
  ],
  [579, "Cuka Apel (Apple Vinegar)", "No", "No", "Aktif"],
  [580, "Cuka Balsamic (Balsamic Vinegar)", "No", "No", "Aktif"],
  [581, "Cuka Beras (Rice Vinegar)", "No", "No", "Aktif"],
  [582, "Cuka Bubuk (Vinegar Powder)", "No", "No", "Aktif"],
  [583, "CUKA FERMENTASI (VINEGAR)", "No", "No", "Aktif"],
  [584, "Cuka Lemon (Lemon Vinegar)", "No", "No", "Aktif"],
  [585, "Cuka Makan (Vinegar)", "No", "No", "Aktif"],
  [586, "Cuka Plum (Plum Vinegar)", "No", "No", "Aktif"],
  [587, "Cumi-Cumi (Squid)", "No", "No", "Aktif"],
  [588, "CUMI-CUMI BUBUK (SQUID POWDER)", "No", "No", "Aktif"],
  [589, "cupuacu (theobroma grandiflorum)", "No", "No", "Nonaktif"],
  [590, "Custard (Custard)", "No", "No", "Aktif"],
  [591, "Custard Bubuk (Custard Powder)", "No", "No", "Aktif"],
  [592, "D-XILOSA (D-XYLOSE)", "No", "No", "Aktif"],
  [593, "Dada Ayam (Chicken Breast)", "No", "No", "Aktif"],
  [594, "Dadih", "No", "No", "Aktif"],
  [595, "Dadih Bubuk (Buttermilk Powder)", "No", "No", "Aktif"],
  [596, "Dadih Keju (Cheese Curd)", "No", "No", "Aktif"],
  [597, "DAGING AYAM (CHICKEN MEAT)", "No", "No", "Aktif"],
  [
    598,
    "DAGING AYAM ASAP (SMOKE CHICKEN MEAT)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [599, "Daging Ayam Bubuk (Chicken Powder)", "No", "No", "Aktif"],
  [
    600,
    "Daging Ayam Cincang (Minced Chiken)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [601, "Daging Ayam Fillet (Chicken Fillet)", "No", "No", "Aktif"],
  [602, "Daging Ayam Irisan (Chicken Strips)", "No", "No", "Aktif"],
  [
    603,
    "DAGING AYAM SERPIHAN (CHICKEN FLAKES)",
    "No",
    "No",
    "Aktif",
  ],
  [604, "Daging Babi (Pork)", "No", "No", "Aktif"],
  [605, "DAGING BABI ASAP (SMOKE PORK)", "No", "No", "Aktif"],
  [606, "Daging Babi Bubuk (Pork Powder)", "No", "No", "Aktif"],
  [607, "Daging Bebek (Duck Meat)", "No", "No", "Aktif"],
  [608, "Daging Burung Puyuh/Dara/.....", "No", "No", "Aktif"],
  [609, "Daging Domba (Lamb)", "No", "No", "Aktif"],
  [610, "Daging Kalkun (Turkey Meat)", "No", "No", "Aktif"],
  [611, "Daging Kambing (Mutton)", "No", "No", "Aktif"],
  [612, "Daging Kelinci (Rabbit Meat)", "No", "No", "Aktif"],
  [613, "DAGING KERBAU (BUFFALO MEAT)", "No", "No", "Aktif"],
  [614, "Daging Paha Babi (Ham)", "No", "No", "Aktif"],
  [615, "Daging Rusa (Deer Meat)", "No", "No", "Aktif"],
  [616, "Daging Sapi (Beef)", "No", "No", "Aktif"],
  [617, "DAGING SAPI ASAP (SMOKE BEEF)", "Yes", "Yes", "Aktif"],
  [618, "Daging Sapi Bubuk (Beef Powder)", "No", "No", "Aktif"],
  [619, "Daging Sapi Cincang (Minced Beef)", "Yes", "Yes", "Aktif"],
  [
    620,
    "Dandelion Root Powder (Taraxacum officinale)",
    "No",
    "No",
    "Nonaktif",
  ],
  [621, "DAUN ANGGUR (GRAPE LEAF)", "No", "No", "Nonaktif"],
  [
    622,
    "Daun Apple Mint (Mentha suaveolens Ehrh)",
    "No",
    "No",
    "Aktif",
  ],
  [623, "Daun Asam Jawa (Tamarindus indica)", "No", "No", "Aktif"],
  [624, "Daun Basil (Basil Leaf)", "No", "No", "Aktif"],
  [625, "Daun Basil Bubuk (Basil Leaf Powder)", "No", "No", "Aktif"],
  [626, "Daun Basil Kering (Dried Basil Leaf)", "No", "No", "Aktif"],
  [627, "DAUN BAWANG (SCALLION)", "No", "No", "Aktif"],
  [628, "DAUN BAWANG BUBUK (LEEK POWDER)", "No", "No", "Aktif"],
  [629, "DAUN BAWANG KERING (DRIED SCALLION)", "No", "No", "Aktif"],
  [630, "Daun Beluntas (Pluchea Folium)", "No", "No", "Aktif"],
  [631, "Daun Bergamot (Monarda didyma)", "No", "No", "Aktif"],
  [632, "Daun Blackberry (Blackberry Leaf)", "No", "No", "Aktif"],
  [633, "Daun Blackcurrant", "No", "No", "Aktif"],
  [634, "Daun Cengkeh (Clove Leaf)", "No", "No", "Aktif"],
  [
    635,
    "Daun Chervil (Anthriscus cerefolium) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "No",
    "No",
    "Aktif",
  ],
  [
    636,
    "Daun Citrus Thyme (Thymus citriodorus)",
    "No",
    "No",
    "Aktif",
  ],
  [637, "DAUN GANDUM (WHEATGRASS)", "No", "No", "Nonaktif"],
  [
    638,
    "Daun Gedi (Abelmoschus manihot (L.) Medik)",
    "No",
    "No",
    "Aktif",
  ],
  [639, "DAUN JAMBU BIJI (GUAVA LEAF)", "No", "No", "Nonaktif"],
  [
    640,
    "DAUN JATI BELANDA (GUAZUMA ULMIFOLIA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    641,
    "DAUN JERUK (CITRUS LEAF ATAU LIME LEAF)",
    "No",
    "No",
    "Aktif",
  ],
  [642, "Daun Jeruk Purut (Kaffir Lime Leaf)", "No", "No", "Aktif"],
  [643, "Daun Kari (Curry Leaf)", "No", "No", "Aktif"],
  [644, "Daun Katuk", "No", "No", "Aktif"],
  [645, "Daun Kelor (Moringa oleifera L.)", "No", "No", "Aktif"],
  [646, "DAUN KEMANGI (LEMON BASIL LEAF)", "No", "No", "Aktif"],
  [
    647,
    "DAUN KETUMBAR (CILANTRO- CORIANDER LEAF)",
    "No",
    "No",
    "Aktif",
  ],
  [648, "DAUN KOPI (COFFEE LEAF)", "No", "No", "Aktif"],
  [649, "DAUN KUCAI (GARLIC LEAF CHIVES)", "No", "No", "Aktif"],
  [650, "Daun Kunyit (Turmeric Leaf)", "No", "No", "Aktif"],
  [651, "DAUN LAKSA (LAKSA LEAF)", "No", "No", "Aktif"],
  [652, "Daun Lobak (Radish Leaf)", "No", "No", "Aktif"],
  [653, "Daun Marjoram (Marjoram Leaf)", "No", "No", "Aktif"],
  [654, "DAUN MELINJO (MELINJO LEAF)", "No", "No", "Aktif"],
  [655, "Daun Mint (Mint Leaf)", "No", "No", "Aktif"],
  [656, "DAUN MOLOKHIA (MOLOKHIA LEAF)", "No", "No", "Aktif"],
  [657, "DAUN MULBERRY (MULBERRY LEAF)", "No", "No", "Nonaktif"],
  [658, "Daun Oregano (Oregano Leaf)", "No", "No", "Aktif"],
  [
    659,
    "Daun Oregano Kering (Dried Oregano Leaf)",
    "No",
    "No",
    "Aktif",
  ],
  [
    660,
    "Daun Pakis / Paku Sayur (Vegetable Fern)",
    "No",
    "No",
    "Aktif",
  ],
  [661, "Daun Pandan (Pandan Leaf)", "No", "No", "Aktif"],
  [662, "Daun Pepaya (Papaya Leaf)", "No", "No", "Aktif"],
  [663, "Daun Peppermint (Peppermint Leaf)", "No", "No", "Aktif"],
  [664, "DAUN PERILLA (PERILLA LEAF)", "No", "No", "Aktif"],
  [
    665,
    "DAUN PERILLA BUBUK (PERILLA LEAF POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    666,
    "DAUN PETERSELI (PETROSELINUM CRISPUM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [667, "Daun Raspberry (Raspberry Leaf)", "No", "No", "Aktif"],
  [668, "DAUN RHUBARB (RHEUM RHABARBARUM)", "No", "No", "Nonaktif"],
  [669, "Daun Rosemarry (Rosemarry Leaf)", "No", "No", "Aktif"],
  [670, "DAUN SAGA (JEQUIRITY LEAF)", "No", "No", "Aktif"],
  [
    671,
    "Daun Sage (Salvia officinalis - maksimum Tujon 10 ppm)",
    "No",
    "No",
    "Aktif",
  ],
  [672, "Daun Salam (Bay Leaf)", "No", "No", "Aktif"],
  [673, "Daun Salam Bubuk (Bay Leaf Powder)", "No", "No", "Aktif"],
  [674, "Daun Seledri (Celery Leaf)", "No", "No", "Aktif"],
  [
    675,
    "Daun Seledri Kering (Dried Celery Leaf)",
    "No",
    "No",
    "Aktif",
  ],
  [676, "DAUN SEMBUNG (SAMBONG LEAF)", "No", "No", "Aktif"],
  [677, "DAUN SERUNI (CHRYSANTHEMUM LEAF)", "No", "No", "Aktif"],
  [678, "DAUN SINGKONG (CASSAVA LEAF)", "No", "No", "Aktif"],
  [679, "DAUN SIRIH (BETEL LEAF)", "No", "No", "Nonaktif"],
  [680, "DAUN SIRSAK (SOURSOP LEAF)", "No", "No", "Nonaktif"],
  [681, "DAUN STEVIA (STEVIA LEAF)", "No", "No", "Nonaktif"],
  [682, "Daun Stroberi (Strawberry Leaf)", "No", "No", "Aktif"],
  [
    683,
    "DAUN SWISS CHARD (FOLIUM BETA VULGARIS)",
    "No",
    "No",
    "Aktif",
  ],
  [684, "DAUN TARRAGON (TARRAGON LEAF)", "No", "No", "Aktif"],
  [685, "daun teratai ", "No", "No", "Nonaktif"],
  [686, "Daun Teratai (Lotus Leaf)", "No", "No", "Nonaktif"],
  [
    687,
    "Daun Ubi Merah (Red Sweet Potato Leaf)",
    "No",
    "No",
    "Aktif",
  ],
  [
    688,
    "Dekstranase (Dextranase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [689, "Dekstrin (Dextrin)", "No", "No", "Aktif"],
  [690, "Dekstrosa (Dextrose)", "No", "No", "Aktif"],
  [
    691,
    "Dekstrosa Anhidrat (Anhydrous Dextrose)",
    "No",
    "No",
    "Aktif",
  ],
  [692, "Dekstrosa Bubuk (Dextrose Powder)", "No", "No", "Aktif"],
  [693, "Dekstrosa monohidrat", "No", "No", "Nonaktif"],
  [
    694,
    "DEKSTROSA MONOHIDRAT (DEXTROSE MONOHYDRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [695, "Dextrosa", "No", "No", "Nonaktif"],
  [696, "DHA (dari Minyak Ikan)", "No", "No", "Aktif"],
  [697, "DHA (dari Minyak Sel Tunggal)", "No", "No", "Aktif"],
  [698, "DHA (DOCOSAHEXAENOIC ACID )", "No", "No", "Aktif"],
  [
    699,
    "DI-KALIUM HIDROGEN FOSFAT (DI-POTASSIUM HYDOGEN PHOSPAT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    700,
    "DIKALIUM FOSFAT (DIPOTASSIUM PHOSPHATE-DIPOTASSIUM ORTHOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    701,
    "DIKALSIUM FOSFAT (KALSIUM HIDROGEN FOSFAT, KALSIUM MONOHIDROGEN FOSFAT, KALSIUM HIDROGEN ORTOFOSFAT))",
    "No",
    "No",
    "Aktif",
  ],
  [
    702,
    "Dinatrium 5 Inosinat (disodium 5 Inosinate)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    703,
    "Dinatrium 5 ribonukleotida (Disodium 5 ribonucleotides)",
    "No",
    "No",
    "Nonaktif",
  ],
  [704, "DInatrium 5-Monofosfat", "No", "No", "Aktif"],
  [
    705,
    "Dinatrium fosfat (Disodium Orthophosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    706,
    "Dinatrium Fosfat Anhidrat (Disodium Phosphate Anhydrous)",
    "No",
    "No",
    "Aktif",
  ],
  [707, "Dinatrium Guanosin 5-Monofosfat", "No", "No", "Aktif"],
  [
    708,
    "DINATRIUM SUKSINAT (DISODIUM SUCCINATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [709, "Dinatrium Uridin 5-Monofosfat", "No", "No", "Aktif"],
  [
    710,
    "Duckweed / water lentils (Lemna gibba / Lemna minor complex dan Wolffia globosa)",
    "No",
    "No",
    "Aktif",
  ],
  [711, "Dulse (Palmaria palmata)", "No", "No", "Aktif"],
  [712, "DURIAN BUBUK (DURIAN POWDER)", "No", "No", "Aktif"],
  [
    713,
    "ECHINACEAE; CONEFLOWERS; PURPLE CONEFLOWER",
    "No",
    "No",
    "Nonaktif",
  ],
  [714, "EGCG (EPIGALLOCATECHIN GALLATE)", "No", "No", "Aktif"],
  [
    715,
    "EKSTRA VIRGIN OLIVE OIL (VIRGIN OLIVE OIL EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [716, "EKSTRAK .....", "No", "No", "Aktif"],
  [
    717,
    "EKSTRAK AIR KELAPA (COCONUT WATER EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    718,
    "Ekstrak Akar Kolesom (Talinum triangulare Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [719, "EKSTRAK ANGGUR (GRAPE EXTRACT)", "No", "No", "Nonaktif"],
  [720, "EKSTRAK ASAM JAWA (TAMARIND EXTRACT)", "No", "No", "Aktif"],
  [721, "Ekstrak Ayam (Chicken Extract)", "No", "No", "Aktif"],
  [722, "Ekstrak Barley  (Barley Extract)", "No", "No", "Aktif"],
  [
    723,
    "Ekstrak Barley Malt (Barley Malt Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [724, "Ekstrak Basil (Basil Extract)", "No", "No", "Aktif"],
  [
    725,
    "EKSTRAK BAWANG BOMBAY (ONION EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    726,
    "Ekstrak Bawang Goreng (Dried Onion Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    727,
    "Ekstrak Bawang Putih (Garlic Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [728, "Ekstrak Bengkuang (Yambean Extract)", "No", "No", "Aktif"],
  [729, "Ekstrak Beras (Rice Extract)", "No", "No", "Aktif"],
  [
    730,
    "EKSTRAK BERAS KENCUR (BERAS KENCUR EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    731,
    "EKSTRAK BERAS MERAH (BROWN RICE EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    732,
    "EKSTRAK BIJI ANGGUR (GRAPE SEED EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    733,
    "EKSTRAK BIJI BUNGA MATAHARI (SUNFLOWER SEED EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [734, "EKSTRAK BILBERRY (BILBERY EXTRACT)", "No", "No", "Aktif"],
  [735, "Ekstrak Blewah (Cantaloupe Extract)", "No", "No", "Aktif"],
  [736, "Ekstrak Bonito (Bonito Extract)", "No", "No", "Aktif"],
  [737, "EKSTRAK BROKOLI (BROCCOLI EXTRACT)", "No", "No", "Aktif"],
  [
    738,
    "EKSTRAK BUAH ACAI BERRY (ACAI BERRY EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    739,
    "EKSTRAK BUAH ALPUKAT (AVOCADO EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [740, "Ekstrak Buah Anggur (Grape Extract)", "No", "No", "Aktif"],
  [741, "EKSTRAK BUAH APEL (APPLE EXTRACT)", "No", "No", "Aktif"],
  [
    742,
    "EKSTRAK BUAH APEL HIJAU (GREEN  APPLE EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    743,
    "Ekstrak Buah Belimbing (Starfruit Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [744, "EKSTRAK BUAH BIT (BEETROOT EXTRACT)", "No", "No", "Aktif"],
  [
    745,
    "Ekstrak Buah Blackberry (Blackberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    746,
    "Ekstrak Buah Blackcurrant (Blackcurrant Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    747,
    "Ekstrak Buah Blueberry (Blueberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [748, "Ekstrak Buah Ceri (Cherry Extract)", "No", "No", "Aktif"],
  [
    749,
    "Ekstrak Buah Delima (Pomegranate Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [750, "Ekstrak Buah Durian (Durian Extract)", "No", "No", "Aktif"],
  [
    751,
    "EKSTRAK BUAH KELENGKENG (LONGAN EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    752,
    "Ekstrak Buah Kesemek (Persimmon Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [753, "EKSTRAK BUAH KIWI (KIWI EXTRACT)", "No", "No", "Aktif"],
  [
    754,
    "Ekstrak Buah Kundur (Benincasa hispida Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [755, "Ekstrak Buah Leci (Lychee Extract)", "No", "No", "Aktif"],
  [756, "Ekstrak Buah Lemon (Lemon Extract)", "No", "No", "Aktif"],
  [757, "Ekstrak Buah Mangga (Mango Extract)", "No", "No", "Aktif"],
  [
    758,
    "Ekstrak Buah Mangga Manalagi (Manalagi Mango Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    759,
    "Ekstrak Buah Markisa (Passionfruit Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [760, "Ekstrak Buah Melon (Melon Extract)", "No", "No", "Aktif"],
  [
    761,
    "EKSTRAK BUAH MURBEI (MULBERRY EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    762,
    "Ekstrak Buah Nangka (Jackfruit Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [763, "Ekstrak Buah Persik (Peach Extract)", "No", "No", "Aktif"],
  [764, "Ekstrak Buah Pisang (Banana Extract)", "No", "No", "Aktif"],
  [765, "Ekstrak Buah Plum (Plum Extract)", "No", "No", "Aktif"],
  [766, "Ekstrak Buah Prune (Prune Extract)", "No", "No", "Aktif"],
  [
    767,
    "Ekstrak Buah Raspberry (Raspberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    768,
    "Ekstrak Buah Semangka (Watermelon Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    769,
    "Ekstrak Buah Sirsak (Soursop Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    770,
    "Ekstrak Buah Stroberi (Strawberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    771,
    "Ekstrak Buah Tangkwa (Tangkwa Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    772,
    "EKSTRAK BUAH TIN ATAU BUAH ARA (FIG EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    773,
    "Ekstrak Buah Ume (Japanesse Plum Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    774,
    "Ekstrak Bumbu (bawang bombay,bawang putih, paprika dan annato)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    775,
    "EKSTRAK BUNGA CHAMOMILE (CHAMOMILE FLOS EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    776,
    "EKSTRAK BUNGA ELDER (ELDER FLOS EXTRACT) - Khusus Minuman Beralkohol",
    "No",
    "No",
    "Aktif",
  ],
  [
    777,
    "Ekstrak Bunga Jeruk (Orange Flos Extract)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    778,
    "EKSTRAK BUNGA KRISAN (CHRYSANTHEMUM EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    779,
    "EKSTRAK BUNGA MAWAR (ROSE FLOS EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    780,
    "EKSTRAK BUNGA SAFFLOWER (CARTHAMUS TINCTORIUS)",
    "No",
    "No",
    "Aktif",
  ],
  [781, "Ekstrak Cabe (Chili Extract)", "No", "No", "Aktif"],
  [
    782,
    "Ekstrak Campuran Buah Beri (Mixberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [783, "Ekstrak Chicory (Chicory Extract)", "No", "No", "Aktif"],
  [784, "Ekstrak Cincau (Grass Jelly Extract)", "No", "No", "Aktif"],
  [785, "EKSTRAK COCOPANDAN", "No", "No", "Nonaktif"],
  [786, "Ekstrak Cumi-cumi", "No", "No", "Nonaktif"],
  [
    787,
    "Ekstrak Daging Ayam (Chicken Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [788, "Ekstrak Daging Babi (Pork Extract)", "No", "No", "Aktif"],
  [789, "Ekstrak Daging Sapi (Beef Extract)", "No", "No", "Aktif"],
  [
    790,
    "Ekstrak Daun Katuk (Sauropus androgynus Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    791,
    "Ekstrak Daun Kelor (Moringa Leaves Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    792,
    "EKSTRAK DAUN MESONA (MESONA LEAF EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    793,
    "EKSTRAK DAUN PANDAN (PANDANUS LEAF EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    794,
    "Ekstrak Daun Salam (Bay Leaf Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    795,
    "EKSTRAK DAUN SIRIH (PIPER BETLE EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    796,
    "Ekstrak Daun Wasabi (Wasabi Leaf Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [797, "EKSTRAK DEDAK (RICE BRAN EXTRACT)", "No", "No", "Aktif"],
  [
    798,
    "EKSTRAK FRAMBOZEN (FRAMBOZEN EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [799, "Ekstrak Gandum (Wheat Extract)", "No", "No", "Aktif"],
  [
    800,
    "Ekstrak Ginseng (Panax Ginseng C.A Meyer)",
    "No",
    "No",
    "Aktif",
  ],
  [
    801,
    "Ekstrak Ginseng (Panax Quinquefolius-American Ginseng)",
    "No",
    "No",
    "Aktif",
  ],
  [
    802,
    "EKSTRAK GUARANA - PAULLINIA CUPANA(GUARANA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    803,
    "EKSTRAK GUARANA BUBUK (GUARANA POWDER EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    804,
    "Ekstrak Gula Tebu (Cane Sugar Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    805,
    "Ekstrak Gurita Bubuk (Octopus Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [806, "EKSTRAK HOP (HOP EXTRACT)", "No", "No", "Aktif"],
  [807, "Ekstrak Ikan (Fish Extract)", "No", "No", "Aktif"],
  [
    808,
    "Ekstrak Ikan Bonito (Bonito Fish Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    809,
    "Ekstrak Ikan Gabus (Snakehead fish Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    810,
    "Ekstrak Ikan Sardin (Sardines Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [811, "Ekstrak Ikan Sidat (Eel Extract)", "No", "No", "Aktif"],
  [812, "Ekstrak Ikan Teri (Anchovy Extract)", "No", "No", "Aktif"],
  [813, "Ekstrak Jagung (Corn Extract)", "No", "No", "Aktif"],
  [814, "Ekstrak Jahe (Ginger Extract)", "No", "No", "Aktif"],
  [815, "Ekstrak Jambu Biji (Guava Extract)", "No", "No", "Aktif"],
  [816, "Ekstrak Jamur (Mushroom Extract)", "No", "No", "Aktif"],
  [
    817,
    "EKSTRAK JAMUR BUBUK (MUSHROOM EXTRACT POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    818,
    "Ekstrak Jamur Shitake (Shitake Mushroom Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [819, "Ekstrak Jeruk (Orange Extract)", "No", "No", "Aktif"],
  [820, "EKSTRAK JERUK ........", "No", "No", "Nonaktif"],
  [821, "Ekstrak Jeruk Lemon (Lemon Extract)", "No", "No", "Aktif"],
  [822, "Ekstrak Jeruk Limau (Citrus Extract)", "No", "No", "Aktif"],
  [
    823,
    "EKSTRAK JERUK LIMAU BUBUK (LIME EXTRACT POWDER)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [824, "Ekstrak Jeruk Nipis (Lime Extract)", "No", "No", "Aktif"],
  [825, "Ekstrak Jintan Hitam", "No", "No", "Aktif"],
  [
    826,
    "Ekstrak Kacang Hazel (Hazelnut Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    827,
    "Ekstrak Kacang Hijau (Mungben Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    828,
    "Ekstrak Kacang Kedelai (Soybean Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    829,
    "EKSTRAK KACANG TANAH (PEANUT EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [830, "Ekstrak Kawis (Kawis Extract)", "No", "No", "Aktif"],
  [
    831,
    "Ekstrak Kayu Manis (Cinnamon Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [832, "Ekstrak Kecambah (Sprouts Extract)", "No", "No", "Aktif"],
  [833, "EKSTRAK KEDELAI (SOY EXTRACT)", "No", "No", "Nonaktif"],
  [834, "Ekstrak Kelapa (Coconut Extract)", "No", "No", "Aktif"],
  [
    835,
    "EKSTRAK KELAPA MUDA (YOUNG COCONUT EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [836, "Ekstrak Kelp (Kelp Extract)", "No", "No", "Aktif"],
  [837, "EKSTRAK KENCUR (GALANGAL EXTRACT)", "No", "No", "Aktif"],
  [838, "Ekstrak Kepiting (Crab Extract)", "No", "No", "Aktif"],
  [839, "Ekstrak Kerang (Clam Extract)", "No", "No", "Aktif"],
  [840, "Ekstrak Kimchi (Kimchi Extract)", "No", "No", "Aktif"],
  [841, "Ekstrak Kola (Coke Extract)", "No", "No", "Aktif"],
  [842, "Ekstrak Kolesom (Kolesom Extract)", "No", "No", "Aktif"],
  [843, "Ekstrak Kopi (Coffee Extract)", "No", "No", "Aktif"],
  [
    844,
    "Ekstrak Kopi Hijau (Green Coffee Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    845,
    "Ekstrak Krisantemum (Chrysantemum Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    846,
    "Ekstrak Kubis Merah (Red Cabbage Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [847, "EKSTRAK KUNING TELUR (YOLK EXTRACT)", "No", "No", "Aktif"],
  [848, "Ekstrak Kunyit (Turmeric Extract)", "No", "No", "Aktif"],
  [849, "Ekstrak Lada (Pepper Extract)", "No", "No", "Aktif"],
  [
    850,
    "EKSTRAK LICORICE-LIQUORICE- SUCCUS LIQUIRITIAE (GLYCYRRHIZA GLABRA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    851,
    "Ekstrak Licorice-Liquorice- Succus Liquiritiae (Glycyrrhiza Glabra/leguminous weed)",
    "No",
    "No",
    "Aktif",
  ],
  [
    852,
    "Ekstrak Lidah Buaya (Aloe Vera Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [853, "Ekstrak Lobak (Radish Extract)", "No", "No", "Aktif"],
  [854, "Ekstrak Madu (Honey Extract)", "No", "No", "Aktif"],
  [855, "Ekstrak Malt (Malt Extract)", "No", "No", "Aktif"],
  [856, "Ekstrak Mangga (Mango Extract)", "No", "No", "Aktif"],
  [857, "Ekstrak Manggis (Mangosteen Extract)", "No", "No", "Aktif"],
  [858, "Ekstrak Melati (Jasmine Extract)", "No", "No", "Aktif"],
  [859, "Ekstrak Melon (Melon Extract)", "No", "No", "Aktif"],
  [860, "Ekstrak Mint (Mint Extract)", "No", "No", "Aktif"],
  [
    861,
    "Ekstrak Minyak Ikan (Fish Oil Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [862, "Ekstrak Muscat (Muscat Extract)", "No", "No", "Aktif"],
  [863, "Ekstrak Mustard (Mustard Extract)", "No", "No", "Aktif"],
  [864, "Ekstrak Nanas (Pineapple Extact)", "No", "No", "Aktif"],
  [865, "Ekstrak Nangka (Jackfruit Extract)", "No", "No", "Aktif"],
  [866, "Ekstrak Pala (Nutmeg Extract)", "No", "No", "Aktif"],
  [867, "EKSTRAK PANDAN", "No", "No", "Nonaktif"],
  [868, "Ekstrak Paprika (Paprika Extract)", "No", "No", "Aktif"],
  [
    869,
    "EKSTRAK PEGAGAN (PENNYWORTH EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [870, "EKSTRAK PEPAYA (PAPAYA EXTRACT)", "No", "No", "Aktif"],
  [871, "ekstrak perilla seed", "No", "No", "Nonaktif"],
  [872, "Ekstrak Pir (Pear Extract)", "No", "No", "Aktif"],
  [873, "Ekstrak Protein.... (Asal Bahan...)", "No", "No", "Aktif"],
  [874, "EKSTRAK QUILLAILA", "No", "No", "Nonaktif"],
  [875, "Ekstrak Ragi (Yeast Extract)", "No", "No", "Aktif"],
  [876, "Ekstrak Remis (Mussels Extract)", "No", "No", "Aktif"],
  [877, "Ekstrak Ricola (Ricola Extract)", "No", "No", "Aktif"],
  [
    878,
    "EKSTRAK ROSELLA (HIBISCUS SABDARIFFA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    879,
    "EKSTRAK ROSEMARY (ROSMARINUS OFFICINALIS EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [880, "Ekstrak Rum (Rhum Extract)", "No", "No", "Aktif"],
  [
    881,
    "Ekstrak Rumput Laut (Seaweed Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    882,
    "EKSTRAK SARSAPARILA - SARSI (SARSAPARILLA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [883, "Ekstrak Sayuran (Vegetable Extract)", "No", "No", "Aktif"],
  [884, "Ekstrak Seafood (Seafood Extract)", "No", "No", "Aktif"],
  [885, "EKSTRAK SEREALIA (CEREALS EXTRACT)", "No", "No", "Aktif"],
  [886, "Ekstrak Sereh (Lemongrass Extract)", "No", "No", "Aktif"],
  [887, "EKSTRAK STEVIA (STEVIA EXTRACT)", "No", "No", "Nonaktif"],
  [888, "Ekstrak Tebu (Cane Extract)", "No", "No", "Aktif"],
  [889, "Ekstrak Teh (Tea Extract)", "No", "No", "Aktif"],
  [
    890,
    "Ekstrak Teh Hijau (Green Tea Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    891,
    "Ekstrak Teh Hitam (Black Tea Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    892,
    "EKSTRAK TEMU HITAM (CURCUMA AERUGINOSA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    893,
    "Ekstrak Temulawak (Curcuma xanthorrhiza Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [894, "Ekstrak Tiram (Oyster Extract)", "No", "No", "Aktif"],
  [
    895,
    "Ekstrak Tulang Babi (Pig Bone Extract)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [
    896,
    "Ekstrak Tulang Sapi (Beef Bone Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [897, "Ekstrak Udang (Shrimp Extract)", "No", "No", "Aktif"],
  [898, "ekstrak vanillin", "No", "No", "Nonaktif"],
  [899, "Ekstrak Wasabi (Wasabi Extract)", "No", "No", "Aktif"],
  [
    900,
    "Ekstrak Wildberry (Wildberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    901,
    "EKSTRAK WOLFBERRY (WOLFBERRY EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [902, "Ekstrak Wortel (Carrot Extract)", "No", "No", "Aktif"],
  [
    903,
    "EKSTRAK WORTEL UNGU/WORTEL HITAM (PURPLE/BLACK CARROTS EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    904,
    "Ekstrak Zizania Latifolia (Zizania Latifolia Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [905, "ELDERBERRY (SAMBUCUS EBULUS)", "No", "No", "Aktif"],
  [906, "ELDERBERRY (SAMBUCUS NIGRA)", "No", "No", "Aktif"],
  [907, "EMPING BARLEY ", "No", "No", "Aktif"],
  [908, "EMPING JAGUNG (CORN FLAKES)", "No", "No", "Aktif"],
  [909, "EMPING MELINJO - GNETUM GNEMON ", "No", "No", "Aktif"],
  [
    910,
    "Endo-1,3(4)-\\xDFglukanase (Endo1,3(4)-Beta-glucanase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    911,
    "Endo-1,4-\\xDF-xilanase (Endo-1,4-Betaxylanase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    912,
    "Endo-arabinase (Endo-arabinase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [913, "ENZIM AMILASE (AMILASE ENZYME)", "No", "No", "Nonaktif"],
  [
    914,
    "ENZIM BROMELAIN (BROMELAINE ENZYME)",
    "No",
    "No",
    "Nonaktif",
  ],
  [915, "ENZIM LAKTASE (LACTASE ENZYME)", "No", "No", "Nonaktif"],
  [
    916,
    "Enzim Laktoperoksidase (Lactoperoxidase Enzyme)",
    "No",
    "No",
    "Nonaktif",
  ],
  [917, "ENZIM PAPAIN (PAPAIN ENZYME)", "No", "No", "Nonaktif"],
  [918, "ENZIM PROTEASE (PROTEASE ENZYME)", "No", "No", "Nonaktif"],
  [919, "EPA (EICOSAPENTAENOIC ACID)", "No", "No", "Aktif"],
  [920, "Es (Ice)", "No", "No", "Aktif"],
  [921, "Es Batu (Ice Cube)", "No", "No", "Aktif"],
  [922, "Ester Sterol", "No", "No", "Aktif"],
  [923, "EUCOMMIA ULMOIDES", "No", "No", "Nonaktif"],
  [
    924,
    "Feijoa / Pineapple Guava (Acca sellowiana)",
    "No",
    "No",
    "Aktif",
  ],
  [925, "Fenilalanin (Phenilalanin)", "No", "No", "Aktif"],
  [926, "Fikain (Ficain) (Bahan Penolong)", "No", "No", "Aktif"],
  [927, "FITOMENADION (VIT K1)", "No", "No", "Nonaktif"],
  [928, "Fitostanol", "No", "No", "Aktif"],
  [929, "FITOSTANOL (PHYTOSTANOL)", "No", "No", "Nonaktif"],
  [930, "Fitostanol Ester", "No", "No", "Aktif"],
  [931, "Fitosterol", "No", "No", "Aktif"],
  [932, "Fitosterol (Phytosterol)", "No", "No", "Aktif"],
  [933, "Fitosterol Ester", "No", "No", "Aktif"],
  [934, "FONDAN (FONDANT)", "No", "No", "Aktif"],
  [
    935,
    "Fosfolipase A1 (Phospholipase A1) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    936,
    "Fosfolipase A2 (Phospholipase A2) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    937,
    "Fosfolipase C (Phospholipase C) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [938, "Fosfolipid (Phospholipids)", "No", "No", "Aktif"],
  [939, "Fruit Bromelain (Bahan Penolong)", "No", "No", "Aktif"],
  [940, "FRUKTO OLIGOSAKARIDA (FOS)", "No", "No", "Aktif"],
  [
    941,
    "Fruktooligosakarida (Fructooligosacchar ide FOS)",
    "No",
    "No",
    "Aktif",
  ],
  [942, "Fruktosa (Fructose)", "No", "No", "Aktif"],
  [943, "GABAH PADI (RICE GRAIN)", "No", "No", "Aktif"],
  [944, "Galakto Oligosakarida (GOS)", "No", "No", "Aktif"],
  [
    945,
    "Galaktooligosakarida (Galactooligosacch aride \x{2013} GOS)",
    "No",
    "No",
    "Aktif",
  ],
  [946, "GAMA KAROTEN", "No", "No", "Aktif"],
  [947, "Gambir (Uncaria gambir)", "No", "No", "Aktif"],
  [948, "Gandum (Wheat)", "No", "No", "Aktif"],
  [
    949,
    "GANDUM DURUM SEMOLINA (DURUM SEMOLINA WHEAT)",
    "No",
    "No",
    "Aktif",
  ],
  [950, "GANDUM HITAM (RYE)", "No", "No", "Aktif"],
  [951, "GANDUM MALT (WHEAT MALT)", "No", "No", "Aktif"],
  [952, "Gandum Merah (Red Wheat)", "No", "No", "Aktif"],
  [953, "Gandum Panggang (Roasted Wheat)", "No", "No", "Aktif"],
  [954, "Gandum Semolina (Semolina Wheat)", "No", "No", "Aktif"],
  [955, "Gandum Serpihan (Wheat Flakes)", "No", "No", "Aktif"],
  [956, "Gandum Utuh (Whole Wheat)", "No", "No", "Aktif"],
  [957, "Ganggang Laut (Sea Algae)", "No", "No", "Aktif"],
  [958, "GANGLIOSIDA (GANGLIOSIDE)", "No", "No", "Nonaktif"],
  [959, "Garam (Salt)", "No", "No", "Aktif"],
  [960, "GARAM BERIODIUM (IODIZED SALT)", "No", "No", "Nonaktif"],
  [961, "Garam Halus (Refined Salt)", "No", "No", "Aktif"],
  [962, "Garam Hitam (Black Salt)", "No", "No", "Aktif"],
  [963, "Garam Inggris (Epsom Salt)", "No", "No", "Aktif"],
  [964, "Garam Laut (Sea Salt)", "No", "No", "Aktif"],
  [965, "GARAM RAFINASI (REFINED SALT)", "No", "No", "Nonaktif"],
  [966, "GARCINIA CAMBOGIA", "No", "No", "Nonaktif"],
  [967, "GARDENIA BLUE", "No", "No", "Nonaktif"],
  [968, "GELATIN (GELATINE)", "Yes", "No", "Aktif"],
  [969, "GENMAICHA (ROASTED RICE TEA)", "No", "No", "Aktif"],
  [970, "GIN (GIN)", "No", "No", "Aktif"],
  [971, "Ginjal Sapi (Beef Kidney)", "No", "No", "Aktif"],
  [972, "GINKGO BILOBA", "No", "No", "Nonaktif"],
  [973, "GLISERIN", "No", "No", "Nonaktif"],
  [
    974,
    "Gliserolfosfolipid kolesterol asiltransferase (Glycerophospholipid cholesterol acyltransferase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [975, "GLISIN (GLYCINE)", "No", "No", "Aktif"],
  [
    976,
    "Glukan 1,3-\\xDFglukosidase (Glucan 1,3-Beta-glucosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    977,
    "Glukan 1,4-aglukosidase (Glucan 1,4-Alphaglucosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    978,
    "Glukan 1,4-amaltohidrolase (Glucan 1,4-Alphamaltohydrolase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    979,
    "Glukan 1,4-amaltotetraohidrolase (Glucan 1,4-Alphamaltotetraohydrolase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [980, "Glukosa (Glucose)", "No", "No", "Aktif"],
  [981, "Glukosa Anhidrat (Glucose Anhydrate)", "No", "No", "Aktif"],
  [982, "Glukosa Bubuk (Glucose Powder)", "No", "No", "Aktif"],
  [
    983,
    "Glukosa oksidase (Glucose oxidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [984, "Glukosamin (Glucosamine)", "No", "No", "Aktif"],
  [
    985,
    "Glukosamin Hidroklorida (Glucosamine Hydrochloride)",
    "No",
    "No",
    "Aktif",
  ],
  [
    986,
    "Glukosamin Sulfat (Glucosamine Sulphate)",
    "No",
    "No",
    "Aktif",
  ],
  [987, "GLUTEN (GLUTEN)", "No", "No", "Nonaktif"],
  [988, "GLYCYRRHIZA GLABRA (LICORICE)", "No", "No", "Aktif"],
  [989, "GOBO", "No", "No", "Nonaktif"],
  [990, "GOBO BUBUK (GOBO POWDER)", "No", "No", "Nonaktif"],
  [991, "GOJI (LYCIUM BARBARUM)", "No", "No", "Nonaktif"],
  [992, "GOJI BERRY (LYCIUM BARBARUM)", "No", "No", "Aktif"],
  [993, "GOJI BERRY - WOLBERRY", "No", "No", "Aktif"],
  [994, "Great Northern Beans", "No", "No", "Aktif"],
  [995, "GUARANA (PAULLINIA CUPANA)", "No", "No", "Aktif"],
  [996, "GULA AREN (PALM SUGAR)", "No", "No", "Aktif"],
  [997, "Gula Batu (Rock Sugar)", "No", "No", "Aktif"],
  [998, "Gula Bit (Sugar Beet)", "No", "No", "Aktif"],
  [999, "Gula Cair (Liquid Sugar)", "No", "No", "Aktif"],
  [1000, "Gula Cokelat (Brown Sugar-Demerara)", "No", "No", "Aktif"],
  [1001, "Gula Halus (Refined Sugar)", "No", "No", "Aktif"],
  [1002, "Gula Hitam (Raw Cane Sugar)", "No", "No", "Aktif"],
  [1003, "Gula Icing (Icing Sugar)", "No", "No", "Aktif"],
  [1004, "Gula Invert (Invert Sugar)", "No", "No", "Aktif"],
  [1005, "Gula Jawa (Palm Sugar)", "No", "No", "Aktif"],
  [
    1006,
    "GULA KASTOR (CASTOR SUGAR ATAU CASTER SUGAR)",
    "No",
    "No",
    "Aktif",
  ],
  [1007, "GULA KELAPA (COCONUT SUGAR)", "No", "No", "Aktif"],
  [1008, "Gula Kristal (Sugar Crystals)", "No", "No", "Aktif"],
  [1009, "Gula Merah (Brown Sugar)", "No", "No", "Aktif"],
  [1010, "Gula Palem (Palm Sugar)", "No", "No", "Aktif"],
  [1011, "Gula Pasir (Granulated Sugar)", "No", "No", "Aktif"],
  [1012, "GULA SIWALAN (PALM SUGAR)", "No", "No", "Aktif"],
  [1013, "Gula Tebu (Cane Sugar)", "No", "No", "Aktif"],
  [
    1014,
    "Gula Terfermentasi (Fermented Sugar)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1015, "GUM BASE", "No", "No", "Aktif"],
  [1016, "Gurita (Octopus)", "No", "No", "Aktif"],
  [1017, "HALBA (HALBA)", "No", "No", "Nonaktif"],
  [1018, "Halia (Halia)", "No", "No", "Aktif"],
  [
    1019,
    "Hancuran Permen/ Butiran Permen (Crushed candy)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1020,
    "Hasil Destilasi Minyak Peppermint (Peppermint Oil Distillation)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1021,
    "HASIL DISTILASI FERMENTASI ANGGUR (DISTILLED FERMENTED GRAPE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1022,
    "HASIL DISTILASI FERMENTASI ANGGUR HIJAU (DISTILLED FERMENTED GREEN GRAPE) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1023,
    "Hasil Distilasi Fermentasi Beras (Distilled Fermented Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1024,
    "Hasil Distilasi Fermentasi Jambu Mente (Distilled Fermented Cashew)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1025,
    "Hasil Distilasi Fermentasi Malt-Gandum-....... (Distilled Fermented Malt-Wheat-.....)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1026,
    "HASIL FERMENTASI .....(SEREALIA, BUAH, ....)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1027,
    "Hasil Fermentasi Apel (Fermented Apple)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1028,
    "Hasil Fermentasi Arbei (Fermented Berries)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1029,
    "Hasil Fermentasi Beras (Fermented Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1030,
    "Hasil Fermentasi Beras Ketan Hitam (Fermented Black Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1031,
    "Hasil Fermentasi Beras Ketan Putih (Fermented White Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1032,
    "Hasil Fermentasi Buah Agave (Fermented Agave)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1033,
    "Hasil Fermentasi Buah Anggur Hijau (Fermented Green Grape)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1034,
    "Hasil Fermentasi Buah Anggur Merah (Fermented Red Grape)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1035,
    "Hasil Fermentasi Buah Lontar (Fermented Palmyra) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1036,
    "Hasil Fermentasi Gandum (Fermented Wheat)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1037,
    "Hasil Fermentasi Gula Merah (Fermented Brown Sugar)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1038,
    "Hasil Fermentasi Jagung (Fermented Corn)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1039,
    "Hasil Fermentasi Jeruk (Fermented Orange)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1040,
    "HASIL FERMENTASI KEDELAI (FERMENTED SOYBEAN)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1041,
    "Hasil Fermentasi Kedelai Hitam (Fermented Black Soybeans)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1042,
    "HASIL FERMENTASI KETAN HITAM (FERMENTED BLACK GLUTINOUS RICE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1043,
    "Hasil Fermentasi Malt (Fermented Malt)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1044,
    "Hasil Fermentasi Markisa (Fermented Passion Fruit)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1045,
    "Hasil Fermentasi Molases (Fermented Molases)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1046,
    "Hasil Fermentasi Nanas (Fermented Pineapple)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1047,
    "Hasil Fermentasi Nira (Fermented Sap)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1048,
    "Hasil Fermentasi Pepaya (Fermented Papaya)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1049,
    "Hasil Fermentasi Salak (Fermented Salak)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1050,
    "Hasil Fermentasi Sawo (Fermented Sapodilla)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1051,
    "Hasil Fermentasi Singkong (Fermented Cassava)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1052,
    "Hasil Fermentasi Tepung Rye (Fermented Rye Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1053,
    "Hasil Fermentasi Tomat (Fermented Tomato)",
    "No",
    "No",
    "Aktif",
  ],
  [1054, "Hati Ayam  (Chicken Liver)", "No", "No", "Aktif"],
  [
    1055,
    "Hati Ayam Bubuk (Chicken Liver Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1056, "Hati Babi (Pig Liver)", "No", "No", "Aktif"],
  [1057, "Hati Sapi (Cow Liver)", "No", "No", "Aktif"],
  [1058, "HEATHER (ERICA VULGARIS)", "No", "No", "Aktif"],
  [
    1059,
    "Heksosa oksidase (Hexose oxidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1060, "Hemiselulase (Hemicellulase)", "No", "No", "Aktif"],
  [
    1061,
    "Hemiselulase endo1,3-\\xDF-xilanase (Hemicellulase endo1,3-Beta-xylanase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1062,
    "Hidrolisat Kasein Protein (Hydrolysed Casein Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1063,
    "Hidrolisat Protein (Hydrolyzed Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1064,
    "Hidrolisat Protein Ikan (Hydrolyzed Fish Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1065,
    "Hidrolisat Protein Kedelai (Hydrolyzed Soy Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1066,
    "Hidrolisat Protein Nabati (Hydrolyzed Vegetable Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1067,
    "HIDROLISAT PROTEIN WHEY (HYDROLIZED WHEY PROTEIN)",
    "No",
    "Yes",
    "Aktif",
  ],
  [1068, "Histidin (Histidine)", "No", "No", "Aktif"],
  [1069, "Hojicha Bubuk (Hojicha Powder)", "No", "No", "Aktif"],
  [1070, "honeybush (cyclopia maculate)", "No", "No", "Nonaktif"],
  [
    1071,
    "Honeybush (Cyclopia maculate, Cyclopia genistoides, Cyclopia sessiliflora (\"Heidelbergtee\")",
    "No",
    "No",
    "Aktif",
  ],
  [1072, "HONEYSUCKLE", "No", "No", "Nonaktif"],
  [1073, "HOPS", "No", "No", "Aktif"],
  [1074, "HUPERSZINE (HUPERZINE SERRATA)", "No", "No", "Nonaktif"],
  [1075, "HYDRATED DEXTRATES", "No", "No", "Nonaktif"],
  [1076, "ICE STRUCTURING PROTEIN", "No", "No", "Aktif"],
  [1077, "Iga Babi (Pork Ribs)", "No", "No", "Aktif"],
  [1078, "IGA SAPI (BEEF RIBS)", "No", "No", "Aktif"],
  [1079, "Ikan (Fish)", "No", "No", "Aktif"],
  [
    1080,
    "Ikan Asap Bubuk (Smoked Fish Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1081, "Ikan Asin (Salted Fish)", "No", "No", "Aktif"],
  [1082, "Ikan Bandeng (Milkfish)", "No", "No", "Aktif"],
  [1083, "IKAN BELIDA (BELIDA FISH)", "No", "No", "Aktif"],
  [1084, "IKAN BILIS", "No", "No", "Aktif"],
  [1085, "IKAN BONITO (BONITO FISH)", "No", "No", "Aktif"],
  [
    1086,
    "IKAN BONITO BUBUK (BONITO FISH POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1087, "Ikan Bubuk (Fish Powder)", "No", "No", "Aktif"],
  [1088, "IKAN CAKALANG (SKIPJACK TUNA FISH)", "No", "No", "Aktif"],
  [1089, "IKAN DACE (DACE FISH)", "No", "No", "Aktif"],
  [1090, "Ikan Fillet (FISH FILLET)", "No", "No", "Aktif"],
  [1091, "Ikan Gindara", "No", "No", "Aktif"],
  [1092, "IKAN HARING (HERRING FISH)", "No", "No", "Aktif"],
  [
    1093,
    "IKAN HARING FILLET (HERRING FISH FILLET)",
    "No",
    "No",
    "Aktif",
  ],
  [1094, "IKAN KAKAP (SNAPPER FISH)", "No", "No", "Aktif"],
  [1095, "IKAN KISU (KISU FISH)", "No", "No", "Aktif"],
  [1096, "Ikan Kod (Cod Fish)", "No", "No", "Aktif"],
  [1097, "Ikan Kod Bubuk (Cod Fish Powder)", "No", "No", "Aktif"],
  [
    1098,
    "IKAN KORVINA KUNING (YELLOW CORVINA FISH)",
    "No",
    "No",
    "Aktif",
  ],
  [1099, "Ikan Layar (Sailfish)", "No", "No", "Aktif"],
  [1100, "IKAN LAYUR (LAYUR FISH)", "No", "No", "Aktif"],
  [1101, "Ikan Lele (Catfish)", "No", "No", "Aktif"],
  [1102, "Ikan Lemuru (Sardine)", "No", "No", "Aktif"],
  [1103, "IKAN MAKAREL (MACKEREL FISH)", "No", "No", "Aktif"],
  [1104, "IKAN MARLIN (MARLIN FISH)", "No", "No", "Aktif"],
  [1105, "Ikan Nila (Tilapia Fish)", "No", "No", "Aktif"],
  [1106, "Ikan Patin", "No", "No", "Aktif"],
  [1107, "IKAN POLLOCK (POLLOCK FISH)", "No", "No", "Aktif"],
  [1108, "IKAN SALMON (SALMON FISH)", "No", "No", "Aktif"],
  [1109, "IKAN SARDIN (SARDINES FISH)", "No", "No", "Aktif"],
  [
    1110,
    "IKAN SARDIN BUBUK (SARDINES FISH POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1111, "IKAN SLENGSENG (MACKEREL FISH)", "No", "No", "Aktif"],
  [1112, "IKAN TEMBANG (SARDINELLA)", "No", "No", "Aktif"],
  [1113, "Ikan Tenggiri (Mackerel)", "No", "No", "Aktif"],
  [1114, "Ikan Teri (Anchovy)", "No", "No", "Aktif"],
  [1115, "IKAN TUNA (TUNA FISH)", "No", "No", "Aktif"],
  [1116, "Inosin (Inosine)", "No", "No", "Aktif"],
  [1117, "INOSITOL (INOSITOL)", "No", "No", "Nonaktif"],
  [1118, "Inti Buah Sawit (palm kernel)", "No", "No", "Aktif"],
  [1119, "Inulin (Inulin)", "No", "No", "Aktif"],
  [
    1120,
    "Inulinase (Inulinase (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1121, "Iodium (Kalium Iodat - KIO3)", "No", "No", "Aktif"],
  [1122, "Isian berbasis susu", "Yes", "Yes", "Aktif"],
  [
    1123,
    "Isoamilase (Isoamylase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1124, "Isoflavon (Isoflavone)", "No", "No", "Aktif"],
  [
    1125,
    "Isolat Protein Kedelai (Soy Protein Isolate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1126,
    "ISOLAT PROTEIN NABATI (VEGETABLE PROTEIN ISOLATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1127, "Isolat Protein Pea", "No", "No", "Aktif"],
  [
    1128,
    "ISOLAT PROTEIN SUSU (MILK PROTEIN ISOLATE)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    1129,
    "ISOLAT PROTEIN WHEY (WHEY PROTEIN ISOLATE)",
    "No",
    "Yes",
    "Aktif",
  ],
  [1130, "Isoleusin (Isoleucine)", "No", "No", "Aktif"],
  [
    1131,
    "ISOMALTO OLIGOSAKARIDA (ISOMALTOOLIGOSACCHARIDE)",
    "No",
    "No",
    "Aktif",
  ],
  [1132, "Isomaltodekstrin (IMD)", "No", "No", "Aktif"],
  [1133, "Isomaltulosa (Isomaltulose)", "No", "No", "Aktif"],
  [1134, "Jagung", "No", "No", "Nonaktif"],
  [1135, "Jagung (Corn)", "No", "No", "Aktif"],
  [1136, "JAGUNG BAKAR (ROASTED CORN)", "No", "No", "Aktif"],
  [
    1137,
    "Jagung Bakar Bubuk (Roasted Corn Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1138, "Jagung Berondong (Pop Corn)", "No", "No", "Aktif"],
  [1139, "Jagung Butiran (Corn Grain)", "No", "No", "Aktif"],
  [1140, "Jagung Kering (Dried Corn)", "No", "No", "Aktif"],
  [
    1141,
    "Jagung Kernel Utuh (Whole Kernel Corn)",
    "No",
    "No",
    "Aktif",
  ],
  [1142, "Jagung Manis (Sweet Corn)", "No", "No", "Aktif"],
  [
    1143,
    "Jagung Manis Bubuk (Sweet Corn Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1144, "Jagung Muda (Baby Corn)", "No", "No", "Aktif"],
  [1145, "JAGUNG SEMOLINA (MAIZE SEMOLINA)", "No", "No", "Aktif"],
  [1146, "Jagung Serpihan (Corn Flakes)", "No", "No", "Aktif"],
  [1147, "Jahe (Ginger)", "No", "No", "Aktif"],
  [1148, "Jahe Bubuk (Ginger Powder)", "No", "No", "Aktif"],
  [1149, "Jahe Giling (Milled Ginger)", "No", "No", "Aktif"],
  [1150, "Jahe Kering (Dried Ginger)", "No", "No", "Aktif"],
  [
    1151,
    "JAHE MERAH- ZINGIBER OFFICINALE VAR RUBRU (RED GINGER)",
    "No",
    "No",
    "Aktif",
  ],
  [1152, "JALI (COIX LACRYMA-JOBI)", "No", "No", "Aktif"],
  [1153, "JAMBU AIR (ROSE APPLE)", "No", "No", "Aktif"],
  [1154, "Jambu Biji (Guava)", "No", "No", "Aktif"],
  [1155, "Jambu Biji Bubuk (Guava Powder)", "No", "No", "Aktif"],
  [1156, "Jambu Mete (Cashew)", "No", "No", "Aktif"],
  [1157, "Jamur (Mushroom)", "No", "No", "Aktif"],
  [1158, "Jamur Boletes Kuning", "No", "No", "Aktif"],
  [1159, "Jamur Bubuk (Mushroom Powder)", "No", "No", "Aktif"],
  [1160, "Jamur Geotrichum candidum", "No", "No", "Aktif"],
  [1161, "Jamur Kancing (Champignon)", "No", "No", "Aktif"],
  [1162, "Jamur Kering (Dried Mushroom)", "No", "No", "Aktif"],
  [1163, "Jamur Kuping (Auricularia auricula)", "No", "No", "Aktif"],
  [
    1164,
    "JAMUR KUPING HITAM (AURICULARIA POLYTRICHA)",
    "No",
    "No",
    "Aktif",
  ],
  [1165, "Jamur ling zhi (Lingzhi mushroom)", "No", "No", "Aktif"],
  [
    1166,
    "JAMUR MADU (ARMILLARIA OSTOYAE, HONEY MUSHROOM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1167,
    "JAMUR MERAH BUBUK (RED MUSHROOM POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1168, "Jamur Merang (Volvariella volvacea)", "No", "No", "Aktif"],
  [
    1169,
    "JAMUR MESHAMA- JAMUR SANGHWANG, MESHIMAKOBU; SONG GEN (PHELLINUS LINTEUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1170,
    "JAMUR SALJU - ENOKITAKE (FLAMMULINA VELUTIPES)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1171,
    "JAMUR SANGHWANG (PHELLINUS LINTEUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1172, "JAMUR SHIITAKE (LENTINULA EDODES)", "No", "No", "Aktif"],
  [
    1173,
    "Jamur Shiitake Bubuk (Shiitake Mushroom Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1174, "Jamur Tempe", "No", "No", "Aktif"],
  [
    1175,
    "JAMUR TEROMPET - JAMUR SARANG BURUNG",
    "No",
    "No",
    "Aktif",
  ],
  [1176, "Jamur Tiram (Pleurotus ostreatus)", "No", "No", "Aktif"],
  [1177, "Jantung Pisang (Banana Heart)", "No", "No", "Aktif"],
  [1178, "Jantung Sapi (Beef Heart)", "No", "No", "Aktif"],
  [1179, "Jeli (Jelly)", "No", "No", "Aktif"],
  [1180, "Jeli Bubuk (Jelly Powder)", "No", "No", "Aktif"],
  [1181, "JENGKOL (DJENKOL)", "No", "No", "Aktif"],
  [1182, "Jeruk (Orange)", "No", "No", "Aktif"],
  [1183, "Jeruk Asam-Pahit (Seville Orange)", "No", "No", "Aktif"],
  [1184, "Jeruk Bali (Grapefruit- Pomelo)", "No", "No", "Aktif"],
  [1185, "JERUK BALI MERAH (GRAPEFRUIT)", "No", "No", "Aktif"],
  [1186, "JERUK BERGAMOT (CITRUS BERGAMIA)", "No", "No", "Aktif"],
  [1187, "Jeruk Besar (Grapefruit- Pomelo)", "No", "No", "Aktif"],
  [1188, "Jeruk Bubuk (orange powder)", "No", "No", "Aktif"],
  [
    1189,
    "Jeruk Citron-Jeruk Sukade (Citrus medica)",
    "No",
    "No",
    "Aktif",
  ],
  [1190, "JERUK KEPROK (CITRUS RETICULATA)", "No", "No", "Aktif"],
  [1191, "JERUK LEMON (CITRUS LIMON)", "No", "No", "Aktif"],
  [1192, "Jeruk Lemon Bubuk (Lemon Powder)", "No", "No", "Aktif"],
  [1193, "JERUK LIMAU (CITRUS AMBLYCARPA)", "No", "No", "Aktif"],
  [1194, "Jeruk Mandarin (Mandarin Orange)", "No", "No", "Aktif"],
  [1195, "JERUK NIPIS (CITRUS AURANTIFOLIA)", "No", "No", "Aktif"],
  [1196, "Jeruk Nipis Bubuk (Lime Powder)", "No", "No", "Aktif"],
  [
    1197,
    "JERUK PURUT (KAFFIR LIME - CITRUS HYSTRIX)",
    "No",
    "No",
    "Aktif",
  ],
  [1198, "JERUK TANGERINE (CITRUS TANGERINA)", "No", "No", "Aktif"],
  [1199, "JINTAN HITAM (NIGELLA SATIVA)", "No", "No", "Aktif"],
  [1200, "JINTAN-JINTEN (CARAWAY)", "No", "No", "Aktif"],
  [
    1201,
    "JINTAN-JINTEN BUBUK (CARAWAY POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1202, "JINTAN-JINTEN HITAM (HABBATUSSAUDA)", "No", "No", "Aktif"],
  [1203, "JINTAN-JINTEN MANIS (ANISE)", "No", "No", "Aktif"],
  [
    1204,
    "JINTAN-JINTEN PUTIH-CUNICUM CYMINUM (CUMIN)",
    "No",
    "No",
    "Aktif",
  ],
  [1205, "JUNIPER BERRIES", "No", "No", "Aktif"],
  [1206, "Kacang Alas/ Biji Sengon", "No", "No", "Aktif"],
  [1207, "KACANG ALMOND (ALMOND)", "No", "No", "Aktif"],
  [
    1208,
    "KACANG ARAB - GARBANZO (CHICKPEA - CICER ARIETINUM)",
    "No",
    "No",
    "Aktif",
  ],
  [1209, "Kacang Atom ", "No", "No", "Aktif"],
  [
    1210,
    "KACANG AZUKI - KACANG MERAH KECIL - KACANG TOLO MERAH (AZUKI BEANS) ",
    "No",
    "No",
    "Aktif",
  ],
  [1211, "Kacang Blackeye (Blackeye Beans)", "No", "No", "Aktif"],
  [
    1212,
    "KACANG BOGOR (BAMBARA GROUNDNUTS - VIGNA SUBTERRANEA)",
    "No",
    "No",
    "Aktif",
  ],
  [1213, "Kacang Brazil (Brazil Nut)", "No", "No", "Aktif"],
  [1214, "KACANG BUNCIS (COMMON BEAN)", "No", "No", "Aktif"],
  [1215, "KACANG DAL (DHAL PEANUTS) ", "No", "No", "Aktif"],
  [1216, "KACANG DAL URAD (DHAL URAD PEANUTS)", "No", "No", "Aktif"],
  [
    1217,
    "Kacang Flageolet (Flageolet Bean)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1218, "KACANG GARBANZO (GARBANZO BEANS)", "No", "No", "Nonaktif"],
  [1219, "KACANG GINKGO (GINKGO NUTS)", "No", "No", "Aktif"],
  [1220, "Kacang Hazel (Hazelnut)", "No", "No", "Aktif"],
  [
    1221,
    "Kacang Hazel Panggang (Roasted Hazelnut)",
    "No",
    "No",
    "Aktif",
  ],
  [1222, "KACANG HIJAU (MUNG BEAN)", "No", "No", "Aktif"],
  [
    1223,
    "KACANG HIJAU BUBUK (MUNG BEAN POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1224,
    "KACANG HIJAU TANPA KULIT (SPLIT MUNG BEANS)",
    "No",
    "No",
    "Aktif",
  ],
  [1225, "KACANG HITAM", "No", "No", "Aktif"],
  [1226, "KACANG KAPRI (PEAS)", "No", "No", "Aktif"],
  [1227, "KACANG KASTANYE (CHESTNUTS)", "No", "No", "Aktif"],
  [1228, "Kacang Kedelai (Soybean)", "No", "No", "Aktif"],
  [
    1229,
    "Kacang Kedelai Bubuk (Soybean Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1230,
    "KACANG KEDELAI HITAM (BLACK SOYBEAN)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1231,
    "Kacang Kedelai Hitam Bubuk (Black Soybean Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1232, "Kacang Kedelai Muda (Edamame)", "No", "No", "Aktif"],
  [1233, "KACANG KENARI (WALNUTS)", "No", "No", "Aktif"],
  [1234, "Kacang Koro (Broad Bean) ", "No", "No", "Aktif"],
  [1235, "KACANG KRANBERI (BORLOTTI BEANS)", "No", "No", "Aktif"],
  [1236, "Kacang Kuning (Yellow Beans)", "No", "No", "Aktif"],
  [1237, "KACANG LENTIL (LENTILS)", "No", "No", "Aktif"],
  [
    1238,
    "KACANG LENTIL COKLAT (BROWN LENTILS)",
    "No",
    "No",
    "Aktif",
  ],
  [1239, "KACANG LENTIL MERAH (RED LENTILS)", "No", "No", "Aktif"],
  [1240, "KACANG LIMA (LIMA BEANS)", "No", "No", "Aktif"],
  [1241, "Kacang Macadamia (Macadamia Nut)", "No", "No", "Aktif"],
  [1242, "Kacang Mede (Cashewnut)", "No", "No", "Aktif"],
  [1243, "Kacang Merah (Red Bean-Kidney Bean)", "No", "No", "Aktif"],
  [
    1244,
    "KACANG NAVY - KACANG PUTIH (NAVY BEANS - WHITE PEA)",
    "No",
    "No",
    "Aktif",
  ],
  [1245, "KACANG PANJANG (YARDLONG BEAN)", "No", "No", "Aktif"],
  [1246, "KACANG PARANG (JACK BEAN)", "No", "No", "Aktif"],
  [1247, "KACANG PIKAN (PECAN)", "No", "No", "Aktif"],
  [1248, "KACANG PINUS (PINE NUTS)", "No", "No", "Aktif"],
  [1249, "KACANG PISTACHIO (PISTACHIO NUTS)", "No", "No", "Aktif"],
  [
    1250,
    "KACANG PISTACHIO PANGGANG (ROASTED PISTACHIO)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1251,
    "KACANG POLONG HIJAU (GREEN SPLIT PEAS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1252,
    "Kacang Polong Kering (Dried Greenpeas)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1253,
    "KACANG POLONG KUNING (YELLOW GREENPEAS)",
    "No",
    "No",
    "Aktif",
  ],
  [1254, "Kacang Polong-Ercis (Greenpeas)", "No", "No", "Aktif"],
  [1255, "KACANG PUTIH ", "No", "No", "Nonaktif"],
  [1256, "Kacang Tanah (Peanut)", "No", "No", "Aktif"],
  [
    1257,
    "Kacang Tanah Kupas (Shelled Peanuts)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1258,
    "Kacang Tanah Panggang (Roasted Peanut)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1259,
    "KACANG TOLO-KACANG TUNGGAK-KACANG DADAP",
    "No",
    "No",
    "Nonaktif",
  ],
  [1260, "Kacang Tunggak (Cowpea)", "No", "No", "Aktif"],
  [1261, "KACANG WALNUT (WALNUT)", "No", "No", "Nonaktif"],
  [1262, "KAFEIN (CAFFEIN)", "No", "No", "Aktif"],
  [1263, "Kailan (Kai-lan-Chinese Broccoli)", "No", "No", "Aktif"],
  [1264, "KAKAO (COCOA)", "No", "No", "Aktif"],
  [1265, "KAKAO BUBUK (COCOA POWDER)", "No", "No", "Aktif"],
  [1266, "KAKAO LIQUOR", "No", "No", "Nonaktif"],
  [
    1267,
    "KAKAO MASSA (COCOA MASS - COCOA LIQUOR)",
    "No",
    "No",
    "Aktif",
  ],
  [1268, "KAKAO PASTA (COCOA PASTE)", "No", "No", "Aktif"],
  [1269, "Kaki Babi (Pigs Feet)", "No", "No", "Aktif"],
  [1270, "Kalamansi (Calamansi)", "No", "No", "Aktif"],
  [1271, "Kaldu Ayam (Chicken Broth)", "No", "No", "Aktif"],
  [1272, "Kaldu Babi (Pork Broth)", "No", "No", "Aktif"],
  [1273, "Kaldu Ikan (Fish Broth)", "No", "No", "Aktif"],
  [1274, "Kaldu Kalkun (Turkey Broth)", "No", "No", "Aktif"],
  [1275, "Kaldu Kerang (Scallop Broth)", "No", "No", "Aktif"],
  [1276, "Kaldu Sapi (Beef Broth)", "No", "No", "Aktif"],
  [1277, "Kaldu Sayuran (Vegetable Broth)", "No", "No", "Aktif"],
  [1278, "Kaldu Udang", "No", "No", "Aktif"],
  [1279, "Kalium Bikarbonat", "No", "No", "Aktif"],
  [
    1280,
    "Kalium fluorida (Potassium fluoride)",
    "No",
    "No",
    "Aktif",
  ],
  [1281, "Kalium Fosfat ", "No", "No", "Nonaktif"],
  [1282, "Kalium Hidroksida", "No", "No", "Aktif"],
  [
    1283,
    "KALIUM IODIDA (POTASSIUM IODIDA-KIO3)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1284,
    "Kalium Karbonat (Potassium carbonate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1285,
    "Kalium Kaseinat (Potassium Caseinate)",
    "No",
    "No",
    "Aktif",
  ],
  [1286, "KALIUM KLORIDA (POTASSIUM CHLORIDE)", "No", "No", "Aktif"],
  [1287, "Kalium Sitrat", "No", "No", "Aktif"],
  [
    1288,
    "KALSIUM DARI GANGGANG LAUT (CALCAREOUS MARINE ALGAE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1289,
    "Kalsium Gliserofosfat (Calcium Glycerophosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1290,
    "Kalsium Hidrogen Fosfat Anhidrat (Calsium Hydrogen Phosphate Anhydrous)",
    "No",
    "No",
    "Aktif",
  ],
  [1291, "Kalsium hidroksida", "No", "No", "Aktif"],
  [1292, "KALSIUM KARBONAT", "No", "No", "Aktif"],
  [
    1293,
    "Kalsium Kaseinat (Calcium caseinate)",
    "No",
    "No",
    "Aktif",
  ],
  [1294, "Kalsium Klorida", "No", "No", "Aktif"],
  [
    1295,
    "Kalsium L-5-metil tetrahidrofolat (Calcium L-5- methyl tetrahydrofolate)",
    "No",
    "No",
    "Aktif",
  ],
  [1296, "Kalsium Laktat (Calcium Laktate)", "No", "No", "Aktif"],
  [
    1297,
    "Kalsium Natrium Kaseinat (Calcium Sodium Caseinate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1298,
    "KALSIUM PANTOTENAT (CALCIUM PANTOTHENATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1299, "KALSIUM PANTOTENAT (VIT B5)", "No", "No", "Nonaktif"],
  [1300, "Kalsium Pidolat (Calcium Pidolate)", "No", "No", "Aktif"],
  [1301, "Kalsium Susu (Milk Calcium)", "No", "No", "Aktif"],
  [1302, "Kalsium Tulang Ikan", "No", "No", "Aktif"],
  [
    1303,
    "KALSIUM-D-PANTOTENAT (CALCIUM-D-PANTOTHENATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1304, "Kamaboko", "No", "No", "Aktif"],
  [1305, "Kangkung", "No", "No", "Aktif"],
  [1306, "Kapulaga (Cardamon)", "No", "No", "Aktif"],
  [1307, "Kapulaga Bubuk (Cardamon Powder)", "No", "No", "Aktif"],
  [1308, "Karagenan", "No", "No", "Nonaktif"],
  [1309, "Karagenan (Caragenan)", "No", "No", "Aktif"],
  [1310, "Karamel  ", "No", "No", "Nonaktif"],
  [1311, "Karamel (Caramel)", "No", "No", "Aktif"],
  [1312, "Karamel Bubuk (Caramel Powder)", "No", "No", "Aktif"],
  [1313, "KARAMEL CAIR (LIQUID CARAMEL)", "No", "No", "Nonaktif"],
  [
    1314,
    "Karboksil proteinase (Carboxyl proteinase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1315,
    "Karboksilesterase (Carboxylesterase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1316,
    "KARBONDIOKSIDA (CARBONDIOXIDE)-(hanya untuk anggur sparkling dan semi sparkling)",
    "No",
    "No",
    "Aktif",
  ],
  [1317, "Kari Bubuk (Curry Powder)", "No", "No", "Aktif"],
  [1318, "Kasein (Casein)", "No", "No", "Aktif"],
  [
    1319,
    "Katalase (Catalase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1320, "Katekin (Catechin)", "No", "No", "Aktif"],
  [
    1321,
    "Kawista / Buah batok (Limonia acidissima)",
    "No",
    "No",
    "Aktif",
  ],
  [1322, "Kayu Manis (Cinnamon)", "No", "No", "Aktif"],
  [1323, "Kayu Manis Bubuk", "No", "No", "Nonaktif"],
  [
    1324,
    "KAYU SECANG (SAPPAN WOOD - CAESALPINIAE SAPPANIS LIGNUM)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1325,
    "Kayumanis-Keningar Bubuk (Cinnamon Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1326, "Kecap (Soy Sauce)", "No", "No", "Aktif"],
  [1327, "KECAP ASIN (SALTY SOY SAUCE)", "No", "No", "Aktif"],
  [1328, "Kecap Bubuk (Soy Sauce Powder)", "No", "No", "Aktif"],
  [1329, "Kecap Ikan (Fish Sauce)", "No", "No", "Aktif"],
  [
    1330,
    "Kecap Inggris (Worcestershire Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1331,
    "KECAP KEDELAI MANIS (SWEET SOY SAUCE)",
    "No",
    "No",
    "Aktif",
  ],
  [1332, "Kedelai", "No", "No", "Nonaktif"],
  [1333, "KEDONDONG (AMBARELLA)", "No", "No", "Aktif"],
  [1334, "Kefir (Keffir)", "No", "No", "Aktif"],
  [1335, "Keju ", "No", "No", "Nonaktif"],
  [1336, "Keju (Cheese)", "No", "No", "Aktif"],
  [1337, "Keju Biru (Blue Cheese)", "No", "No", "Aktif"],
  [1338, "Keju Bubuk  ", "No", "No", "Nonaktif"],
  [1339, "Keju Bubuk (Cheese Powder)", "No", "No", "Aktif"],
  [1340, "Keju Cheddar (Cheddar Cheese)", "No", "No", "Aktif"],
  [1341, "Keju Edam (Edam Cheese)", "No", "No", "Aktif"],
  [1342, "Keju Feta (Feta Cheese)", "No", "No", "Aktif"],
  [1343, "Keju Gouda (Gouda Cheese)", "No", "No", "Aktif"],
  [
    1344,
    "Keju Grana Padano (Grana Padano Cheese)",
    "No",
    "No",
    "Aktif",
  ],
  [1345, "Keju Krim (Cream Cheese)", "No", "No", "Aktif"],
  [1346, "Keju Mascarpone (Mascarpone Cheese)", "No", "No", "Aktif"],
  [1347, "Keju Mozzarella (Mozzarella Cheese)", "No", "No", "Aktif"],
  [1348, "Keju Myzithra (Mizithra Cheese)", "No", "No", "Aktif"],
  [1349, "Keju Parmesan (Parmesan Cheese)", "No", "No", "Aktif"],
  [1350, "Keju Pecorino (Pecorino Cheese)", "No", "No", "Aktif"],
  [
    1351,
    "Keju Pecorino Romano (Pecorino Romano Cheese)",
    "No",
    "No",
    "Aktif",
  ],
  [1352, "Keju Ricota (Richotta Cheese)", "No", "No", "Aktif"],
  [
    1353,
    "Keju Ricotta (susu sapi, susu domba)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1354, "Keju Romano (Romano Cheese)", "No", "No", "Aktif"],
  [1355, "KEJU WHEY", "No", "No", "Nonaktif"],
  [1356, "KELABAT (FENUGREEK)(HALBA)", "No", "No", "Aktif"],
  [1357, "Kelabat Bubuk (Fenugreek Powder)", "No", "No", "Aktif"],
  [1358, "Keladi - Talas (Taro-Caladium)", "No", "No", "Aktif"],
  [1359, "Kelapa (Coconut)", "No", "No", "Aktif"],
  [1360, "Kelapa Bubuk (Coconut Powder)", "No", "No", "Aktif"],
  [1361, "Kelapa Kering (Dried Coconut)", "No", "No", "Aktif"],
  [1362, "Kelapa Muda (Young Coconut)", "No", "No", "Aktif"],
  [1363, "Kelapa Parut (Desiccated Coconut)", "No", "No", "Aktif"],
  [
    1364,
    "Kelapa Parut Kering (Dried Desiccated Coconut)",
    "No",
    "No",
    "Aktif",
  ],
  [1365, "Kelapa Sawit (Palm)", "No", "No", "Aktif"],
  [1366, "Kelengkeng (Longan)", "No", "No", "Aktif"],
  [1367, "Kelp Bubuk (Kelp Powder)", "No", "No", "Aktif"],
  [1368, "Kemangi (Basil)", "No", "No", "Aktif"],
  [1369, "Kembang Kol (Cauliflower)", "No", "No", "Aktif"],
  [1370, "KEMBANG PALA (MYRISTICA FRAGRAN)", "No", "No", "Nonaktif"],
  [
    1371,
    "KEMBANG SEPATU (HIBISCUS ROSA SINENSIS)",
    "No",
    "No",
    "Aktif",
  ],
  [1372, "Kembang Tahu (Beancurd)", "No", "No", "Aktif"],
  [1373, "KEMIRI (CANDLENUT)", "No", "No", "Aktif"],
  [1374, "KEMIRI BUBUK (CANDLENUT POWDER)", "No", "No", "Aktif"],
  [1375, "KENCUR ( KAEMPFERIA GALANGA )", "No", "No", "Aktif"],
  [1376, "Kenikir (Marigolds)", "No", "No", "Aktif"],
  [1377, "KENTANG", "No", "No", "Nonaktif"],
  [1378, "Kentang (Potato)", "No", "No", "Aktif"],
  [1379, "Kentang Bubuk (Potato Powder)", "No", "No", "Aktif"],
  [1380, "Kentang Kering (Dried Potatoes)", "No", "No", "Aktif"],
  [1381, "Kentang Merah (Red Potato)", "No", "No", "Aktif"],
  [
    1382,
    "Kentang Panggang Bubuk (Roasted Potato Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1383, "Keong (Snail)", "No", "No", "Aktif"],
  [1384, "Kepah (Mussel)", "No", "No", "Aktif"],
  [1385, "Kepiting (Crab)", "No", "No", "Aktif"],
  [1386, "Kerang (Scallops)", "No", "No", "Aktif"],
  [1387, "Kerang Bubuk (Scallops Powder)", "No", "No", "Aktif"],
  [1388, "Keripik Pisang (Banana Chips)", "No", "No", "Aktif"],
  [1389, "Keripik Singkong (Cassava Chips)", "No", "No", "Aktif"],
  [1390, "KERTAS BERAS", "Yes", "Yes", "Aktif"],
  [1391, "Kerupuk", "No", "No", "Aktif"],
  [1392, "Kerupuk Beras (Rice Crackers)", "No", "No", "Aktif"],
  [1393, "Kerupuk Ikan", "No", "No", "Aktif"],
  [1394, "KERUPUK KEPITING ( CRAB CHIPS )", "No", "No", "Aktif"],
  [1395, "Kerupuk Udang (Prawn Crackers)", "No", "No", "Aktif"],
  [1396, "Ketam (Crab)", "No", "No", "Aktif"],
  [1397, "Ketan Hitam (Black Sticky Rice)", "No", "No", "Aktif"],
  [1398, "KETUMBAR (CORIANDER)", "No", "No", "Aktif"],
  [1399, "Ketumbar Bubuk (Coriander Powder)", "No", "No", "Aktif"],
  [1400, "Kimchi (Kimchi)", "No", "No", "Aktif"],
  [1401, "Kimchi Kering (Kimchi Powder)", "No", "No", "Aktif"],
  [1402, "Kimosin (Chymosin) (Bahan Penolong)", "No", "No", "Aktif"],
  [
    1403,
    "Kimotripsin (Chymotrypsin) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1404, "KININ (KININE)", "No", "No", "Aktif"],
  [1405, "Kismis (Raisin)", "No", "No", "Aktif"],
  [1406, "Kismis Merah (Red Raisin)", "No", "No", "Aktif"],
  [1407, "Kitosan (Chitosan)", "No", "No", "Aktif"],
  [1408, "Kiwi (Kiwi)", "No", "No", "Aktif"],
  [1409, "KLEMBAK (RHEUM OFFICINALE)", "No", "No", "Aktif"],
  [1410, "KLOROFIL (CHLOROPHYL)", "No", "No", "Nonaktif"],
  [1411, "Kluwek-Keluwek", "No", "No", "Aktif"],
  [
    1412,
    "KOJI (KECUALI RED KOJI/BENI&nbsp;KOJI)",
    "No",
    "No",
    "Aktif",
  ],
  [1413, "KOJI (SWEET POTATO KOJI)", "No", "Yes", "Nonaktif"],
  [1414, "KOJI BERAS (RICE KOJI)", "No", "Yes", "Nonaktif"],
  [1415, "Kol - Kubis (Cabbage)", "No", "No", "Aktif"],
  [1416, "Kol - Kubis Kering (Dried Cabbage)", "No", "No", "Aktif"],
  [1417, "Kolagen (Collagen)", "No", "No", "Aktif"],
  [
    1418,
    "KOLANG KALING ( BUAH ATAP, SUGAR PALM FRUIT )",
    "No",
    "No",
    "Aktif",
  ],
  [1419, "KOLEKALSIFEROL (VIT D3)", "No", "No", "Aktif"],
  [1420, "Kolin (Choline)", "No", "No", "Aktif"],
  [1421, "Kolin Bitartrat (Choline Bitartrat)", "No", "No", "Aktif"],
  [1422, "Kolin Klorida (Choline Chloride)", "No", "No", "Aktif"],
  [1423, "Kolostrum (Colostrum)", "No", "No", "Aktif"],
  [1424, "Kolostrum Bubuk (Colostrum Powder)", "No", "No", "Aktif"],
  [1425, "Kondroitin (Chondroitin)", "No", "No", "Aktif"],
  [
    1426,
    "Kondroitin Sulfat (Chondroitin Sulfate)",
    "No",
    "No",
    "Aktif",
  ],
  [1427, "Konsentrat acerola", "No", "No", "Aktif"],
  [
    1428,
    "Konsentrat Agave (Agave Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1429,
    "Konsentrat Air Kelapa (Coconut Water Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1430,
    "Konsentrat Akar Bunga Balon (Balloon Flower Root Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1431,
    "KONSENTRAT ANGGUR MERAH (RED GRAPE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1432, "KONSENTRAT APEL (APPLE CONCENTRATE)", "No", "No", "Aktif"],
  [
    1433,
    "KONSENTRAT ARONIA BERRY (CHOKEBERRY CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1434,
    "Konsentrat Asam Jawa (Tamarind Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1435,
    "Konsentrat Bawang Putih (Garlic Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1436,
    "Konsentrat Blewah (Cantaloupe Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1437, "KONSENTRAT BUAH ......", "No", "No", "Aktif"],
  [
    1438,
    "Konsentrat Buah Anggur (Grape Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1439, "Konsentrat Buah Apel", "No", "No", "Nonaktif"],
  [
    1440,
    "Konsentrat Buah Blueberry (Blueberry Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1441,
    "KONSENTRAT BUAH ELDERBERRY (ELDERBERRY CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1442,
    "KONSENTRAT BUNGA ELDERBERI (ELDERFLOWER CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1443,
    "KONSENTRAT CAMPURAN SARI BUAH (MIXTURE OF FRUIT JUICE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1444,
    "KONSENTRAT COCOPANDAN (COCOPANDAN CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1445,
    "KONSENTRAT COKELAT SUSU (MILK CHOCOLATE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1446, "KONSENTRAT COLA (COLA CONCENTRATE)", "No", "No", "Aktif"],
  [
    1447,
    "KONSENTRAT DAUN ASAM MUDA (TAMARIND LEAVES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1448,
    "Konsentrat Daun Mint (Mint Leaves Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1449,
    "KONSENTRAT DAUN PANDAN (PANDAN LEAVES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1450,
    "KONSENTRAT DAUN TEH (TEA LEAVES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1451,
    "Konsentrat Gula Tebu (Sugar Cane Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1452,
    "Konsentrat Jahe (Ginger Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1453,
    "Konsentrat Jeruk (Orange Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1454, "Konsentrat Jus Apel", "No", "No", "Nonaktif"],
  [
    1455,
    "Konsentrat Kacang Kedelai (Soybean Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1456,
    "Konsentrat Kacang Merah (Red Beans Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1457,
    "KONSENTRAT KELAPA KOPYOR (KOPYOR CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1458,
    "Konsentrat Kepiting (Crab Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1459,
    "Konsentrat Kopi (Coffee Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1460,
    "KONSENTRAT LECI (LYCHEES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1461,
    "Konsentrat Lemon (Lemon Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1462,
    "Konsentrat Lidah Buaya (Aloe Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1463,
    "Konsentrat Lobak Merah (Red Radish Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1464,
    "Konsentrat Loofah (Loofah Concentrate) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "No",
    "No",
    "Aktif",
  ],
  [1465, "Konsentrat Madu (Honey Concentrate)", "No", "No", "Aktif"],
  [
    1466,
    "Konsentrat Mangga (Mango Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1467,
    "Konsentrat Mentimun (Cucumber Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1468,
    "Konsentrat Nanas (Pineapple Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1469,
    "Konsentrat Peppermint (Peppermint Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1470, "Konsentrat Pir (Pears Concentrate)", "No", "No", "Aktif"],
  [
    1471,
    "Konsentrat Protein Kedelai (Soy Protein Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1472,
    "Konsentrat Protein Susu (Milk Protein Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1473,
    "KONSENTRAT PROTEIN WHEY (WHEY PROTEIN CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1474,
    "Konsentrat Santan (Coconut Milk Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1475,
    "Konsentrat Sari Buah Acai Berry (Acai Berry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1476,
    "Konsentrat Sari Buah Anggur (Grape Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1477,
    "Konsentrat Sari Buah Anggur Merah (Red Grape Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1478,
    "Konsentrat Sari Buah Apel (Apple Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1479,
    "Konsentrat Sari Buah Aprikot (Apricots Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1480,
    "KONSENTRAT SARI BUAH ARONIA BERRY (ARONIABERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1481,
    "Konsentrat Sari Buah Bit (Bit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1482,
    "Konsentrat Sari Buah Bit Merah (Red Bit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1483,
    "Konsentrat Sari Buah Blackberry (Blackberry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1484,
    "Konsentrat Sari Buah Blackcurrant (Blackcurrant Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1485,
    "Konsentrat Sari Buah Blueberry (Blueberry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1486,
    "KONSENTRAT SARI BUAH CAMPURAN (MIXED FRUIT JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1487,
    "Konsentrat Sari Buah Ceri (Cherry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1488,
    "Konsentrat Sari Buah Delima (Pomegranate Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1489,
    "Konsentrat Sari Buah Durian (Durian Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1490,
    "KONSENTRAT SARI BUAH ELDERBERRY (ELDERBERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1491,
    "KONSENTRAT SARI BUAH GOJI BERRY (GOJI BERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1492,
    "KONSENTRAT SARI BUAH JAMBU MERAH (GUAVA JUICE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1493,
    "KONSENTRAT SARI BUAH JERUK (ORANGE JUICE CONCENTRATE)",
    "Yes",
    "No",
    "Aktif",
  ],
  [
    1494,
    "Konsentrat Sari Buah Jeruk Bali Merah (grapefruit juice concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1495,
    "Konsentrat Sari Buah Jeruk Florida (Florida Orange Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1496,
    "KONSENTRAT SARI BUAH JERUK NIPIS (LIME JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1497,
    "Konsentrat Sari Buah Kawista (Kawista Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1498,
    "Konsentrat Sari Buah Kiwi (Kiwi Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1499,
    "KONSENTRAT SARI BUAH KRANBERI (CRANBERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1500,
    "KONSENTRAT SARI BUAH KURMA (DATES JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1501,
    "KONSENTRAT SARI BUAH LABU AIR (CALABASH JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1502,
    "KONSENTRAT SARI BUAH LECI (LYCHEE JUICE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1503,
    "Konsentrat Sari Buah Leci (Lychees Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1504,
    "Konsentrat Sari Buah Lemon (Lemon Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1505,
    "Konsentrat Sari Buah Mangga (Mango Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1506,
    "Konsentrat Sari Buah Markisa (Passion Fruit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1507,
    "Konsentrat Sari Buah Melon (Honeydew Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1508,
    "Konsentrat Sari Buah Merah (Red Fruit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1509,
    "Konsentrat Sari Buah Nanas (Pineapple Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1510,
    "Konsentrat Sari Buah Nangka (Jackfruit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1511,
    "Konsentrat Sari Buah Pepaya (Papaya Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1512,
    "KONSENTRAT SARI BUAH PERSIK (PEACH JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1513,
    "KONSENTRAT SARI BUAH PIR (PEAR JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1514,
    "Konsentrat Sari Buah Pisang (Banana Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1515,
    "Konsentrat Sari Buah Plum (Plum Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1516,
    "Konsentrat Sari Buah Prune (Prune Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1517,
    "Konsentrat Sari Buah Quince (Quince Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1518,
    "Konsentrat Sari Buah Raspberry (Raspberry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1519,
    "Konsentrat Sari Buah Redcurrant (Redcurrant Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1520,
    "KONSENTRAT SARI BUAH SALAK (SNAKE FRUIT JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1521,
    "Konsentrat Sari Buah Semangka (Watermelon Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1522,
    "Konsentrat Sari Buah Sirsak (Soursop Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1523,
    "KONSENTRAT SARI BUAH STROBERI (STRAWBERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1524,
    "KONSENTRAT SARI BUAH TOMAT (TOMATO JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1525,
    "Konsentrat Sari Kelapa (Coconut Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1526, "konsentrat sayur .....", "No", "No", "Aktif"],
  [
    1527,
    "Konsentrat Spirulina (Spirulina Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1528, "KONSENTRAT SUSU (MILK CONCENTRATE)", "No", "No", "Aktif"],
  [1529, "Konsentrat Talas (Taro Concentrate)", "No", "No", "Aktif"],
  [
    1530,
    "KONSENTRAT VANILA (VANILLA CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1531,
    "KONSENTRAT WHEY PROTEIN (WHEY PROTEIN CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1532,
    "Konsentrat Wortel (Carrot Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1533,
    "KONSENTRAT WORTEL UNGU/WORTEL HITAM (PURPLE/BLACK CARROT CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1534, "Konyaku Bubuk", "No", "No", "Nonaktif"],
  [1535, "Kopi (Coffee)", "No", "No", "Aktif"],
  [1536, "KOPI ARABIKA (ARABICA COFFEE)", "No", "No", "Aktif"],
  [1537, "Kopi Bubuk (Coffee Powder)", "No", "No", "Aktif"],
  [
    1538,
    "Kopi Bubuk Instan (Instant Coffee Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1539, "Kopi Pasta (Coffee Paste)", "No", "No", "Aktif"],
  [1540, "Kopi Putih Bubuk", "No", "No", "Nonaktif"],
  [1541, "Kopi Robusta (Robusta Coffee)", "No", "No", "Aktif"],
  [1542, "Kopra (Copra)", "No", "No", "Aktif"],
  [
    1543,
    "KORIANDER BUBUK (CORIANDER POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1544, "Kranberi (Cranberry)", "No", "No", "Aktif"],
  [1545, "Kranberi Kering (Dried Cranberry)", "No", "No", "Aktif"],
  [1546, "Kratom (Mitragyna speciosa)", "No", "No", "Nonaktif"],
  [1547, "Kreatin (Creatine)", "No", "No", "Aktif"],
  [
    1548,
    "KREATIN MONOHIDRAT (CREATINE MONOHYDRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1549, "KRECEK (KRECHEK)", "No", "No", "Aktif"],
  [1550, "Krekers Beras (Rice Crackers)", "No", "No", "Aktif"],
  [1551, "Krill Oil (Eupausia Superba)", "No", "No", "Aktif"],
  [1552, "Krim (Cream)", "No", "No", "Aktif"],
  [1553, "Krim Asam (Sour Cream)", "No", "No", "Aktif"],
  [1554, "Krim Bubuk (Cream Powder)", "No", "No", "Aktif"],
  [1555, "Krim Kacang Hazel (Hazelnut Cream)", "No", "No", "Aktif"],
  [1556, "KRIM KAPUCINO (CAPPUCCINO CREAM)", "No", "No", "Aktif"],
  [1557, "Krim Karamel (Caramel Cream)", "No", "No", "Aktif"],
  [1558, "Krim Kelapa (Coconut Cream)", "No", "No", "Aktif"],
  [1559, "Krim Kopi (Coffee Cream)", "No", "No", "Aktif"],
  [1560, "Krim Nabati (Vegetable Cream) ", "No", "No", "Aktif"],
  [1561, "Krim Nabati Bubuk", "No", "No", "Nonaktif"],
  [
    1562,
    "Krim Nabati Bubuk (Vegetable Cream Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1563,
    "Krim Pasteurisasi (Pasteurized Cream)",
    "No",
    "No",
    "Aktif",
  ],
  [1564, "KRIM RASA VANILA (VANILLA CREAM)", "No", "No", "Aktif"],
  [1565, "KRIM SAYUR (VEGETABLE CREAM)", "No", "No", "Nonaktif"],
  [1566, "Krim Stroberi (Strawberry Cream)", "No", "No", "Aktif"],
  [1567, "KRIM SUSU (MILK CREAM)", "No", "No", "Nonaktif"],
  [1568, "Krim Susu Bubuk (Milk Cream Powder)", "No", "No", "Aktif"],
  [1569, "Krim Tiramisu (Tiramisu Cream)", "No", "No", "Aktif"],
  [1570, "Krimer", "No", "No", "Nonaktif"],
  [1571, "KRIMER (CREAMER)", "No", "No", "Nonaktif"],
  [
    1572,
    "Krimer Kental Manis (Sweetened Condensed Creamer)",
    "No",
    "No",
    "Aktif",
  ],
  [1573, "KRIMER MINUMAN (NON DAIRY CREAMER)", "No", "No", "Aktif"],
  [1574, "Krimer Nabati", "No", "No", "Nonaktif"],
  [
    1575,
    "KRIMER NABATI (NON DAIRY CREAMER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1576, "KRISANTEMUM (CHRYSANTHEMUM)", "No", "No", "Nonaktif"],
  [
    1577,
    "KRISANTEMUM BUBUK (CHRYSANTEMUM POWDER) ",
    "No",
    "No",
    "Nonaktif",
  ],
  [1578, "Krispi ", "No", "No", "Nonaktif"],
  [1579, "Krispi Beras (Rice Crispy)", "No", "No", "Aktif"],
  [1580, "Krispi Kedelai (Soy Crispy)", "No", "No", "Aktif"],
  [1581, "KROMIUM KLORIDA (CHROMIUM CHLORIDE)", "No", "No", "Aktif"],
  [
    1582,
    "Kromium Pikolinat (Chromium Picolinate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1583,
    "KROMIUM POLINIKOTINAT (CHROMIUM POLYNICOTINATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1584, "Kuaci (Sunflower Seed)", "No", "No", "Aktif"],
  [1585, "Kubis ", "No", "No", "Nonaktif"],
  [1586, "Kubis Brussel (Brussels Sprouts)", "No", "No", "Aktif"],
  [1587, "KUCAI (GARLIC CHIVES)", "No", "No", "Aktif"],
  [1588, "KUCAI KERING (DRIED GARLIC CHIVES)", "No", "No", "Aktif"],
  [1589, "Kue berbahan dasar beras", "No", "No", "Aktif"],
  [1590, "KUE BROWNIES (BROWNIE CAKE)", "No", "No", "Aktif"],
  [1591, "KUE BUSA (MERINGUE)", "No", "No", "Aktif"],
  [1592, "Kue Ikan (Fish Cake)", "No", "No", "Aktif"],
  [1593, "KUKIS (COOKIES)", "No", "No", "Aktif"],
  [1594, "Kulit Anggur (Vitis vinifera)", "No", "No", "Aktif"],
  [1595, "Kulit Ari Gandum", "No", "No", "Aktif"],
  [1596, "Kulit Ayam (Chicken Skin)", "No", "No", "Aktif"],
  [1597, "Kulit Babi (Pork Rind)", "No", "No", "Aktif"],
  [1598, "Kulit Bergamot (Bergamot Peels)", "No", "No", "Aktif"],
  [1599, "KULIT BIJI PALA (NUTMEG MACE)", "No", "No", "Aktif"],
  [
    1600,
    "Kulit Buah Kopi (cascara) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "No",
    "No",
    "Aktif",
  ],
  [1601, "Kulit Buah Manggis ", "No", "No", "Nonaktif"],
  [1602, "Kulit Domba (Sheepskin)", "No", "No", "Aktif"],
  [1603, "Kulit Gandum (Wheat Bran)", "No", "No", "Aktif"],
  [1604, "Kulit Ikan (Fish Skin)", "No", "No", "Aktif"],
  [1605, "KULIT IKAN PATIN (PANGASIUS SKIN)", "No", "No", "Aktif"],
  [1606, "Kulit Ikan Salmon (Salmon Skin)", "No", "No", "Aktif"],
  [1607, "Kulit Ikan Tenggiri (Mackerel)", "No", "No", "Aktif"],
  [1608, "Kulit Jagung (Corn Bran)", "No", "No", "Aktif"],
  [1609, "Kulit Jeruk (Orange Peel)", "No", "No", "Aktif"],
  [1610, "KULIT JERUK ........", "No", "No", "Nonaktif"],
  [
    1611,
    "Kulit Jeruk Bubuk (Orange Peel Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1612, "Kulit Jeruk Lemon (Orange Peels)", "No", "No", "Aktif"],
  [
    1613,
    "KULIT JERUK MANDARIN (MANDARIN ORANGE PEELS)",
    "No",
    "No",
    "Aktif",
  ],
  [1614, "KULIT JERUK NIPIS (LIME PEELS)", "No", "No", "Aktif"],
  [1615, "Kulit Kebab/Tortilla", "No", "No", "Aktif"],
  [1616, "Kulit Lumpia (Spring Roll Skin)", "No", "No", "Aktif"],
  [1617, "Kulit Oats Bubuk (Oats Bran Powder)", "No", "No", "Aktif"],
  [1618, "Kulit Pangsit (Dumpling Skin)", "No", "No", "Aktif"],
  [
    1619,
    "KULIT POHON PINUS EKSTRAK (PINE BARK EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1620, "Kulit Sapi", "No", "No", "Aktif"],
  [1621, "KULIT SIOMAY (DUMPLING WRAPPER)", "No", "No", "Aktif"],
  [
    1622,
    "KULIT TAHU (GOHYONG, BEAN CURD SHEET, BEAN CURD ROBES, BEAN CURD SKIN, TOFU SKIN)",
    "No",
    "No",
    "Aktif",
  ],
  [1623, "KULIT TELUR (EGGSHELL)", "No", "No", "Nonaktif"],
  [
    1624,
    "KULTUR BAKTERI (BACTERIAL CULTURE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1625,
    "KULTUR BAKTERI ASAM LAKTAT (LACTIC ACID BACTERIAL CULTURE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1626, "KULTUR STARTER (STARTER CULTURE)", "No", "No", "Nonaktif"],
  [1627, "KUNING TELUR (EGG YOLK)", "No", "Yes", "Aktif"],
  [
    1628,
    "KUNING TELUR ASIN (SALTED EGG YOLK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    1629,
    "KUNING TELUR BUBUK (EGG YOLK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [1630, "KUNYIT (TURMERIC)", "No", "No", "Nonaktif"],
  [
    1631,
    "KUNYIT (TURMERIC-CURCUMA LONGA RHIZOME)",
    "No",
    "No",
    "Aktif",
  ],
  [1632, "KUNYIT ASAM (TURMERIC AND TAMARIND)", "No", "No", "Aktif"],
  [1633, "Kunyit Bubuk (Turmeric Powder)", "No", "No", "Aktif"],
  [
    1634,
    "KUPANG KERING (DRY GREENSHELL MUSSELS",
    "No",
    "No",
    "Aktif",
  ],
  [1635, "Kurma (Dates)", "No", "No", "Aktif"],
  [1636, "Kurma Bubuk (Dates Powder)", "No", "No", "Aktif"],
  [1637, "Kurma Merah (Red Dates)", "No", "No", "Aktif"],
  [1638, "L - GLUTATION (L - GLUTATHIONE)", "No", "No", "Aktif"],
  [1639, "L-Alanin (LAlanine)", "No", "No", "Aktif"],
  [1640, "L-Asam aspartat (L-Aspartic acid)", "No", "No", "Aktif"],
  [1641, "L-Asam Glutamat (L-Glutamic acid)", "No", "No", "Aktif"],
  [1642, "L-Fenilalanin (L-Phenylalanine)", "No", "No", "Aktif"],
  [1643, "L-Glutamin (L-Glutamine)", "Yes", "Yes", "Aktif"],
  [1644, "L-Histidin (LHistidine)", "No", "No", "Aktif"],
  [1645, "L-Isoleusin (LIsoleucine)", "No", "No", "Aktif"],
  [1646, "L-KARNITIN (L-CARNITINE)", "No", "No", "Aktif"],
  [
    1647,
    "L-ORNITIN (L-ORNITHINE) (KATEGORI PANGAN 13)",
    "No",
    "No",
    "Aktif",
  ],
  [1648, "L-Prolin (L-Proline)", "No", "No", "Aktif"],
  [1649, "L-Serin (L-Serine)", "No", "No", "Aktif"],
  [1650, "L-Sistin (L-Cystine)", "No", "No", "Aktif"],
  [1651, "L-Sitrulin (LCitrulline)", "No", "No", "Aktif"],
  [1652, "L-Teanin (LTheanine)", "No", "No", "Aktif"],
  [1653, "L-Theanine", "No", "No", "Aktif"],
  [1654, "L-Valin (L-Valine)", "No", "No", "Aktif"],
  [1655, "Labu (Pumpkin)", "No", "No", "Aktif"],
  [1656, "Labu Bubuk (Pumpkin Powder)", "No", "No", "Aktif"],
  [1657, "LABU KUNING", "No", "No", "Nonaktif"],
  [1658, "LABU SIAM (CHAYOTE)", "No", "No", "Aktif"],
  [1659, "LACTOBACILLUS ACIDOPHILUS", "No", "No", "Aktif"],
  [1660, "Lactobacillus bulgaricus", "No", "No", "Aktif"],
  [1661, "Lactobacillus casei", "No", "No", "Aktif"],
  [1662, "Lactobacillus Fermentum", "No", "No", "Aktif"],
  [1663, "Lactobacillus helveticus ", "No", "No", "Aktif"],
  [1664, "Lactobacillus kefiri ", "No", "No", "Aktif"],
  [
    1665,
    "Lactobacillus lactis subsp. cremoris",
    "No",
    "No",
    "Aktif",
  ],
  [1666, "Lactobacillus lactis subsp. lactis", "No", "No", "Aktif"],
  [1667, "LACTOBACILLUS PARACASEI", "Yes", "Yes", "Aktif"],
  [1668, "Lactobacillus Plantarum", "No", "No", "Aktif"],
  [1669, "Lactobacillus Reuteri", "No", "No", "Aktif"],
  [1670, "Lactobacillus rhamnosus", "No", "No", "Aktif"],
  [1671, "Lactobacillus rhamnosus NCC 4007", "No", "No", "Aktif"],
  [1672, "Lactococcus lactis", "No", "No", "Aktif"],
  [1673, "LADA (PEPPER)", "No", "No", "Aktif"],
  [1674, "LADA HIJAU (GREEN PEPPERCORN)", "No", "No", "Aktif"],
  [1675, "Lada Hitam", "No", "No", "Nonaktif"],
  [1676, "Lada Hitam (Black Pepper)", "No", "No", "Aktif"],
  [
    1677,
    "Lada Hitam Bubuk (Black Pepper Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1678, "Lada Jalapeno", "No", "No", "Nonaktif"],
  [1679, "LADA MERAH (RED PEPPER)", "No", "No", "Aktif"],
  [1680, "Lada Putih (White Pepper)", "No", "No", "Aktif"],
  [
    1681,
    "LADA PUTIH BUBUK (WHITE PEPPER POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1682, "LAKTOFERIN (LACTOFERRIN)", "No", "Yes", "Aktif"],
  [1683, "Laktosa", "No", "No", "Nonaktif"],
  [1684, "LAKTOSA (LACTOSE)", "No", "Yes", "Aktif"],
  [1685, "LAKTOSA BUBUK (LACTOSE POWDER)", "No", "Yes", "Aktif"],
  [1686, "LAKTULOSA (LACTULOSE)", "No", "Yes", "Aktif"],
  [
    1687,
    "LAPACHO (TABEBULA IMPETIGINOSA ATAU HANDROANTHUS IMPETIGINOSUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1688, "LARUTAN GULA (SUGAR SOLUTION)", "No", "No", "Aktif"],
  [
    1689,
    "lavender (lavandula angustifolia)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1690, "Lemak Ayam (Chicken Fat)", "No", "No", "Aktif"],
  [1691, "Lemak Babi (Lard)", "No", "No", "Aktif"],
  [1692, "LEMAK COKLAT  (CHOCOLATE FAT)", "No", "No", "Aktif"],
  [1693, "Lemak Hewani (Tallow)", "No", "No", "Aktif"],
  [
    1694,
    "Lemak Inti Sawit Terhidrogenasi (Refined Hydrogenated Palm Kernel Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1695, "Lemak Kakao ", "No", "No", "Nonaktif"],
  [1696, "Lemak Kakao (Cocoa Butter)", "No", "No", "Aktif"],
  [1697, "LEMAK MENTEGA (BUTTER FAT)", "No", "No", "Aktif"],
  [
    1698,
    "LEMAK NABATI (MARGARIN DAN LEMAK REROTI)",
    "No",
    "No",
    "Aktif",
  ],
  [1699, "Lemak Nabati (Vegetable Fat)", "No", "No", "Aktif"],
  [
    1700,
    "Lemak Nabati Terhidrogenasi (Hydrogenated Vegetable Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1701,
    "Lemak Nabati tidak hidrogenasi (Unhydrogenated Vegetable Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1702, "Lemak Reroti (Shortening)", "No", "No", "Aktif"],
  [1703, "Lemak Sapi (Beef Fat)", "No", "No", "Aktif"],
  [1704, "Lemak Susu (Fat Milk)", "No", "No", "Aktif"],
  [
    1705,
    "Lemak Susu Anhidrat (Anhydrous Milk Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1706, "Lemak Susu Sapi (Cow Milk Fat)", "No", "No", "Aktif"],
  [
    1707,
    "Lemak Trigliserida Rantai Sedang (MCT) (Medium Chain Triglyceride Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1708, "Lembaga Gandum (Wheat Germ)", "No", "No", "Aktif"],
  [1709, "Lemon Verbena (Lippia citriodora)", "Yes", "No", "Aktif"],
  [1710, "Lempuyang", "No", "No", "Aktif"],
  [1711, "Lempuyang Wangi ", "No", "No", "Aktif"],
  [1712, "Lengkuas - Laos (Galangal)", "No", "No", "Aktif"],
  [1713, "Lengkuas Bubuk (Galangal Powder)", "No", "No", "Aktif"],
  [1714, "Lentil (Lens Culinaris)", "No", "No", "Aktif"],
  [1715, "LEPTOSPERPUM CITRATEM", "No", "No", "Nonaktif"],
  [1716, "Leuconostoc citreum", "No", "No", "Aktif"],
  [1717, "Leuconostoc cremoris", "No", "No", "Aktif"],
  [1718, "Leuconostoc mesenteroides", "No", "No", "Aktif"],
  [1719, "Leusin (Leucine)", "No", "No", "Aktif"],
  [1720, "Leusin (Leusin)", "No", "No", "Aktif"],
  [1721, "Licorice (Glycyrrhiza Glabra)", "No", "No", "Aktif"],
  [
    1722,
    "Licorice - Liquorice / Glycyrrhiza glabra",
    "No",
    "No",
    "Aktif",
  ],
  [
    1723,
    "Licorice Root-Akar Licorice (Licorice Root) / Glycyrrhiza uralensis",
    "No",
    "No",
    "Aktif",
  ],
  [1724, "Lidah Buaya (Aloe Vera)", "No", "No", "Aktif"],
  [
    1725,
    "Lidah Buaya Bubuk (Aloe Vera Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1726, "Lidah Buaya Gel (Aloe Vera Gel)", "No", "No", "Aktif"],
  [
    1727,
    "LIDAH SAPI (BEEF ATAU COW ATAU OX TONGUE)",
    "No",
    "No",
    "Aktif",
  ],
  [1728, "Likopen (Lycopene)", "No", "No", "Aktif"],
  [1729, "Limpa Sapi (Beef Spleen)", "No", "No", "Aktif"],
  [1730, "LINGZHI (GANODERMA LUCIDUM)", "No", "No", "Nonaktif"],
  [
    1731,
    "Lipase Triasilgliserol (Triacylglycerol Lipase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1732, "LIQUEUR", "No", "No", "Aktif"],
  [1733, "LIQUIORICE", "No", "No", "Nonaktif"],
  [1734, "Lisin (Lysine)", "No", "No", "Aktif"],
  [
    1735,
    "Lisin Monohidrat (Lysine Monohydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1736,
    "Lisofosfolipase (Lysophospholipase (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1737, "LO HAN GUO (LO HAN GUO)", "No", "No", "Nonaktif"],
  [1738, "Lobak (Radish)", "No", "No", "Aktif"],
  [1739, "Lobak Bubuk (Radish Powder)", "No", "No", "Aktif"],
  [1740, "Lobak Hijau (Turnip Greens)", "No", "No", "Aktif"],
  [
    1741,
    "Lobak Hijau Kering (Dried Turnip Greens)",
    "No",
    "No",
    "Aktif",
  ],
  [1742, "Lobak Merah (Red Radish)", "No", "No", "Aktif"],
  [1743, "LOBI - LOBI  (BATOKO PLUM)", "No", "No", "Aktif"],
  [1744, "Lobster", "No", "No", "Aktif"],
  [1745, "LOKIO KERING (DRIED CHIVES)", "No", "No", "Aktif"],
  [1746, "LOKIO-BAWANG BATAK (CHIVES)", "No", "No", "Aktif"],
  [1747, "LONICERA JAPONICA", "No", "No", "Nonaktif"],
  [
    1748,
    "LONTAR  (LONTAR PALM ATAU BORASSUS FLABELLIFER)",
    "No",
    "No",
    "Aktif",
  ],
  [1749, "Lucuma (Pouteria lucuma)", "No", "No", "Aktif"],
  [1750, "Lutein (hanya pangan umum)", "No", "No", "Aktif"],
  [1751, "Lutein dari Tagetes erecta", "No", "No", "Aktif"],
  [1752, "Madu (Honey)", "No", "No", "Aktif"],
  [1753, "Madu Agave (Agave Honey)", "No", "No", "Aktif"],
  [1754, "Madu Akasia (Acacia Honey)", "No", "No", "Aktif"],
  [1755, "Madu Bubuk (Honey Powder)", "No", "No", "Aktif"],
  [1756, "MADU HUTAN (FOREST HONEY)", "No", "No", "Aktif"],
  [1757, "Madu Kelengkeng (Longan Honey)", "No", "No", "Aktif"],
  [1758, "MADU RANDU (KAPOK HONEY)", "No", "No", "Aktif"],
  [
    1759,
    "Madu Sarang (Comb Honey) (Khusus Madu)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1760,
    "MAGNESIUM ASETAT (MAGNESIUM ACETATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1761,
    "Magnesium hidrogen fosfat (Magnesium hydrogen phosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1762,
    "Magnesium hidroksida (Magnesium hydroxide)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1763,
    "MAGNESIUM KARBONAT (MAGNESIUM CARBONATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1764, "Magnesium Kaseinat", "No", "No", "Aktif"],
  [
    1765,
    "magnesium klorida (magnesium chloride)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1766,
    "Magnesium L-Aspartat (Magnesium L-Aspartate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1767,
    "Magnesium laktat (Magnesium lactate)",
    "No",
    "No",
    "Aktif",
  ],
  [1768, "MAGNESIUM OKSIDA (MAGNESIUM OXIDE)", "No", "No", "Aktif"],
  [1769, "Magnesium Sulfat", "No", "No", "Aktif"],
  [1770, "MAIZENA (CORNSTARCH)", "No", "No", "Nonaktif"],
  [1771, "Makaroni (Macaroni)", "No", "No", "Aktif"],
  [1772, "MALT (BARLEY MALT)", "No", "No", "Nonaktif"],
  [1773, "Malt (Malt)", "No", "No", "Aktif"],
  [1774, "Malt Barley (Barley Malt)", "No", "No", "Aktif"],
  [1775, "Malt Bubuk (Malt Powder)", "No", "No", "Aktif"],
  [
    1776,
    "Malto Oligosakarida (Malto Oligosaccharide)",
    "No",
    "No",
    "Aktif",
  ],
  [1777, "Maltodekstrin", "No", "No", "Nonaktif"],
  [1778, "Maltodekstrin (Maltodextrine)", "No", "No", "Aktif"],
  [
    1779,
    "Maltodekstrin Resisten (Resistant Maltodextrine)",
    "No",
    "No",
    "Aktif",
  ],
  [1780, "Maltosa (Maltose)", "No", "No", "Aktif"],
  [1781, "Maltotriose (Maltotriose)", "No", "No", "Aktif"],
  [
    1782,
    "MANGAN (II) GLUKONAT (MANGANESE (II) GLUCONATE) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1783,
    "Mangan (II) Klorida (Manganese (II) Chloride)",
    "No",
    "No",
    "Aktif",
  ],
  [1784, "MANGAN SITRAT (MANGANESE CITRATE)", "No", "No", "Aktif"],
  [1785, "Mangan Sulfat (Manganese Sulphate)", "No", "No", "Aktif"],
  [1786, "Mangga (Manggo)", "No", "No", "Aktif"],
  [1787, "Mangga Bubuk (Mango Powder)", "No", "No", "Aktif"],
  [1788, "Mangga Kering (Dried Mango)", "No", "No", "Aktif"],
  [1789, "Manggis (Mangosteen)", "No", "No", "Aktif"],
  [
    1790,
    "MANISAN CRANBERRY (CANDIED CRANBERRY)",
    "No",
    "No",
    "Aktif",
  ],
  [1791, "Manisan Jeruk (Candied Orange)", "No", "No", "Aktif"],
  [
    1792,
    "Manisan Kulit Jeruk (Candied Orange Peel)",
    "No",
    "No",
    "Aktif",
  ],
  [1793, "Manisan Mangga (Candied Mango)", "No", "No", "Aktif"],
  [1794, "Manisan Nanas (Candied Pineapple)", "No", "No", "Aktif"],
  [1795, "Manisan Pepaya (Candied Papaya)", "No", "No", "Aktif"],
  [
    1796,
    "Mannan endo-1,4-\\xDFmannosidase (Mannan endo-1,4- Beta-mannosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1797,
    "MAQUI BERRY (ARISTOTELIA CHILENSIS) ",
    "No",
    "No",
    "Nonaktif",
  ],
  [1798, "Margarin (Margarine)", "No", "No", "Aktif"],
  [1799, "MARGARIN OLES (MARGARINE SPREAD)", "No", "No", "Aktif"],
  [1800, "Marjoram", "No", "No", "Aktif"],
  [1801, "Markisa (Passion Fruit)", "No", "No", "Aktif"],
  [1802, "Marmalad (Marmalade)", "No", "No", "Aktif"],
  [1803, "MARSHMALLOW (MARSHMALLOW)", "No", "No", "Aktif"],
  [1804, "MARSMALLOW", "No", "No", "Nonaktif"],
  [1805, "MARZIPAN (MARZIPAN)", "No", "No", "Aktif"],
  [1806, "Massa Kakao", "No", "No", "Nonaktif"],
  [1807, "mate green (illex paraguarienis)", "No", "No", "Nonaktif"],
  [1808, "Mate Green (Illex Paraguariensis)", "No", "No", "Aktif"],
  [
    1809,
    "MAXIMOWICZIA (SCHISANDRA CHINENSIS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1810, "Mayonais (Mayonnaise)", "No", "No", "Aktif"],
  [1811, "Melati (Jasmine)", "No", "No", "Aktif"],
  [1812, "MELINJO (GNETUM GNEMON L.)", "No", "No", "Aktif"],
  [
    1813,
    "MELISASA OFFICINALIS (HERBA LEMON BALM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1814, "Melon (Melon)", "No", "No", "Aktif"],
  [1815, "Melon Bubuk ( Melon Powder)", "No", "No", "Aktif"],
  [1816, "Mengkudu (Morinda citrifolia)", "No", "No", "Aktif"],
  [1817, "Mentega ", "No", "No", "Nonaktif"],
  [1818, "Mentega (Butter)", "No", "No", "Aktif"],
  [1819, "MENTEGA ASIN (SALTED BUTTER)", "No", "No", "Aktif"],
  [1820, "Mentega Bubuk (Butter Powder)", "No", "No", "Aktif"],
  [1821, "Mentega Kacang (Peanut Butter)", "No", "No", "Aktif"],
  [1822, "Mentega Tawar (Unsalted Butter)", "No", "No", "Aktif"],
  [1823, "Mentimun - Ketimun (Cucumber)", "No", "No", "Aktif"],
  [1824, "Mentimun Hijau (Green Cucumber)", "No", "No", "Aktif"],
  [1825, "Mentimun Suri", "No", "No", "Aktif"],
  [1826, "MENTOL (MENTHOL)", "No", "No", "Nonaktif"],
  [
    1827,
    "Merica Sichuan (Zanthoxylum peperitum - Szechuan pepper)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1828,
    "MESES (CHOCOLATE SPRINKLES-CHOCOLATE VERMICELLI-STREUSEL)",
    "No",
    "No",
    "Aktif",
  ],
  [1829, "MESHIMAKOBU", "No", "No", "Nonaktif"],
  [1830, "Mesoyi", "No", "No", "Aktif"],
  [1831, "Metionin (Methionine)", "No", "No", "Aktif"],
  [1832, "Mi (Noodle)", "No", "No", "Aktif"],
  [1833, "Mi Telur (Egg Noodles)", "No", "No", "Aktif"],
  [1834, "Microcos paniculata", "No", "No", "Nonaktif"],
  [1835, "Millet (Millet)", "No", "No", "Aktif"],
  [1836, "Millet Serpih (Millet Flakes)", "No", "No", "Aktif"],
  [1837, "MINUMAN BERALKOHOL", "No", "No", "Nonaktif"],
  [1838, "Minuman Sari Buah ....", "No", "No", "Aktif"],
  [1839, "Minyak  Almond (Almond Oil)", "No", "No", "Aktif"],
  [1840, "Minyak Adas Manis (Anise Oil)", "No", "No", "Aktif"],
  [1841, "Minyak Alpukat (Avocado Oil)", "No", "No", "Aktif"],
  [1842, "MINYAK ANGGUR (GRAPE OIL)", "No", "No", "Nonaktif"],
  [1843, "MINYAK ANIS (ANISE OIL)", "No", "No", "Nonaktif"],
  [
    1844,
    "Minyak Atsiri Adas Manis (Anise Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1845,
    "MINYAK ATSIRI BAWANG BOMBAY (ONION ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1846,
    "Minyak Atsiri Bunga Matahari (Sunflower Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1847,
    "Minyak Atsiri Cabai (Chili Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1848,
    "Minyak Atsiri Cengkeh (Clove Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1849,
    "Minyak Atsiri Chamomile (Chammomile Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1850,
    "Minyak Atsiri Durian (Durian Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1851,
    "MINYAK ATSIRI JAHE (GINGER OLEORESIN-GINGER ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1852,
    "Minyak Atsiri Jeruk (Orange Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1853,
    "MINYAK ATSIRI JERUK BALI (GRAPEFRUIT ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1854,
    "Minyak Atsiri Jeruk Bergamot (Bergamot Orange Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1855,
    "Minyak Atsiri Jeruk Lemon (Lemon Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1856,
    "Minyak Atsiri Jeruk Nipis (Lime Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1857,
    "MINYAK ATSIRI JERUK PURUT (KAFFIR LIME ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1858,
    "Minyak Atsiri Jintan Hitam (Black Cumin Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1859,
    "MINYAK ATSIRI JUNIPER BERRY (JUNIPER BERRY ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1860,
    "Minyak Atsiri Kayu Manis (Cinnamon Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1861,
    "Minyak Atsiri Kemukus (Cubeb Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1862,
    "Minyak Atsiri Kunyit (Turmeric Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1863,
    "Minyak Atsiri Lada (Pepper Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1864,
    "Minyak Atsiri Leci (Lychee Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1865,
    "MINYAK ATSIRI LEMON (LEMON ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1866,
    "MINYAK ATSIRI LOBAK (RADISH ESSENTIAL OIL-TURNIP ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1867,
    "Minyak Atsiri Mangga (Mango Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1868,
    "Minyak Atsiri Mint (Mint Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1869,
    "MINYAK ATSIRI MUSTARD (MUSTARDSEED ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1870,
    "MINYAK ATSIRI NANAS (PINEAPPLE ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1871,
    "Minyak Atsiri Nangka (Jackfruit Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1872,
    "Minyak Atsiri Pala (Nutmeg Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1873,
    "Minyak Atsiri Pandan (Pandan Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1874,
    "MINYAK ATSIRI PAPRIKA (PAPRIKA OLEORESIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1875,
    "Minyak Atsiri Peppermint (Peppermint Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1876,
    "MINYAK ATSIRI PERILLA (PERILLA ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1877,
    "Minyak Atsiri Pisang (Banana Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1878,
    "MINYAK ATSIRI ROSEMARY (ROSEMARY OLEORESIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1879,
    "Minyak Atsiri Sereh (Lemongrass Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1880,
    "Minyak Atsiri Spearmint (Spearmint Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1881,
    "Minyak Atsiri Stroberi (Strawberry Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1882,
    "Minyak Atsiri Tarragon (Tarragon Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1883,
    "Minyak Atsiri Wortel (Carrot Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1884, "Minyak Ayam (Chicken Oil)", "No", "No", "Aktif"],
  [1885, "Minyak Babi (Pork Oil)", "No", "No", "Aktif"],
  [1886, "Minyak Barley (Barley Oil)", "No", "No", "Aktif"],
  [1887, "Minyak Bawang Merah (Shallot Oil)", "No", "No", "Aktif"],
  [1888, "MINYAK BAWANG PUTIH (GARLIC OIL)", "No", "No", "Aktif"],
  [1889, "MINYAK BERAS (RICE BRAN OIL)", "No", "No", "Aktif"],
  [1890, "Minyak Biji Anggur (Grapeseed Oil)", "No", "No", "Aktif"],
  [
    1891,
    "MINYAK BIJI APRIKOT (APRICOT KERNEL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1892,
    "MINYAK BIJI BUNGA MATAHARI (REFINED BLEACHED DEODORIZED SUNFLOWER OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1893,
    "MINYAK BIJI KAPAS (REFINED BLEACHED DEODORIZED COTTONSEED OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1894, "Minyak Biji Rami (Flaxseed Oil)", "No", "No", "Aktif"],
  [
    1895,
    "MINYAK BIJI SAWI (MUSTARDSEED OIL - REFINED BLEACHED DEODORIZED MUSTARDSEED OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1896,
    "MINYAK BUNGA MATAHARI (SUNFLOWER OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1897, "MINYAK CABAI (CAPSICUM OLEORESIN)", "No", "No", "Aktif"],
  [
    1898,
    "MINYAK DAUN JERUK PURUT (KAFFIR LIME LEAF OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1899, "Minyak Durian (Durian Oil)", "No", "No", "Aktif"],
  [1900, "MINYAK FRAMBOZEN (FRAMBOZEN OIL)", "No", "No", "Nonaktif"],
  [1901, "MINYAK GORENG (FRYING OIL)", "No", "No", "Aktif"],
  [
    1902,
    "MINYAK GORENG KEDELAI (SOYBEAN FRYING OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1903,
    "Minyak Goreng Kelapa Sawit (Palm Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1904, "MINYAK IKAN (FISH OIL)", "No", "No", "Aktif"],
  [
    1905,
    "Minyak Inti Kelapa Sawit Terhidrogenasi (Refined Hydrogenated Palm Kernel Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1906,
    "MINYAK JAGUNG (REFINED BLEACHED DEODORIZED CORN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1907, "MINYAK JERUK (CITRUS OIL)", "No", "No", "Aktif"],
  [1908, "MINYAK KACANG (PEANUT OIL)", "No", "No", "Aktif"],
  [
    1909,
    "Minyak Kacang Macadamia (Macadamia Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1910,
    "MINYAK KACANG TANAH (REFINED BLEACHED DEODORIZED PEANUT OIL - REFINED BLEACHED DEODORIZED GROUNDNUT OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1911, "MINYAK KACANG WALNUT (WALNUT OIL)", "No", "No", "Aktif"],
  [1912, "Minyak Kanola (Canola Oil)", "No", "No", "Aktif"],
  [1913, "Minyak Kari (Curry Oil)", "No", "No", "Aktif"],
  [1914, "MINYAK KAYU MANIS (CINNAMON OIL)", "No", "No", "Aktif"],
  [1915, "MINYAK KAYU PUTIH (EUCALYPTUS OIL)", "No", "No", "Aktif"],
  [1916, "Minyak Kedelai", "No", "No", "Nonaktif"],
  [
    1917,
    "MINYAK KEDELAI (REFINED BLEACHED DEODORIZED SOYBEAN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1918,
    "Minyak Kedelai Terhidrogenasi Parsial (Partially Hydrogenated Soybean Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1919,
    "MINYAK KELAPA (REFINED BLEACHED DEODORIZED COCONUT OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1920,
    "Minyak Kelapa Bubuk (Coconut Oil Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1921,
    "Minyak Kelapa Mentah (Unrefined Coconut Oil-Crude Coconut Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1922,
    "Minyak Kelapa Murni (Virgin Coconut Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1923,
    "MINYAK KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM OIL-RBDPO) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1924,
    "Minyak Kelapa Sawit Terhidrogenasi (Refined Hydrogenated Palm Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1925,
    "Minyak Kelapa Terhidrogenasi (Hydogenated Coconut Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1926,
    "Minyak Kulit Ari Beras (Rice Husk Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1927, "Minyak LC-PUFA (Oil Mix LC-PUFA)", "No", "No", "Aktif"],
  [1928, "Minyak Melon (Melon Oil)", "No", "No", "Aktif"],
  [1929, "minyak mentega", "No", "No", "Nonaktif"],
  [1930, "Minyak Mentega (Butter Oil)", "No", "No", "Aktif"],
  [1931, "MINYAK MUSTARD", "No", "No", "Nonaktif"],
  [1932, "Minyak Nabati ", "No", "No", "Nonaktif"],
  [1933, "Minyak Nabati (Vegetable Oil)", "No", "No", "Aktif"],
  [
    1934,
    "Minyak Nabati Terhidrogenasi (Hydrogenated Vegetable Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1935, "Minyak Nanas (Pineapple Oil)", "No", "No", "Aktif"],
  [1936, "Minyak Nangka (Jackfruit Oil)", "No", "No", "Aktif"],
  [
    1937,
    "MINYAK OLEIN KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM OLEIN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1938, "Minyak Pandan (Pandan Oil)", "No", "No", "Aktif"],
  [1939, "Minyak Peppermint (Peppermint Oil)", "No", "No", "Aktif"],
  [1940, "MINYAK PERILLA (PERILLA OIL)", "No", "No", "Aktif"],
  [
    1941,
    "Minyak Primrose (Evening Primrose Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1942,
    "MINYAK RAPESEED (RAPESEED OIL-TURNIP RAPE OIL-COLZA OIL-RAVISON OIL-SARSON OIL-TORIA OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1943, "Minyak Raspberry (Raspberry Oil)", "No", "No", "Aktif"],
  [1944, "Minyak Reroti (Shortening Oil)", "No", "No", "Aktif"],
  [
    1945,
    "MINYAK ROS ESENSIAL (ROSE ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1946,
    "Minyak Sacha Inchi (Plukenetiva Volubilis L)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1947,
    "MINYAK SAFFLOWER (REFINED BLEACHED DEODORIZED SAFFLOWER OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1948, "Minyak Salad (Salad Oil)", "No", "No", "Aktif"],
  [
    1949,
    "MINYAK SAMIN ATAU VANASPATI (VEGETABLE GHEE)",
    "No",
    "No",
    "Aktif",
  ],
  [1950, "Minyak Sapi (Beef Oil)", "No", "No", "Aktif"],
  [
    1951,
    "Minyak Sarsaparila (Sarsaparilla Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1952, "Minyak Sawit Olein", "No", "No", "Nonaktif"],
  [1953, "MINYAK SAYUR (COOKING OIL)", "No", "No", "Aktif"],
  [1954, "MINYAK SAYUR PADAT (COOKING FAT)", "No", "No", "Aktif"],
  [1955, "Minyak Sekam Oat (Oat Bran Oil)", "No", "No", "Aktif"],
  [1956, "Minyak Spearmint (Spearmint Oil)", "No", "No", "Aktif"],
  [1957, "Minyak Spinkenard (Spinkenard Oil)", "No", "No", "Aktif"],
  [
    1958,
    "Minyak Stearin Inti Kelapa Sawit Terhidrogenasi (Hydrogenated Palm Kernel Stearin Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1959,
    "MINYAK STEARIN KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM STEARIN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1960,
    "MINYAK TRIGLISERIDA RANTAI SEDANG (MCT) (MEDIUM CHAIN TRIGLYCERIDES OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1961, "minyak vanila", "No", "No", "Nonaktif"],
  [1962, "Minyak Wijen (Sesame Oil)", "No", "No", "Aktif"],
  [
    1963,
    "MINYAK ZAITUN (REFINED BLEACHED DEODORIZED OLIVE OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1964,
    "MINYAK ZAITUN EXTRA VIRGIN (EXTRA VIRGIN OLIVE OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1965,
    "Minyak Zaitun Pomace (Pomace Olive Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1966,
    "Minyak Zaitun Virgin (Virgin Olive Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1967, "Mirin", "No", "No", "Aktif"],
  [1968, "Miso", "No", "No", "Aktif"],
  [1969, "MISO BUBUK (MISO POWDER)", "No", "No", "Aktif"],
  [1970, "Mocaf (Tepung Singkong Fermentasi)", "No", "No", "Aktif"],
  [1971, "Molibdenum", "No", "No", "Aktif"],
  [
    1972,
    "Mono Dan Digliserida (mono- And Di-glycerides)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1973, "Monogliserida (monoglycerides)", "No", "No", "Nonaktif"],
  [
    1974,
    "Monokalium fosfat (Potassium phosphate, monobasic) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1975,
    "Mukorpepsin (Mucorpepsin) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [1976, "MULUKHIYAH", "No", "No", "Aktif"],
  [1977, "MUNG DHAL (MOONG DAL)", "No", "No", "Aktif"],
  [1978, "Muscat (Muscat)", "No", "No", "Aktif"],
  [1979, "Mustard (Mustard)", "No", "No", "Aktif"],
  [1980, "Mustard Bubuk (Mustard Powder)", "No", "No", "Aktif"],
  [1981, "Mustard Kuning (Yellow Mustard)", "No", "No", "Aktif"],
  [1982, "Mustard Pasta (Mustard Paste)", "No", "No", "Aktif"],
  [1983, "Myo-Inositol", "No", "No", "Aktif"],
  [1984, "Naget (Nugget)", "No", "No", "Aktif"],
  [1985, "Nanas (Pineapple)", "No", "No", "Aktif"],
  [1986, "NANAS BUBUK (PINEAPPLE POWDER)", "No", "No", "Aktif"],
  [1987, "Nangka (Jackfruit)", "No", "No", "Aktif"],
  [1988, "Nasi (Rice)", "No", "No", "Aktif"],
  [1989, "Nata De Coco (Nata De Coco)", "No", "No", "Aktif"],
  [1990, "NATRIUM ASKORBAT (SODIUM ASCORBATE)", "No", "No", "Aktif"],
  [
    1991,
    "NATRIUM BENZOAT (SODIUM BENZOATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1992,
    "Natrium dihidrogen fosfat (Sodium dihydrogen phosphate) ",
    "No",
    "No",
    "Aktif",
  ],
  [1993, "Natrium fluorida (Sodium fluoride)", "No", "No", "Aktif"],
  [
    1994,
    "NATRIUM HIDROGEN KARBONAT (SODIUM BICARBONATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1995,
    "Natrium Hidroksida (Sodium Hydroxide) (Kecuali MP ASI)",
    "No",
    "No",
    "Aktif",
  ],
  [1996, "NATRIUM IODIDA (SODIUM IODIDE)", "No", "No", "Aktif"],
  [
    1997,
    "NATRIUM KARBOKSIMETIL SELULOSA (SODIUM CARBOXYMETHYL CELLULOSE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1998,
    "NATRIUM KARBONAT (SODIUM CARBONATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1999, "Natrium Kaseinat (Sodium Caseinate)", "No", "No", "Aktif"],
  [2000, "natrium klorida (sodium chloride)", "No", "No", "Aktif"],
  [2001, "NATRIUM MOLIBDAT (SODIUM MOLYBDATE)", "No", "No", "Aktif"],
  [
    2002,
    "NATRIUM POLIFOSFAT (SODIUM POLYPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2003, "NATRIUM SELENAT (SODIUM SELENATE)", "No", "No", "Aktif"],
  [2004, "NATRIUM SELENIT (SODIUM SELENITE)", "No", "No", "Aktif"],
  [
    2005,
    "NATRIUM TRIPOLIFOSFAT (SODIUM TRIPOLYPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2006, "Nektar Agave (Agave Nectar)", "No", "No", "Aktif"],
  [2007, "Nektar Buah", "No", "No", "Aktif"],
  [2008, "Nektar Lontar", "No", "No", "Aktif"],
  [
    2009,
    "NETTLE LEAF POWDER (URTICA DIOCA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2010, "NIASIN (NIACIN)", "No", "No", "Nonaktif"],
  [2011, "NIKOTINAMIDA (NICOTINAMIDE)", "No", "No", "Aktif"],
  [2012, "Nira Aren", "No", "No", "Aktif"],
  [2013, "NIRA KELAPA (COCONUT SAP)", "No", "No", "Aktif"],
  [2014, "Nira Lontar (Siwalan)", "No", "No", "Aktif"],
  [
    2015,
    "Non-Dairy Toppings, Fillings, Frostings",
    "Yes",
    "No",
    "Aktif",
  ],
  [2016, "Nori Goreng (Fried Seawed)", "No", "No", "Aktif"],
  [2017, "Nougat (Nougat)", "No", "No", "Aktif"],
  [2018, "Nukleotida (Nucleotide)", "No", "No", "Aktif"],
  [
    2019,
    "NUKLEOTIDA PREMIKS (PREMIX NUCLEOTIDE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2020, "Oat (Oat)", "No", "No", "Aktif"],
  [2021, "OAT BUBUK (OAT POWDER)", "No", "No", "Aktif"],
  [2022, "OAT SERPIHAN (OAT FLAKES)", "No", "No", "Aktif"],
  [2023, "OATMEAL (OATMEAL)", "No", "No", "Aktif"],
  [2024, "OKSIGEN (OXYGEN)", "No", "No", "Aktif"],
  [2025, "OLIGOFRUKTOSA (OLIGOFRUCTOSE)", "No", "No", "Aktif"],
  [2026, "OLIGOSAKARIDA (OLIGOSACCHARIDES)", "No", "No", "Aktif"],
  [2027, "Omega 3 (Omega 3)", "No", "No", "Aktif"],
  [2028, "Oregano (Oregano)", "No", "No", "Aktif"],
  [2029, "Oregano Bubuk (Oregano Powder)", "No", "No", "Aktif"],
  [2030, "PADATAN SUSU (MILK SOLIDS)", "No", "No", "Aktif"],
  [
    2031,
    "PADATAN SUSU TANPA LEMAK (NON FAT MILK SOLIDS)",
    "No",
    "No",
    "Aktif",
  ],
  [2032, "PAHA AYAM (CHICKEN THIGHS)", "No", "No", "Aktif"],
  [
    2033,
    "Pakcoy atau Pokcoy (Brassica Rapa L)",
    "No",
    "No",
    "Aktif",
  ],
  [2034, "Pala (Nutmeg)", "No", "No", "Aktif"],
  [2035, "Pala Bubuk (Nutmeg Powder)", "No", "No", "Aktif"],
  [2036, "Pandan (Pandan)", "No", "No", "Aktif"],
  [2037, "PANGSIT (DUMPLINGS)", "No", "No", "Aktif"],
  [2038, "Papain (Papain) (Bahan Penolong)", "No", "No", "Aktif"],
  [2039, "PAPRIKA (PAPRIKA)", "No", "No", "Aktif"],
  [2040, "PAPRIKA BUBUK (PAPRIKA POWDER)", "No", "No", "Aktif"],
  [2041, "PAPRIKA HIJAU (GREEN PAPRIKA)", "No", "No", "Aktif"],
  [
    2042,
    "PAPRIKA HIJAU MANIS (SWEET GREEN PAPRIKA)",
    "No",
    "No",
    "Aktif",
  ],
  [2043, "PAPRIKA KUNING (YELLOW PAPRIKA)", "No", "No", "Aktif"],
  [2044, "PAPRIKA MERAH (RED PAPRIKA)", "No", "No", "Aktif"],
  [
    2045,
    "PAPRIKA MERAH MANIS (SWEET RED PAPRIKA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2046,
    "PAPRIKA OLEORESIN (PAPRIKA OLEORESIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2047, "PARE (PARE)", "No", "No", "Aktif"],
  [2048, "PARE KERING (DRY PARE)", "No", "No", "Aktif"],
  [2049, "PARSLEY", "No", "No", "Nonaktif"],
  [2050, "PARSNIP (PASTINACA SATIVA)", "No", "No", "Aktif"],
  [2051, "PARU SAPI (PULMONARY COW)", "No", "No", "Aktif"],
  [2052, "PARUTAN KELAPA (GRATED COCONUT)", "No", "No", "Aktif"],
  [2053, "Parutan Kelapa Kering", "No", "No", "Nonaktif"],
  [2054, "PASAK BUMI (EURYCOMA LONGIFOLIA)", "No", "No", "Nonaktif"],
  [
    2055,
    "Pasta (Fettucini, Lasagna, Macaroni, Spaghetti, dll)",
    "No",
    "No",
    "Aktif",
  ],
  [2056, "Pasta Almond (Almond Paste)", "No", "No", "Aktif"],
  [2057, "Pasta Apel (Apple Paste)", "No", "No", "Aktif"],
  [2058, "Pasta Ayam (Chicken Paste)", "No", "No", "Aktif"],
  [2059, "Pasta Bawang Bombay (Onion Paste)", "No", "No", "Aktif"],
  [2060, "Pasta Bawang Putih (Garlic Paste)", "No", "No", "Aktif"],
  [
    2061,
    "Pasta Biji Wijen (Sesame Seed Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [2062, "Pasta Bluberi (Blueberry Paste)", "No", "No", "Aktif"],
  [2063, "PASTA BUAH, DLL (FRUITS PASTE, ETC)", "No", "No", "Aktif"],
  [2064, "Pasta Bumbu Kari (Curry Paste)", "No", "No", "Aktif"],
  [2065, "Pasta Cabe (Chili Paste)", "No", "No", "Aktif"],
  [
    2066,
    "Pasta Cokelat Malt (Chocolate Malt Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [2067, "Pasta Coklat (Chocolate Paste)", "No", "No", "Aktif"],
  [2068, "Pasta Durian (Durian Paste)", "No", "No", "Aktif"],
  [2069, "Pasta Ikan  (Fish Paste)", "No", "No", "Aktif"],
  [2070, "Pasta Ikan Anchovy (Anchovy Paste)", "No", "No", "Aktif"],
  [
    2071,
    "Pasta Jagung Manis (Sweet Corn Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [2072, "Pasta Jeruk (Orange Paste)", "No", "No", "Aktif"],
  [2073, "Pasta Jeruk Lemon (Lemon Paste)", "No", "No", "Aktif"],
  [2074, "Pasta Kacang (Nut Paste)", "No", "No", "Aktif"],
  [2075, "Pasta Kacang Hazel (Hazelnut Paste)", "No", "No", "Aktif"],
  [2076, "Pasta Kacang Hijau (Mungbean Paste)", "No", "No", "Aktif"],
  [
    2077,
    "Pasta Kacang Kedelai (Soybean Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [2078, "PASTA KACANG MERAH (RED BEAN PASTE)", "No", "No", "Aktif"],
  [2079, "Pasta Keju (Cheese Paste)", "No", "No", "Aktif"],
  [2080, "Pasta Kelapa (Coconut Paste)", "No", "No", "Aktif"],
  [
    2081,
    "PASTA KETAN HITAM (BLACK STICKY RICE PASTE)",
    "No",
    "No",
    "Aktif",
  ],
  [2082, "Pasta Kismis (Raisin Paste)", "No", "No", "Aktif"],
  [2083, "Pasta Kopi", "No", "No", "Nonaktif"],
  [2084, "Pasta Kurma (Datess Paste)", "No", "No", "Aktif"],
  [2085, "PASTA LADA MERAH (RED PEPPER PASTE)", "No", "No", "Aktif"],
  [2086, "Pasta Leci (Lychee Paste)", "No", "No", "Aktif"],
  [2087, "Pasta Mangga (Mango Paste)", "No", "No", "Aktif"],
  [2088, "Pasta Nanas (Pineapple Paste)", "No", "No", "Aktif"],
  [2089, "Pasta Pear (Pear Paste)", "No", "No", "Aktif"],
  [2090, "Pasta Pepaya (Papaya Paste)", "No", "No", "Aktif"],
  [2091, "Pasta Persik (Peach Paste)", "No", "No", "Aktif"],
  [2092, "Pasta Pisang (Banana Paste)", "No", "No", "Aktif"],
  [2093, "Pasta Plum (Plum Paste)", "No", "No", "Aktif"],
  [2094, "PASTA RASPBERI (RASPBERRY PASTE)", "No", "No", "Aktif"],
  [2095, "PASTA SARIKAYA (SARIKAYA PASTE)", "No", "No", "Aktif"],
  [2096, "Pasta Srikaya (Soursop Paste)", "No", "No", "Aktif"],
  [2097, "Pasta Stroberi (Strawberry Paste)", "No", "No", "Aktif"],
  [2098, "Pasta Tomat (Tomato Paste)", "No", "No", "Aktif"],
  [2099, "Pasta Udang (Shrimp Paste)", "No", "No", "Aktif"],
  [2100, "Pasta Wijen (Sesame Paste)", "No", "No", "Aktif"],
  [2101, "Pastri Samosa  (Samosa Pastry)", "No", "No", "Aktif"],
  [2102, "Pati (Starch)", "No", "No", "Aktif"],
  [2103, "Pati Beras (Rice Starch)", "No", "No", "Aktif"],
  [2104, "Pati Gandum (Wheat Starch)", "No", "No", "Aktif"],
  [2105, "Pati Jagung (Corn Starch)", "No", "No", "Aktif"],
  [
    2106,
    "Pati Jagung Terhidrolisa (Hydrolized Corn Starch)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2107,
    "PATI JAGUNG TERMODIFIKASI (MODIFIED CORN STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2108, "Pati Kacang Hijau (Mungbean Starch)", "No", "No", "Aktif"],
  [2109, "PATI KACANG POLONG (PEAS STARCH)", "No", "Yes", "Aktif"],
  [
    2110,
    "Pati Kedelai Terhidrolisa ((Hydrolized Soy Starch)",
    "No",
    "No",
    "Aktif",
  ],
  [2111, "Pati Kentang (Potato Starch)", "No", "No", "Aktif"],
  [
    2112,
    "PATI KENTANG TERMODIFIKASI (MODIFIED POTATO STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2113, "PATI MODIFIKASI (MODIFIED STARCH)", "No", "No", "Aktif"],
  [2114, "Pati Sagu (Sago Starch)", "No", "No", "Aktif"],
  [2115, "PATI SINGKONG (TAPIOCA STARCH) ", "No", "No", "Nonaktif"],
  [2116, "PATI TAPIOKA", "No", "No", "Aktif"],
  [
    2117,
    "PATI TAPIOKA TERMODIFIKASI (MODIFIED TAPIOCA STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2118, "Pati terModifikasi", "No", "No", "Nonaktif"],
  [2119, "Pati Ubi (Cassava Starch)", "No", "No", "Aktif"],
  [
    2120,
    "PATI UBI JALAR (SWEET POTATO STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2121, "PECAHAN JAGUNG (CORN GRITS)", "No", "No", "Aktif"],
  [2122, "Pedada (Sonneratia caseolaris)", "No", "No", "Aktif"],
  [
    2123,
    "Pekak (Bunga Lawang-Kembang Lawang-Star Anise) (Star Anise)",
    "No",
    "No",
    "Aktif",
  ],
  [2124, "Pekak Bubuk (Star Anise Powder)", "No", "No", "Aktif"],
  [2125, "pektin", "No", "No", "Nonaktif"],
  [2126, "Pektin (Pectin)", "No", "No", "Aktif"],
  [
    2127,
    "Pektin liase (Pectin lyase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2128,
    "Pektinesterase (Pectinesterase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2129, "Pelapis Gula (Sugar Coating)", "No", "No", "Aktif"],
  [2130, "Pelet (Pellet)", "No", "No", "Nonaktif"],
  [
    2131,
    "Pengganti Lemak Kakao (Cacao Butter Substitute)",
    "No",
    "No",
    "Aktif",
  ],
  [2132, "PENGGANTI MENTEGA", "Yes", "No", "Nonaktif"],
  [
    2133,
    "PENGGANTI MINYAK MENTEGA (BUTTER OIL SUBSTITUTE)",
    "No",
    "No",
    "Aktif",
  ],
  [2134, "Penicillium camemberti", "No", "No", "Aktif"],
  [2135, "Penicillium candidum", "No", "No", "Aktif"],
  [2136, "PENICILLIUM CASEICOLUM", "No", "No", "Aktif"],
  [2137, "Penicillium roqueforti", "No", "No", "Aktif"],
  [2138, "penyangga bunga teratai", "No", "No", "Nonaktif"],
  [2139, "Pepaya Gunung/Karika", "No", "No", "Aktif"],
  [2140, "Pepermint (Peppermint)", "No", "No", "Aktif"],
  [2141, "Pepermint Bubuk (Peppermint Powder)", "No", "No", "Aktif"],
  [
    2142,
    "Pepsin A (Pepsin A) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2143,
    "Pepsin B (Pepsin B) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2144,
    "Pepsin C (Pepsin C) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2145, "Peptida Kolagen (Collagen Peptide)", "Yes", "No", "Aktif"],
  [2146, "Perasan Air Jeruk (Lemon Juice)", "No", "No", "Aktif"],
  [2147, "Perisa Test", "No", "No", "Nonaktif"],
  [2148, "PETAI (BITTER BEAN)", "No", "No", "Aktif"],
  [2149, "PETAI CINA (WHITE LEADTREE)", "No", "No", "Aktif"],
  [2150, "Peterseli (Parsley)", "No", "No", "Aktif"],
  [2151, "Peterseli Bubuk (Parsley Powder)", "No", "No", "Aktif"],
  [2152, "Pilus", "No", "No", "Aktif"],
  [2153, "Pimenta (Pimenta)", "No", "No", "Aktif"],
  [2154, "Pimento (Allspice)", "No", "No", "Aktif"],
  [2155, "Pimento Bubuk (Allspice Powder)", "No", "No", "Aktif"],
  [2156, "PINANG (ARECA NUT)", "No", "No", "Nonaktif"],
  [2157, "Pinto Beans (Kacang Pinto)", "No", "No", "Aktif"],
  [2158, "PIR (PEAR)", "No", "No", "Aktif"],
  [
    2159,
    "PIRIDOKSIN HIDROKLORIDA (VITAMIN B6)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2160, "Pisang (Banana)", "No", "No", "Aktif"],
  [2161, "Pisang Bubuk (Banana Powder)", "No", "No", "Aktif"],
  [2162, "Pizza Bubuk Ekstrak", "No", "No", "Nonaktif"],
  [
    2163,
    "PLANT STANOL ESTER-FITOSTANOL (PHYTOSTANOL)",
    "No",
    "No",
    "Aktif",
  ],
  [2164, "Polidekstrosa (Polydextrose)", "No", "No", "Aktif"],
  [2165, "Polifruktosa (Polyfructose)", "No", "No", "Aktif"],
  [
    2166,
    "Poligalakturonase (Polygalacturonase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2167, "Polisakarida (Polysaccharides)", "No", "No", "Aktif"],
  [2168, "POTONGAN BUAH APEL (APPLE SLICES)", "No", "No", "Aktif"],
  [2169, "POTONGAN KENTANG (POTATO SLICES)", "No", "No", "Aktif"],
  [2170, "Pottasium Aspartate", "No", "No", "Aktif"],
  [2171, "Praline (Praline)", "No", "No", "Aktif"],
  [2172, "PREM (PLUM)", "No", "No", "Aktif"],
  [2173, "PREM ASIN (SALTED PLUM)", "No", "No", "Aktif"],
  [2174, "PREMIKS MINERAL (MINERAL PREMIX)", "No", "No", "Aktif"],
  [
    2175,
    "PREMIKS MINERAL (MINERAL PREMIX) - Khusus Produk Wajib SNI",
    "No",
    "No",
    "Aktif",
  ],
  [2176, "Premiks Vitamin (Vitamin Premix)", "No", "No", "Aktif"],
  [
    2177,
    "Premiks Vitamin (Vitamin Premix) - Khusus Produk Wajib SNI",
    "No",
    "No",
    "Aktif",
  ],
  [
    2178,
    "PREMIKS VITAMIN DAN MINERAL (VITAMIN AND MINERAL PREMIX)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2179,
    "PREMIKS VITAMIN DAN MINERAL (VITAMIN AND MINERAL PREMIX) - Khusus Produk Wajib SNI",
    "No",
    "No",
    "Aktif",
  ],
  [
    2180,
    "Preparat Perisa (Flavoring Preparation)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2181,
    "Prolyl oligopeptidase (Prolyl oligopeptidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2182, "PROPOLIS (PROPOLLIS)", "No", "No", "Nonaktif"],
  [2183, "Protein Daging", "No", "No", "Aktif"],
  [2184, "Protein Gandum (Wheat Protein)", "No", "No", "Aktif"],
  [
    2185,
    "Protein Jagung Terhidrolisa (Hydrolized Corn Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [2186, "Protein Kedelai (Soy Protein)", "No", "No", "Aktif"],
  [
    2187,
    "PROTEIN KEDELAI TERHIDROLISA (HYDROLIZED SOY PROTEIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2188, "PROTEIN NABATI (VEGETABLE PROTEIN)", "No", "No", "Aktif"],
  [2189, "Protein Nabati Terhidrolisa", "No", "No", "Nonaktif"],
  [2190, "protein nabati terhirolisa", "No", "No", "Nonaktif"],
  [2191, "Protein nabati tertekstur", "No", "No", "Nonaktif"],
  [2192, "Protein Pea", "No", "No", "Aktif"],
  [2193, "Protein Susu (Milk Protein)", "No", "No", "Aktif"],
  [
    2194,
    "Protein Susu Fermentasi (Fermented Milk Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [2195, "Protein Whey (Whey Protein)", "No", "No", "Aktif"],
  [2196, "PRUNELLA VULGARIS", "No", "No", "Nonaktif"],
  [2197, "Psyllium", "No", "No", "Aktif"],
  [2198, "PSYLLIUM HUSK", "No", "No", "Aktif"],
  [2199, "Puff Gandum (Wheat Puffed)", "No", "No", "Aktif"],
  [
    2200,
    "Pululanase (Pullulanase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2201, "Puree Apel (Apple Puree)", "No", "No", "Aktif"],
  [2202, "PUREE BAWANG PUTIH (GARLIC PUREE)", "No", "No", "Aktif"],
  [2203, "PUREE BLACKBERRY (BLACKBERRY PUREE)", "No", "No", "Aktif"],
  [
    2204,
    "Puree Blackcurrant (Blackcurrant Puree)",
    "No",
    "No",
    "Aktif",
  ],
  [2205, "PUREE BLUBERI (BLUEBERRY PUREE)", "No", "No", "Aktif"],
  [2206, "PUREE BUAH LAINNYA (FRUIT PUREE)", "No", "No", "Aktif"],
  [2207, "Puree Ceri (Cherry Puree)", "No", "No", "Aktif"],
  [2208, "Puree Jambu Biji (Guava Puree)", "No", "No", "Aktif"],
  [2209, "PUREE JAMBU MERAH", "No", "No", "Nonaktif"],
  [2210, "Puree Kurma", "No", "No", "Aktif"],
  [2211, "Puree Leci (Lyche Puree)", "No", "No", "Aktif"],
  [2212, "Puree Mangga (Mango Puree)", "No", "No", "Aktif"],
  [2213, "PUREE MIX BERRY (MIX BERRY PUREE)", "No", "No", "Aktif"],
  [2214, "Puree Persik (Peach Puree)", "No", "No", "Aktif"],
  [2215, "PUREE PIR (PEAR PUREE)", "No", "No", "Aktif"],
  [2216, "Puree Sirsak (Soursop Puree)", "No", "No", "Aktif"],
  [2217, "Puree Stroberi (Strawberry Puree)", "No", "No", "Aktif"],
  [2218, "Puree Tomat (Tomato Puree)", "No", "No", "Aktif"],
  [2219, "PUTIH TELUR (EGG WHITE)", "No", "No", "Aktif"],
  [
    2220,
    "PUTIH TELUR BUBUK (EGG WHITE POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2221, "PUTIH TELUR PADAT (EGG WHITE SOLID)", "No", "No", "Aktif"],
  [
    2222,
    "QUERCETIN (BERUPA ISOLAT DARI BANYAK TANAMAN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2223, "Rafinosa (Raffinose)", "No", "No", "Aktif"],
  [2224, "Ragi (Yeast)", "No", "No", "Aktif"],
  [2225, "Ragi Bubuk (Yeast Powder)", "No", "No", "Aktif"],
  [2226, "Ragi Instan (Instant Yeast)", "No", "No", "Aktif"],
  [2227, "Ragi Kering (Dried Yeast)", "No", "No", "Aktif"],
  [2228, "Ragi Padat (Solid Yeast)", "No", "No", "Aktif"],
  [2229, "Ragi Roti", "No", "No", "Nonaktif"],
  [2230, "RAGI ROTI (BAKER YEAST)", "No", "No", "Aktif"],
  [2231, "Ragi Tape", "No", "No", "Aktif"],
  [2232, "Rajungan", "No", "No", "Aktif"],
  [2233, "Rambutan (Rambutan)", "No", "No", "Aktif"],
  [
    2234,
    "REBUNG (BAMBOO SPROUTS-BAMBOO SHOOTS)",
    "No",
    "No",
    "Aktif",
  ],
  [2235, "Rebung Kelapa Sawit (Palm Heart)", "No", "No", "Aktif"],
  [
    2236,
    "red currant leaves (ribes rubrum)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2237,
    "REHMANNIA GLUTINOSA (REHMANNIA GLUTINOSE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2238, "REMAHAN BAWANG HIJAU", "No", "No", "Aktif"],
  [2239, "REMAHAN BISKUIT (BISCUIT CRUMB)", "No", "No", "Aktif"],
  [
    2240,
    "REMAHAN HOKEY POKEY (HOKEY POKEY CRUMB)",
    "No",
    "No",
    "Aktif",
  ],
  [2241, "REMAHAN TELUR", "No", "No", "Aktif"],
  [2242, "Remahan wafer", "No", "No", "Aktif"],
  [2243, "Remis Bubuk (Mussel Powder)", "No", "No", "Aktif"],
  [2244, "Remis Kering (Dried Mussel)", "No", "No", "Aktif"],
  [2245, "Rempah (Spices)", "No", "No", "Aktif"],
  [2246, "Renet (Rennet) (Bahan Penolong)", "No", "No", "Aktif"],
  [2247, "Rennet (Rennet)", "No", "No", "Aktif"],
  [2248, "Resin Gum (Gum Resin)", "No", "No", "Aktif"],
  [2249, "Retinil Asetat (Retinyl Acetate)", "No", "No", "Aktif"],
  [
    2250,
    "Retinil Palmitat (Retinyl Palmitate)",
    "No",
    "No",
    "Aktif",
  ],
  [2251, "Rhodopseudomonas palustris", "No", "No", "Aktif"],
  [
    2252,
    "rhubarb batang (rheum rhabarbarum)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2253, "Riboflavin (vitamin B2)", "No", "No", "Nonaktif"],
  [
    2254,
    "Ribonuklease P (Ribonuclease P) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2255, "RIMPANG TERATAI (LOTUS ROOT)", "No", "No", "Nonaktif"],
  [2256, "Rolled Oats", "No", "No", "Aktif"],
  [
    2257,
    "rooibos-rooibush-rooibosh (asphalatus linearis)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2258, "Roombutter (Roombutter)", "No", "No", "Aktif"],
  [2259, "ROOT BEER BASE", "Yes", "Yes", "Aktif"],
  [2260, "ROSEHIP PEELS (ROSA CANINA)", "No", "No", "Aktif"],
  [2261, "ROSELA (HIBISCUS SABDARIFFA)", "No", "No", "Aktif"],
  [2262, "ROSEMARI (ROSEMARY)", "No", "No", "Nonaktif"],
  [2263, "Roti (Bread)", "No", "No", "Aktif"],
  [2264, "Roti Kering (Crusty Bread)", "No", "No", "Aktif"],
  [2265, "ROYAL JELLY (KHUSUS MADU)", "No", "No", "Aktif"],
  [2266, "Rum (Rum)", "No", "No", "Aktif"],
  [2267, "Rumput Laut (Seaweed)", "No", "No", "Aktif"],
  [2268, "Rumput Laut Bubuk (Seaweed Powder)", "No", "No", "Aktif"],
  [2269, "Rumput Laut Kering (Dried Seaweed)", "No", "No", "Aktif"],
  [2270, "SAFRON (SAFFRON)", "No", "No", "Aktif"],
  [2271, "SAGE (SALVIA OFFICINALIS)", "No", "No", "Nonaktif"],
  [2272, "Sagu (Sago)", "No", "No", "Aktif"],
  [2273, "Sake (Sake)", "No", "No", "Aktif"],
  [2274, "Salak", "No", "No", "Aktif"],
  [
    2275,
    "Salicornia herbacea L (Salicornia europaea L)",
    "No",
    "No",
    "Aktif",
  ],
  [2276, "SAMBAL (SAUCE)", "No", "No", "Aktif"],
  [2277, "Sambal Seafood (Seafood Sauce)", "No", "No", "Aktif"],
  [
    2278,
    "SAMBILOTO (ANDROGRAPHIS PANICULATA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2279, "SAMBUCUS NIGRA", "No", "No", "Nonaktif"],
  [2280, "Santan Kelapa (Coconut Milk)", "No", "No", "Aktif"],
  [
    2281,
    "Santan Kelapa Bubuk (Coconut Milk Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2282,
    "SANTAN KELAPA MURNI (PURE COCONUT MILK)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2283,
    "Sarang Burung Walet (Swallow's Nest)",
    "No",
    "No",
    "Aktif",
  ],
  [2284, "Sari Asam (Tamarind Juice)", "No", "No", "Aktif"],
  [2285, "Sari Asam Jawa (Tamarind Juice)", "No", "No", "Aktif"],
  [2286, "SARI AYAM (CHICKEN ESSENCE)", "No", "No", "Nonaktif"],
  [2287, "Sari Bawang Bombay (Onion Juice)", "No", "No", "Aktif"],
  [2288, "Sari Beras (Grains of Rice)", "No", "No", "Aktif"],
  [2289, "SARI BERAS MERAH (BROWN RICE JUICE)", "No", "No", "Aktif"],
  [2290, "Sari Buah ...... Rekonstitusi", "No", "No", "Aktif"],
  [2291, "Sari Buah Anggur (Grape Juice)", "No", "No", "Aktif"],
  [2292, "SARI BUAH ANGGUR BUBUK", "No", "No", "Aktif"],
  [
    2293,
    "Sari Buah Anggur Hijau  (Green Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2294,
    "Sari Buah Anggur Merah (Red Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2295,
    "Sari Buah Anggur Muscat (Muscat Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2296,
    "Sari Buah Anggur Putih  (White Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2297,
    "SARI BUAH ANGGUR REKONSTITUSI (GRAPE JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2298, "Sari Buah Apel (Apple Juice)", "No", "No", "Aktif"],
  [
    2299,
    "SARI BUAH APEL REKONSTITUSI (APPLE JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2300, "Sari Buah Apricot (Apricot Juice)", "No", "No", "Aktif"],
  [2301, "SARI BUAH ARBEI (ARBEI JUICE)", "No", "No", "Aktif"],
  [2302, "Sari Buah Aren", "No", "No", "Aktif"],
  [2303, "Sari Buah Aronia (Aronia Juice)", "No", "No", "Aktif"],
  [
    2304,
    "SARI BUAH ASAM JAWA (TAMARIND JUICE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2305,
    "Sari Buah Belimbing (Starfruit Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2306, "Sari Buah Bilberry (Bilberry Juice)", "No", "No", "Aktif"],
  [
    2307,
    "Sari Buah Blackberry (Blackberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2308,
    "Sari Buah Blackcurant (Blackcurrant Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2309,
    "Sari Buah Blackcurrant Bubuk (blackcurrant juice powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2310, "Sari Buah Blewah (Cantaloupe Juice)", "No", "No", "Aktif"],
  [
    2311,
    "Sari Buah Blueberry (Blueberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2312, "Sari Buah Ceri (Cherry Juice)", "No", "No", "Aktif"],
  [
    2313,
    "Sari Buah Chokeberry (Chokeberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2314,
    "Sari Buah Cranberry (Cranberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2315,
    "SARI BUAH CRANBERRY REKONSTITUSI (CRANBERRY JUICE RECONSTITUTION) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    2316,
    "Sari Buah Delima (Pomegranate Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2317,
    "SARI BUAH FRAMBOZEN (FRAMBOZEN JUICE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2318,
    "SARI BUAH GOJIBERRY (GOJIBERRY JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2319,
    "Sari Buah Gooseberry (Gooseberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2320, "Sari Buah Jambu", "No", "No", "Aktif"],
  [2321, "Sari Buah Jambu Biji (Guava Juice)", "No", "No", "Aktif"],
  [2322, "SARI BUAH JAMBU MERAH", "No", "No", "Nonaktif"],
  [2323, "Sari Buah Jeruk (Orange Juice)", "No", "No", "Aktif"],
  [
    2324,
    "SARI BUAH JERUK BUBUK (ORANGE JUICE POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2325, "Sari Buah Jeruk Florida-Jeruk .....", "No", "No", "Aktif"],
  [2326, "Sari Buah Jeruk Kalamansi", "No", "No", "Aktif"],
  [2327, "Sari Buah Jeruk Lemon (Lemon Juice)", "No", "No", "Aktif"],
  [2328, "SARI BUAH JERUK LIMAU (LIMAU JUICE)", "No", "No", "Aktif"],
  [2329, "Sari Buah Jeruk Mandarin", "No", "No", "Aktif"],
  [2330, "Sari Buah Jeruk Nipis", "No", "No", "Aktif"],
  [
    2331,
    "SARI BUAH JERUK REKONSTITUSI (ORANGE JUICE RECONSTITUTION) ",
    "No",
    "No",
    "Aktif",
  ],
  [2332, "SARI BUAH KELAPA (COCONUT JUICE)", "No", "No", "Aktif"],
  [2333, "Sari Buah Kiwi (Kiwi Juice)", "No", "No", "Aktif"],
  [
    2334,
    "Sari Buah Kranberi (Cranberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2335,
    "SARI BUAH KUNDUR (BENINCASA HISPIDA JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2336, "SARI BUAH KURMA (DATES JUICE)", "No", "No", "Aktif"],
  [2337, "Sari Buah Labu (Pumpkin Juice)", "No", "No", "Aktif"],
  [2338, "Sari Buah Leci (Lychee Juice)", "No", "No", "Aktif"],
  [2339, "Sari Buah Mangga (Mango Juice)", "No", "No", "Aktif"],
  [
    2340,
    "SARI BUAH MANGGA BUBUK (MANGO JUICE POWDER)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [
    2341,
    "Sari Buah Manggis (Mangosteen Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2342,
    "Sari Buah Markisa (Passion Fruit Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2343,
    "SARI BUAH MARKISA REKONSTITUSI (PASSION FRUIT JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2344, "SARI BUAH MELON (MELON JUICE)", "No", "No", "Aktif"],
  [2345, "Sari Buah Nanas (Pineapple Juice)", "No", "No", "Aktif"],
  [
    2346,
    "SARI BUAH NANAS REKONSTITUSI (PINEAPPLE JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2347, "Sari Buah Nangka (Jackfruit Juice)", "No", "No", "Aktif"],
  [2348, "Sari Buah Pala (Nutmeg Juice)", "No", "No", "Aktif"],
  [
    2349,
    "SARI BUAH PEAR REKONSTITUSI (PEAR JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2350, "Sari Buah Pepaya (Papaya Juice)", "No", "No", "Aktif"],
  [2351, "Sari Buah Persik (Peach Juice)", "No", "No", "Aktif"],
  [2352, "Sari Buah Pir (Pear Juice)", "No", "No", "Aktif"],
  [2353, "Sari Buah Pisang (Banana Juice)", "No", "No", "Aktif"],
  [2354, "Sari Buah Plum (Plum Juice)", "No", "No", "Aktif"],
  [2355, "Sari Buah Prune (Prune Juice)", "No", "No", "Aktif"],
  [
    2356,
    "Sari Buah Raspberi (Raspberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2357,
    "SARI BUAH RASPBERI REKONSTITUSI (RASPBERRY JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2358,
    "Sari Buah Redcurrant (Redcurrant Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2359,
    "Sari Buah Semangka (Watermelon Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2360, "Sari Buah Sirsak (Soursop Juice)", "No", "No", "Aktif"],
  [
    2361,
    "SARI BUAH SIWALAN (PALMYRA FRUIT JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2362,
    "Sari Buah Stroberi (Strawberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2363,
    "SARI BUAH STROBERI REKONSTITUSI (STRAWBERRY JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2364, "Sari Buah Terong (Eggplant Juice)", "No", "No", "Aktif"],
  [
    2365,
    "SARI BUAH TERONG BELANDA (TAMARILLO JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2366, "Sari Buah Tomat (Tomato Juice)", "No", "No", "Aktif"],
  [2367, "SARI BUNGA MAWAR (ROSE JUICE)", "No", "No", "Nonaktif"],
  [2368, "SARI DAGING AYAM", "No", "No", "Nonaktif"],
  [2369, "SARI DAGING SAPI", "No", "No", "Nonaktif"],
  [
    2370,
    "SARI DAUN CINCAU (GRASS JELLY JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2371, "SARI DAUN KATUK (KATUK JUICE)", "No", "No", "Aktif"],
  [2372, "SARI DAUN PANDAN (PANDAN JUICE)", "No", "No", "Aktif"],
  [2373, "Sari Jagung (Corn Juice)", "No", "No", "Aktif"],
  [2374, "Sari Jahe (Ginger Juice)", "No", "No", "Aktif"],
  [2375, "SARI JAHE MERAH (RED GINGER JUICE)", "No", "No", "Aktif"],
  [2376, "Sari Kacang Almond (Almond Juice)", "No", "No", "Aktif"],
  [2377, "Sari Kacang Kedelai (Soy Juice)", "No", "No", "Aktif"],
  [
    2378,
    "SARI KACANG KEDELAI BUBUK (SOY JUICE POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2379,
    "SARI KACANG KEDELAI HITAM (BLACK SOYBEAN JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2380, "Sari Kelapa (Coconut Juice)", "No", "No", "Aktif"],
  [2381, "SARI KERANG ABALONE (ABALONE JUICE)", "No", "No", "Aktif"],
  [2382, "Sari Kopi (Coffee Juice)", "No", "No", "Aktif"],
  [2383, "Sari Kunyit (Turmeric Juice)", "No", "No", "Aktif"],
  [2384, "Sari Lidah Buaya (Aloe Vera Juice)", "No", "No", "Aktif"],
  [2385, "Sari Malt (Malt Juice)", "No", "No", "Aktif"],
  [2386, "Sari Rosella (Rosella Juice)", "No", "No", "Aktif"],
  [2387, "Sari Rumput Laut (Seaweed Juice)", "No", "No", "Aktif"],
  [2388, "Sari Sayuran (Vegetable Juice)", "No", "No", "Aktif"],
  [2389, "Sari Seledri (Celery Juice)", "No", "No", "Aktif"],
  [2390, "SARI TAPE (TAPAI JUICE)", "No", "No", "Aktif"],
  [2391, "Sari Tebu (Sugar Cane Juice)", "No", "No", "Aktif"],
  [2392, "Sari Tiram (Oyster Juice)", "No", "No", "Aktif"],
  [2393, "Sari Wortel (Carrot Juice)", "No", "No", "Aktif"],
  [2394, "SAUS (SAUCE)", "Yes", "No", "Aktif"],
  [2395, "SAUS BARBEKUE (BARBEQUE SAUCE)", "No", "No", "Aktif"],
  [2396, "SAUS BUAH (FRUIT SAUCE)", "No", "No", "Aktif"],
  [
    2397,
    "Saus Buah Blueberry (Blueberry Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [2398, "Saus Buah Jambu (Guava Sauce)", "No", "No", "Aktif"],
  [
    2399,
    "Saus Buah Markisa (Passion Fruit Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [2400, "Saus Buah Pepaya (Papaya Sauce)", "No", "No", "Aktif"],
  [2401, "Saus Buah Pisang (Banana Sauce)", "No", "No", "Aktif"],
  [
    2402,
    "SAUS BUAH STROBERI (STRAWBERRY SAUCE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2403,
    "Saus Buffalo Style (Buffalo Style Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [2404, "Saus Cabe (Chili Sauce)", "No", "No", "Aktif"],
  [2405, "Saus Coklat (Chocolate Sauce)", "No", "No", "Aktif"],
  [2406, "Saus Durian (Durian Sauce)", "No", "No", "Aktif"],
  [2407, "Saus Ikan (Fish Sauce)", "No", "No", "Aktif"],
  [2408, "Saus Ikan Teri (Anchovy Sauce)", "No", "No", "Aktif"],
  [2409, "Saus Kacang (Peanut Sauce)", "No", "No", "Aktif"],
  [2410, "SAUS KACANG KEDELAI (SOYBEAN SAUCE)", "No", "No", "Aktif"],
  [2411, "SAUS KAPUCINO (CAPPUCINNO SAUCE)", "No", "No", "Aktif"],
  [2412, "SAUS KEJU (CHEESE SAUCE)", "Yes", "Yes", "Aktif"],
  [2413, "SAUS KOPI (COFFEE SAUCE)", "No", "No", "Aktif"],
  [2414, "SAUS TAR TAR (TAR TAR SAUCE)", "No", "No", "Aktif"],
  [2415, "Saus Teriyaki (Teriyaki Sauce)", "No", "No", "Aktif"],
  [2416, "Saus Tiram (Oyster Sauce)", "No", "No", "Aktif"],
  [2417, "Saus Tomat (Tomato Sauce)", "No", "No", "Aktif"],
  [2418, "Saus/ Topping/ Olesan/ Pasta Manis", "No", "No", "Aktif"],
  [2419, "Sawi (Mustard Greens)", "No", "No", "Aktif"],
  [2420, "SAWI PUTIH (CHINESE CABBAGE)", "No", "No", "Aktif"],
  [2421, "Sawo (Sapodilla)", "No", "No", "Aktif"],
  [2422, "Sayap Ayam (Chicken Wing)", "No", "No", "Aktif"],
  [2423, "SAYUR BUBUK (VEGETABLE POWDER)", "No", "No", "Aktif"],
  [2424, "Sayuran Beku (Frozen Vegetable)", "No", "No", "Aktif"],
  [2425, "SAYURAN KERING (DRY VEGETABLE)", "No", "No", "Aktif"],
  [
    2426,
    "Sayuran kering (Kubis, protein nabati tertekstur, bawang putih goreng, wortel)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2427,
    "Sayuran Okra (Abelmoschus esculentus)",
    "No",
    "No",
    "Aktif",
  ],
  [2428, "Scoby", "No", "No", "Aktif"],
  [
    2429,
    "SCUTELLARIA BAICALENSIS (ASIAN SKULLCAP, BAIKAL SKULLCAP, GOLDEN ROOT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2430,
    "Seabuckthorn (Hippophae Rhamnoides L)",
    "No",
    "No",
    "Aktif",
  ],
  [2431, "SEAFOOD KERING (DRY SEAFOOD)", "No", "No", "Aktif"],
  [2432, "Selada (Lettuce)", "No", "No", "Aktif"],
  [
    2433,
    "SELADA AIR (WATERCRESS) (FOLIUM NOSTURTIUM OFFICINALE)",
    "No",
    "No",
    "Aktif",
  ],
  [2434, "SELAI (JAM)", "No", "No", "Aktif"],
  [2435, "Selai Anggur (Grape Jam)", "No", "No", "Aktif"],
  [2436, "Selai Apel (Apple Jam)", "No", "No", "Aktif"],
  [2437, "Selai Aprikot (Apricot Jam)", "No", "No", "Aktif"],
  [2438, "Selai Belimbing (Starfruit Jam)", "No", "No", "Aktif"],
  [2439, "SELAI BLUBERI (BLUEBERRY JAM)", "No", "No", "Aktif"],
  [2440, "Selai Buah-Buahan (Fruits Jam)", "No", "No", "Aktif"],
  [2441, "Selai Ceri (Cherry Jam)", "No", "No", "Aktif"],
  [2442, "SELAI COKELAT (CHOCOLATE JAM)", "No", "No", "Aktif"],
  [2443, "Selai Durian (Durian Jam)", "No", "No", "Aktif"],
  [2444, "Selai Jeruk (Orange Jam)", "No", "No", "Aktif"],
  [2445, "Selai Kacang (Peanut Jam)", "No", "No", "Aktif"],
  [2446, "Selai Kelapa (Coconut Jam)", "No", "No", "Aktif"],
  [2447, "Selai Kiwi (Kiwi Jam)", "No", "No", "Aktif"],
  [2448, "Selai Kurma (Dates Jam)", "No", "No", "Aktif"],
  [2449, "Selai Nanas (Pineapple Jam)", "No", "No", "Aktif"],
  [2450, "Selai Nangka (Jackfruit Jam)", "No", "No", "Aktif"],
  [2451, "Selai Pisang (Banana Jam)", "No", "No", "Aktif"],
  [2452, "Selai Rasberi (Raspberry Jam)", "No", "No", "Aktif"],
  [2453, "SELAI SRIKAYA (SWEETSOP JAM)", "No", "No", "Aktif"],
  [2454, "Selai Stroberi (Strawberry Jam)", "No", "No", "Aktif"],
  [2455, "Selasih (Basil)", "No", "No", "Aktif"],
  [2456, "Seledri (Celery)", "No", "No", "Aktif"],
  [2457, "Seledri Bubuk (Celery Powder)", "No", "No", "Aktif"],
  [2458, "Selenium (Selenium)", "No", "No", "Aktif"],
  [2459, "SELONGSONG SOSIS (SAUSAGE SLEEVE)", "No", "No", "Aktif"],
  [
    2460,
    "Selulase (Cellulase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2461, "Selulosa (Cellulose)", "No", "No", "Aktif"],
  [2462, "Semangka Merah (Red Watermelon)", "No", "No", "Aktif"],
  [2463, "SEMOLINA", "No", "No", "Aktif"],
  [2464, "Seng", "No", "No", "Nonaktif"],
  [2465, "Seng Laktat (Zinc Lactate)", "No", "No", "Aktif"],
  [2466, "Seng Oksida (Zinc Oxide)", "No", "No", "Aktif"],
  [2467, "Seng Sulfat (Zinc Sulphate)", "No", "No", "Aktif"],
  [2468, "SERAT GANDUM (WHEAT FIBER)", "No", "No", "Aktif"],
  [2469, "SERAT LARUT (SOLUBLE FIBER)", "No", "No", "Nonaktif"],
  [
    2470,
    "Serat Larut dari Jagung (Soluble Corn Fiber atau Gluco Fibre)",
    "No",
    "No",
    "Aktif",
  ],
  [2471, "Serat Pangan", "No", "No", "Nonaktif"],
  [2472, "Serat Pangan (Dietary Fiber)", "No", "No", "Aktif"],
  [2473, "Serat Sayuran (Vegetable Fiber)", "No", "No", "Aktif"],
  [2474, "Serbu Sari Buah Raspberi", "No", "No", "Nonaktif"],
  [
    2475,
    "Serbuk Kale (Brassica Oleracea L.var. acephala)",
    "No",
    "No",
    "Aktif",
  ],
  [2476, "Serbuk Minuman", "No", "No", "Aktif"],
  [2477, "Serbuk Sari (Pollen)", "No", "No", "Aktif"],
  [2478, "Sereal (Cereal)", "No", "No", "Aktif"],
  [2479, "Sereal Beras (Rice Cereal)", "No", "No", "Aktif"],
  [2480, "Sereal Gandum (Wheat Cereal)", "No", "No", "Aktif"],
  [
    2481,
    "Sereal Gandum Utuh (Whole Wheat Cereal)",
    "No",
    "No",
    "Aktif",
  ],
  [2482, "Sereal Jagung (Corn Cereal)", "No", "No", "Aktif"],
  [2483, "Serealia (Cerealia)", "No", "No", "Aktif"],
  [
    2484,
    "SEREH (LEMON GRASS-CYMBOPOGON NARDUS)",
    "No",
    "No",
    "Aktif",
  ],
  [2485, "Sereh Bubuk (Lemongrass Powder)", "No", "No", "Aktif"],
  [
    2486,
    "Serin Proteinase (Serine Proteinase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2487, "SERPIHAN KENTANG (POTATO FLAKES)", "No", "No", "Aktif"],
  [2488, "Serundeng Ikan (Fish Serundeng)", "No", "No", "Aktif"],
  [
    2489,
    "Siklodekstrin glukotransferase (Cyclodextrin glucanotransferase (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2490,
    "Silver Needle-yingzhen (white tea)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2491, "SINGKONG - UBI KAYU (CASSAVA)", "No", "No", "Aktif"],
  [2492, "Singkong Bubuk (Cassava Powder)", "No", "No", "Aktif"],
  [2493, "SIOMAY", "Yes", "No", "Nonaktif"],
  [2494, "SIRIH (BETEL)", "No", "No", "Nonaktif"],
  [2495, "SIRIH EKSTRAK (PIPER BETLE L.)", "No", "No", "Nonaktif"],
  [2496, "Sirip Ikan Hiu (Shark Fins)", "No", "No", "Aktif"],
  [2497, "Sirsak (Soursop)", "No", "No", "Aktif"],
  [2498, "Sirup (Syrup)", "No", "No", "Aktif"],
  [2499, "Sirup Agave (Agave Syrup)", "No", "No", "Aktif"],
  [2500, "Sirup Anggur (Grape Syrup)", "No", "No", "Aktif"],
  [
    2501,
    "Sirup Barley Malt (Barley Malt Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2502, "Sirup Beras (Rice Syrup)", "No", "No", "Aktif"],
  [
    2503,
    "Sirup Beras Merah (Brown Rice Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2504,
    "Sirup Cokelat Malt (Chocolate Malt Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2505, "Sirup Fruktosa (Fructose Syrup)", "No", "No", "Aktif"],
  [
    2506,
    "SIRUP FRUKTOSA JAGUNG (FRUCTOSE CORN SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [2507, "Sirup Glukosa", "No", "No", "Nonaktif"],
  [2508, "Sirup Glukosa (Glucose Syrup)", "No", "No", "Aktif"],
  [
    2509,
    "SIRUP GLUKOSA - FRUKTOSA (GLUCOSE - FRUCTOSE SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2510,
    "SIRUP GLUKOSA BUBUK (GLUCOSE POWDER SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [2511, "Sirup Grenadine (Grenadine Syrup)", "No", "No", "Aktif"],
  [2512, "Sirup Gula (Sugar Syrup)", "No", "No", "Aktif"],
  [
    2513,
    "Sirup Gula Invert (Invert Sugar Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2514,
    "SIRUP GULA JAGUNG (CORN SUGAR SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2515,
    "Sirup Gula Merah (Brown Sugar Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2516,
    "SIRUP GULA TERKARAMELISASI (CARAMELIZED SUGAR SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [2517, "Sirup Jagung (Corn Syrup)", "No", "No", "Aktif"],
  [
    2518,
    "Sirup Jagung Fruktosa (Fructose Corn Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2519,
    "Sirup Jagung Padat (Corn Syrup Solid)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2520,
    "Sirup Jagung Tinggi Fruktosa (High Fructose Corn Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2521,
    "Sirup Jagung Tinggi Maltosa (High Maltose Corn Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2522, "Sirup Jahe (Ginger Syrup)", "No", "No", "Aktif"],
  [2523, "Sirup Karamel (Caramel Syrup)", "No", "No", "Aktif"],
  [2524, "Sirup Kelengkeng (Longan Syrup)", "No", "No", "Aktif"],
  [2525, "Sirup Kiwi (Kiwi Syrup)", "No", "No", "Aktif"],
  [2526, "Sirup Kurma (Dates Syrup)", "No", "No", "Aktif"],
  [2527, "Sirup Malt (Malt Syrup)", "No", "No", "Aktif"],
  [2528, "SIRUP MAPEL (MAPLE SYRUP)", "No", "No", "Aktif"],
  [2529, "Sirup Melon (Melon Syrup)", "No", "No", "Aktif"],
  [2530, "Sirup Semangka (Watermelon Syrup)", "No", "No", "Aktif"],
  [2531, "Sirup Stroberi (Strawberry Syrup)", "No", "No", "Aktif"],
  [2532, "Sirup Sukrosa (Sucrose Syrup)", "No", "No", "Aktif"],
  [2533, "SIRUP TAPIOKA (TAPIOCA SYRUP)", "No", "No", "Aktif"],
  [
    2534,
    "Sirup Tinggi Fruktosa (High Fructose Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2535, "Sistein (Cysteine)", "No", "No", "Aktif"],
  [2536, "Sistin (Cystine)", "No", "No", "Aktif"],
  [
    2537,
    "SITIDIN 5'-MONOFOSFAT (CYTIDINE 5'-MONOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [2538, "Sitrulin Malat", "No", "No", "Aktif"],
  [2539, "SIWALAN (SIWALAN)", "No", "No", "Aktif"],
  [2540, "SOBA (BUCKWHEAT)", "No", "No", "Nonaktif"],
  [2541, "Soda (Soda)", "No", "No", "Aktif"],
  [2542, "SODA BUBUK (SODA POWDER)", "No", "No", "Nonaktif"],
  [2543, "Soda Krim (Cream Soda)", "No", "No", "Aktif"],
  [2544, "Sohun-Soun (Vermicelli)", "No", "No", "Aktif"],
  [2545, "Sorgum (Sorghum)", "No", "No", "Aktif"],
  [2546, "Sosis Ayam (Chicken Sausage)", "No", "No", "Aktif"],
  [2547, "Sosis Babi (Pork Sausage)", "No", "No", "Aktif"],
  [2548, "Sosis Ikan (Fish Sausage)", "No", "No", "Aktif"],
  [2549, "Sosis Sapi (Beef Sausage)", "No", "No", "Aktif"],
  [2550, "Sotong (Cuttlefish)", "No", "No", "Aktif"],
  [2551, "Sotong Bubuk (Cuttlefish Powder)", "No", "No", "Aktif"],
  [2552, "Spagheti (Spaghetti)", "No", "No", "Aktif"],
  [2553, "Spearmint (Spearmint)", "No", "No", "Aktif"],
  [2554, "Spelt (Triticum spelta)", "No", "No", "Aktif"],
  [2555, "SPINGOMIELIN (SPHINGOMYELIN)", "No", "No", "Nonaktif"],
  [2556, "Spirit (Spirit)", "No", "No", "Aktif"],
  [2557, "Spirit Air Nira (Sap Water Spirit)", "No", "No", "Aktif"],
  [2558, "Spirit Anggur (Grape Spirit)", "No", "No", "Aktif"],
  [2559, "Spirit Beras (Rice Spirit)", "No", "No", "Aktif"],
  [
    2560,
    "Spirit Beras Ketan (Glutinous Rice Spirit)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2561,
    "Spirit Buah Nanas (Pineapple Spirit)",
    "No",
    "No",
    "Aktif",
  ],
  [2562, "Spirit Buah Pepaya (Papaya Spirit)", "No", "No", "Aktif"],
  [2563, "Spirit Buah Tomat (Tomato Spirit)", "No", "No", "Aktif"],
  [2564, "Spirit Gula (Sugar Spirit)", "No", "No", "Aktif"],
  [
    2565,
    "Spirit Gula Merah (Brown Sugar Spirit)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2566,
    "SPIRIT HASIL FERMENTASI MOLASES (FERMENTED MOLASES SPIRIT)",
    "No",
    "No",
    "Aktif",
  ],
  [2567, "Spirit Jeruk (Orange Spirit)", "No", "No", "Aktif"],
  [2568, "Spirit Lontar (Palmyra Spirit)", "No", "No", "Aktif"],
  [2569, "Spirulina (Spirulina)", "No", "No", "Aktif"],
  [2570, "Spirulina Bubuk (Spirulina Powder)", "No", "No", "Aktif"],
  [
    2571,
    "SQUASH BERPERISA ANGGUR (GRAPE FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2572,
    "SQUASH BERPERISA JERUK (ORANGE FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [2573, "Squash Berperisa Kelapa ", "No", "No", "Aktif"],
  [
    2574,
    "SQUASH BERPERISA LECI (LYCHEE FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2575,
    "SQUASH BERPERISA STROBERI  (STRAWBERRY FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [2576, "SRIKAYA (ANNONA SQUAMOSA)", "No", "No", "Aktif"],
  [
    2577,
    "STARTER YOGHURT (YOGHURT STARTER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2578, "Stearin (Stearine)", "No", "No", "Aktif"],
  [
    2579,
    "Stearin Inti Buah Rafinasi (Refined Kernel Stearine)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2580,
    "Stearin Inti Kelapa Sawit Hidrogenasi (Hydrogenated Palm Kernel Stearine)",
    "No",
    "No",
    "Aktif",
  ],
  [2581, "Stem Bromelain (Bahan Penolong)", "No", "No", "Aktif"],
  [2582, "STEVIA (STEVIA)", "No", "No", "Nonaktif"],
  [2583, "Streptococcus cremoris", "No", "No", "Aktif"],
  [2584, "Streptococcus lactis", "No", "No", "Aktif"],
  [2585, "Streptococcus thermophilus", "No", "No", "Aktif"],
  [
    2586,
    "Subtilisin (Subtilisin) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2587, "SUCCUS LIQUIRITIAE", "No", "No", "Nonaktif"],
  [2588, "succus liquirities", "No", "No", "Nonaktif"],
  [2589, "SUJI (DRACAENA ANGUSTIFOLIA)", "No", "No", "Aktif"],
  [2590, "Sukade (Sukade)", "No", "No", "Aktif"],
  [2591, "Sukade Pepaya (Papaya Sukade)", "No", "No", "Aktif"],
  [2592, "Sukromalt (sucromalt)", "No", "No", "Aktif"],
  [2593, "Sukrosa (Sucrose)", "No", "No", "Aktif"],
  [2594, "Sultana (Sultana)", "No", "No", "Aktif"],
  [2595, "Sup (Soup)", "No", "No", "Aktif"],
  [2596, "Sup Apel (Apple Soup)", "No", "No", "Aktif"],
  [2597, "Sup Daging (Meat Soup)", "No", "No", "Aktif"],
  [2598, "Surimi (Surimi)", "No", "No", "Aktif"],
  [2599, "SUSU (MILK)", "No", "No", "Nonaktif"],
  [2600, "SUSU BUBUK (MILK POWDER)", "No", "Yes", "Aktif"],
  [
    2601,
    "SUSU BUBUK FULL CREAM (FULL CREAM MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2602, "Susu Bubuk Lemak/Minyak Nabati", "No", "No", "Aktif"],
  [
    2603,
    "SUSU BUBUK RENDAH LEMAK (LOW FAT MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2604,
    "SUSU BUBUK TANPA LEMAK ATAU SUSU SKIM BUBUK (SKIMMED MILK POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2605, "SUSU CAIR (LIQUID MILK)", "No", "Yes", "Aktif"],
  [2606, "SUSU COKLAT (CHOCOLATE MILK)", "No", "Yes", "Aktif"],
  [
    2607,
    "SUSU COKLAT BUBUK (CHOCOLATE MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2608, "SUSU EVAPORASI (EVAPORATED MILK)", "No", "Yes", "Aktif"],
  [2609, "SUSU FERMENTASI (FERMENTED MILK)", "No", "Yes", "Aktif"],
  [2610, "Susu Full Cream (Full Cream Milk)", "No", "No", "Aktif"],
  [2611, "Susu Kambing (Goat's Milk)", "No", "No", "Aktif"],
  [
    2612,
    "Susu Kambing Bubuk (Goat's Milk Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2613,
    "SUSU KAMBING FULL CREAM BUBUK (FULL CREAM GOAT'S MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2614,
    "SUSU KAMBING SKIM BUBUK (SKIM GOAT'S MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2615, "SUSU KENTAL  (CONDENSED MILK)", "No", "Yes", "Aktif"],
  [
    2616,
    "SUSU KENTAL MANIS (SWEETENED CONDENSED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2617,
    "SUSU KENTAL TIDAK MANIS (UNSWEETENED CONDENSED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2618, "SUSU KERBAU (BUFFALO MILK)", "No", "Yes", "Aktif"],
  [2619, "SUSU KUDA (HORSE MILK)", "No", "Yes", "Aktif"],
  [
    2620,
    "Susu Lemak Nabati-Susu Minyak Nabati (Filled Milk)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2621,
    "SUSU PASTEURISASI (PASTEURIZED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2622, "SUSU RENDAH LEMAK (LOW FAT MILK)", "No", "Yes", "Aktif"],
  [2623, "Susu Sapi (Cow Milk)", "No", "No", "Aktif"],
  [2624, "SUSU SEGAR (FRESH MILK)", "No", "Yes", "Aktif"],
  [2625, "SUSU SKIM (SKIM MILK)", "No", "Yes", "Aktif"],
  [
    2626,
    "SUSU SKIM BUBUK (SKIMMED MILK POWDER)",
    "No",
    "Yes",
    "Nonaktif",
  ],
  [
    2627,
    "SUSU SKIM COKLAT (SKIM MILK CHOCOLATE)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2628,
    "SUSU SKIM KENTAL MANIS (SWEETENED CONDENSED SKIMMED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2629,
    "SUSU TANPA LEMAK ATAU SUSU SKIM (SKIMMED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2630, "SUSU UHT (UHT MILK)", "No", "Yes", "Aktif"],
  [2631, "Taburan Berbasis Gula", "No", "No", "Aktif"],
  [2632, "Tahini (Tahini)", "No", "No", "Aktif"],
  [2633, "Tahu (Tofu)", "No", "No", "Aktif"],
  [2634, "Tahu Goreng (Fried Tofu)", "No", "No", "Aktif"],
  [2635, "TAHU KERING (DRIED TOFU)", "No", "No", "Aktif"],
  [2636, "TAHU MATANG", "No", "No", "Nonaktif"],
  [2637, "TALAS (TARO)", "No", "No", "Nonaktif"],
  [2638, "TANGKAI TERATAI (LOTUS STEM)", "No", "No", "Nonaktif"],
  [2639, "Tannase (Tannase) (Bahan Penolong)", "No", "No", "Aktif"],
  [2640, "TAOGE (BEAN SPROUTS)", "No", "No", "Aktif"],
  [2641, "TAPAI BERAS (FERMENTED RICE)", "No", "No", "Aktif"],
  [2642, "TAPAI KETAN (FERMENTED STILKY RICE)", "No", "No", "Aktif"],
  [2643, "tapioka ", "No", "No", "Nonaktif"],
  [2644, "Tarako Bubuk (Tarako Powder)", "No", "No", "Aktif"],
  [2645, "Tartazine (cl.19140)", "No", "No", "Nonaktif"],
  [2646, "TAUCO (TAUCO)", "No", "No", "Aktif"],
  [2647, "TAURIN (TAURINE)", "No", "No", "Aktif"],
  [2648, "Tebu", "No", "No", "Nonaktif"],
  [2649, "Tebu (Cane)", "No", "No", "Aktif"],
  [2650, "TEH (TEA)", "No", "No", "Nonaktif"],
  [2651, "Teh Bubuk", "No", "No", "Nonaktif"],
  [2652, "Teh Bubuk (Tea Powder)", "No", "No", "Aktif"],
  [2653, "Teh Earl Grey (Earl Grey Tea)", "No", "No", "Aktif"],
  [2654, "Teh Hijau (Green Tea)", "No", "No", "Aktif"],
  [2655, "Teh Hijau Bubuk (Green Tea Powder)", "No", "No", "Aktif"],
  [
    2656,
    "Teh Hijau Melati (Green Tea Jasmine)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2657,
    "Teh Hijau Panggang (Roasted Green Tea)",
    "No",
    "No",
    "Aktif",
  ],
  [2658, "Teh Hitam (Black Tea Leaf)", "No", "No", "Aktif"],
  [2659, "Teh Hitam Ceylon (Black Tea Ceylon)", "No", "No", "Aktif"],
  [
    2660,
    "Teh Hitam Melati (Jasmine Black Tea)",
    "No",
    "No",
    "Aktif",
  ],
  [2661, "Teh Instan (Instant Tea)", "No", "No", "Aktif"],
  [
    2662,
    "TEH JAWA (ORTHOSIPHON STAMINEUS; ORTHOSIPHON ARISTATUS; ORTHOSIPHON SPICATUS; ORTHOSIPHONBLAETTER; JAVATEE, INDISCHER NIERENTEE, FEUILLES DE BARBIFLORE; DE JAVA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2663, "TEH KERING (DRIED TEA)", "No", "No", "Nonaktif"],
  [2664, "Teh Melati (Jasmine Tea)", "No", "No", "Aktif"],
  [2665, "Teh Oolong (Oolong Tea)", "No", "No", "Aktif"],
  [2666, "Teh Putih (White Tea)", "No", "No", "Aktif"],
  [
    2667,
    "TEH ROOIBOSA&nbsp;(ASPHALATUS LINEARIS)",
    "No",
    "No",
    "Aktif",
  ],
  [2668, "Telur", "No", "No", "Nonaktif"],
  [2669, "TELUR (EGG)", "No", "Yes", "Aktif"],
  [2670, "TELUR ASIN (SALTED EGG)", "No", "No", "Aktif"],
  [2671, "TELUR AYAM (CHICKEN EGG)", "No", "No", "Aktif"],
  [2672, "TELUR AYAM NEGERI UTUH", "No", "No", "Nonaktif"],
  [2673, "TELUR BEBEK (DUCK EGG)", "No", "No", "Aktif"],
  [2674, "Telur Bubuk (Whole Egg Powder)", "No", "No", "Aktif"],
  [2675, "Telur Ikan (Fish Egg)", "No", "No", "Aktif"],
  [2676, "Telur Puyuh (Quail Egg)", "No", "No", "Aktif"],
  [2677, "TEMBAGA GLUKONAT (COPPER GLUCONAT)", "No", "No", "Aktif"],
  [2678, "Tembaga Sulfat (Copper Sulfate)", "No", "No", "Aktif"],
  [2679, "Tempe", "No", "No", "Aktif"],
  [2680, "Tempe Goreng (Fried Tempe)", "No", "No", "Aktif"],
  [2681, "TEMPE MATANG", "No", "No", "Nonaktif"],
  [2682, "Tempura (Tempura)", "No", "No", "Aktif"],
  [
    2683,
    "TEMU KUNCI (CURCUMA ROTUNDA, BOESENBERGIA ROTUNDA (L) MANSF)",
    "No",
    "No",
    "Aktif",
  ],
  [2684, "TEMULAWAK (CURCUMA XANTHORRHIZA)", "No", "No", "Aktif"],
  [
    2685,
    "TEPUNG AGAR-AGAR (AGAR-AGAR POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2686, "Tepung Amaranth", "No", "No", "Aktif"],
  [
    2687,
    "TEPUNG ARARUT/TEPUNG GARUT (ARROWROOT FLOUR)",
    "No",
    "No",
    "Aktif",
  ],
  [2688, "Tepung Aren (Sugar Palm Powder)", "No", "No", "Aktif"],
  [2689, "Tepung Barley (Barley Flour)", "No", "No", "Aktif"],
  [
    2690,
    "Tepung Barley Malt (Barley Malt Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2691, "TEPUNG BATTER", "No", "No", "Aktif"],
  [2692, "Tepung Beras", "No", "No", "Nonaktif"],
  [2693, "Tepung Beras (Rice Flour)", "No", "No", "Aktif"],
  [
    2694,
    "Tepung Beras Cokelat (Brown Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2695, "Tepung Beras Hitam", "No", "No", "Aktif"],
  [
    2696,
    "Tepung Beras Ketan (Glutinous Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2697,
    "Tepung Beras Merah (Brown Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2698, "Tepung Biji Rami (Flaxseed Flour)", "No", "No", "Aktif"],
  [
    2699,
    "Tepung Bran Gandum (Wheat Bran Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2700, "Tepung Breader", "No", "No", "Aktif"],
  [2701, "Tepung Buckwheat (Buckwheat Flour)", "No", "No", "Aktif"],
  [2702, "Tepung Bumbu (Seasoning Powder)", "No", "No", "Aktif"],
  [
    2703,
    "Tepung Bumbu Ayam Goreng (Fried Chicken Seasoning Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2704, "TEPUNG DHAL (HUSKED DEW GRAM FLOUR)", "No", "No", "Aktif"],
  [2705, "TEPUNG DURUM ", "No", "No", "Aktif"],
  [2706, "Tepung Gandum (Wheat Flour)", "No", "No", "Aktif"],
  [2707, "Tepung Gandum Hitam (Rye Flour)", "No", "No", "Aktif"],
  [
    2708,
    "Tepung Gandum Hitam Terfermentasi (Fermented Rye Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2709, "Tepung Gandum Semolina ", "No", "No", "Nonaktif"],
  [
    2710,
    "Tepung Gandum Semolina (Semolina Wheat Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2711,
    "Tepung Gandum Utuh (Whole Wheat Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2712, "Tepung Gaplek (Cassava Flour)", "No", "No", "Aktif"],
  [
    2713,
    "Tepung Glukomanan (Glucomannan Flour)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2714, "Tepung Gluten (Gluten Flour)", "No", "No", "Aktif"],
  [2715, "Tepung Iles-Iles", "No", "No", "Aktif"],
  [2716, "Tepung Jagung (Corn Flour)", "No", "No", "Aktif"],
  [
    2717,
    "Tepung Jagung Modifikasi (Modified Corn Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2718,
    "Tepung Jagung Ungu (Purple Corn Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2719, "Tepung Jamur (Mushroom Flour)", "No", "No", "Aktif"],
  [2720, "Tepung Kacang (Peanut Flour)", "No", "No", "Aktif"],
  [
    2721,
    "TEPUNG KACANG ARAB - TEPUNG GARBANZO (CHICKPEA - GARBANZO FLOUR)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2722,
    "Tepung Kacang Chena (Chena Bean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2723,
    "Tepung Kacang Hijau (Mungbean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2724,
    "Tepung Kacang Kedelai (Soybean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2725,
    "Tepung Kacang Koro (Broad Bean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2726,
    "Tepung Kacang Merah (Red Bean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2727,
    "Tepung Kacang Mete (Cashew Nut Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2728, "Tepung Kacang Polong (Pea Flour)", "No", "No", "Aktif"],
  [2729, "TEPUNG KAMUT", "No", "No", "Nonaktif"],
  [2730, "Tepung Kanji (Starch)", "No", "No", "Aktif"],
  [2731, "TEPUNG KEDELAI (SOY FLOUR)", "No", "No", "Nonaktif"],
  [2732, "Tepung Kelapa (Coconut Flour)", "No", "No", "Aktif"],
  [
    2733,
    "Tepung Kencur (Kaempferia galanga Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2734, "Tepung Kentang (Potato Flour)", "No", "No", "Aktif"],
  [2735, "Tepung Kerang (Shell Flour)", "No", "No", "Aktif"],
  [
    2736,
    "TEPUNG KETAN (GLUTINOUS RICE FLOUR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2737,
    "Tepung Ketan Hitam (Black Glutinous Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2738,
    "Tepung Ketan Putih (White Glutinous Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2739, "TEPUNG KONJAC", "Yes", "No", "Nonaktif"],
  [2740, "TEPUNG KONNYAKU (KONJAC FLOUR)", "No", "No", "Aktif"],
  [2741, "TEPUNG KONYAKU (KONYAKU FLOUR)", "No", "No", "Nonaktif"],
  [2742, "Tepung Kue (Cake Flour)", "No", "No", "Aktif"],
  [2743, "Tepung Lobak (Rapeseed Flour)", "No", "No", "Aktif"],
  [2744, "Tepung Maizena", "No", "No", "Nonaktif"],
  [2745, "Tepung Malt (Malt Flour)", "No", "No", "Aktif"],
  [2746, "Tepung mazena", "No", "No", "Nonaktif"],
  [2747, "Tepung Muffin (Muffin Flour)", "No", "No", "Aktif"],
  [
    2748,
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    "No",
    "No",
    "Aktif",
  ],
  [2749, "Tepung Olahan Pra&nbsp;Masak", "No", "No", "Aktif"],
  [2750, "Tepung Panir (Panir Flour)", "No", "No", "Aktif"],
  [2751, "Tepung Premiks (Premix Flour)", "No", "No", "Aktif"],
  [
    2752,
    "Tepung Premiks Es Krim (Ice Cream Base)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [2753, "Tepung Quinoa (Quinoa Flour)", "No", "No", "Aktif"],
  [2754, "Tepung Roti (Bread Crumb)", "No", "No", "Aktif"],
  [2755, "Tepung Roti (Bread Flour)", "No", "No", "Aktif"],
  [2756, "Tepung Rumput laut", "No", "No", "Nonaktif"],
  [2757, "Tepung Rye (Rye Flour)", "No", "No", "Aktif"],
  [2758, "Tepung Sagu (Sago Flour)", "No", "No", "Aktif"],
  [2759, "Tepung Semolina (Semolina Flour)", "No", "No", "Aktif"],
  [2760, "Tepung Singkong (Cassava Flour)", "No", "No", "Aktif"],
  [2761, "Tepung Sorgum (Sorghum Flour)", "No", "No", "Aktif"],
  [2762, "Tepung Spelt (Spelt flour)", "No", "No", "Aktif"],
  [2763, "Tepung Talas (Taro Powder)", "No", "No", "Aktif"],
  [2764, "TEPUNG TAPIOKA", "No", "No", "Nonaktif"],
  [2765, "TEPUNG TELUR", "No", "Yes", "Aktif"],
  [2766, "Tepung Tempura (Tempura Flour)", "No", "No", "Aktif"],
  [2767, "TEPUNG TERIGU (WHEAT FLOUR)", "No", "No", "Aktif"],
  [
    2768,
    "Tepung Terigu Diperkaya (Enriched Flour)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2769,
    "Tepung Terigu Protein Rendah (Low Protein Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2770,
    "Tepung Terigu Protein Sedang (Cake Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2771,
    "Tepung Terigu Protein Tinggi (High Protein Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2772,
    "TEPUNG TERIGU SEMOLINA (SEMOLINA FLOUR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2773,
    "Tepung Terigu Terfermentasi (Fermented Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2774, "TEPUNG UBI (CASSAVA FLOUR)", "No", "No", "Nonaktif"],
  [
    2775,
    "Tepung Ubi Jalar (Sweet Potato Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2776,
    "Tepung Ubi Jalar Ungu (Violet Sweet Potato Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2777, "Tequila (Tequilla)", "No", "No", "Aktif"],
  [2778, "Terasi - Belacan (Paste)", "No", "No", "Aktif"],
  [
    2779,
    "Terasi - Belacan Udang (Shrimp Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2780,
    "TERIPANG LAUT (SEA CUCUMBERS - HOLOTHUROIDEA)",
    "No",
    "No",
    "Aktif",
  ],
  [2781, "Terong (Eggplant)", "No", "No", "Aktif"],
  [2782, "TESTING", "Yes", "No", "Nonaktif"],
  [2783, "TETES TEBU (MOLASES, TREACLE)", "No", "No", "Aktif"],
  [2784, "THIAMIN MONONITRAT", "No", "No", "Nonaktif"],
  [2785, "Thixogums", "No", "No", "Nonaktif"],
  [2786, "TIAMIN MONONITRAT (VIT B1)", "No", "No", "Nonaktif"],
  [2787, "TIMI (THYME - THYMUS VULGARIS)", "No", "No", "Aktif"],
  [
    2788,
    "TIMI BUBUK (THYME - THYMUS VULGARIS POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2789, "Tinta Cumi (Squid Ink)", "No", "No", "Aktif"],
  [2790, "Tiram (Oyster)", "No", "No", "Aktif"],
  [2791, "Tiramisu (Tiramisu)", "No", "No", "Aktif"],
  [2792, "Tirosin (Thyrosin)", "No", "No", "Aktif"],
  [2793, "TOFFEE", "No", "No", "Nonaktif"],
  [2794, "Tomat (Tomato)", "No", "No", "Aktif"],
  [2795, "Tomat Bubuk  (Tomato Powder)", "No", "No", "Aktif"],
  [2796, "Tomat Cincang (Chopped Tomato)", "No", "No", "Aktif"],
  [2797, "Tomat Hijau (Green Tomato)", "No", "No", "Aktif"],
  [2798, "Tomat Kering (Dried Tomato)", "No", "No", "Aktif"],
  [2799, "Tomat Kupas (Peeled Tomato)", "No", "No", "Aktif"],
  [
    2800,
    "TONGKAT ALI BUBUK (EURYCOMA LONGIFOLIA POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2801, "TOPPING", "No", "No", "Aktif"],
  [2802, "Torbangun (Mexican mint)", "No", "No", "Aktif"],
  [
    2803,
    "Transglutaminase (Transglutaminase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [2804, "TREHALOSA (TREHALOSE DIHYDRATE)", "No", "No", "Aktif"],
  [2805, "TREONIN (THREONINE)", "No", "No", "Aktif"],
  [2806, "TRIBULUS", "No", "No", "Nonaktif"],
  [
    2807,
    "Trigliserida Rantai Menengah (Medium-Chain Triglyceride MCT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2808,
    "Trikalium fosfat (Tripotassium orthophosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2809,
    "trikalium sitrat (tripotassium citrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2810,
    "Trikalium Sitrat Monohidrat (Tripotassium Citrate Monohydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2811,
    "Trikalsium Fosfat (Tricalcium Phosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2812,
    "trikalsium sitrat (Tricalcium citrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2813,
    "Trimagnesium sitrat anhidrat (Trimagnesium Citrate Anhydrous)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2814,
    "TRINATRIUM FOSFAT (TRISODIUM ORTHOPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2815,
    "TRINATRIUM FOSFAT (TRISODIUM OTRHOPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2816,
    "TRINATRIUM SITRAT  (TRISODIUM CITRATE) (KECUALI MP ASI)",
    "No",
    "No",
    "Aktif",
  ],
  [2817, "Tripsin (Trypsin) (Bahan Penolong)", "No", "No", "Aktif"],
  [2818, "Triptofan (Triptophan)", "No", "No", "Aktif"],
  [2819, "Triticale", "No", "No", "Aktif"],
  [2820, "Truffle (Truffle)", "No", "No", "Aktif"],
  [2821, "Tulang Ayam (Chicken Bone)", "No", "No", "Aktif"],
  [2822, "Tulang Babi (Pig Bone)", "No", "No", "Aktif"],
  [2823, "Tulang Ikan Salmon (Salmon Bone)", "No", "No", "Aktif"],
  [
    2824,
    "Tulang Muda Ikan Hiu Bubuk (Cartilage Shark Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2825, "Tulang Sapi (Cow Bone)", "No", "No", "Aktif"],
  [2826, "Tuna Bubuk (Tuna Powder)", "No", "No", "Aktif"],
  [2827, "TVP (Texturized Vegetable Protein)", "No", "No", "Aktif"],
  [2828, "UBI JALAR (SWEET POTATO)", "No", "No", "Aktif"],
  [2829, "Ubi Jepang (Japanese Yam)", "No", "No", "Aktif"],
  [2830, "UBI KAYU (CASSAVA)", "No", "No", "Nonaktif"],
  [2831, "UBI MADU (SWEET HONEY POTATO)", "No", "No", "Aktif"],
  [2832, "Ubi Merah ", "No", "No", "Aktif"],
  [2833, "UBI RAMBAT (YAM)", "No", "No", "Nonaktif"],
  [2834, "UBI UNGU (PURPLE SWEET POTATO)", "No", "No", "Aktif"],
  [
    2835,
    "Ubikuinon (Ubiquinone/Coen zyme Q10)",
    "No",
    "No",
    "Aktif",
  ],
  [2836, "Ubur-Ubur (Jellyfish)", "No", "No", "Aktif"],
  [2837, "Udang  Bubuk (Shrimp Powder)", "No", "No", "Aktif"],
  [2838, "UDANG (FRESH PRAWN)", "No", "No", "Aktif"],
  [2839, "Udang (Shrimp)", "No", "No", "Aktif"],
  [2840, "Udang Kering - Ebi (Dried Shrimp)", "No", "No", "Aktif"],
  [2841, "Udang Rebon (Shrimp Rebon)", "No", "No", "Aktif"],
  [2842, "Umbi Ganyong (Canna indica)", "No", "No", "Aktif"],
  [2843, "UMBI KONNYAKU (KONJAC)", "No", "No", "Aktif"],
  [2844, "Urease (Urease) (Bahan Penolong)", "No", "No", "Aktif"],
  [2845, "Usus Ayam", "No", "No", "Aktif"],
  [2846, "Usus Babi", "No", "No", "Aktif"],
  [2847, "Usus Kambing", "No", "No", "Aktif"],
  [2848, "Usus Sapi (Cow Intestines)", "No", "No", "Aktif"],
  [
    2849,
    "UVA URSI POWDER (ARCTISTAPHYLOS UVA URSI)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2850, "Valin", "Yes", "Yes", "Aktif"],
  [2851, "VANILA", "No", "No", "Nonaktif"],
  [2852, "VANILIN", "No", "No", "Nonaktif"],
  [2853, "Vitamin A (Retinal)", "No", "No", "Aktif"],
  [
    2854,
    "Vitamin A (Retinal) - Khusus Produk Wajib SNI",
    "No",
    "No",
    "Aktif",
  ],
  [2855, "VITAMIN A ASETAT", "No", "No", "Aktif"],
  [2856, "Vitamin A Palmitat", "No", "No", "Aktif"],
  [
    2857,
    "Vitamin A Palmitat - Khusus Produk Wajib SNI",
    "No",
    "No",
    "Aktif",
  ],
  [2858, "VITAMIN B", "No", "No", "Nonaktif"],
  [2859, "Vitamin B1 (Thiamine)", "No", "No", "Aktif"],
  [2860, "VITAMIN B10", "No", "No", "Nonaktif"],
  [2861, "Vitamin B12 (Cyanocobalamin)", "No", "No", "Aktif"],
  [2862, "Vitamin B2 (Riboflavin)", "No", "No", "Aktif"],
  [
    2863,
    "VITAMIN B3 (NIACINAMIDE)(NICOTINAMIDE)",
    "No",
    "No",
    "Aktif",
  ],
  [2864, "Vitamin B5 (Pantothenic Acid)", "No", "No", "Aktif"],
  [
    2865,
    "Vitamin B6 (Pyridoxine Hydrochloride)",
    "No",
    "No",
    "Aktif",
  ],
  [2866, "Vitamin B7 (Biotin)", "No", "No", "Aktif"],
  [2867, "VITAMIN B8 (INOSITOL)", "No", "No", "Aktif"],
  [2868, "Vitamin B9 (Folic Acid)", "No", "No", "Aktif"],
  [2869, "Vitamin C (Ascorbic Acid)", "No", "No", "Aktif"],
  [2870, "VITAMIN D ", "No", "No", "Nonaktif"],
  [2871, "VITAMIN D1", "No", "No", "Nonaktif"],
  [2872, "Vitamin D2 (Ergocalciferol)", "No", "No", "Aktif"],
  [2873, "Vitamin D3 (Cholecalciferol)", "No", "No", "Aktif"],
  [2874, "Vitamin E (Tocopherol)", "No", "No", "Aktif"],
  [2875, "VITAMIN E ASETAT", "No", "No", "Aktif"],
  [2876, "VITAMIN H (BIOTIN)", "No", "No", "Nonaktif"],
  [2877, "VITAMIN K", "No", "No", "Nonaktif"],
  [2878, "Vitamin K1 (Phytomenadione)", "No", "No", "Aktif"],
  [2879, "VITAMIN K2 (MENAQUINONE)", "No", "No", "Aktif"],
  [2880, "Vodka (Vodka)", "No", "No", "Aktif"],
  [2881, "WAFER", "No", "No", "Aktif"],
  [2882, "WAFER CONE", "No", "No", "Aktif"],
  [2883, "Wakame (Wakame)", "No", "No", "Aktif"],
  [2884, "WALNUT (WALNUT)", "No", "No", "Nonaktif"],
  [2885, "Wasabi (Wasabi)", "No", "No", "Aktif"],
  [2886, "Wasabi Bubuk (Wasabi Powder)", "No", "No", "Aktif"],
  [2887, "WATER CHESNUT", "Yes", "Yes", "Aktif"],
  [2888, "WAX (WAX)", "No", "No", "Nonaktif"],
  [2889, "Waxberry (Waxberry)", "No", "No", "Aktif"],
  [2890, "Wheat grass (Triticum aestirum)", "No", "No", "Aktif"],
  [2891, "Whey (Whey)", "No", "No", "Aktif"],
  [2892, "Whey Bubuk (Whey Powder)", "No", "No", "Aktif"],
  [
    2893,
    "Whey Demineralisasi (Whey Demineralization)",
    "No",
    "No",
    "Aktif",
  ],
  [2894, "Whey Protein (Whey Protein)", "No", "No", "Aktif"],
  [
    2895,
    "Whey Protein Demineralisasi (Whey Protein Demineralization)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2896,
    "Whey Protein Konsentrat (Whey Protein Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [2897, "Whipping Cream (Whipping Cream)", "No", "No", "Aktif"],
  [2898, "Wijen (Sesame)", "No", "No", "Aktif"],
  [2899, "Wijen Bubuk (Sesame Powder)", "No", "No", "Aktif"],
  [2900, "Wijen Hitam (Black Sesame)", "No", "No", "Aktif"],
  [2901, "Wijen Putih (White Sesame)", "No", "No", "Aktif"],
  [2902, "WISKI (WHISKY)", "No", "No", "Aktif"],
  [2903, "Wortel (Carrot)", "No", "No", "Aktif"],
  [2904, "Wortel Bubuk (Carrot Powder)", "No", "No", "Aktif"],
  [2905, "Wortel Kering (Dried Carrot)", "No", "No", "Aktif"],
  [
    2906,
    "Xilosa isomerase (xylose isomerase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2907,
    "Yerbamate Ekstrak (Ilex paraguariensis)",
    "No",
    "No",
    "Aktif",
  ],
  [2908, "Yoghurt (Yoghurt)", "No", "No", "Aktif"],
  [2909, "Yoghurt Bubuk (Yoghurt Powder)", "No", "No", "Aktif"],
  [2910, "ZAT BESI (IRON)", "No", "No", "Aktif"],
  [2911, "ZEASANTIN", "No", "No", "Nonaktif"],
  [2912, "Zeaxanthin Rich Extract", "No", "No", "Aktif"],
  [2913, "Zink Glukonat (Zinc Gluconate)", "No", "No", "Aktif"],
  [
    2914,
    "Zink Laktat Dihidrat (Zink Lactate Dihydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [2915, "Zink Oksida (Zinc Oxide)", "No", "No", "Aktif"],
  [2916, "Zink Pikolinat (Zinc Picolinate)", "No", "No", "Aktif"],
  [
    2917,
    "zink Sitrat Dihidrat (Zink Citrate Dihydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [2918, "Zink Sulfat (Zinc Sulphate)", "No", "No", "Aktif"],
  [
    2919,
    "\\xDF-amilase (Betaamylase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2920,
    "\\xDF-fruktofuranosidase (BetaFructofuranosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2921,
    "\\xDF-galaktosidase (Betagalactosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2922,
    "\\xDF-Glukosidase (BetaGlucosidase) (Bahan Penolong)",
    "No",
    "No",
    "Aktif",
  ],
];
# END FRAGMENT id=data-idn_bpom_bahan_baku_pangan_rba

my $res = gen_read_table_func(
    name => 'bpom_list_food_ingredients_rba',
    summary => 'List ingredients in BPOM processed food division (RBA version)',
    table_data => $data_idn_bpom_bahan_baku_pangan_rba,
    table_spec => $meta_idn_bpom_bahan_baku_pangan_rba,
    description => <<'_',
_
    extra_props => {
        examples => [
        ],
    },
    hooks => {
        before_return => sub {
            my %args = @_;
            # XXX adjust other properties e.g. table.field_formats etc
            #$args{_func_res}[3]{'table.fields'} = ['status'];
            1;
        },
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List ingredients in BPOM processed food division (RBA version)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodIngredientRBA - List ingredients in BPOM processed food division (RBA version)

=head1 VERSION

This document describes version 0.022 of App::BPOMUtils::Table::FoodIngredientRBA (from Perl distribution App-BPOMUtils-Table-FoodIngredient), released on 2025-02-25.

=head1 FUNCTIONS


=head2 bpom_list_food_ingredients_rba

Usage:

 bpom_list_food_ingredients_rba(%args) -> [$status_code, $reason, $payload, \%result_meta]

List ingredients in BPOM processed food division (RBA version).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<country_of_origin> => I<str>

Only return records where the 'country_of_origin' field equals specified value.

=item * B<country_of_origin.contains> => I<str>

Only return records where the 'country_of_origin' field contains specified text.

=item * B<country_of_origin.in> => I<array[str]>

Only return records where the 'country_of_origin' field is in the specified values.

=item * B<country_of_origin.is> => I<str>

Only return records where the 'country_of_origin' field equals specified value.

=item * B<country_of_origin.isnt> => I<str>

Only return records where the 'country_of_origin' field does not equal specified value.

=item * B<country_of_origin.matches> => I<str>

Only return records where the 'country_of_origin' field matches specified regular expression pattern.

=item * B<country_of_origin.max> => I<str>

Only return records where the 'country_of_origin' field is less than or equal to specified value.

=item * B<country_of_origin.min> => I<str>

Only return records where the 'country_of_origin' field is greater than or equal to specified value.

=item * B<country_of_origin.not_contains> => I<str>

Only return records where the 'country_of_origin' field does not contain specified text.

=item * B<country_of_origin.not_in> => I<array[str]>

Only return records where the 'country_of_origin' field is not in the specified values.

=item * B<country_of_origin.not_matches> => I<str>

Only return records where the 'country_of_origin' field does not match specified regular expression.

=item * B<country_of_origin.xmax> => I<str>

Only return records where the 'country_of_origin' field is less than specified value.

=item * B<country_of_origin.xmin> => I<str>

Only return records where the 'country_of_origin' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<name> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.contains> => I<str>

Only return records where the 'name' field contains specified text.

=item * B<name.in> => I<array[str]>

Only return records where the 'name' field is in the specified values.

=item * B<name.is> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.isnt> => I<str>

Only return records where the 'name' field does not equal specified value.

=item * B<name.matches> => I<str>

Only return records where the 'name' field matches specified regular expression pattern.

=item * B<name.max> => I<str>

Only return records where the 'name' field is less than or equal to specified value.

=item * B<name.min> => I<str>

Only return records where the 'name' field is greater than or equal to specified value.

=item * B<name.not_contains> => I<str>

Only return records where the 'name' field does not contain specified text.

=item * B<name.not_in> => I<array[str]>

Only return records where the 'name' field is not in the specified values.

=item * B<name.not_matches> => I<str>

Only return records where the 'name' field does not match specified regular expression.

=item * B<name.xmax> => I<str>

Only return records where the 'name' field is less than specified value.

=item * B<name.xmin> => I<str>

Only return records where the 'name' field is greater than specified value.

=item * B<origin> => I<str>

Only return records where the 'origin' field equals specified value.

=item * B<origin.contains> => I<str>

Only return records where the 'origin' field contains specified text.

=item * B<origin.in> => I<array[str]>

Only return records where the 'origin' field is in the specified values.

=item * B<origin.is> => I<str>

Only return records where the 'origin' field equals specified value.

=item * B<origin.isnt> => I<str>

Only return records where the 'origin' field does not equal specified value.

=item * B<origin.matches> => I<str>

Only return records where the 'origin' field matches specified regular expression pattern.

=item * B<origin.max> => I<str>

Only return records where the 'origin' field is less than or equal to specified value.

=item * B<origin.min> => I<str>

Only return records where the 'origin' field is greater than or equal to specified value.

=item * B<origin.not_contains> => I<str>

Only return records where the 'origin' field does not contain specified text.

=item * B<origin.not_in> => I<array[str]>

Only return records where the 'origin' field is not in the specified values.

=item * B<origin.not_matches> => I<str>

Only return records where the 'origin' field does not match specified regular expression.

=item * B<origin.xmax> => I<str>

Only return records where the 'origin' field is less than specified value.

=item * B<origin.xmin> => I<str>

Only return records where the 'origin' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodIngredient>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodIngredient>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodIngredient>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
