use strict;
use warnings;

use App::NKC2MARC;
use English;
use Error::Pure::Utils qw(clean);
use File::Object;
use File::Spec::Functions qw(abs2rel);
use Test::More 'tests' => 6;
use Test::NoWarnings;
use Test::Output;
use Test::Warn 0.31;

# Test.
@ARGV = (
	'-h',
);
my $right_ret = help();
stderr_is(
	sub {
		App::NKC2MARC->new->run;
		return;
	},
	$right_ret,
	'Run help (-h).',
);

# Test.
@ARGV = ();
$right_ret = help();
stderr_is(
	sub {
		App::NKC2MARC->new->run;
		return;
	},
	$right_ret,
	'Run help (no arguments).',
);

# Test.
@ARGV = (
	'-x',
);
$right_ret = help();
stderr_is(
	sub {
		warning_is { App::NKC2MARC->new->run; } "Unknown option: x\n",
			'Warning about bad argument';
		return;
	},
	$right_ret,
	'Run help (-x - bad option).',
);

# Test.
@ARGV = (
	'-o bad',
	'cnb000703274',
);
eval {
	App::NKC2MARC->new->run;
};
is($EVAL_ERROR, "Bad output format.\n",
	"Bad output format (bad).");
clean();

sub help {
	my $script = abs2rel(File::Object->new->file('04-run.t')->s);
	# XXX Hack for missing abs2rel on Windows.
	if ($OSNAME eq 'MSWin32') {
		$script =~ s/\\/\//msg;
	}
	my $help = <<"END";
Usage: $script [-h] [-o output_format] [--version] id_of_book ..
	-h			Print help.
	-o output_format	Output format (usmarc, xml - default).
	--version		Print version.
	id_of_book ..		Identifier of book e.g. Czech national bibliography id or ISBN
END

	return $help;
}
