# Generated by default/object.tt
package Paws::SSMContacts::ContactChannelAddress;
  use Moose;
  has SimpleAddress => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::ContactChannelAddress

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::ContactChannelAddress object:

  $service_obj->Method(Att1 => { SimpleAddress => $value, ..., SimpleAddress => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::ContactChannelAddress object:

  $result = $service_obj->Method(...);
  $result->Att1->SimpleAddress

=head1 DESCRIPTION

The details that Incident Manager uses when trying to engage the
contact channel.

=head1 ATTRIBUTES


=head2 SimpleAddress => Str

The format is dependent on the type of the contact channel. The
following are the expected formats:

=over

=item *

SMS - '+' followed by the country code and phone number

=item *

VOICE - '+' followed by the country code and phone number

=item *

EMAIL - any standard email format

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

