# Generated by default/object.tt
package Paws::Chime::BatchChannelMemberships;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has InvitedBy => (is => 'ro', isa => 'Paws::Chime::Identity');
  has Members => (is => 'ro', isa => 'ArrayRef[Paws::Chime::Identity]');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::BatchChannelMemberships

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::BatchChannelMemberships object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::BatchChannelMemberships object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

The membership information, including member ARNs, the channel ARN, and
membership types.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the channel to which you're adding users.


=head2 InvitedBy => L<Paws::Chime::Identity>




=head2 Members => ArrayRef[L<Paws::Chime::Identity>]

The users successfully added to the request.


=head2 Type => Str

The membership types set for the channel users.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

