# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153522;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '2277',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              3[13]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          1(?:
            (?:
              5(?:
                [0-25-9]\\d\\d|
                3(?:
                  10|
                  33
                )
              )|
              7[26-9]\\d\\d
            )\\d{6}|
            6[023]\\d{7,8}
          )|
          17\\d{8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"49911", "Nürnberg",
"492339", "Sprockhövel\-Haßlinghausen",
"498536", "Kößlarn",
"494684", "Langeneß\ Hallig",
"4989", "München",
"4935726", "Groß\ Särchen",
"497351", "Biberach\ an\ der\ Riß",
"498633", "Tüßling",
"496252", "Heppenheim\ Bergstraße",
"496364", "Nußbach\ Pfalz",
"495064", "Groß\ Düngen",
"498807", "Dießen\ am\ Ammersee",
"4934445", "Stößen",
"495827", "Unterlüß",
"4934901", "Roßlau\ Elbe",
"497162", "Süßen",
"4935841", "Großschönau\ Sachsen",
"4935248", "Schönfeld\ bei\ Großenhain",
"49221", "Köln",
"4936072", "Weißenborn\-Lüderode",
"4939934", "Groß\ Plasten",
"499242", "Gößweinstein",
"494497", "Barßel\-Harkebrügge",
"495053", "Faßberg\-Müden",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"496663", "Steinau\ an\ der\ Straße",
"499567", "Seßlach\-Gemünda",
"4935938", "Großpostwitz\ OL",
"497355", "Hochdorf\ Riß",
"4935952", "Großröhrsdorf\ OL",
"499656", "Moosbach\ bei\ Vohenstrauß",
"4938234", "Born\ Darß",
"499141", "Weißenburg\ in\ Bayern",
"498170", "Straßlach\-Dingharting",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4934493", "Gößnitz\ Thüringen",
"499636", "Plößberg",
"492203", "Köln\-Porz",
"494483", "Ovelgönne\-Großenmeer",
"4939883", "Groß\ Dölln",
"493647", "Pößneck",
"495384", "Seesen\-Groß\ Rhüden",
"4939976", "Groß\ Bützin",
"4936484", "Knau\ bei\ Pößneck",
"498367", "Roßhaupten\ Forggensee",
"4936949", "Obermaßfeld\-Grimmenthal",
"4935240", "Tauscha\ bei\ Großenhain",
"4935753", "Großräschen",
"494509", "Groß\ Grönau",};
$areanames{en} = {"4939833", "Mirow\ Kreis\ Neustrelitz",
"499642", "Kemnath\ Stadt",
"496333", "Waldfischbach\-Burgalben",
"495191", "Soltau",
"496186", "Grosskrotzenburg",
"498635", "Pleiskirchen",
"494762", "Kutenholz",
"4933921", "Zechlinerhütte",
"4936651", "Lobenstein",
"492904", "Bestwig",
"493965", "Burow\ bei\ Altentreptow",
"49631", "Kaiserslautern",
"4934261", "Kühren\ bei\ Wurzen",
"4936081", "Arenshausen",
"4939608", "Staven",
"495574", "Oberweser",
"495244", "Rietberg",
"492296", "Reichshof\-Brüchermühle",
"494328", "Rickling",
"4933232", "Brieselang",
"495776", "Preussisch\ Ströhen",
"495643", "Borgentreich",
"497732", "Radolfzell\ am\ Bodensee",
"499907", "Zenting",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4936704", "Steinheid",
"495304", "Meine",
"4935698", "Hornow",
"498743", "Geisenhausen",
"493621", "Gotha\ Thüringen",
"499345", "Külsheim\ Baden",
"497203", "Walzbachtal",
"497181", "Schorndorf\ Württemberg",
"4935247", "Zehren\ Sachsen",
"494339", "Christiansholm",
"498332", "Ottobeuren",
"4937202", "Claussnitz\ bei\ Chemnitz",
"495161", "Walsrode",
"499268", "Teuschnitz",
"497427", "Schömberg\ bei\ Balingen",
"498324", "Hindelang",
"494792", "Worpswede",
"498340", "Baisweil",
"499205", "Vorbach",
"499359", "Karlstadt\-Wiesenfeld",
"4935327", "Priessen",
"497343", "Buch\ bei\ Illertissen",
"492266", "Lindlar",
"499371", "Miltenberg",
"4938858", "Lassahn",
"4936200", "Elxleben\ bei\ Arnstadt",
"4934773", "Schwittersdorf",
"4934928", "Seegrehna",
"496742", "Boppard",
"497258", "Oberderdingen\-Flehingen",
"496162", "Reinheim\ Odenwald",
"497525", "Aulendorf",
"493461", "Merseburg\ Saale",
"496373", "Schönenberg\-Kübelberg",
"498193", "Geltendorf",
"499964", "Stallwang",
"4939772", "Rothemühl",
"497387", "Hohenstein\ Württemberg",
"492295", "Ruppichteroth",
"495775", "Diepenau",
"4935363", "Fermerswalde",
"495367", "Rühen",
"4933605", "Boossen",
"4938373", "Katzow",
"499523", "Hofheim\ in\ Unterfranken",
"492174", "Burscheid\ Rheinland",
"4937343", "Jöhstadt",
"496503", "Hermeskeil",
"493723", "Hohenstein\-Ernstthal",
"498038", "Vogtareuth",
"497221", "Baden\-Baden",
"498641", "Grassau\ Kreis\ Traunstein",
"496558", "Büdesheim\ Eifel",
"4935753", "Grossräschen",
"493966", "Cölpin",
"4936424", "Kahla\ Thüringen",
"495534", "Eschershausen\ an\ der\ Lenne",
"492591", "Lüdinghausen",
"494802", "Wrohm",
"498809", "Wessobrunn",
"495522", "Osterode\ am\ Harz",
"499177", "Heideck",
"495741", "Lübbecke",
"495838", "Gross\ Oesingen",
"496757", "Becherbach\ bei\ Kirn",
"495429", "Melle\-Wellingholzhausen",
"4938797", "Karstädt\ Kreis\ Prignitz",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"496854", "Oberthal\ Saar",
"498636", "Ampfing",
"496185", "Hammersbach\ Hessen",
"497954", "Kirchberg\ an\ der\ Jagst",
"499657", "Waldthurn",
"496192", "Hofheim\ am\ Taunus",
"498372", "Obergünzburg",
"493491", "Lutherstadt\ Wittenberg",
"498029", "Kreuth\ bei\ Tegernsee",
"4934600", "Ostrau\ Saalkreis",
"493344", "Bad\ Freienwalde",
"495438", "Bakum\-Lüsche",
"492265", "Reichshof\-Eckenhagen",
"4935727", "Burghammer",
"494402", "Rastede",
"494637", "Sterup",
"4939031", "Dähre",
"492208", "Niederkassel",
"498502", "Fürstenzell",
"494509", "Gross\ Grönau",
"493603", "Bad\ Langensalza",
"496454", "Lichtenfels\-Sachsenberg",
"495829", "Wriedel",
"495084", "Hambühren",
"493861", "Plate",
"494488", "Westerstede",
"492253", "Bad\ Münstereifel",
"495948", "Itterbeck",
"4936961", "Bad\ Liebenstein",
"493996", "Teterow",
"499206", "Mistelgau\-Obernsees",
"492654", "Polch",
"496226", "Meckesheim",
"4933454", "Wölsickendorf\/Wollenberg",
"499331", "Ochsenfurt",
"497667", "Breisach\ am\ Rhein",
"494142", "Steinkirchen\ Kreis\ Stade",
"492561", "Ahaus",
"499346", "Grünsfeld",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"4939265", "Löderburg",
"4935452", "Golssen",
"494351", "Eckernförde",
"4936023", "Horsmar",
"492166", "Mönchengladbach\-Rheydt",
"4938232", "Zingst\ Ostseebad",
"494828", "Lägerdorf",
"494532", "Bargteheide",
"499445", "Neustadt\ an\ der\ Donau",
"497585", "Ostrach",
"495508", "Gleichen\-Rittmarshausen",
"496059", "Jossgrund",
"4938426", "Neuburg\-Steinhausen",
"4935936", "Sohland\ Spree",
"498432", "Burgheim",
"499976", "Rötz",
"495565", "Einbeck\-Wenzen",
"4938306", "Samtens",
"4939754", "Löcknitz\ Vorpom",
"4933397", "Wandlitz",
"4935609", "Drachhausen",
"499552", "Burghaslach",
"494963", "Dörpen",
"498424", "Nassenfels",
"497327", "Dischingen",
"494524", "Scharbeutz\-Pönitz",
"495707", "Petershagen\ Weser",
"4935691", "Bärenklau\ NL",
"4939052", "Erxleben\ bei\ Haldensleben",
"496045", "Gedern",
"495378", "Sassenburg\-Platendorf",
"4934464", "Freyburg\ Unstrut",
"497158", "Neuhausen\ auf\ den\ Fildern",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"497443", "Dornstetten",
"499471", "Burglengenfeld",
"494955", "Westoverledingen",
"497933", "Creglingen",
"4939364", "Dolle",
"495261", "Lemgo",
"496833", "Rehlingen\-Siersburg",
"499935", "Stephansposching",
"495582", "Sankt\ Andreasberg",
"4933928", "Wildberg\ Brandenburg",
"4936741", "Bad\ Blankenburg",
"49681", "Saarbrücken",
"499105", "Grosshabersdorf",
"497562", "Isny\ im\ Allgäu",
"49791", "Schwäbisch\ Hall",
"495553", "Kalefeld",
"4939601", "Friedland",
"496071", "Dieburg",
"49365", "Gera",
"492196", "Wermelskirchen",
"495144", "Wathlingen",
"4939246", "Lindau\ Anh",
"4939406", "Harbke",
"499871", "Windsbach",
"496433", "Hadamar",
"492745", "Brachbach\ Sieg",
"494257", "Schweringen",
"4938851", "Zarrentin",
"492759", "Bad\ Berleburg\-Aue",
"4934921", "Kemberg",
"49641", "Giessen",
"4936205", "Gräfenroda",
"49234", "Bochum",
"494606", "Wanderup",
"499845", "Oberdachstetten",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"492771", "Dillenburg",
"494839", "Wöhrden\ Dithmarschen",
"492222", "Bornheim\ Rheinland",
"4934426", "Kayna",
"496286", "Walldürn\-Rippberg",
"49261", "Koblenz\ am\ Rhein",
"4933472", "Golzow\ bei\ Seelow",
"492234", "Frechen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"498824", "Oberau\ Loisach",
"4939999", "Tutow",
"498727", "Falkenberg\ Niederbayern",
"4938464", "Bernitt",
"492633", "Brohl\-Lützing",
"495404", "Westerkappeln",
"497843", "Renchen",
"4935474", "Schönwalde\ bei\ Lübben",
"495032", "Neustadt\ am\ Rübenberge",
"494479", "Molbergen\-Peheim",
"499936", "Wallerfing",
"492153", "Nettetal\-Lobberich",
"492448", "Hellenthal\-Rescheid",
"493391", "Neuruppin",
"4936377", "Rastenberg",
"499106", "Markt\ Erlbach",
"496126", "Idstein",
"497629", "Tegernau\ Baden",
"498249", "Ettringen\ Wertach",
"492182", "Grevenbroich\-Kapellen",
"494242", "Syke",
"494230", "Verden\-Walle",
"494302", "Kirchbarkau",
"494956", "Uplengen",
"4934905", "Wörlitz",
"499941", "Kötzting",
"496873", "Nonnweiler",
"4933832", "Rogäsen",
"497973", "Obersontheim",
"496292", "Seckach",
"4939007", "Tangeln",
"498263", "Breitenbrunn\ Schwaben",
"498067", "Tuntenhausen",
"496046", "Ortenberg\ Hessen",
"497260", "Sinsheim\-Hilsbach",
"4939062", "Bebertal",
"494725", "Helgoland",
"498664", "Chieming",
"499431", "Schwandorf",
"492165", "Jüchen",
"492938", "Ense",
"4939925", "Wredenhagen",
"496031", "Friedberg\ Hessen",
"496648", "Bad\ Salzschlirf",
"499446", "Altmannstein",
"497586", "Herbertingen",
"498551", "Freyung",
"494451", "Varel\ Jadebusen",
"495764", "Steyerberg",
"493681", "Suhl",
"499975", "Waldmünchen\-Geigant",
"497121", "Reutlingen",
"4936968", "Rossdorf\ Rhön",
"493361", "Fürstenwalde\ Spree",
"496473", "Leun",
"499831", "Gunzenhausen",
"4938454", "Kritzkow",
"499748", "Motten",
"4939855", "Parmen\-Weggun",
"4939726", "Ducherow",
"498384", "Röthenbach\ Allgäu",
"494605", "Medelby",
"499846", "Ipsheim",
"499277", "Warmensteinach",
"499547", "Zapfendorf",
"499073", "Gundelfingen\ an\ der\ Donau",
"4934605", "Gröbers",
"495467", "Voltlage",
"494668", "Klanxbüll",
"494851", "Marne",
"496285", "Walldürn\-Altheim",
"496262", "Aglasterhausen",
"498293", "Welden\ bei\ Augsburg",
"497041", "Mühlacker",
"493844", "Schwaan",
"495072", "Neustadt\-Mandelsloh",
"492195", "Radevormwald",
"492673", "Ellenz\-Poltersdorf",
"4939038", "Henningen",
"497709", "Wutach",
"495329", "Schulenberg\ im\ Oberharz",
"492520", "Wadersloh\-Diestedde",
"496581", "Saarburg",
"492274", "Elsdorf\ Rheinland",
"493868", "Rastow",
"492375", "Balve",
"494481", "Hatten\-Sandkrug",
"495941", "Neuenhaus\ Dinkel",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"497754", "Görwihl",
"492864", "Reken",
"497556", "Uhldingen\-Mühlhofen",
"498581", "Waldkirchen\ Niederbayern",
"499338", "Röttingen\ Unterfranken",
"494127", "Westerhorn",
"498262", "Mittelneufnach",
"494269", "Ahausen\-Kirchwalsede",
"492568", "Heek",
"493923", "Zerbst",
"496872", "Losheim\ am\ See",
"497972", "Gschwend\ bei\ Gaildorf",
"496293", "Schefflenz",
"4934443", "Teuchern",
"4934203", "Zwenkau",
"493564", "Schwarze\ Pumpe",
"494358", "Loose\ bei\ Eckernförde",
"492505", "Altenberge\ Westfalen",
"495936", "Twist",
"496694", "Neukirchen\ Knüll",
"495250", "Delbrück\ Westfalen",
"496384", "Konken",
"499867", "Geslau",
"4933082", "Menz\ Kreis\ Oberhavel",
"494303", "Schlesen",
"499566", "Meeder",
"495975", "Rheine\-Mesum",
"499764", "Höchheim",
"4933652", "Neuzelle",
"4936922", "Gerstungen",
"4939343", "Jerichow",
"498285", "Burtenbach",
"493337", "Biesenthal\ Brandenburg",
"495446", "Rehden",
"4939223", "Theessen",
"495431", "Quakenbrück",
"494644", "Karby",
"492152", "Kempen",
"4936649", "Gefell\ bei\ Schleiz",
"494243", "Twistringen",
"492183", "Rommerskirchen",
"493679", "Neuhaus\ am\ Rennweg",
"499280", "Selbitz\ Oberfranken",
"492336", "Schwelm",
"498031", "Rosenheim\ Oberbayern",
"492672", "Treis\-Karden",
"497228", "Forbach",
"495073", "Neustadt\-Esperke",
"4933849", "Wiesenburg\ Mark",
"496551", "Prüm",
"4934742", "Sylda",
"499467", "Michelsneukirchen",
"495277", "Höxter\-Fürstenau",
"495846", "Gartow\ Niedersachsen",
"4935245", "Burkhardswalde\-Munzig",
"492598", "Senden\-Ottmarsbocholt",
"498292", "Dinkelscherben",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"495831", "Wittingen",
"496263", "Neckargerach",
"493594", "Bischofswerda",
"496664", "Sinntal\-Sterbfritz",
"498046", "Bad\ Heilbrunn",
"494881", "Friedrichstadt",
"496255", "Lindenfels",
"4936622", "Triebes",
"497457", "Rottenburg\-Ergenzingen",
"492464", "Aldenhoven\ bei\ Jülich",
"499072", "Lauingen\ Donau",
"4938876", "Roggendorf",
"4938729", "Marnitz",
"496472", "Weilmünster",
"4939888", "Lychen",
"4936949", "Obermassfeld\-Grimmenthal",
"4935954", "Grossharthau",
"496249", "Guntersblum",
"4938203", "Bad\ Doberan",
"499378", "Eichenbühl\-Riedern",
"496824", "Ottweiler",
"497940", "Künzelsau",
"499804", "Aurach",
"495459", "Hörstel",
"495583", "Braunlage\-Hohegeiss",
"496727", "Gensingen",
"495552", "Katlenburg",
"4934491", "Schmölln\ Thüringen",
"492335", "Wetter\ Ruhr",
"497563", "Kisslegg",
"495976", "Salzbergen",
"499565", "Untersiemau",
"4933607", "Briesen\ Mark",
"4936370", "Grossenehrich",
"497932", "Niederstetten\ Württemberg",
"496832", "Beckingen\-Reimsbach",
"497251", "Bruchsal",
"495445", "Drebber",
"499553", "Ebrach\ Oberfranken",
"494962", "Papenburg\-Aschendorf",
"493377", "Zossen\ Brandenburg",
"49451", "Lübeck",
"4936603", "Weida",
"495105", "Barsinghausen",
"4939743", "Zerrenthin",
"492506", "Münster\-Wolbeck",
"4937608", "Waldenburg\ Sachsen",
"497442", "Baiersbronn",
"49841", "Ingolstadt\ Donau",
"495168", "Walsrode\-Stellichte",
"495935", "Twist\-Schöninghsdorf",
"493765", "Reichenbach\ Vogtland",
"499261", "Kronach",
"4938222", "Semlow",
"494533", "Reinfeld\ Holstein",
"4939391", "Lückstedt",
"498433", "Königsmoos",
"495471", "Bohmte",
"497555", "Deggenhausertal",
"4939000", "Beetzendorf",
"4933638", "Rüdersdorf\ bei\ Berlin",
"495237", "Augustdorf",
"494321", "Neumünster",
"4934342", "Neukieritzsch",
"49881", "Weilheim\ in\ Oberbayern",
"495033", "Wunstorf\-Grossenheidorn",
"492632", "Andernach",
"498071", "Wasserburg\ am\ Inn",
"497842", "Kappelrodeck",
"492407", "Herzogenrath\-Kohlscheid",
"4934222", "Arzberg\ bei\ Torgau",
"496256", "Lampertheim\-Hüttenfeld",
"492624", "Höhr\-Grenzhausen",
"4933962", "Heiligengrabe",
"493628", "Arnstadt",
"492223", "Königswinter",
"499144", "Pleinfeld",
"499120", "Leinburg",
"4935725", "Wittichenau",
"495859", "Thomasburg",
"499404", "Nittendorf",
"496424", "Ebsdorfergrund",
"496440", "Kölschhausen",
"498045", "Lenggries\-Fall",
"495198", "Schneverdingen\-Wintermoor",
"493901", "Salzwedel",
"4939267", "Schneidlingen",
"494287", "Heeslingen\-Boitzen",
"495845", "Bergen\ Dumme",
"4939202", "Gross\ Ammensleben",
"496004", "Lich\-Eberstadt",
"496432", "Diez",
"499627", "Freudenberg\ Oberpfalz",
"495523", "Bad\ Sachsa",
"496787", "Niederbrombach",
"492738", "Netphen",
"499367", "Unterpleichfeld",
"4933742", "Oehna\ Brandenburg",
"497631", "Müllheim\ Baden",
"496155", "Griesheim\ Hessen",
"492841", "Moers",
"494803", "Pahlen",
"4938784", "Kleinow\ Kreis\ Prignitz",
"499775", "Schönau\ an\ der\ Brend",
"495964", "Lähden",
"493722", "Limbach\-Oberfrohna",
"493541", "Calau",
"497773", "Bodman\-Ludwigshafen",
"498226", "Bibertal",
"492836", "Wachtendonk",
"494925", "Hinte",
"497646", "Weisweil\ Breisgau",
"496588", "Pluwig",
"4933395", "Zerpenschleuse",
"494756", "Odisheim",
"497128", "Sonnenbühl",
"499429", "Rain\ Niederbayern",
"494554", "Wahlstedt",
"496409", "Biebertal",
"498454", "Karlshuld",
"499741", "Bad\ Brückenau",
"495177", "Edemissen\-Abbensen",
"499522", "Eltmann",
"497357", "Attenweiler",
"496502", "Schweich",
"492364", "Haltern\ Westfalen",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"496372", "Bruchmühlbach\-Miesau",
"498192", "Schondorf\ am\ Ammersee",
"4936694", "Schkölen\ Thüringen",
"499534", "Burgpreppach",
"496163", "Höchst\ im\ Odenwald",
"499736", "Oberthulba",
"496029", "Mömbris",
"494858", "Sankt\ Margarethen\ Holstein",
"494661", "Niebüll",
"496809", "Grossrosseln",
"499829", "Flachslanden",
"494381", "Lütjenburg",
"499397", "Wertheim\-Dertingen",
"497139", "Neuenstadt\ am\ Kocher",
"499438", "Fensterbach",
"496636", "Romrod",
"496641", "Lauterbach\ Hessen",
"492931", "Arnsberg",
"492684", "Puderbach\ Westerwald",
"4939881", "Ringenwalde\ bei\ Templin",
"4933876", "Buschow",
"498558", "Hohenau\ Niederbayern",
"492252", "Zülpich",
"495054", "Bergen\-Sülze",
"499180", "Pyrbaum",
"4933203", "Kleinmachnow",
"494458", "Wiefelstede\-Spohle",
"4935240", "Tauscha\ bei\ Grossenhain",
"4935892", "Horka\ OL",
"494143", "Drochtersen",
"495657", "Meissner",
"493947", "Thale",
"492441", "Kall",
"494403", "Bad\ Zwischenahn",
"496484", "Beselich",
"4934652", "Allstedt",
"492394", "Neuenrade\-Affeln",
"498503", "Neuhaus\ am\ Inn",
"495346", "Liebenburg",
"493437", "Grimma",
"4936207", "Plaue\ Thüringen",
"495331", "Wolfenbüttel",
"496675", "Breitenbach\ am\ Herzberg",
"494169", "Sauensiek",
"495206", "Bielefeld\-Jöllenbeck",
"498373", "Altusried",
"492436", "Wegberg\-Rödgen",
"499084", "Bissingen\ Schwaben",
"499948", "Eschlkam",
"493774", "Schwarzenberg",
"4934638", "Zöschen",
"4939083", "Messdorf",
"493877", "Wittenberge",
"499735", "Massbach",
"494421", "Wilhelmshaven",
"4936375", "Kindelbrück",
"493576", "Weisswasser",
"497671", "Todtnau",
"4934294", "Rackwitz",
"494749", "Schiffdorf\-Geestenseth",
"498742", "Velden\ Vils",
"492778", "Siegbach",
"4937601", "Mülsen\ Skt\ Jacob",
"492307", "Kamen",
"49771", "Donaueschingen",
"499191", "Forchheim\ Oberfranken",
"494755", "Ihlienworth",
"492247", "Neunkirchen\-Seelscheid",
"4934907", "Jeber\-Bergfrieden",
"494187", "Holm\-Seppensen",
"497733", "Engen\ Hegau",
"4937364", "Reitzenhain\ Erzgebirge",
"492043", "Gladbeck",
"4939398", "Gross\ Garz",
"4933436", "Prötzel",
"493306", "Gransee",
"495642", "Warburg\-Scherfede",
"494763", "Gnarrenburg",
"4933931", "Rheinsberg\ Mark",
"496340", "Wörth\-Schaidt",
"496324", "Hassloch",
"4937754", "Zwönitz",
"495137", "Seelze",
"4933674", "Trebatsch",
"498225", "Jettingen\-Scheppach",
"4934498", "Rositz",
"497645", "Freiamt",
"492835", "Issum",
"4937439", "Jocketa",
"494926", "Krummhörn\-Greetsiel",
"4939005", "Kusey",
"495907", "Geeste",
"4939823", "Rechlin",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"493535", "Herzberg\ Elster",
"499776", "Mellrichstadt",
"4939927", "Nossentiner\ Hütte",
"499574", "Marktzeuln",
"4940", "Hamburg",
"499220", "Kasendorf\-Azendorf",
"496332", "Zweibrücken",
"499244", "Betzenstein",
"4939857", "Drense",
"496676", "Hohenroda\ Hessen",
"495205", "Bielefeld\-Sennestadt",
"4939953", "Schwinkendorf",
"492435", "Erkelenz\-Lövenich",
"496743", "Bacharach",
"499161", "Neustadt\ an\ der\ Aisch",
"4936252", "Tambach\-Dietharz",
"4939484", "Harzgerode",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4934607", "Wettin",
"4962195", "Ludwigshafen",
"492971", "Schmallenberg\-Dorlar",
"495345", "Baddeckenstedt",
"496078", "Gross\-Umstadt",
"4933631", "Bad\ Saarow\-Pieskow",
"4934384", "Grossbothen",
"494821", "Itzehoe",
"494793", "Hambergen",
"4933974", "Dessow",
"4937326", "Frauenstein\ Sachsen",
"4938294", "Neubukow",
"49831", "Kempten\ Allgäu",
"497202", "Karlsbad",
"4935266", "Heyda\ bei\ Riesa",
"498333", "Babenhausen\ Schwaben",
"497151", "Waiblingen",
"496635", "Kirtorf",
"492945", "Lippstadt\-Benninghausen",
"495371", "Gifhorn",
"497123", "Metzingen\ Württemberg",
"4934771", "Querfurt",
"496471", "Weilburg",
"494495", "Friesoythe\-Thüle",
"499833", "Heidenheim\ Mittelfranken",
"498144", "Grafrath",
"4933470", "Lietzen",
"494882", "Lunden",
"492645", "Vettelschoss",
"497835", "Zell\ am\ Harmersbach",
"499071", "Dillingen\ an\ der\ Donau",
"49375", "Zwickau",
"494853", "Sankt\ Michaelisdonn",
"49981", "Ansbach",
"496105", "Mörfelden\-Walldorf",
"495832", "Hankensbüttel",
"495528", "Gieboldehausen",
"498291", "Zusmarshausen",
"496445", "Schöffengrund",
"492733", "Hilchenbach",
"4938459", "Laage",
"497043", "Maulbronn",
"497577", "Veringenstadt",
"497247", "Linkenheim\-Hochstetten",
"494865", "Osterhever",
"498024", "Holzkirchen",
"49271", "Siegen",
"498404", "Oberdolling",
"496552", "Olzheim",
"497307", "Senden\ Iller",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"492671", "Cochem",
"4936484", "Knau\ bei\ Pössneck",
"495840", "Schnackenburg",
"494706", "Schiffdorf",
"495824", "Bad\ Bodenteich",
"494504", "Ratekau",
"496583", "Palzem",
"497945", "Wüstenrot",
"494626", "Treia",
"492151", "Krefeld",
"494408", "Hude\ Oldenburg",
"495607", "Fuldatal",
"495432", "Löningen",
"498565", "Dietersburg\-Baumgarten",
"499286", "Oberkotzau",
"494465", "Friedeburg\ Ostfriesland",
"492330", "Herdecke",
"497476", "Bisingen",
"492202", "Bergisch\ Gladbach",
"499560", "Grub\ am\ Forst",
"498707", "Adlkofen",
"496198", "Eppstein",
"4933235", "Friesack",
"498378", "Buchenberg\ bei\ Kempten",
"4933657", "Steinsdorf\ Brandenburg",
"4936927", "Unterellen",
"497959", "Frankenhardt",
"499943", "Lam\ Oberpfalz",
"495424", "Bad\ Rothenfelde",
"4933087", "Bredereiche",
"4936653", "Lehesten\ Thüringer\ Wald",
"496871", "Wadern",
"4933923", "Flecken\ Zechlin",
"497971", "Gaildorf",
"498261", "Mindelheim",
"4936083", "Uder",
"4934263", "Hohburg",
"499433", "Nabburg",
"496033", "Butzbach",
"497435", "Albstadt\-Laufen",
"494482", "Hatten",
"495942", "Uelsen",
"498553", "Spiegelau",
"4939831", "Feldberg",
"494453", "Zetel",
"494148", "Drochtersen\-Assel",
"49941", "Regensburg",
"498582", "Röhrnbach",
"493683", "Schmalkalden",
"4939050", "Bartensleben",
"496237", "Maxdorf",
"4933981", "Putlitz",
"4939976", "Gross\ Bützin",
"494768", "Hipstedt",
"493902", "Diesdorf\ Altm",
"499292", "Konradsreuth",
"4939207", "Colbitz",
"499873", "Abenberg\-Wassermungenau",
"4939262", "Güsten\ Anh",
"496431", "Limburg\ an\ der\ Lahn",
"4936021", "Schlotheim",
"4935455", "Walddrehna",
"494705", "Wremen",
"497364", "Oberkochen",
"4936963", "Dorndorf\ Rhön",
"498467", "Kinding",
"496446", "Hohenahr",
"499648", "Neustadt\ am\ Kulm",
"492357", "Herscheid\ Westfalen",
"4939994", "Metschow",
"495384", "Seesen\-Gross\ Rhüden",
"4939033", "Wallstawe",
"497836", "Schiltach",
"492646", "Königsfeld\ Eifel",
"495694", "Diemelstadt",
"4933967", "Freyenstein",
"4938334", "Grammendorf",
"492773", "Haiger",
"494334", "Bredenbek\ bei\ Rendsburg",
"499126", "Eckental",
"495293", "Paderborn\-Dahl",
"496106", "Rodgau",
"495872", "Stoetze",
"494322", "Bordesholm",
"4934347", "Oelzschau\ bei\ Borna",
"493647", "Pössneck",
"495957", "Lindern\ Oldenburg",
"492984", "Hallenberg",
"498072", "Haag\ in\ Oberbayern",
"492631", "Neuwied",
"494496", "Friesoythe\-Markhausen",
"497841", "Achern",
"497738", "Steisslingen",
"499354", "Rieneck",
"4933830", "Ziesar",
"497436", "Messstetten\-Oberdigisheim",
"499262", "Wallenfels",
"495472", "Bad\ Essen",
"4938227", "Lüdershagen\ bei\ Barth",
"4935387", "Seyda",
"4933051", "Nassenheide",
"4935751", "Welzow",
"497394", "Schelklingen",
"497729", "Tennenbronn",
"494961", "Papenburg",
"498338", "Böhen",
"495255", "Altenbeken",
"495309", "Lehre\-Wendhausen",
"497441", "Freudenstadt",
"4939775", "Ahlbeck\ bei\ Torgelow",
"499473", "Kallmünz",
"495067", "Bockenem",
"495664", "Morschen",
"4937341", "Ehrenfriedersdorf",
"4933602", "Alt\ Zeschdorf",
"497252", "Bretten",
"497684", "Glottertal",
"497931", "Bad\ Mergentheim",
"4938371", "Karlshagen",
"495263", "Barntrup",
"496831", "Saarlouis",
"4935361", "Schlieben",
"494625", "Jübek",
"498764", "Mauern\ Kreis\ Freising",
"497946", "Bretzfeld",
"498867", "Rottenbuch\ Oberbayern",
"499285", "Kirchenlamitz",
"494466", "Wittmund\-Ardorf",
"4935604", "Krieschow",
"497475", "Burladingen",
"495551", "Northeim",
"496073", "Babenhausen\ Hessen",
"494308", "Schwedeneck",
"4936336", "Klettenberg",
"492555", "Schöppingen",
"494874", "Todenbüttel",
"495332", "Schöppenstedt",
"493493", "Bitterfeld",
"494777", "Cadenberge",
"498161", "Freising",
"494365", "Heringsdorf\ Holstein",
"4939862", "Schmölln\ bei\ Prenzlau",
"495156", "Coppenbrügge",
"4933734", "Felgentreu",
"497376", "Langenenslingen",
"4936202", "Neudietendorf",
"497704", "Geisingen\ Baden",
"497506", "Wangen\-Leupolz",
"497807", "Neuried\ Ortenaukreis",
"499927", "Kirchberg\ Wald",
"494248", "Bassum\-Neubruchhausen",
"493601", "Mühlhausen\ Thüringen",
"495324", "Vienenburg",
"4933475", "Letschin",
"493863", "Crivitz",
"4934923", "Cobbelsdorf",
"492251", "Euskirchen",
"496642", "Schlitz",
"492932", "Neheim\-Hüsten",
"499186", "Lauterhofen\ Oberpfalz",
"499333", "Sommerhausen",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"492102", "Ratingen",
"492563", "Stadtlohn",
"497335", "Wiesensteig",
"496298", "Möckmühl",
"493928", "Schönebeck\ Elbe",
"498389", "Weissensberg",
"494382", "Wangels",
"4938853", "Drönnewitz\ bei\ Hagenow",
"49931", "Würzburg",
"494353", "Ascheffel",
"492924", "Möhnesee",
"496630", "Schwalmtal\-Storndorf",
"49212", "Solingen",
"496371", "Landstuhl",
"4933230", "Börnicke\ Kreis\ Havelland",
"498191", "Landsberg\ am\ Lech",
"4935433", "Vetschau",
"495635", "Vöhl",
"4939603", "Burg\ Stargard",
"497147", "Sachsenheim\ Württemberg",
"498669", "Traunreut",
"494662", "Leck",
"4938827", "Kalkhorst",
"4936743", "Teichel",
"498735", "Gangkofen\-Kollbach",
"499742", "Kalbach\ Rhön",
"495769", "Steyerberg\-Voigtei",
"499521", "Hassfurt",
"496501", "Konz",
"497223", "Bühl\ Baden",
"493721", "Meinersdorf",
"493542", "Lübbenau\ Spreewald",
"494474", "Garrel",
"496345", "Albersweiler",
"498574", "Wittibreut",
"497624", "Grenzach\-Wyhlen",
"4939055", "Hörsingen",
"4935693", "Lauschütz",
"498304", "Wildpoldsried",
"497632", "Badenweiler",
"492593", "Ascheberg\ Westfalen",
"492842", "Kamp\-Lintfort",
"495743", "Espelkamp\-Gestringen",
"496268", "Hüffenhardt",
"4933747", "Marzahna",
"495676", "Liebenau\ Hessen",
"499225", "Stadtsteinach",
"496359", "Grünstadt",
"496205", "Hockenheim",
"4933334", "Greiffenberg",
"497336", "Lonsee",
"497183", "Rudersberg\ Württemberg",
"4935206", "Kreischa\ bei\ Dresden",
"497152", "Leonberg\ Württemberg",
"494737", "Stadland\-Schwei",
"495372", "Meinersen",
"4935873", "Herrnhut",
"494834", "Büsum",
"4936736", "Arnsgereuth",
"495163", "Fallingbostel\-Dorfmark",
"495502", "Dransfeld",
"494822", "Kellinghusen",
"499185", "Mühlhausen\ Oberpfalz",
"499854", "Wittelshofen",
"4938486", "Gustävel",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4939296", "Welsleben",
"499373", "Amorbach",
"497505", "Fronreute",
"499162", "Scheinfeld",
"495149", "Wienhausen",
"498084", "Taufkirchen\ Vils",
"4936028", "Kammerforst\ Thüringen",
"492972", "Schmallenberg",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"497568", "Bad\ Wurzach\-Hauerz",
"498687", "Taching\-Tengling",
"4936257", "Luisenthal\ Thüringen",
"496670", "Ludwigsau\ Hessen",
"492857", "Rees\-Mehr",
"492556", "Metelen",
"492754", "Bad\ Laasphe\-Feudingen",
"494366", "Grömitz\-Cismar",
"499503", "Oberhaid\ Oberfranken",
"496523", "Holsthum",
"495155", "Emmerthal",
"4939852", "Schönermark\ bei\ Prenzlau",
"497375", "Obermarchtal",
"4939922", "Dambeck\ bei\ Röbel",
"496150", "Weiterstadt",
"4939386", "Seehausen\ Altmark",
"495675", "Trendelburg",
"4937348", "Oberwiesenthal\ Kurort",
"496331", "Pirmasens",
"4938378", "Heringsdorf\ Seebad",
"495193", "Schneverdingen",
"496206", "Lampertheim",
"498367", "Rosshaupten\ Forggensee",
"4933835", "Golzow\ bei\ Brandenburg",
"497464", "Talheim\ Kreis\ Tuttlingen",
"496346", "Annweiler\ am\ Trifels",
"495484", "Lienen\-Kattenvenne",
"494920", "Wirdum",
"494944", "Wiesmoor",
"49228", "Bonn",
"496054", "Birstein",
"499192", "Gräfenberg",
"496657", "Hofbieber",
"498534", "Tettenweis",
"494434", "Colnrade",
"495641", "Warburg",
"494422", "Sande\ Kreis\ Friesl",
"495636", "Lichtenfels\-Goddelsheim",
"497672", "St\ Blasien",
"494529", "Süsel\-Bujendorf",
"492228", "Remagen\-Rolandseck",
"498741", "Vilsbiburg",
"499454", "Aufhausen\ Oberpfalz",
"493623", "Friedrichroda",
"499409", "Pielenhofen",
"496429", "Schweinsberg\ Hessen",
"4933979", "Wusterhausen\ Dosse",
"495185", "Duingen",
"495854", "Bleckede\-Barskamp",
"494176", "Marschacht",
"4938201", "Gelbensande",
"492586", "Beelen",
"4933208", "Fahrland",
"499502", "Frensdorf",
"496838", "Saarwellingen",
"497938", "Mulfingen\ Jagst",
"496741", "St\ Goar",
"497165", "Göppingen\-Hohenstaufen",
"496522", "Mettendorf",
"498054", "Breitbrunn\ am\ Chiemsee",
"499163", "Dachsbach",
"496736", "Bechenheim",
"496534", "Mülheim\ Mosel",
"498657", "Ramsau\ bei\ Berchtesgaden",
"499372", "Klingenberg\ am\ Main",
"493886", "Gadebusch",
"4936625", "Langenwetzendorf",
"492973", "Eslohe\ Sauerland",
"499155", "Simmelsdorf",
"4935322", "Doberlug\-Kirchhain",
"494791", "Osterholz\-Scharmbeck",
"494823", "Wilster",
"495503", "Nörten\-Hardenberg",
"498346", "Pforzen",
"496775", "Strüth\ Taunus",
"497182", "Welzheim",
"4937207", "Hainichen\ Sachsen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"494968", "Neulehe",
"494135", "Kirchgellersen",
"498331", "Memmingen",
"499149", "Weissenburg\-Suffersheim",
"4935242", "Nossen",
"495162", "Fallingbostel",
"497153", "Plochingen",
"498206", "Egling\ an\ der\ Paar",
"497448", "Seewald",
"4939489", "Strassberg\ Harz",
"495373", "Hillerse\ Kreis\ Gifhorn",
"497274", "Germersheim",
"497544", "Markdorf",
"498670", "Reischach\ Kreis\ Altötting",
"497520", "Bodnegg",
"4937434", "Bobenneukirchen",
"499484", "Brennberg",
"494423", "Fedderwarden",
"497746", "Wutöschingen",
"4933366", "Chorin",
"4933679", "Wendisch\ Rietz",
"4939221", "Möckern\ bei\ Magdeburg",
"497673", "Schönau\ im\ Schwarzwald",
"4936764", "Neuhaus\-Schierschnitz",
"4938392", "Sassnitz",
"493622", "Waltershausen\ Thüringen",
"497195", "Winnenden",
"494347", "Flintbek",
"495226", "Bruchmühlen\ Westfalen",
"499193", "Höchstadt\ an\ der\ Aisch",
"493981", "Neustrelitz",
"493634", "Sömmerda",
"4933085", "Seilershof",
"499675", "Altendorf\ am\ Nabburg",
"494207", "Oyten",
"497731", "Singen\ Hohentwiel",
"4933237", "Paulinenaue",
"492041", "Bottrop",
"492638", "Waldbreitbach",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"496084", "Schmitten\ Taunus",
"4936925", "Marksuhl",
"4939341", "Redekin",
"495454", "Hörstel\-Riesenbeck",
"496397", "Leimen\ Pfalz",
"494761", "Bremervörde",
"498177", "Münsing\ Starnberger\ See",
"4935056", "Altenberg\ Sachsen",
"4934299", "Gaschwitz",
"499636", "Plössberg",
"496438", "Hünfelden",
"4934441", "Hohenmölsen",
"4939932", "Malchow\ bei\ Waren",
"499641", "Grafenwöhr",
"4937369", "Wolkenstein",
"495192", "Munster",
"496304", "Wolfstein\ Pfalz",
"499340", "Königheim\-Brehmen",
"494383", "Grebin",
"499324", "Dettelbach",
"492562", "Gronau\ Westfalen",
"498268", "Tussenhausen",
"49291", "Meschede",
"494136", "Scharnebeck",
"4939205", "Langenweddingen",
"498205", "Dasing",
"494352", "Damp",
"4938844", "Gülze",
"496643", "Herbstein",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"492933", "Sundern\ Sauerland",
"498345", "Stöttwang",
"499332", "Marktbreit",
"496220", "Wilhelmsfeld",
"496244", "Westhofen\ Rheinhessenen",
"496574", "Hasborn",
"494141", "Stade",
"492103", "Hilden",
"496776", "Dachsenhausen",
"492158", "Grefrath\ bei\ Krefeld",
"494401", "Brake\ Unterweser",
"4935024", "Stadt\ Wehlen",
"492443", "Mechernich",
"496735", "Eppelsheim",
"49531", "Braunschweig",
"4933965", "Herzsprung\ bei\ Wittstock",
"492327", "Bochum\-Wattenscheid",
"49395", "Neubrandenburg",
"498501", "Thyrnau",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495333", "Dettum",
"495186", "Salzhemmendorf\-Wallensen",
"494294", "Riede\ Kreis\ Verden",
"496669", "Neuhof\-Hauswurz",
"4934345", "Bad\ Lausick",
"494175", "Egestorf\ Nordheide",
"492585", "Warendorf\-Hoetmar",
"497166", "Adelberg",
"495521", "Herzberg\ am\ Harz",
"495742", "Preussisch\ Oldendorf",
"4938792", "Lenzen\ \(Elbe\)",
"4938225", "Trinwillershagen",
"492592", "Selm",
"497633", "Staufen\ im\ Breisgau",
"4935385", "Annaburg",
"492843", "Rheinberg",
"4933766", "Teupitz",
"498630", "Oberneukirchen",
"497234", "Tiefenbronn",
"4939393", "Werben\ Elbe",
"49761", "Freiburg\ im\ Breisgau",
"4939741", "Jatznick",
"492678", "Büchel\ bei\ Cochem",
"497222", "Rastatt",
"4934633", "Braunsbedra",
"4939088", "Letzlingen",
"4936601", "Hermsdorf\ Thüringen",
"497771", "Stockach",
"498642", "Übersee",
"499635", "Bärnau",
"495225", "Spenge",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"496478", "Greifenstein\-Ulm",
"499676", "Winklarn",
"4938789", "Wolfshagen\ bei\ Perleberg",
"4939777", "Borkenfriede",
"498137", "Petershausen",
"493462", "Bad\ Dürrenberg",
"497745", "Jestetten",
"496161", "Brensbach",
"494264", "Sottrum\ Kreis\ Rotenburg",
"499078", "Mertingen",
"4934493", "Gössnitz\ Thüringen",
"494663", "Süderlügum",
"492954", "Rüthen\-Oestereiden",
"498846", "Uffing\ am\ Staffelsee",
"496764", "Rheinböllen",
"498547", "Osterhofen\-Gergweis",
"497967", "Jagstzell",
"496566", "Körperich",
"494323", "Bornhöved",
"499384", "Schwanfeld",
"496867", "Perl",
"495648", "Brakel\-Gehrden",
"495031", "Wunstorf",
"498073", "Gars\ am\ Inn",
"494447", "Vechta\-Langförden",
"4938324", "Velgast",
"492697", "Blankenheim\-Ahrhütte",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4937296", "Stollberg\ Erzgebirge",
"495292", "Lichtenau\-Atteln",
"495873", "Eimke",
"492772", "Herborn\ Hessen",
"497174", "Mögglingen",
"495354", "Jerxheim",
"4939883", "Gross\ Dölln",
"496338", "Hornbach\ Pfalz",
"4938208", "Kavelstorf",
"4935895", "Klitten",
"4936846", "Suhl\-Dietzhausen",
"492387", "Drensteinfurt\-Walstedde",
"4933201", "Gross\ Glienicke",
"495126", "Algermissen",
"499293", "Berg\ Oberfranken",
"499872", "Heilsbronn",
"494107", "Siek\ Kreis\ Stormarn",
"493386", "Premnitz",
"499097", "Marxheim",
"492525", "Beckum\-Neubeckum",
"4938825", "Klütz",
"499255", "Marktleugast",
"496329", "Weidenthal\ Pfalz",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"496897", "Sulzbach\ Saar",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"496596", "Üdersdorf",
"4936920", "Grossenlupnitz",
"493425", "Wurzen",
"497561", "Leutkirch\ im\ Allgäu",
"4934208", "Löbnitz\ bei\ Delitzsch",
"492667", "Stein\-Neukirch",
"497654", "Löffingen",
"492064", "Dinslaken",
"499472", "Hohenfels\ Oberpfalz",
"494235", "Langwedel\-Etelsen",
"498250", "Hilgertshausen\-Tandern",
"495262", "Extertal",
"4934955", "Gossa",
"4938756", "Grabow",
"498106", "Vaterstetten",
"497253", "Bad\ Schönborn",
"499551", "Burgwindheim",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"496467", "Hatzfeld\ Eder",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"498446", "Pörnbach",
"494847", "Oster\-Ohrstedt",
"494276", "Borstel\ bei\ Sulingen",
"494546", "Mustin\ Lauenburg",
"4934244", "Mockrehna",
"494744", "Loxstedt",
"497265", "Angelbachtal",
"499263", "Ludwigsstadt",
"4933745", "Petkus",
"4936074", "Worbis",
"494531", "Bad\ Oldesloe",
"4934324", "Ostrau\ Sachsen",
"498431", "Neuburg\ an\ der\ Donau",
"499664", "Hahnbach",
"495473", "Ostercappeln",
"4939348", "Klitsche",
"497348", "Beimerstetten",
"49581", "Uelzen",
"498033", "Oberaudorf",
"495071", "Schwarmstedt",
"496553", "Schönecken",
"4939456", "Altenbrak",
"492724", "Finnentrop\-Serkenrode",
"496582", "Freudenburg",
"492827", "Goch\-Hassum",
"493385", "Rathenow",
"492526", "Sendenhorst",
"498237", "Aindling",
"4935975", "Hohnstein",
"492732", "Kreuztal",
"497042", "Vaihingen\ an\ der\ Enz",
"4936944", "Rentwertshausen",
"495833", "Brome",
"496261", "Mosbach\ Baden",
"494164", "Harsefeld",
"4933633", "Spreenhagen",
"499089", "Bissingen\-Unterringingen",
"4939200", "Gommern",
"4938724", "Siggelkow",
"496707", "Windesheim",
"4936255", "Goldbach\ bei\ Gotha",
"499727", "Schonungen\-Marktsteinach",
"496804", "Mandelbachtal",
"495045", "Springe\-Bennigsen",
"499824", "Dietenhofen",
"494883", "Süderstapel",
"497904", "Ilshofen",
"4933844", "Brück\ Brandenburg",
"494852", "Brunsbüttel",
"497134", "Weinsberg",
"498845", "Bad\ Kohlgrub",
"493695", "Bad\ Salzungen",
"493362", "Erkner",
"494977", "Blomberg\ Ostfriesland",
"496565", "Dudeldorf",
"497122", "St\ Johann\ Württemberg",
"492689", "Dierdorf",
"496508", "Hetzerath\ Mosel",
"499832", "Wassertrüdingen",
"4939951", "Faulenrost",
"4935842", "Oderwitz",
"499528", "Donnersdorf",
"494483", "Ovelgönne\-Grossenmeer",
"499424", "Strasskirchen",
"498552", "Grafenau\ Niederbayern",
"495943", "Emlichheim",
"494559", "Wensin",
"4939821", "Carpin",
"496404", "Lich\ Hessen",
"496032", "Bad\ Nauheim",
"492369", "Dorsten\-Wulfen",
"494452", "Zetel\-Neuenburg",
"498459", "Manching",
"498583", "Neureichenau",
"493682", "Zella\-Mehlis",
"4938356", "Behrenhoff",
"493921", "Burg\ bei\ Magdeburg",
"494194", "Sievershütten",
"4933933", "Lindow\ Mark",
"4938220", "Wustrow\ Ostseebad",
"495286", "Ottenstein\ Niedersachsen",
"4936644", "Hirschberg\ Saale",
"498445", "Gerolsbach",
"496291", "Adelsheim",
"494275", "Ehrenburg",
"499607", "Luhe\-Wildenau",
"494545", "Seedorf\ Lauenburg",
"496627", "Nentershausen\ Hessen",
"4933837", "Brielow",
"496024", "Schöllkrippen",
"497266", "Kirchardt",
"4939002", "Oebisfelde",
"49541", "Osnabrück",
"498168", "Attenkirchen",
"494950", "Holtland",
"494236", "Kirchlinteln",
"499942", "Viechtach",
"492427", "Nideggen",
"498105", "Gilching",
"4933094", "Löwenberg",
"4935829", "Gersdorf\ bei\ Görlitz",
"499256", "Stammbach",
"495433", "Badbergen",
"492604", "Nassau\ Lahn",
"4939748", "Viereck",
"4936372", "Kleinneuhausen",
"4936608", "Seelingstädt\ bei\ Gera",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"496595", "Dockweiler",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"496120", "Aarbergen",
"492181", "Grevenbroich",
"492203", "Cologne\-Porz",
"494241", "Bassum",
"4937603", "Wildenfels",
"498328", "Balderschwang",
"4938462", "Baumgarten",
"499264", "Küps",
"4935472", "Schlepzig",
"497739", "Hilzingen",
"495474", "Stemwede\-Dielingen",
"498157", "Feldafing",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"498785", "Rottenburg\-Oberroning",
"497392", "Laupheim",
"497665", "March\ Breisgau",
"4938327", "Elmenhorst\ Vorpom",
"4933474", "Neutrebbin",
"497426", "Gosheim",
"494743", "Langen\ bei\ Bremerhaven",
"495685", "Knüllwald",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"497653", "Lenzkirch",
"495662", "Felsberg\ Hessen",
"498650", "Marktschellenberg",
"494635", "Sörup",
"4937321", "Frankenstein\ Sachsen",
"497254", "Waghäusel",
"492129", "Haan\ Rheinland",
"497682", "Elzach",
"492267", "Wipperfürth",
"4939453", "Derenburg",
"498762", "Wartenberg\ Oberbayern",
"494769", "Bremervörde\-Iselersheim",
"496821", "Neunkirchen\ Saar",
"499655", "Tännesberg",
"496187", "Schöneck",
"4939427", "Ströbeck",
"493904", "Haldensleben",
"496755", "Odernheim\ am\ Glan",
"499294", "Regnitzlosau",
"499175", "Spalt",
"4937606", "Lengenfeld\ Vogtland",
"4936041", "Bad\ Tennstedt",
"4939362", "Grieben\ bei\ Tangerhütte",
"496421", "Marburg",
"497362", "Bopfingen",
"499401", "Neutraubling",
"495353", "Königslutter\ am\ Elm",
"497173", "Heubach",
"4935773", "Schleife",
"495382", "Bad\ Gandersheim",
"498170", "Strasslach\-Dingharting",
"492621", "Lahnstein",
"4939054", "Flechtingen",
"494156", "Talkau",
"497728", "Niedereschach",
"4934462", "Laucha\ Unstrut",
"4938353", "Gützkow\ bei\ Greifswald",
"495365", "Wolfsburg\-Neindorf",
"495692", "Wolfhagen",
"499141", "Weissenburg\ in\ Bayern",
"495777", "Diepenau\-Essern",
"494332", "Hamdorf\ bei\ Rendsburg",
"497385", "Gomadingen",
"495874", "Soltendieck",
"492297", "Wildbergerhütte",
"495308", "Lehre",
"4939752", "Blumenhagen\ bei\ Strasburg",
"499383", "Wiesentheid",
"494324", "Brokstedt",
"494340", "Achterwehr",
"496763", "Kirchberg\ Hunsrück",
"4936077", "Grossbodungen",
"492953", "Wünnenberg",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4934327", "Waldheim\ Sachsen",
"492982", "Medebach",
"498074", "Schnaitsee",
"4933609", "Brieskow\-Finkenheerd",
"499352", "Lohr\ am\ Main",
"499906", "Mariaposching",
"4938234", "Born\ Darss",
"497826", "Schuttertal",
"497527", "Wolfegg",
"498677", "Burghausen\ Salzach",
"495434", "Essen\ Oldenburg",
"494641", "Süderbrarup",
"492603", "Bad\ Ems",
"492204", "Bensberg",
"4933335", "Pinnow\ Kreis\ Uckermark",
"496458", "Rosenthal\ Hessen",
"499656", "Moosbach\ bei\ Vohenstrauss",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"495529", "Rhumspringe",
"4936947", "Jüchsen",
"498802", "Huglfing",
"4939886", "Milmersdorf",
"496381", "Kusel",
"494636", "Langballig",
"4936843", "Benshausen",
"4938727", "Mestlin",
"495422", "Melle",
"492056", "Heiligenhaus",
"497666", "Denzlingen",
"4937293", "Eppendorf\ Sachsen",
"494193", "Henstedt\-Ulzburg",
"496227", "Walldorf\ Baden",
"499207", "Königsfeld\ Oberfranken",
"496023", "Alzenau\ in\ Unterfranken",
"496691", "Schwalmstadt",
"497425", "Trossingen",
"495686", "Schwarzenborn\ Knüll",
"4933847", "Görzke",
"493561", "Guben",
"4934363", "Cavertitz",
"496403", "Linden\ Hessen",
"4938452", "Lalendorf",
"499423", "Geiselhöring",
"494484", "Hude\-Wüsting",
"495944", "Hoogstede",
"498584", "Breitenberg\ Niederbayern",
"497751", "Waldshut",
"492861", "Borken\ Westfalen",
"499347", "Wittighausen",
"499135", "Hessdorf\ Mittelfranken",
"494149", "Fredenbeck",
"498142", "Olching",
"4937383", "Lunzenau",
"497825", "Kippenheim",
"499905", "Bernried\ Niederbayern",
"49711", "Stuttgart",
"494884", "Schwabstedt",
"499823", "Leutershausen",
"497903", "Mainhardt",
"496803", "Mandelbachtal\-Ommersheim",
"494155", "Büchen",
"4936647", "Saalburg\ Thüringen",
"495366", "Jembke",
"497133", "Lauffen\ am\ Neckar",
"492461", "Jülich",
"4933834", "Pritzerbe",
"497386", "Hayingen",
"4935600", "Döbern\ NL",
"494163", "Horneburg\ Niederelbe",
"495834", "Wittingen\-Knesebeck",
"498379", "Waltenhofen\-Oberdorf",
"494372", "Westfehmarn",
"493967", "Oertzenhof\ bei\ Strasburg",
"496858", "Ottweiler\-Fürth",
"496661", "Schlüchtern",
"497958", "Rot\ Am\ See\-Brettheim",
"4938753", "Wöbbelin",
"493591", "Bautzen",
"498022", "Tegernsee",
"496554", "Waxweiler",
"498637", "Lohkirchen",
"494409", "Westerstede\-Ocholt",
"498402", "Münchsmünster",
"4935797", "Schwepnitz",
"498034", "Brannenburg",
"496756", "Winterbach\ Soonwald",
"495822", "Ebstorf",
"499176", "Allersberg",
"494502", "Lübeck\-Travemünde",
"498509", "Ruderting",
"492723", "Kirchhundem",
"499090", "Rain\ Lech",
"494256", "Hilgermissen",
"499241", "Pegnitz",
"499571", "Lichtenfels\ Bayern",
"4937328", "Grossschirma",
"497462", "Immendingen",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"499236", "Nagel",
"493745", "Falkenstein\ Vogtland",
"495453", "Recke",
"498095", "Aying",
"495148", "Steinhorst\ Niedersachsen",
"4935268", "Stauchitz",
"495482", "Tecklenburg",
"494942", "Südbrookmerland",
"497569", "Isny\-Eisenbach",
"496052", "Bad\ Orb",
"496287", "Limbach\ Baden",
"495465", "Neuenkirchen\ bei\ Bramsche",
"498532", "Griesbach\ im\ Rottal",
"492238", "Pulheim",
"494539", "Westerau",
"499194", "Ebermannstadt",
"4938735", "Plau\ am\ See",
"499545", "Buttenheim",
"494432", "Dötlingen\-Brettorf",
"494607", "Janneby",
"499275", "Speichersdorf",
"496083", "Weilrod",
"497485", "Empfingen",
"4939859", "Fürstenwerder",
"495626", "Bad\ Zwesten",
"4934691", "Könnern",
"49361", "Erfurt",
"495028", "Pennigsehl",
"4937204", "Lichtenstein\ Sachsen",
"497543", "Kressbronn\ am\ Bodensee",
"497273", "Hagenbach\ Pfalz",
"493771", "Aue\ Sachsen",
"4934609", "Salzmünde",
"498726", "Schönau\ Niederbayern",
"497674", "Todtmoos",
"499452", "Langquaid",
"499977", "Arnschwang",
"495865", "Gusborn",
"4937437", "Bad\ Elster",
"4936702", "Lauscha",
"495374", "Isenbüttel",
"497154", "Kornwestheim",
"4934496", "Nöbdenitz",
"495808", "Gerdau",
"494528", "Schönwalde\ am\ Bungsberg",
"494832", "Meldorf",
"495504", "Friedland\ Kreis\ Göttingen",
"4939929", "Jabel\ bei\ Waren",
"498065", "Tuntenhausen\-Schönau",
"494824", "Krempe",
"495706", "Porta\ Westfalica",
"497326", "Neresheim",
"499852", "Feuchtwangen",
"4933234", "Wustermark",
"4934636", "Schafstädt",
"496533", "Morbach\ Hunsrück",
"499164", "Langenfeld\ Mittelfranken",
"495495", "Vörden\ Kreis\ Vechta",
"498053", "Bad\ Endorf",
"492974", "Schmallenberg\-Fredeburg",
"498257", "Inchenhofen",
"498082", "Schwindegg",
"4936781", "Grossbreitenbach",
"495853", "Neu\ Darchau",
"49651", "Trier",
"492752", "Bad\ Laasphe",
"4939396", "Neukirchen\ Altmark",
"4934909", "Aken\ Elbe",
"4933438", "Altlandsberg",
"495882", "Gorleben",
"4933763", "Bestensee",
"494263", "Scheessel",
"4936209", "Klettbach",
"499531", "Ebern",
"4935454", "Uckro",
"498388", "Hergensweiler",
"498725", "Wurmannsquick",
"494664", "Neukirchen\ bei\ Niebüll",
"4938847", "Boizenburg\ Elbe",
"4933452", "Neulewin",
"494551", "Bad\ Segeberg",
"495466", "Merzen",
"4939995", "Nossendorf",
"492361", "Recklinghausen",
"499546", "Burgebrach",
"499276", "Bischofsgrün",
"499847", "Ergersheim",
"499744", "Zeitlofs\-Detter",
"497486", "Horb\-Altheim",
"495625", "Naumburg\ Hessen",
"499720", "Üchtelhausen",
"4935027", "Weesenstein",
"493544", "Luckau\ Brandenburg",
"499235", "Thierstein",
"494472", "Lastrup",
"494249", "Bassum\-Nordwohlde",
"492548", "Dülmen\-Rorup",
"497622", "Schopfheim",
"498572", "Tann\ Niederbayern",
"49721", "Karlsruhe",
"498302", "Görisried",
"497634", "Sulzburg",
"4938871", "Mühlen\ Eichsen",
"492844", "Rheinberg\-Orsoy",
"494255", "Martfeld",
"498230", "Gablingen",
"496881", "Lebach",
"492747", "Molzhain",
"4933878", "Nennhausen",
"493731", "Freiberg\ Sachsen",
"497233", "Niefern\-Öschelbronn",
"49760", "Oberried\ Breisgau",
"495961", "Haselünne",
"494872", "Hanerau\-Hademarschen",
"494293", "Ottersberg\-Fischerhude",
"496127", "Niedernhausen\ Taunus",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"499107", "Trautskirchen",
"496269", "Gundelsheim\ Württemberg",
"499081", "Nördlingen",
"496358", "Kriegsfeld",
"499937", "Oberpöring",
"497702", "Blumberg\ Baden",
"4936422", "Reinstädt\ Thüringen",
"4935053", "Glashütte\ Sachsen",
"492444", "Schleiden\-Gemünd",
"494957", "Detern",
"492391", "Plettenberg",
"495322", "Bad\ Harzburg",
"493448", "Meuselwitz\ Thüringen",
"496047", "Altenstadt\ Hessen",
"492934", "Sundern\-Altenhellefeld",
"495705", "Petershagen\-Windheim",
"492681", "Altenkirchen\ Westerwald",
"498066", "Bad\ Feilnbach",
"496644", "Grebenhain",
"496620", "Philippsthal\ Werra",
"497325", "Sontheim\ an\ der\ Brenz",
"4939774", "Mönkebude",
"496573", "Gillenfeld",
"495768", "Petershagen\-Heimsen",
"492104", "Mettmann",
"495051", "Bergen\ Kreis\ Celle",
"496243", "Monsheim",
"4933363", "Altenhof\ Kreis\ Barnim",
"4935605", "Komptendorf",
"499323", "Iphofen",
"494384", "Selent",
"496303", "Enkenbach\-Alsenborn",
"498851", "Kochel\ am\ See",
"497587", "Hosskirch",
"499447", "Essing",
"492922", "Werl",
"495744", "Hüllhorst",
"499625", "Kastl\ bei\ Amberg",
"495546", "Scheden",
"498303", "Waltenhofen",
"492594", "Dülmen",
"495276", "Marienmünster",
"496668", "Birstein\-Lichenroth",
"499466", "Stamsried",
"497951", "Crailsheim",
"494285", "Rhade\ bei\ Zeven",
"496851", "St\ Wendel",
"497232", "Königsbach\-Stein",
"497300", "Roggenburg",
"4939721", "Liepen\ bei\ Anklam",
"492159", "Meerbusch\-Osterath",
"494473", "Emstek",
"4934782", "Mansfeld\ Südharz",
"497570", "Sigmaringen\-Gutenstein",
"4934654", "Stolberg\ Harz",
"496215", "Ludwigshafen",
"497224", "Gernsbach",
"496066", "Michelstadt\-Vielbrunn",
"4939293", "Dreileben",
"497240", "Pfinztal",
"495531", "Holzminden",
"498243", "Fuchstal",
"4938325", "Rolofshagen",
"493672", "Rudolstadt",
"498573", "Ering",
"497623", "Rheinfelden\ Baden",
"499961", "Mitterfels",
"4935894", "Hähnichen",
"497456", "Haiterbach",
"492171", "Leverkusen\-Opladen",
"4938483", "Brüel",
"492405", "Würselen",
"4935203", "Tharandt",
"493464", "Sangerhausen",
"4937463", "Bergen\ Vogtland",
"498269", "Unteregg\ bei\ Mindelheim",
"494262", "Visselhövede",
"495235", "Blomberg\ Lippe",
"4936733", "Kaulsdorf",
"4935876", "Weissenberg\ Sachsen",
"497557", "Herdwangen\-Schönach",
"496302", "Winnweiler",
"492564", "Vreden",
"4939425", "Dingelstedt\ am\ Huy",
"496698", "Schrecksbach",
"492923", "Lippetal\-Herzfeld",
"4938824", "Mallentin",
"494354", "Fleckeby",
"4936692", "Bürgel",
"495937", "Geeste\-Gross\ Hesepe",
"496096", "Wiesen\ Unterfranken",
"496479", "Waldbrunn\ Westerwald",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"496572", "Manderscheid\ Eifel",
"4937430", "Eichigt",
"499334", "Giebelstadt",
"496242", "Osthofen",
"4933708", "Rangsdorf",
"492651", "Mayen",
"494126", "Horst\ Holstein",
"493375", "Königs\ Wusterhausen",
"495447", "Lembruch",
"497703", "Bonndorf\ im\ Schwarzwald",
"495323", "Clausthal\-Zellerfeld",
"499567", "Sesslach\-Gemünda",
"496451", "Frankenberg\ Eder",
"492337", "Hagen\-Dahl",
"493494", "Wolfen",
"4938782", "Reetz\ bei\ Perleberg",
"494873", "Aukrug",
"494292", "Ritterhude",
"4933744", "Hohenseefeld",
"4936075", "Dingelstädt\ Eichsfeld",
"4934325", "Mochau\-Lüttewitz",
"496725", "Gau\-Algesheim",
"493341", "Strausberg",
"4939383", "Sandau\ Elbe",
"497542", "Tettnang",
"4933337", "Altkünkendorf",
"497721", "Villingen\ im\ Schwarzwald",
"492406", "Herzogenrath",
"4935974", "Hinterhermsdorf",
"492628", "Rhens",
"497272", "Rülzheim",
"4939401", "Neuwegersleben",
"4939241", "Leitzkau",
"499482", "Wörth\ an\ der\ Donau",
"49851", "Passau",
"493624", "Ohrdruf",
"495236", "Blomberg\-Grossenmarpe",
"499148", "Ettenstatt",
"49441", "Oldenburg",
"499453", "Thalmassing",
"495301", "Lehre\-Essenrode",
"4936458", "Bad\ Berka",
"497449", "Baiersbronn\-Obertal",
"4938856", "Pritzier\ bei\ Hagenow",
"498533", "Rotthalmünster",
"4938725", "Gross\ Godems",
"4938292", "Kröpelin",
"493632", "Sondershausen",
"495241", "Gütersloh",
"4934926", "Pretzsch\ Elbe",
"496053", "Wächtersbach",
"497455", "Dornhan",
"495571", "Uslar",
"4933972", "Breddin",
"496257", "Seeheim\-Jugenheim",
"496082", "Niederreifenberg",
"4936945", "Henneberg",
"494433", "Dötlingen",
"4934382", "Nerchau",
"4939321", "Arneburg",
"495452", "Mettingen\ Westfalen",
"496216", "Ludwigshafen",
"497463", "Mühlheim\ an\ der\ Donau",
"492131", "Neuss",
"4933845", "Borkheide",
"4935249", "Basslitz",
"496008", "Echzell",
"498460", "Berching\-Holnstein",
"495483", "Lienen",
"4939482", "Gatersleben",
"4936254", "Friedrichswerth",
"494943", "Grossefehn",
"499408", "Altenthann",
"499626", "Hohenburg",
"496428", "Stadtallendorf",
"4935329", "Dollenchen",
"495545", "Hedemünden",
"495275", "Höxter\-Ottbergen",
"4936333", "Heringen\ Helme",
"499465", "Neukirchen\-Balbini",
"495194", "Bispingen",
"494286", "Gyhum",
"4935020", "Struppen",
"497939", "Schrozberg\-Spielbach",
"492753", "Erndtebrück",
"495852", "Bleckede",
"498860", "Bernbeuren",
"495883", "Lemgow",
"4935931", "Königswartha",
"496726", "Lorch\ Rheingau",
"496524", "Rodershausen",
"499504", "Stadelhofen",
"4938301", "Putbus",
"493335", "Finowfurt",
"498052", "Aschau\ im\ Chiemgau",
"499374", "Eschau",
"4933672", "Pfaffendorfb\ Beeskow",
"496532", "Zeltingen\-Rachtig",
"496439", "Holzappel",
"4937752", "Eibenstock",
"4935696", "Briesnig",
"4936645", "Mühltroff",
"495977", "Spelle",
"495060", "Bodenburg",
"498083", "Isen",
"499865", "Adelshofen\ Mittelfranken",
"498321", "Sonthofen",
"4935342", "Mühlberg\ Elbe",
"4937362", "Seiffen\ Erzgebirge",
"492507", "Havixbeck",
"496095", "Bessenbach",
"492639", "Anhausen\ Kreis\ Neuwied",
"49481", "Heide\ Holstein",
"499853", "Wilburgstetten",
"494125", "Seestermühe",
"497184", "Kaisersbach",
"4935436", "Laasow\ bei\ Calau",
"4934292", "Brandis\ bei\ Wurzen",
"4935795", "Königsbrück",
"495164", "Hodenhagen",
"494833", "Wesselburen",
"499495", "Breitenbrunn\ Oberpfalz",
"492377", "Wickede\ Ruhr",
"4939606", "Glienke",
"492947", "Anröchte",
"496402", "Hungen",
"4935952", "Grossröhrsdorf\ OL",
"499422", "Bogen\ Niederbayern",
"496637", "Feldatal",
"498554", "Schönberg\ Niederbayern",
"498756", "Nandlstadt",
"492688", "Kroppach",
"496034", "Wöllstadt",
"499396", "Urspringen\ bei\ Lohr",
"4938320", "Tribsees",
"493931", "Stendal",
"496509", "Büdlich",
"494454", "Jade",
"499529", "Oberaurach",
"495761", "Stolzenau",
"493946", "Quedlinburg",
"495656", "Waldkappel",
"4936624", "Teichwolframsdorf",
"4939036", "Binde",
"494192", "Bad\ Bramstedt",
"499434", "Bodenwöhr",
"498661", "Grabenstätt\ Chiemsee",
"498858", "Kochel\-Walchensee",
"493475", "Lutherstadt\ Eisleben",
"496022", "Obernburg\ am\ Main",
"4936461", "Bad\ Sulza",
"496130", "Schwabenheim\ an\ der\ Selz",
"498803", "Peissenberg",
"495347", "Burgdorf\ bei\ Salzgitter",
"4936966", "Kaltennordheim",
"499088", "Mönchsdeggingen",
"499944", "Miltach",
"499920", "Bischofsmais",
"495423", "Versmold",
"4938737", "Ganzlin",
"496351", "Eisenberg\ Pfalz",
"4939728", "Medow\ bei\ Anklam",
"492602", "Montabaur",
"493394", "Wittstock\ Dosse",
"4939973", "Altkalen",
"4962199", "Ludwigshafen",
"496142", "Rüsselsheim",
"494770", "Wischhafen",
"495207", "Schloss\ Holte\-Stukenbrock",
"493441", "Zeitz",
"493836", "Wolgast",
"493537", "Jessen\ Elster",
"498403", "Pförring",
"496584", "Wellen\ Mosel",
"492271", "Bergheim\ Erft",
"4937435", "Reuth\ bei\ Plauen",
"492541", "Coesfeld",
"494503", "Timmendorfer\ Strand",
"499366", "Geroldshausen\ Unterfranken",
"492722", "Attendorn",
"4939009", "Badel",
"495823", "Bienenbüttel",
"496786", "Kempfeld",
"492734", "Freudenberg\ Westfalen",
"495905", "Beesten",
"497044", "Mönsheim",
"496888", "Lebach\-Steinbach",
"494162", "Jork",
"492837", "Weeze",
"4933654", "Fünfeichen",
"4936924", "Mihla",
"492536", "Münster\-Albachten",
"493841", "Wismar",
"495135", "Burgwedel\-Fuhrberg",
"498023", "Bayrischzell",
"4933084", "Gutengermendorf",
"499822", "Bechhofen\ an\ der\ Heide",
"498381", "Lindenberg\ im\ Allgäu",
"497356", "Schemmerhofen",
"495176", "Edemissen",
"496802", "Völklingen\-Lauterbach",
"4936379", "Holzengel",
"494854", "Friedrichskoog",
"492575", "Greven\-Reckenfeld",
"492245", "Much",
"494185", "Marxen\ Auetal",
"497132", "Neckarsulm",
"494757", "Wanna",
"494558", "Todesfelde",
"493364", "Eisenhüttenstadt",
"492305", "Castrop\-Rauxel",
"497124", "Trochtelfingen\ Hohenz",
"499737", "Wartmannsroth",
"4933701", "Grossbeeren",
"492368", "Oer\-Erkenschwick",
"498458", "Gaimersheim",
"498143", "Inning\ am\ Ammersee",
"4935822", "Hagenwerder",
"499834", "Theilenhofen",
"4938720", "Grebbin",
"4938845", "Kaarssen",
"493971", "Anklam",
"4939204", "Niederndodeleben",
"496074", "Rödermark",
"4936940", "Oepfershausen",
"496677", "Neuenstein\ Hessen",
"492850", "Rees\-Haldern",
"495663", "Spangenberg",
"493435", "Oschatz",
"4934672", "Rossleben",
"497652", "Hinterzarten",
"499474", "Schmidmühlen",
"496339", "Grosssteinhausen",
"495264", "Kalletal",
"4939997", "Jarmen",
"497683", "Simonswald",
"498421", "Eichstätt\ Bayern",
"495655", "Wanfried",
"4939248", "Dobritz",
"497393", "Munderkingen",
"4933964", "Fretzdorf",
"4939408", "Hadmersleben",
"4936451", "Buttelstedt",
"4935025", "Liebstadt",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4934224", "Belgern\ Sachsen",
"494521", "Eutin",
"494742", "Dorum",
"4934344", "Kohren\-Sahlis",
"499395", "Triefenstein",
"499662", "Vilseck",
"4939328", "Rochau",
"496762", "Kastellaun",
"492306", "Lünen",
"492952", "Rüthen",
"499382", "Gerolzhofen",
"498821", "Garmisch\-Partenkirchen",
"4938224", "Gresenhorst",
"499353", "Karlstadt",
"49431", "Kiel",
"4935384", "Steinsdorf\ bei\ Jessen",
"4936640", "Remptendorf",
"493876", "Perleberg",
"492983", "Winterberg\-Siedlinghausen",
"495401", "Georgsmarienhütte",
"493307", "Zehdenick",
"495693", "Volkmarsen",
"495021", "Nienburg\ Weser",
"497355", "Hochdorf\ Riss",
"495175", "Lehrte\-Arpke",
"4933926", "Herzberg\ Mark",
"496650", "Hosenfeld",
"492246", "Lohmar\ Rheinland",
"495294", "Hövelhof\-Espeln",
"494186", "Buchholz\-Trelde",
"492774", "Dietzhölztal",
"494333", "Erfde",
"495906", "Lünne",
"495352", "Schöningen",
"497172", "Lorch\ Württemberg",
"494927", "Krummhörn\-Loquard",
"492535", "Sendenhorst\-Albersloh",
"497363", "Lauchheim",
"495136", "Burgdorf\ Kreis\ Hannover",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4935938", "Grosspostwitz\ OL",
"495383", "Lutter\ am\ Barenberge",
"4938308", "Göhren\ Rügen",
"496328", "Elmstein",
"499874", "Neuendettelsau",
"499777", "Ostheim\ von\ der\ Rhön",
"495141", "Celle",
"496157", "Pfungstadt",
"499365", "Rimpar",
"4935607", "Jänschwalde",
"496785", "Herrstein",
"498374", "Dietmannsried",
"4939826", "Blankensee\ bei\ Neustrelitz",
"498808", "Pähl",
"497477", "Jungingen\ bei\ Hechingen",
"4939779", "Eggesin",
"495839", "Wittingen\-Ohrdorf",
"499287", "Selb",
"495428", "Melle\-Neuenkirchen",
"493342", "Neuenhagen\ bei\ Berlin",
"4938787", "Glöwen",
"499083", "Möttingen",
"495606", "Zierenberg",
"496275", "Rothenberg\ Odenwald",
"496545", "Blankenrath",
"494627", "Dörpstedt",
"498039", "Rott\ am\ Inn",
"4938351", "Mesekenhagen",
"4934465", "Bad\ Bibra",
"496559", "Leidenborn",
"496483", "Selters\ Taunus",
"497085", "Enzklösterle",
"494404", "Elsfleth",
"496452", "Battenberg\ Eder",
"498504", "Tittling",
"492393", "Sundern\-Allendorf",
"495065", "Sibbesse",
"498706", "Vilsheim",
"4939365", "Bellingen\ bei\ Stendal",
"495257", "Hövelhof",
"495082", "Langlingen",
"492683", "Asbach\ Westerwald",
"4933768", "Prieros",
"492652", "Mendig",
"497062", "Beilstein\ Württemberg",
"494120", "Ellerhoop",
"496571", "Wittlich",
"494144", "Himmelpforten",
"4933433", "Buckow\ Märkische\ Schweiz",
"495053", "Fassberg\-Müden",
"4935771", "Bad\ Muskau",
"496241", "Worms",
"496236", "Neuhofen\ Pfalz",
"4939086", "Jävenitz",
"499321", "Kitzingen",
"496301", "Otterbach\ Pfalz",
"4936043", "Kirchheilingen",
"494261", "Rotenburg\ Wümme",
"4935263", "Gröditz\ bei\ Riesa",
"496164", "Reichelsheim\ Odenwald",
"499533", "Untermerzbach",
"4939451", "Wasserleben",
"495955", "Esterwegen",
"499962", "Schwarzach\ Niederbayern",
"494489", "Apen",
"49951", "Bamberg",
"494553", "Geschendorf",
"492363", "Datteln",
"4937323", "Lichtenberg\ Erzgebirge",
"498453", "Reichertshofen\ Oberbayern",
"497774", "Eigeltingen",
"495439", "Bersenbrück",
"497246", "Malsch\ Kreis\ Karlsruhe",
"497576", "Krauchenwies",
"494508", "Krummesse",
"4935032", "Langenhennersdorf",
"493671", "Saalfeld\ Saale",
"492355", "Schalksmühle",
"498465", "Kipfenberg",
"4936204", "Stotternheim",
"495532", "Stadtoldendorf",
"495828", "Himbergen",
"49371", "Chemnitz\ Sachsen",
"494804", "Nordhastedt",
"495726", "Wiedensahl",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"494707", "Langen\-Neuenwalde",
"495524", "Bad\ Lauterberg\ im\ Harz",
"4935475", "Straupitz",
"498028", "Fischbachau",
"497231", "Pforzheim",
"493733", "Annaberg\-Buchholz",
"495963", "Bawinkel",
"497952", "Gerabronn",
"497306", "Vöhringen\ Iller",
"496852", "Nohfelden",
"4939956", "Neukalen",
"4935058", "Pretzschendorf",
"496235", "Schifferstadt",
"4934297", "Liebertwolkwitz",
"4937422", "Markneukirchen",
"498334", "Bad\ Grönenbach",
"494329", "Langwedel\ Holstein",
"498322", "Oberstdorf",
"494794", "Worpswede\-Ostersode",
"4934904", "Oranienbaum",
"4937367", "Lengefeld\ Erzgebirge",
"4938751", "Picher",
"496531", "Bernkastel\-Kues",
"493909", "Klötze\ Altmark",
"4933368", "Hohensaaten",
"498051", "Prien\ am\ Chiemsee",
"4937757", "Rittersgrün",
"4933677", "Glienicke\ bei\ Beeskow",
"498705", "Altfraunhofen",
"495066", "Sarstedt",
"495851", "Dahlenburg",
"494467", "Wittmund\-Funnix",
"4933239", "Gross\ Behnitz",
"496744", "Oberwesel",
"495605", "Kaufungen\ Hessen",
"4939924", "Stuer",
"496276", "Hesseneck",
"4937381", "Penig",
"497947", "Forchtenberg",
"4939854", "Kleptow",
"499644", "Pressath",
"495725", "Lindhorst\ bei\ Stadthagen",
"4934361", "Dahlen\ Sachsen",
"4938455", "Plaaz",
"499243", "Pottenstein",
"499573", "Staffelstein\ Oberfranken",
"497305", "Erbach\ Donau",
"497259", "Östringen\-Odenheim",
"499303", "Eibelstadt",
"4939487", "Friedrichsbrunn",
"492132", "Meerbusch\-Büderich",
"496323", "Edenkoben",
"497245", "Durmersheim",
"4937291", "Augustusburg",
"495451", "Ibbenbüren",
"497575", "Messkirch",
"494764", "Gnarrenburg\-Klenkendorf",
"4934604", "Niemberg",
"492902", "Warstein",
"496447", "Langgöns\-Niederkleen",
"4937209", "Einsiedel\ bei\ Chemnitz",
"498466", "Denkendorf\ Oberbayern",
"495242", "Rheda\-Wiedenbrück",
"496107", "Kelsterbach",
"499269", "Tettau\ Kreis\ Kronach",
"499127", "Rosstal\ Mittelfranken",
"495572", "Bodenfelde",
"4933873", "Grosswudicke",
"493631", "Nordhausen\ Thüringen",
"493984", "Prenzlau",
"492647", "Kesseling",
"499358", "Gössenheim",
"4933977", "Gumtow",
"4936841", "Schleusingen",
"497837", "Oberharmersbach",
"4933206", "Fichtenwalde",
"496081", "Usingen",
"4938297", "Moitin",
"497734", "Gailingen",
"499481", "Pfatter",
"497541", "Friedrichshafen",
"497722", "Triberg\ im\ Schwarzwald",
"494497", "Barssel\-Harkebrügge",
"493773", "Johanngeorgenstadt",
"497271", "Wörth\ am\ Rhein",
"495956", "Rastdorf",
"495302", "Vechelde",
"4933332", "Gartz\ Oder",
"494338", "Alt\ Duvenstedt",
"4935827", "Nieder\-Seifersdorf",
"497146", "Remseck\ am\ Neckar",
"498382", "Lindau\ Bodensee",
"4939746", "Krackow",
"4936606", "Kraftsdorf",
"496655", "Neuhof\ Kreis\ Fulda",
"497131", "Heilbronn\ Neckar",
"492463", "Titz",
"4936783", "Gehren\ Thüringen",
"494161", "Buxtehude",
"497026", "Lenningen",
"495339", "Gielde",
"496264", "Neudenau",
"492455", "Waldfeucht",
"496663", "Steinau\ an\ der\ Strasse",
"498365", "Wertach",
"494478", "Cappeln\ Oldenburg",
"495074", "Rodewald",
"492449", "Blankenheim\ Ahr",
"4933839", "Wusterwitz",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"495677", "Calden\-Westuffeln",
"499360", "Thüngen",
"492272", "Bedburg\ Erft",
"497628", "Efringen\-Kirchen",
"492542", "Gescher",
"498248", "Lamerdingen",
"492721", "Lennestadt",
"495157", "Emmerthal\-Börry",
"494643", "Gelting\ Angeln",
"4936482", "Triptis",
"492601", "Nauort",
"497708", "Geisingen\-Leipferdingen",
"494776", "Osten\-Altendorf",
"495328", "Altenau\ Harz",
"494244", "Harpstedt",
"497765", "Rickenbach\ Hotzenwald",
"492855", "Voerde\ Niederrhein",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"498685", "Kirchanschöring",
"496136", "Nieder\-Olm",
"496383", "Glan\-Münchweiler",
"4938732", "Gallin\ bei\ Lübz",
"499926", "Frauenau",
"497806", "Bad\ Peterstal\-Griesbach",
"496352", "Kirchheimbolanden",
"495650", "Cornberg",
"496294", "Krautheim\ Jagst",
"494191", "Kaltenkirchen\ Holstein",
"499187", "Altdorf\ bei\ Nürnberg",
"4939458", "Heudeber",
"496693", "Neuental",
"496021", "Aschaffenburg",
"492928", "Soest\-Ostönnen",
"496175", "Friedrichsdorf\ Taunus",
"498395", "Tannheim\ Württemberg",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"493563", "Spremberg",
"496401", "Grünberg\ Hessen",
"499421", "Straubing",
"494735", "Butjadingen\-Stollhamm",
"499749", "Oberbach\ Unterfranken",
"497753", "Albbruck",
"492863", "Velen",
"496207", "Wald\-Michelbach",
"495142", "Eschede",
"4935602", "Drebkau",
"499227", "Neuenmarkt",
"4939226", "Hohenziatz",
"4933361", "Joachimsthal",
"496003", "Rosbach\ von\ der\ Höhe",
"494948", "Wiesmoor\-Marcardsmoor",
"4939059", "Wegenstedt",
"496423", "Wetter\ Hessen",
"497025", "Neuffen",
"499403", "Donaustauf",
"4933604", "Lebus",
"495351", "Helmstedt",
"497171", "Schwäbisch\ Gmünd",
"496347", "Hochstadt\ Pfalz",
"492456", "Selfkant",
"495130", "Wedemark",
"4939346", "Tucheim",
"498366", "Oy\-Mittelberg",
"492623", "Ransbach\-Baumbach",
"4936425", "Isserstedt",
"495022", "Wietzen",
"492224", "Bad\ Honnef",
"499143", "Pappenheim\ Mittelfranken",
"496656", "Ebersburg",
"4934977", "Quellendorf",
"494180", "Königsmoor",
"495379", "Sassenburg\-Grussendorf",
"497159", "Renningen",
"4934446", "Grosskorbetha",
"4934206", "Rötha",
"499381", "Volkach",
"498822", "Oberammergau",
"494829", "Wewelsfleth",
"492232", "Brühl\ Rheinland",
"498538", "Pocking\-Hartkirchen",
"497145", "Markgröningen",
"496761", "Simmern\ Hunsrück",
"492951", "Büren",
"495509", "Rosdorf\ Kreis\ Göttingen",
"496058", "Gründau",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"495034", "Neustadt\-Hagen",
"4938758", "Dömitz",
"494534", "Steinburg\ Kreis\ Storman",
"499199", "Kunreuth",
"494736", "Butjadingen\-Tossens",
"4938873", "Carlow",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4936848", "Wernshausen",
"498434", "Rennertshofen",
"499661", "Sulzbach\-Rosenberg",
"497337", "Nellingen\ Alb",
"4938450", "Tarnow\ bei\ Bützow",
"499554", "Untersteinbach\ Unterfranken",
"498422", "Dollnstein",
"494838", "Tellingstedt",
"4938332", "Gross\ Bisdorf",
"494522", "Plön",
"494741", "Nordholz\ bei\ Bremerhaven",
"495802", "Wrestedt",
"492758", "Bad\ Berleburg\-Girkhausen",
"496135", "Bodenheim\ Rhein",
"498686", "Petting",
"497651", "Titisee\-Neustadt",
"4939992", "Görmin",
"497805", "Appenweier",
"499925", "Bayerisch\ Eisenstein",
"495584", "Hattorf\ am\ Harz",
"4937298", "Oelsnitz\ Erzgebirge",
"499803", "Colmberg",
"4939264", "Kroppenstedt",
"494367", "Grossenbrode",
"497564", "Bad\ Wurzach",
"494775", "Grossenwörden",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4933479", "Küstrin\-Kietz",
"492856", "Hamminkeln\-Brünen",
"494346", "Gettorf",
"4938785", "Berge\ bei\ Perleberg",
"498823", "Mittenwald",
"492233", "Hürth\ Rheinland",
"4936072", "Weissenborn\-Lüderode",
"499351", "Gemünden\ am\ Main",
"4934322", "Rosswein",
"497747", "Berau",
"492981", "Winterberg\ Westfalen",
"492634", "Rengsdorf",
"495403", "Bad\ Iburg",
"497844", "Rheinau",
"4934242", "Hohenpriessnitz",
"498135", "Sulzemoos",
"49221", "Cologne",
"4933394", "Blumberg\ Kreis\ Barnim",
"495691", "Bad\ Arolsen",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"492622", "Bendorf\ am\ Rhein",
"494206", "Stuhr\-Heiligenrode",
"499142", "Treuchtlingen",
"4935820", "Zodel",
"4934467", "Eckartsberga",
"494331", "Rendsburg",
"492486", "Nettersheim",
"499637", "Falkenberg\ Oberpfalz",
"496422", "Kirchhain",
"4935389", "Holzdorf\ Elster",
"497361", "Aalen",
"499402", "Regenstauf",
"4938229", "Bad\ Sülze",
"495381", "Seesen",
"498176", "Egling\ bei\ Wolfratshausen",
"496396", "Hinterweidenthal",
"495458", "Hopsten",
"495143", "Winsen\ Aller",
"496002", "Ober\-Mörlen",
"4939422", "Badersleben",
"496434", "Bad\ Camberg",
"4936695", "Söllmnitz",
"499802", "Ansbach\-Katterbach",
"493973", "Pasewalk",
"492587", "Ennigerloh\-Westkirchen",
"4935201", "Langebrück",
"494177", "Drage\ Elbe",
"498761", "Moosburg\ an\ der\ Isar",
"4933969", "Stepenitz",
"495554", "Moringen",
"4936731", "Unterloquitz",
"495661", "Melsungen",
"495858", "Hitzacker\-Wietzetze",
"493586", "Neugersdorf\ Sachsen",
"492325", "Wanne\-Eickel",
"496834", "Bous",
"498656", "Anger",
"497681", "Waldkirch\ Breisgau",
"497934", "Weikersheim",
"496737", "Köngernheim",
"4938481", "Witzin",
"495199", "Schneverdingen\-Heber",
"4939291", "Calbe\ Saale",
"4939978", "Gross\ Roge",
"4934785", "Sandersleben",
"494964", "Rhede\ Ems",
"498423", "Titting",
"497391", "Ehingen\ Donau",
"4939723", "Krien",
"4939209", "Wanzleben",
"497420", "Deisslingen",
"495803", "Rosche",
"497444", "Alpirsbach",
"498347", "Friesenried",
"4938322", "Richtenberg",
"493629", "Stadtilm",
"494523", "Malente",
"498207", "Affing",
"495925", "Wietmarschen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492674", "Bad\ Bertrich",
"4934722", "Preusslitz",
"4934295", "Krensitz",
"499170", "Schwanstetten",
"4936374", "Weissensee",
"492273", "Kerpen\-Horrem",
"4935792", "Ossling",
"494501", "Kastorf\ Holstein",
"492543", "Billerbeck\ Westfalen",
"495821", "Bad\ Bevensen",
"492485", "Schleiden\-Dreiborn",
"494371", "Burg\ auf\ Fehmarn",
"498294", "Horgau",
"4937365", "Sayda",
"493843", "Güstrow",
"493592", "Kirschau",
"498021", "Waakirchen",
"496395", "Münchweiler\ an\ der\ Rodalb",
"498136", "Markt\ Indersdorf",
"494268", "Bötersen",
"4939004", "Köckte\ bei\ Gardelegen",
"4933675", "Tauche",
"498383", "Grünenbach\ Allgäu",
"4938303", "Sellin\ Ostseebad",
"499677", "Oberviechtach\-Pullenried",
"494205", "Ottersberg",
"4936642", "Harra",
"4937755", "Schönheide\ Erzgebirge",
"492462", "Linnich",
"499074", "Höchstädt\ an\ der\ Donau",
"4933089", "Himmelpfort",
"493869", "Dümmer",
"496474", "Villmar\-Aumenau",
"4936929", "Ruhla",
"4938423", "Bad\ Kleinen",
"4935933", "Neschwitz",
"498141", "Fürstenfeldbruck",
"499339", "Ippesheim",
"4936331", "Ilfeld",
"4935844", "Oybin\ Kurort",
"495926", "Engden",
"492862", "Südlohn",
"494137", "Barendorf",
"4938457", "Krakow\ am\ See",
"493933", "Genthin",
"496578", "Salmtal",
"495763", "Uchte",
"497660", "St\ Peter\ Schwarzwald",
"497974", "Bühlerzell",
"496308", "Olsbrücken",
"496874", "Wadern\-Nunkirchen",
"498663", "Ruhpolding",
"4936875", "Straufhain\-Streufdorf",
"4934423", "Heuckewalde",
"49391", "Magdeburg",
"493562", "Forst\ Lausitz",
"496692", "Neustadt\ Hessen",
"499157", "Alfeld\ Mittelfranken",
"4939485", "Gernrode\ Harz",
"492599", "Ascheberg\-Herbern",
"494298", "Lilienthal",
"498801", "Seeshaupt",
"49209", "Gelsenkirchen",
"496382", "Lauterecken",
"4938722", "Raduhn",
"4938295", "Satow\ bei\ Bad\ Doberan",
"493585", "Löbau",
"499762", "Saal\ an\ der\ Saale",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4939323", "Schönhausen\ Elbe",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"494630", "Barderup",
"4934385", "Mutzschen",
"496353", "Freinsheim",
"498649", "Schleching",
"494642", "Kappeln\ Schlei",
"497229", "Iffezheim",
"4939243", "Nedlitz\ bei\ Zerbst",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"492154", "Willich",
"493327", "Werder\ Havel",
"495187", "Delligsen",
"495755", "Kalletal\-Varenholz",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"492751", "Bad\ Berleburg",
"4939934", "Gross\ Plasten",
"496597", "Jünkerath",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4935825", "Kodersdorf",
"4933703", "Sperenberg",
"4935756", "Hosena",
"492425", "Nideggen\-Embken",
"4938780", "Lanz\ Brandenburg",
"498081", "Dorfen\ Stadt",
"497056", "Gechingen",
"492666", "Freilingen\ Westerwald",
"498323", "Immenstadt\ im\ Allgäu",
"496625", "Niederaula",
"494547", "Gudow\ Lauenburg",
"494277", "Schwaförden",
"499605", "Weiherhammer",
"494846", "Hattstedt",
"4937346", "Geyer",
"4939388", "Goldbeck\ Altm",
"497344", "Blaubeuren",
"4938376", "Zirchow",
"499851", "Dinkelsbühl",
"496466", "Dautphetal\-Friedensdorf",
"497204", "Malsch\-Völkersbach",
"4936762", "Steinach\ Thüringen",
"494748", "Stubben\ bei\ Bremerhaven",
"4937432", "Pausa\ Vogtland",
"492779", "Greifenstein\-Beilstein",
"4936259", "Tabarz\ Thüringer\ Wald",
"4939298", "Barby\ Elbe",
"4939971", "Gnoien",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"497723", "Furtwangen\ im\ Schwarzwald",
"494446", "Bakum\ Kreis\ Vechta",
"493772", "Schneeberg\ Erzgebirge",
"4935244", "Krögis",
"4936026", "Struth\ bei\ Mühlhausen",
"496866", "Perl\-Nennig",
"496567", "Oberkail",
"499451", "Schierling",
"498744", "Gerzen",
"497966", "Unterschneidheim",
"495303", "Wendeburg",
"498546", "Windorf\-Otterskirchen",
"494975", "Westerholt\ Ostfriesland",
"498847", "Obersöchering",
"498276", "Baar\ Schwaben",
"498531", "Pocking",
"492958", "Büren\-Harth",
"496051", "Gelnhausen",
"495573", "Uslar\-Volpriehausen",
"4935324", "Crinitz",
"494431", "Wildeshausen",
"492696", "Nohn\ Eifel",
"499725", "Poppenhausen\ Unterfranken",
"495644", "Willebadessen\-Peckelsheim",
"493525", "Riesa",
"4937468", "Treuen\ Vogtland",
"4935208", "Radeburg",
"499956", "Eichendorf\-Aufhausen",
"499302", "Rottendorf\ Unterfranken",
"497461", "Tuttlingen",
"492133", "Dormagen",
"496322", "Bad\ Dürkheim",
"4936463", "Gebstedt",
"495481", "Lengerich\ Westfalen",
"4936738", "Königsee",
"492903", "Meschede\-Freienohl",
"494941", "Aurich",
"49211", "Düsseldorf",
"4935955", "Pulsnitz",
"494936", "Grossheide",
"492825", "Uedem",
"495358", "Bahrdorf\-Mackendorf",
"494106", "Quickborn\ Kreis\ Pinneberg",
"4938488", "Demen",
"496334", "Thaleischweiler\-Fröschen",
"499242", "Gössweinstein",
"499572", "Burgkunstadt",
"495127", "Harsum",
"4937360", "Olbernhau",
"496028", "Sulzbach\ am\ Main",
"492921", "Soest",
"494859", "Windbergen",
"492682", "Hamm\ Sieg",
"497267", "Gemmingen",
"497129", "Lichtenstein\ Württemberg",
"496626", "Wildeck\-Obersuhl",
"499428", "Kirchroth",
"492254", "Weilerswist",
"496408", "Buseck",
"499606", "Pfreimd",
"494845", "Ostenfeld\ Husum",
"495083", "Hohne\ bei\ Celle",
"495052", "Hermannsburg",
"492653", "Kaisersesch",
"497063", "Bad\ Wimpfen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"496482", "Runkel",
"4934975", "Görzig\ Kreis\ Köthen",
"492426", "Nörvenich",
"492608", "Welschneudorf",
"495321", "Goslar",
"494237", "Bendingbostel",
"496589", "Kell\ am\ See",
"496453", "Gemünden\ Wohra",
"4936427", "Dornburg\ Saale",
"492392", "Werdohl",
"497055", "Neuweiler\ Kreis\ Calw",
"492739", "Wilnsdorf",
"494871", "Hohenwestedt",
"4938794", "Cumlosen",
"499257", "Zell\ Oberfranken",
"499082", "Oettingen\ in\ Bayern",
"498236", "Fischach",
"492527", "Lippetal\-Lippborg",
"494168", "Neu\ Wulmstorf\-Elstorf",
"494935", "Juist",
"492826", "Kranenburg\ Niederrhein",
"4934776", "Rothenschirmbach",
"497953", "Blaufelden",
"4936870", "Masserberg",
"494105", "Seevetal",
"496853", "Marpingen",
"49551", "Göttingen",
"495962", "Herzlake",
"492385", "Hamm\-Rhynern",
"4935724", "Lohsa",
"494471", "Cloppenburg",
"499955", "Mamming",
"493724", "Burgstädt",
"495533", "Bodenwerder",
"4936453", "Mellingen",
"4935022", "Bad\ Schandau",
"498241", "Buchloe",
"497621", "Lörrach",
"498571", "Simbach\ am\ Inn",
"4936338", "Bleicherode",
"496039", "Karben",
"499963", "Konzell",
"494552", "Leezen",
"492173", "Langenfeld\ Rheinland",
"496504", "Thalfang",
"499270", "Creussen",
"498452", "Geisenfeld",
"499524", "Zeil\ am\ Main",
"499726", "Euerbach",
"492695", "Insul",
"4933457", "Altreetz",
"492362", "Dorsten",
"496706", "Wallhausen\ Nahe",
"494445", "Visbek\ Kreis\ Vechta",
"499532", "Maroldsweisach",
"499828", "Rügland",
"4938842", "Lüttenmark",
"496374", "Weilerbach",
"498194", "Vilgertshofen",
"4933970", "Neustadt\ Dosse",
"496865", "Mettlach\-Orscholz",
"497138", "Schwaigern",
"497965", "Ellwangen\-Röhlingen",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"494976", "Spiekeroog",
"499439", "Neunburg\-Kemnath",
"498545", "Hofkirchen\ Bayern",
"492845", "Neukirchen\-Vluyn",
"497635", "Schliengen",
"496151", "Darmstadt",
"494254", "Eystrup",
"494682", "Amrum",
"49961", "Weiden\ in\ der\ Oberpfalz",
"495147", "Uetze\-Hänigsen",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"496202", "Schwetzingen",
"499222", "Presseck",
"4939294", "Gross\ Rosenburg",
"4934653", "Rottleberode",
"499234", "Neusorg",
"496342", "Schweigen\-Rechtenbach",
"4935248", "Schönfeld\ bei\ Grossenhain",
"492859", "Wesel\-Bislich",
"494921", "Emden\ Stadt",
"499633", "Mitterteich",
"4935893", "Mücka",
"4933202", "Töplitz",
"492871", "Bocholt",
"498732", "Frontenhausen",
"4934927", "Globig\-Bleddin",
"49201", "Essen",
"499196", "Wiesenttal",
"495223", "Bünde",
"4939885", "Jakobshagen",
"495027", "Linsburg",
"493301", "Oranienburg",
"4938484", "Ventschow",
"495624", "Bad\ Emstal",
"499745", "Wildflecken",
"493571", "Hoyerswerda",
"4933336", "Passow\ Kreis\ Uckermark",
"494608", "Handewitt",
"4936459", "Blankenhain\ Thüringen",
"4937464", "Schöneck\ Vogtland",
"497743", "Ühlingen\-Birkendorf",
"494426", "Wangerland\-Horumersiel",
"4935204", "Wilsdruff",
"495632", "Willingen\ Upland",
"495407", "Wallenhorst",
"494392", "Nortorf\ bei\ Neumünster",
"494665", "Emmelsbüll\-Horsbüll",
"498724", "Massing",
"492237", "Kerpen\ Rheinland\-Türnich",
"497676", "Feldberg\ Schwarzwald",
"4936734", "Leutenberg",
"497332", "Lauterstein",
"492471", "Roetgen\ Eifel",
"494385", "Hohenfelde\ bei\ Kiel",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"498203", "Grossaitingen",
"497156", "Ditzingen",
"4938823", "Selmsdorf",
"496659", "Eichenzell",
"4939607", "Kotelow",
"495807", "Altenmedingen",
"4934953", "Gräfenhainichen",
"495506", "Adelebsen",
"498343", "Aitrang",
"494826", "Hohenlockstedt",
"495704", "Petershagen\-Friedewalde",
"492935", "Sundern\-Hachen",
"496645", "Ulrichstein",
"494527", "Bosau",
"497324", "Herbrechtingen",
"497340", "Neenstetten",
"498427", "Wellheim",
"499978", "Schönthal\ Oberpfalz",
"499166", "Münchsteinach",
"496733", "Gau\-Odernheim",
"492445", "Schleiden\ Eifel",
"4935697", "Bagenz",
"493883", "Hagenow",
"492552", "Steinfurt\-Borghorst",
"498258", "Sielenbach",
"49671", "Bad\ Kreuznach",
"495335", "Schladen",
"4939384", "Arendsee\ Altmark",
"494362", "Heiligenhafen",
"498369", "Rückholz",
"492583", "Sassenberg",
"494173", "Wulfsen",
"4933743", "Blönsdorf",
"499848", "Simmershofen",
"4935728", "Uhyst\ Spree",
"494425", "Wangerland\-Hooksiel",
"4935973", "Stolpen",
"494666", "Ladelund",
"497193", "Sulzbach\ an\ der\ Murr",
"4935877", "Cunewalde",
"497675", "Bernau\ Baden",
"499673", "Tiefenbach\ Oberpfalz",
"494751", "Otterndorf",
"495464", "Alfhausen",
"499195", "Adelsdorf\ Mittelfranken",
"499544", "Baunach",
"496500", "Waldrach",
"499274", "Hollfeld",
"498387", "Weiler\-Simmerberg",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"497484", "Simmersfeld",
"499746", "Zeitlofs",
"493847", "Sternberg",
"493546", "Lübben\ Spreewald",
"493744", "Auerbach\ Vogtland",
"498094", "Steinhöring",
"4936253", "Georgenthal\ Thüringer\ Wald",
"498772", "Mallersdorf\-Pfaffenberg",
"494779", "Freiburg\ Elbe",
"492831", "Geldern",
"497641", "Emmendingen",
"498221", "Günzburg",
"497636", "Münstertal\ Schwarzwald",
"4936334", "Wolkramshausen",
"4939952", "Grammentin",
"4935841", "Grossschönau\ Sachsen",
"492547", "Rosendahl\-Osterwick",
"496139", "Budenheim",
"495672", "Bad\ Karlshafen",
"499929", "Ruhmannsfelden",
"493531", "Finsterwalde",
"495201", "Halle\ Westfalen",
"495183", "Lamspringe",
"494958", "Jemgum",
"493447", "Altenburg\ Thüringen",
"495336", "Semmenstedt",
"497163", "Ebersbach\ an\ der\ Fils",
"492431", "Erkelenz",
"4939822", "Kratzeburg",
"495152", "Hessisch\ Oldendorf",
"4939001", "Apenburg",
"4939390", "Iden",
"499165", "Sugenheim",
"499938", "Moos\ Niederbayern",
"497502", "Wolpertswende",
"496357", "Standenbühl",
"495494", "Holdorf\ Niedersachsen",
"492446", "Heimbach\ Eifel",
"495341", "Salzgitter",
"492975", "Schmallenberg\-Oberkirchen",
"496128", "Taunusstein",
"498667", "Seeon\-Seebruck",
"495505", "Hardegsen",
"494825", "Burg\ Dithmarschen",
"498064", "Au\ bei\ Bad\ Aibling",
"496646", "Grebenau",
"499448", "Hausen\ Niederbayern",
"499153", "Schnaittach",
"499182", "Velburg",
"496773", "Kamp\-Bornhofen",
"494133", "Wittorf\ Kreis\ Lüneburg",
"495864", "Jameln",
"493937", "Osterburg\ Altmark",
"495767", "Warmsen",
"4937605", "Hartenstein\ Sachsen",
"496048", "Büdingen\-Eckartshausen",
"495375", "Müden\ Aller",
"494903", "Wymeer",
"4939082", "Mieste",
"4936371", "Schlossvippach",
"492941", "Lippstadt",
"496631", "Alsfeld",
"497432", "Albstadt\-Tailfingen",
"4939329", "Möringen",
"4938202", "Volkenshagen",
"499266", "Mitwitz",
"495945", "Wilsum",
"494485", "Elsfleth\-Huntorf",
"492371", "Iserlohn",
"498585", "Grainet",
"495476", "Ostercappeln\-Venne",
"498158", "Tutzing",
"498443", "Hohenwart\ Paar",
"4936623", "Berga\ Elster",
"494674", "Ockholm",
"498327", "Rettenberg",
"4939409", "Eilsleben",
"497440", "Bad\ Rippoldsau",
"497424", "Spaichingen",
"494543", "Nusse",
"492501", "Münster\-Hiltrup",
"494892", "Schenefeld\ Mittelholstein",
"494273", "Kirchdorf\ bei\ Sulingen",
"495971", "Rheine",
"497930", "Boxberg\ Baden",
"4939996", "Törpin",
"497256", "Philippsburg",
"498281", "Thannhausen\ Schwaben",
"496842", "Blieskastel",
"496593", "Hillesheim\ Eifel",
"497942", "Neuenstein\ Württemberg",
"492268", "Kürten",
"498562", "Triftern",
"495435", "Berge\ bei\ Quakenbrück",
"4935241", "Lommatzsch",
"493663", "Schleiz",
"498469", "Freystadt\-Burggriesbach",
"494462", "Wittmund",
"492205", "Rösrath",
"4934743", "Ermsleben",
"492359", "Kierspe",
"496555", "Bleialf",
"4933398", "Werneuchen",
"498035", "Raubling",
"4938391", "Altenkirchen\ Rügen",
"495123", "Schellerten",
"495069", "Nordstemmen",
"4939222", "Möser",
"496430", "Hahnstätten",
"4935606", "Briesen\ bei\ Cottbus",
"4938309", "Trent",
"4939342", "Gladau",
"4936923", "Treffurt",
"4933653", "Ziltendorf",
"495835", "Wahrenholz",
"4935939", "Hochkirch",
"4938429", "Glasin",
"496442", "Braunfels",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"496188", "Kahl\ am\ Main",
"498869", "Kinsau",
"492137", "Neuss\-Norf",
"494862", "Garding",
"496251", "Bensheim",
"494885", "Bergenhusen",
"495043", "Lauenau",
"4934202", "Delitzsch",
"494154", "Trittau",
"498678", "Marktl",
"497528", "Neukirch\ bei\ Tettnang",
"497832", "Haslach\ im\ Kinzigtal",
"492642", "Remagen",
"4933927", "Linum",
"496102", "Neu\-Isenburg",
"495247", "Harsewinkel",
"499122", "Schwabach",
"4936087", "Wüstheuterode",
"494326", "Wankendorf",
"496563", "Kyllburg",
"493693", "Meiningen",
"499134", "Neunkirchen\ am\ Brand",
"495307", "Braunschweig\-Wenden",
"498592", "Wegscheid\ Niederbayern",
"497727", "Vöhrenbach",
"4939931", "Röbel\ Müritz",
"498076", "Pfaffing",
"494492", "Saterland",
"499904", "Lalling",
"497824", "Schwanau",
"492630", "Mülheim\-Kärlich",
"497249", "Stutensee",
"4939203", "Barleben",
"497579", "Schwenningen\ Baden",
"498629", "Palling",
"494622", "Taarstedt",
"495436", "Nortrup",
"499253", "Weissenstadt",
"492150", "Meerbusch\-Lank",
"49421", "Bremen",
"492331", "Hagen\ Westfalen",
"499282", "Naila",
"493423", "Eilenburg",
"492206", "Overath",
"497472", "Rottenburg\ am\ Neckar",
"499654", "Pleystein",
"494233", "Blender",
"4936967", "Geisa",
"496457", "Burgwald\ Eder",
"499561", "Coburg",
"497309", "Weissenhorn",
"494634", "Husby",
"495441", "Diepholz",
"497255", "Graben\-Neudorf",
"4938736", "Goldberg",
"492054", "Essen\-Kettwig",
"497664", "Freiburg\-Tiengen",
"495283", "Lügde\-Rischenau",
"495101", "Pattensen",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"499348", "Werbach\-Gamburg",
"492657", "Uersfeld",
"4939037", "Pretzier",
"493761", "Werdau\ Sachsen",
"497263", "Waibstadt",
"4934223", "Dommitzsch",
"495684", "Frielendorf",
"495931", "Meppen",
"495252", "Bad\ Lippspringe",
"4934343", "Regis\-Breitingen",
"499265", "Pressig",
"494486", "Edewecht\-Friedrichsfehn",
"495946", "Georgsdorf",
"492994", "Marsberg\-Westheim",
"498586", "Hauzenberg",
"495475", "Bohmte\-Hunteburg",
"497551", "Überlingen\ Bodensee",
"498784", "Hohenthann",
"493998", "Demmin",
"499208", "Bindlach",
"496228", "Schönau\ Odenwald",
"4939395", "Wanzer",
"4938791", "Bad\ Wilsnack",
"498075", "Amerang",
"4935383", "Elster\ Elbe",
"4938223", "Saal\ Vorpom",
"498121", "Markt\ Schwaben",
"495364", "Velpke",
"496239", "Bobenheim\-Roxheim",
"4936378", "Ostramondra",
"4936602", "Ronneburg\ Thüringen",
"499070", "Tapfheim",
"497384", "Schelklingen\-Hütten",
"495875", "Emmendorf",
"4939742", "Brüssow\ bei\ Pasewalk",
"4934635", "Bad\ Lauchstädt",
"495836", "Wittingen\-Radenbeck",
"4937600", "Neumark\ Sachsen",
"498041", "Bad\ Tölz",
"498638", "Waldkraiburg",
"495609", "Ahnatal",
"496556", "Pronsfeld",
"497957", "Kressberg",
"496857", "Namborn",
"4939008", "Kunrau",
"498036", "Stephanskirchen\ Simssee",
"492964", "Brilon\-Alme",
"499295", "Töpen",
"4934495", "Dobitschen",
"496754", "Martinstein",
"492523", "Wadersloh",
"494702", "Sandstedt",
"498709", "Eching\ Niederbayern",
"499174", "Hilpoltstein",
"493968", "Schönbeck",
"495841", "Lüchow\ Wendland",
"4939861", "Gramzow\ bei\ Prenzlau",
"498857", "Benediktbeuern",
"497581", "Saulgau",
"498556", "Haidmühle",
"498754", "Volkenschwand",
"499441", "Kelheim",
"496036", "Wölfersheim",
"495561", "Einbeck",
"499729", "Grettstadt",
"499394", "Esselbach",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"493686", "Eisfeld",
"494456", "Varel\-Altjührden",
"493944", "Blankenburg\ Harz",
"495654", "Herleshausen",
"4933473", "Zechin",
"495282", "Schieder\-Schwalenberg",
"496638", "Schwalmtal\-Renzendorf",
"499436", "Nittenau",
"496041", "Glauburg",
"4933846", "Dippmannsdorf",
"495253", "Bad\ Driburg",
"492948", "Lippstadt\-Rebbeke",
"4936201", "Walschleben",
"497262", "Eppingen",
"492687", "Horhausen\ Westerwald",
"494951", "Weener",
"495208", "Leopoldshöhe",
"4936946", "Erbenhausen\ Thüringen",
"494232", "Langwedel\ Kreis\ Verden",
"498239", "Langenneufnach",
"4939887", "Gerswalde",
"49340", "Dessau\ Anh",
"495265", "Dörentrup",
"4934925", "Bad\ Schmiedeberg",
"499946", "Hohenwarth\ bei\ Kötzing",
"4938726", "Spornitz",
"499087", "Marktoffingen",
"499252", "Helmbrechts",
"4938855", "Lübtheen",
"493529", "Heidenau\ Sachsen",
"4939454", "Elbingerode\ Harz",
"499931", "Plattling",
"494623", "Böklund",
"497473", "Mössingen",
"494224", "Gross\ Ippener",
"499283", "Rehau",
"499101", "Langenzenn",
"494240", "Syke\-Heiligenfelde",
"493737", "Rochlitz",
"499875", "Wolframs\-Eschenbach",
"492429", "Hürtgenwald",
"4939605", "Gross\ Nemerow",
"4935796", "Panschwitz\-Kuckau",
"493834", "Greifswald",
"496586", "Beuren\ Hochwald",
"496887", "Schmelz\ Saar",
"499364", "Zellingen",
"497031", "Böblingen",
"492522", "Oelde",
"492741", "Betzdorf",
"494703", "Loxstedt\-Donnern",
"492838", "Sonsbeck",
"4935435", "Gollmitz\ bei\ Calau",
"496784", "Weierbach",
"492736", "Burbach\ Siegerl",
"497046", "Zaberfeld",
"492534", "Münster\-Roxel",
"4935774", "Boxberg\ Sachsen",
"499738", "Rottershausen",
"492367", "Henrichenburg",
"499841", "Bad\ Windsheim",
"4938354", "Wusterhusen",
"497354", "Erolzheim",
"4936646", "Tanna\ bei\ Schleiz",
"495174", "Lahstedt",
"4935695", "Simmersdorf",
"498457", "Vohburg\ an\ der\ Donau",
"4939053", "Süplingen",
"494856", "Kronprinzenkoog",
"494557", "Blunk",
"495295", "Lichtenau\ Westfalen",
"492775", "Driedorf",
"496629", "Schenklengsfeld",
"493366", "Beeskow",
"494758", "Nordleda",
"497126", "Burladingen\-Melchingen",
"4933920", "Walsleben\ bei\ Neuruppin",
"4938233", "Prerow\ Ostseebad",
"499836", "Gunzenhausen\-Cronheim",
"498563", "Bad\ Birnbach\ Rottal",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"493395", "Pritzwalk",
"496843", "Gersheim",
"496592", "Daun",
"492389", "Werne",
"497943", "Schöntal\ Jagst",
"494463", "Wangerland",
"4933637", "Beerfelde",
"498251", "Aichach",
"499099", "Kaisheim",
"494939", "Baltrum",
"496678", "Wildeck\-Hönebach",
"495266", "Lemgo\-Kirchheide",
"499945", "Arnbruck",
"4936844", "Rohr\ Thüringen",
"498102", "Höhenkirchen\-Siegertsbrunn",
"494109", "Tangstedt\ Bz\ Hamburg",
"4938326", "Grimmen",
"49741", "Rottweil",
"4937294", "Grünhainichen",
"4939268", "Egeln",
"498442", "Wolnzach",
"4934601", "Teutschenthal",
"499435", "Schwarzenfeld",
"498549", "Vilshofen\-Pleinting",
"494542", "Mölln\ Lauenburg",
"494721", "Cuxhaven",
"494893", "Hohenaspe",
"494272", "Siedenburg",
"496869", "Merzig\-Silwingen",
"4939851", "Göritz\ bei\ Prenzlau",
"498555", "Perlesreut",
"497433", "Balingen",
"4934364", "Wermsdorf",
"496035", "Reichelsheim\ Wetterau",
"492161", "Mönchengladbach",
"499971", "Cham",
"4939030", "Brunau",
"493685", "Hildburghausen",
"494455", "Jade\-Schweiburg",
"498593", "Untergriesbach",
"497071", "Tübingen",
"492304", "Schwerte",
"494849", "Hooge",
"4933608", "Jacobsdorf\ Mark",
"49781", "Offenburg",
"4936076", "Niederorschel",
"497125", "Bad\ Urach",
"496562", "Speicher",
"493874", "Ludwigslust",
"4937384", "Wechselburg",
"4939921", "Ankershagen",
"499835", "Ehingen\ Mittelfranken",
"494493", "Friesoythe\-Gehlenberg",
"497833", "Hornberg\ Schwarzwaldbahn",
"493578", "Kamenz",
"492643", "Altenahr",
"495042", "Bad\ Münder\ am\ Deister",
"496281", "Buchen\ Odenwald",
"496103", "Langen\ Hessen",
"494855", "Eddelak",
"492574", "Saerbeck",
"499123", "Lauf\ an\ der\ Pegnitz",
"494184", "Hanstedt\ Nordheide",
"4933833", "Wollin\ bei\ Brandenburg",
"492244", "Königswinter\-Oberpleis",
"492776", "Bad\ Endbach\-Hartenrod",
"497045", "Oberderdingen",
"492735", "Neunkirchen\ Siegerl",
"495904", "Lengerich\ Emsl",
"496443", "Ehringshausen\ Dill",
"496158", "Riedstadt",
"4934901", "Rosslau\ Elbe",
"499307", "Altertheim",
"496327", "Neustadt\-Lachen",
"494863", "Sankt\ Peter\-Ording",
"4938754", "Leussow\ bei\ Ludwigslust",
"499778", "Fladungen",
"499876", "Rohr\ Mittelfranken",
"4939426", "Hessen",
"492191", "Remscheid",
"496585", "Ralingen",
"4937607", "Ebersbrunn\ Sachsen",
"493382", "Lehnin",
"494928", "Ihlow\-Riepe",
"495746", "Rödinghausen",
"495544", "Reinhardshagen",
"492596", "Nordkirchen",
"495520", "Braunlage",
"495274", "Nieheim",
"499464", "Walderbach",
"498631", "Mühldorf\ am\ Inn",
"4934772", "Helbra",
"495195", "Neuenkirchen\ bei\ Soltau",
"495673", "Immenhausen\ Hessen",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"496667", "Steinau\-Ulmbach",
"497226", "Bühl\-Sand",
"498773", "Neufahrn\ in\ Niederbayern",
"493961", "Altentreptow",
"495848", "Trebel",
"495731", "Bad\ Oeynhausen",
"4938850", "Gammelin",
"497454", "Sulz\ am\ Neckar",
"499672", "Neunburg\ vorm\ Wald",
"493466", "Artern\ Unstrut",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4934920", "Kropstädt",
"4936208", "Ermstedt",
"497192", "Murrhardt",
"497854", "Kehl\-Goldscheuer",
"495108", "Gehrden\ Han",
"492764", "Welschen\ Ennest",
"492867", "Heiden\ Kreis\ Borken",
"498139", "Röhrmoos",
"494132", "Amelinghausen",
"492566", "Legden",
"499341", "Tauberbischofsheim",
"495165", "Rethem\ Aller",
"494356", "Gross\ Wittensee",
"494902", "Jemgum\-Ditzum",
"496697", "Willingshausen",
"4939600", "Zwiedorf",
"499152", "Hartenstein\ Mittelfranken",
"496094", "Weibersbrunn",
"493866", "Cambs",
"497558", "Illmensee",
"499336", "Bütthard",
"496221", "Heidelberg",
"494140", "Estorf\ Kreis\ Stade",
"493991", "Waren\ Müritz",
"4933233", "Ketzin",
"499201", "Gesees",
"499183", "Burgthann",
"496772", "Nastätten",
"494124", "Glückstadt",
"493334", "Eberswalde",
"497503", "Wilhelmsdorf\ Württemberg",
"4936085", "Reinholterode",
"499375", "Freudenberg\ Baden",
"4933925", "Wustrau\-Altfriesack",
"492338", "Breckerfeld",
"496387", "Sankt\ Julian",
"493496", "Köthen\ Anhalt",
"498370", "Wiggensbach",
"496190", "Hattersheim\ am\ Main",
"495182", "Gronau\ Leine",
"499568", "Neustadt\ bei\ Coburg",
"4933764", "Mittenwalde\ Mark",
"497373", "Zwiefalten",
"4939832", "Wesenberg",
"495153", "Salzhemmendorf",
"493322", "Falkensee",
"495448", "Barver",
"496525", "Irrel",
"497162", "Süssen",
"499505", "Litzendorf",
"49871", "Landshut",
"495633", "Diemelsee",
"492404", "Alsdorf\ Rheinland",
"4935453", "Drahnsdorf",
"496258", "Gernsheim",
"4936022", "Grossengottern",
"498671", "Altötting",
"497742", "Klettgau",
"495234", "Horn\-Bad\ Meinberg",
"494393", "Boostedt",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4939858", "Bietikow",
"495771", "Rahden\ Westfalen",
"499147", "Nennslingen",
"495222", "Bad\ Salzuflen",
"492291", "Waldbröl",
"498733", "Mengkofen",
"49561", "Kassel",
"492627", "Braubach",
"4936965", "Stadtlengsfeld",
"496343", "Bad\ Bergzabern",
"497225", "Gaggenau",
"496427", "Cölbe\-Schönstadt",
"499632", "Waldsassen",
"4939035", "Kuhfelde",
"499407", "Wenzenbach",
"499624", "Ensdorf\ Oberpfalz",
"494683", "Oldsum",
"495745", "Stemwede\-Levern",
"4937329", "Grosshartmannsdorf",
"492595", "Olfen",
"496007", "Rosbach\-Rodheim",
"496181", "Hanau",
"496203", "Ladenburg",
"494284", "Selsingen",
"499223", "Rugendorf",
"495196", "Wietzendorf",
"4933439", "Fredersdorf\-Vogelsdorf",
"492553", "Ochtrup",
"495978", "Hörstel\-Dreierwalde",
"4933052", "Leegebruch",
"499704", "Euerdorf",
"492582", "Everswinkel",
"4939397", "Geestgottberg",
"494172", "Salzhausen",
"498179", "Eurasburg\ an\ der\ Loisach",
"496724", "Stromberg\ Hunsrück",
"496526", "Bollendorf",
"494363", "Lensahn",
"496827", "Eppelborn",
"496732", "Wörrstadt",
"4935054", "Lauenstein\ Sachsen",
"4934637", "Frankleben",
"499376", "Collenberg",
"492261", "Gummersbach",
"4935752", "Ruhland",
"4938372", "Usedom",
"49731", "Ulm\ Donau",
"4935362", "Schönewalde\ bei\ Herzberg",
"4937342", "Cranzahl",
"492378", "Fröndenberg\-Langschede",
"493865", "Holthusen",
"4933601", "Podelzig",
"498342", "Marktoberdorf",
"494349", "Dänischenhagen",
"492804", "Xanten\-Marienbaum",
"4939773", "Altwarp",
"499335", "Aub\ Kreis\ Würzburg",
"4939928", "Möllenhagen",
"498151", "Starnberg",
"4937436", "Weischlitz",
"493504", "Dippoldiswalde",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"492565", "Gronau\-Epe",
"497333", "Laichingen",
"4936766", "Schalkau",
"495166", "Walsrode\-Kirchboitzen",
"4934497", "Langenleuba\-Niederhain",
"498330", "Legau",
"494355", "Rieseby",
"492508", "Drensteinfurt",
"498202", "Althegnenberg",
"494209", "Schwanewede",
"497144", "Marbach\ am\ Neckar",
"4936928", "Neuenhof\ Thüringen",
"4933741", "Niedergörsdorf",
"495035", "Gross\ Munzel",
"4933088", "Falkenthal",
"498123", "Moosinning",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"499842", "Uffenheim",
"492225", "Meckenheim\ Rheinland",
"496266", "Hassmersheim",
"497024", "Wendlingen\ am\ Neckar",
"498247", "Bad\ Wörishofen",
"497627", "Steinen\ Kreis\ Lörrach",
"498043", "Jachenau",
"493821", "Ribnitz\-Damgarten",
"494477", "Lastrup\-Hemmelte",
"497032", "Herrenberg",
"492521", "Beckum",
"492742", "Wissen",
"496580", "Zemmer",
"4938821", "Lüdersdorf",
"495592", "Gleichen\-Bremke",
"495843", "Wustrow\ Wendland",
"497404", "Epfendorf",
"495585", "Herzberg\-Sieber",
"499932", "Osterhofen",
"4936628", "Zeulenroda",
"499251", "Münchberg",
"494774", "Hechthausen",
"496122", "Hofheim\-Wallau",
"492333", "Ennepetal",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"499102", "Wilhermsdorf",
"494246", "Twistringen\-Heiligenloh",
"493421", "Torgau",
"494877", "Hennstedt\ bei\ Itzehoe",
"494231", "Verden\ Aller",
"495327", "Bad\ Grund\ Harz",
"4933205", "Michendorf",
"496134", "Mainz\-Kastel",
"494952", "Rhauderfehn",
"499563", "Rödental",
"4935891", "Rothenburg\ OL",
"495158", "Hemeringen",
"499924", "Bodenmais",
"4939882", "Gollin",
"497804", "Oppenau",
"495443", "Lemförde",
"497707", "Bräunlingen",
"49231", "Dortmund",
"496296", "Ahorn\ Baden",
"4939724", "Klein\ Bünzow",
"495281", "Bad\ Pyrmont",
"495103", "Wennigsen\ Deister",
"4934651", "Rossla",
"499555", "Schlüsselfeld\-Aschbach",
"497261", "Sinsheim",
"493763", "Glauchau",
"495933", "Lathen",
"496042", "Büdingen\ Hessen",
"498550", "Philippsreut",
"499442", "Riedenburg",
"494535", "Nahe",
"49335", "Frankfurt\ \(Oder\)",
"492927", "Neuengeseke",
"4930", "Berlin",
"497582", "Bad\ Buchau",
"4938456", "Langhagen\ bei\ Güstrow",
"497553", "Salem\ Baden",
"495562", "Dassel\-Markoldendorf",
"49591", "Lingen\ \(Ems\)",
"499549", "Lisberg",
"499188", "Postbauer\-Heng",
"498435", "Ehekirchen",
"499279", "Mistelgau",
"492192", "Hückeswagen",
"496348", "Offenbach\ an\ der\ Queich",
"4937602", "Kirchberg\ Sachsen",
"495121", "Hildesheim",
"4939085", "Zichtau",
"493381", "Brandenburg\ an\ der\ Havel",
"4936373", "Buttstädt",
"496265", "Billigheim\ Baden",
"494947", "Aurich\-Ogenbargen",
"492454", "Gangelt",
"4938228", "Dettmannsdorf\-Kölzow",
"499228", "Thurnau",
"4935388", "Klöden",
"497467", "Neuhausen\ ob\ Eck",
"4939366", "Kehnert",
"498364", "Seeg",
"4938304", "Garz\ Rügen",
"496253", "Fürth\ Odenwald",
"495041", "Springe\ Deister",
"4939003", "Jübar",
"494602", "Freienwill",
"498537", "Bad\ Füssing\-Aigen",
"492226", "Rheinbach",
"496654", "Gersfeld\ Rhön",
"496057", "Flörsbachtal",
"496282", "Walldürn",
"492770", "Eschenburg",
"4933932", "Fehrbellin",
"4934466", "Janisroda",
"496561", "Bitburg",
"493691", "Eisenach\ Thüringen",
"497072", "Gomaringen",
"498841", "Murnau\ am\ Staffelsee",
"4938424", "Bobitz",
"4935934", "Grossdubrau",
"497329", "Steinheim\ am\ Albuch",
"495036", "Neustadt\-Schneeren",
"4939825", "Wokuhl",
"4939740", "Nechlin",
"494536", "Steinhorst\ Lauenburg",
"4939955", "Jürgenstorf",
"492162", "Viersen",
"494837", "Neuenkirchen\ Dithmarschen",
"4935843", "Hirschfelde\ bei\ Zittau",
"494734", "Stadland\-Seefeld",
"492373", "Menden\ Sauerland",
"4938466", "Jürgenshagen",
"4935476", "Wittmannsdorf\-Bückchen",
"499972", "Waldmünchen",
"496295", "Rosenberg\ Baden",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"493925", "Stassfurt",
"499857", "Schopfloch\ Mittelfranken",
"499556", "Geiselwind",
"4939208", "Loitsche",
"4934424", "Reuden\ bei\ Zeitz",
"498394", "Lautrach",
"494541", "Ratzeburg",
"494722", "Cuxhaven\-Altenbruch",
"496174", "Königstein\ im\ Taunus",
"494271", "Sulingen",
"498684", "Fridolfing",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4934348", "Frohburg",
"494305", "Westensee",
"498252", "Schrobenhausen",
"492558", "Horstmar",
"498283", "Neuburg\ an\ der\ Kammel",
"4933632", "Hangelsberg",
"4939324", "Kläden\ bei\ Stendal",
"496591", "Gerolstein",
"4935971", "Sebnitz",
"495586", "Wieda",
"4939244", "Steutz",
"4939404", "Ausleben",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"493661", "Greiz",
"497566", "Argenbühl",
"494245", "Neuenkirchen\ bei\ Bassum",
"497764", "Herrischried",
"496196", "Bad\ Soden\ am\ Taunus",
"498376", "Sulzberg\ Allgäu",
"495203", "Werther\ Westfalen",
"495181", "Alfeld\ Leine",
"497161", "Göppingen",
"496745", "Gondershausen",
"492433", "Hückelhoven",
"495604", "Grossalmerode",
"4933704", "Baruth\ Mark",
"4939933", "Vollrathsruhe",
"493321", "Nauen\ Brandenburg",
"4934205", "Markranstädt",
"495427", "Melle\-Buer",
"4934445", "Stössen",
"494406", "Berne",
"497478", "Hirrlingen",
"498807", "Diessen\ am\ Ammersee",
"498506", "Bad\ Höhenstadt",
"499288", "Bad\ Steben",
"49241", "Aachen",
"498704", "Altdorf\-Pfettrach",
"4938828", "Schönberg",
"4936426", "Ottendorf\ bei\ Stadtroda",
"499179", "Freystadt",
"4939345", "Parchen",
"494795", "Garlstedt",
"499151", "Hersbruck",
"493860", "Raben\ Steinfeld",
"4936921", "Wutha\-Farnroda",
"4933748", "Treuenbrietzen",
"496222", "Wiesloch",
"499202", "Waischenfeld",
"496771", "St\ Goarshausen",
"494146", "Stade\-Bützfleth",
"49661", "Fulda",
"494131", "Lüneburg",
"49345", "Halle\ Saale",
"4938393", "Binz\ Ostseebad",
"496234", "Mutterstadt",
"499342", "Wertheim",
"492943", "Erwitte",
"497389", "Heroldstatt",
"495258", "Salzkotten",
"496633", "Homberg\ Ohm",
"4939225", "Altengrabow",
"498335", "Fellheim",
"4935243", "Weinböhla",
"4933200", "Bergholz\-Rehbrücke",
"496166", "Fischbachtal",
"499733", "Münnerstadt",
"4934658", "Hayn\ Harz",
"497669", "St\ Märgen",
"4934741", "Frose",
"497191", "Backnang",
"499671", "Oberviechtach",
"494753", "Balje",
"49971", "Bad\ Kissingen",
"49385", "Schwerin",
"4935323", "Sonnewalde",
"4933456", "Wriezen",
"492045", "Bottrop\-Kirchhellen",
"497735", "Öhningen",
"498027", "Dietramszell",
"497244", "Weingarten\ Baden",
"497220", "Forbach\-Hundsbach",
"4936621", "Elsterberg\ bei\ Plauen",
"498640", "Reit\ Im\ Winkl",
"494765", "Ebersdorf\ bei\ Bremervörde",
"497574", "Gammertingen",
"498624", "Obing",
"49351", "Dresden",
"493962", "Penzlin\ bei\ Waren",
"495732", "Löhne",
"499659", "Leuchtenberg",
"4936464", "Wormstedt",
"492833", "Kerken",
"497643", "Herbolzheim\ Breisgau",
"498223", "Ichenhausen",
"494708", "Ringstedt",
"495724", "Obernkirchen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"494806", "Sarzbüttel",
"4938205", "Tessin\ bei\ Rostock",
"495827", "Unterlüss",
"492590", "Dülmen\-Buldern",
"49281", "Wesel",
"494639", "Schafflund",
"497304", "Blaustein\ Württemberg",
"498407", "Grossmehring",
"493533", "Elsterwerda",
"492473", "Simmerath",
"498152", "Herrsching\ am\ Ammersee",
"494159", "Basthorst",
"4934492", "Lucka",
"498336", "Erkheim",
"498341", "Kaufbeuren",
"494796", "Teufelsmoor",
"4939389", "Schollene",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"4939080", "Kalbe\ Milde",
"4938377", "Zinnowitz",
"492262", "Wiehl",
"497948", "Öhringen\-Ohrnberg",
"496731", "Alzey",
"494405", "Edewecht",
"497084", "Schömberg\ bei\ Neuenbürg",
"496848", "Homburg\-Einöd",
"4936605", "Bad\ Köstritz",
"498505", "Hutthurm",
"495064", "Gross\ Düngen",
"4939820", "Triepkendorf",
"4939745", "Hetzdorf\ bei\ Strasburg",
"494468", "Friedeburg\-Reepsholt",
"493881", "Grevesmühlen",
"4934632", "Mücheln\ Geiseltal",
"498375", "Weitnau",
"496195", "Kelkheim\ Taunus",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"496673", "Haunetal",
"496746", "Pfalzfeld",
"4938221", "Marlow",
"496274", "Waldbrunn\ Odenwald",
"492581", "Warendorf",
"494171", "Winsen\ Luhe",
"4938793", "Dergenthin",
"496544", "Rhaunen",
"499646", "Freihung",
"494805", "Schafstedt",
"4934341", "Geithain",
"495525", "Walkenried",
"495190", "Soltau\-Emmingen",
"496182", "Seligenstadt",
"499773", "Unsleben",
"494564", "Schashagen",
"4936739", "Rottenbach",
"497775", "Mühlingen",
"4935723", "Bernsdorf\ OL",
"494766", "Basdahl",
"4935209", "Mohorn",
"492354", "Meinerzhagen",
"499631", "Tirschenreuth",
"4936454", "Magdala",
"498464", "Dietfurt\ an\ der\ Altmühl",
"494923", "Krummhörn\-Pewsum",
"4934221", "Schildau\ Gneisenaustadt",
"497367", "Aalen\-Ebnat",
"492292", "Windeck\ Sieg",
"492873", "Isselburg\-Werth",
"495772", "Espelkamp",
"494337", "Jevenstedt",
"495221", "Herford",
"497534", "Reichenau\ Baden",
"493303", "Birkenwerder",
"494498", "Saterland\-Ramsloh",
"497736", "Tengen",
"493573", "Senftenberg",
"497838", "Nordrach",
"499357", "Gräfendorf\ Bayern",
"497522", "Wangen\ im\ Allgäu",
"497741", "Tiengen\ Hochrhein",
"496165", "Breuberg",
"4939201", "Wolmirstedt",
"4936027", "Lengenfeld\ Unterm\ Stein",
"499128", "Feucht",
"495954", "Lorup",
"493644", "Apolda",
"496108", "Mühlheim\ am\ Main",
"497429", "Egesheim",
"4936258", "Friemar",
"498165", "Neufahrn\ bei\ Freising",
"496672", "Eiterfeld",
"492551", "Steinfurt\-Burgsteinfurt",
"495909", "Wettrup",
"4933238", "Senzke",
"496894", "St\ Ingbert",
"495139", "Burgwedel",
"4938231", "Barth",
"494361", "Oldenburg\ in\ Holstein",
"4939051", "Calvörde",
"4937756", "Breitenbrunn\ Erzgebirge",
"4935692", "Kerkwitz",
"492263", "Engelskirchen",
"4933676", "Friedland\ bei\ Beeskow",
"4933369", "Oderberg",
"497657", "Eisenbach\ Hochschwarzwald",
"493605", "Leinefelde",
"497054", "Wildberg\ Württemberg",
"492664", "Rennerod",
"494747", "Beverstedt",
"492255", "Euskirchen\-Flamersheim",
"492309", "Waltrop",
"494844", "Pellworm",
"4937366", "Rübenau",
"497346", "Illerkirchberg",
"4933434", "Herzfelde\ bei\ Strausberg",
"496464", "Angelburg",
"492472", "Monschau",
"498153", "Wessling",
"4939602", "Kleeth",
"4936742", "Uhlstädt",
"497331", "Geislingen\ an\ der\ Steige",
"4934296", "Groitzsch\ bei\ Pegau",
"497150", "Korntal\-Münchingen",
"494189", "Undeloh",
"495631", "Korbach",
"494444", "Goldenstedt",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496375", "Wallhalben",
"4938852", "Wittenburg",
"4935264", "Strehla",
"496864", "Mettlach",
"497964", "Stödtlen",
"498544", "Eging\ am\ See",
"498274", "Buttenwiesen",
"492957", "Wünnenberg\-Haaren",
"495773", "Stemwede\-Wehdem",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"496568", "Wolsfeld",
"492293", "Nümbrecht",
"499190", "Heroldsbach",
"498731", "Dingolfing",
"492872", "Rhede\ Westfalen",
"496505", "Kordel",
"4934922", "Mühlanger",
"499525", "Königsberg\ in\ Bayern",
"4933976", "Wutike",
"4937324", "Reinsberg\ Sachsen",
"4933207", "Gross\ Kreutz",
"492694", "Wershofen",
"495646", "Willebadessen",
"4938296", "Rerik\ Ostseebad",
"493302", "Hennigsdorf",
"496341", "Landau\ in\ der\ Pfalz",
"4937208", "Auerswalde",
"492384", "Welver",
"499954", "Simbach\ Niederbayern",
"495128", "Hohenhameln",
"493725", "Zschopau",
"494922", "Borkum",
"4936203", "Vieselbach",
"495357", "Grasleben",
"499094", "Tagmersheim",
"494934", "Marienhafe",
"494681", "Wyk\ auf\ Föhr",
"496152", "Gross\-Gerau",
"4939863", "Seehausen\ bei\ Prenzlau",
"499772", "Bischofsheim\ an\ der\ Rhön",
"496183", "Erlensee",
"496201", "Weinheim\ Bergstr",
"494104", "Aumühle\ bei\ Hamburg",
"499221", "Kulmbach",
"496336", "Dellfeld",
"4938370", "Kröslin",
"4939087", "Jerchel\ Altmark",
"499343", "Lauda\-Königshofen",
"49465", "Sylt",
"497268", "Bad\ Rappenau\-Obergimpern",
"492942", "Geseke",
"496407", "Rabenau\ Hessen",
"499427", "Leiblfing",
"496027", "Stockstadt\ am\ Main",
"4934903", "Coswig\ Anhalt",
"496624", "Heringen\ Werra",
"492256", "Mechernich\-Satzvey",
"499604", "Wernberg\-Köblitz",
"4933769", "Töpchin",
"497345", "Langenau\ Württemberg",
"496223", "Neckargemünd",
"499203", "Neudrossenfeld",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"4939061", "Weferlingen",
"492440", "Nettersheim\-Tondorf",
"492424", "Vettweiss",
"496789", "Heimbach\ Nahe",
"493606", "Heiligenstadt\ Heilbad",
"4933831", "Weseram",
"499369", "Uettingen",
"498166", "Allershausen\ Oberbayern",
"49203", "Duisburg",
"494238", "Neddenaverbergen",
"4939827", "Schwarz\ bei\ Neustrelitz",
"495202", "Oerlinghausen",
"496147", "Trebur",
"497371", "Riedlingen\ Württemberg",
"495151", "Hameln",
"4939923", "Priborn",
"492607", "Kobern\-Gondorf",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"492432", "Wassenberg",
"498234", "Bobingen",
"492824", "Kalkar",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498633", "Tüssling",
"49571", "Minden\ Westfalen",
"496335", "Trulben",
"495671", "Hofgeismar",
"4939957", "Gielow",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"493726", "Flöha",
"492832", "Kevelaer",
"498771", "Ergoldsbach",
"494167", "Apensen",
"497642", "Endingen\ Kaiserstuhl",
"492528", "Ennigerloh\-Enniger",
"498222", "Burgau\ Schwaben",
"493963", "Woldegk",
"495733", "Vlotho",
"49861", "Traunstein",
"494752", "Neuhaus\ Oste",
"4936020", "Ebeleben",
"4933874", "Stechow\ Brandenburg",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"496506", "Welschbillig",
"499827", "Lichtenau\ Mittelfranken",
"499526", "Riedbach",
"499724", "Stadtlauringen",
"495645", "Borgentreich\-Borgholz",
"496704", "Langenlonsheim",
"4935872", "Neusalza\-Spremberg",
"498196", "Pürgen",
"493949", "Oschersleben\ Bode",
"495659", "Ringgau",
"499732", "Hammelburg",
"498745", "Bodenkirchen",
"494974", "Neuharlingersiel",
"496475", "Weilmünster\-Wolfenhausen",
"498591", "Obernzell",
"497073", "Ammerbuch",
"494344", "Schönberg\ Holstein",
"494320", "Heidmühlen",
"4938759", "Tewswoos",
"495228", "Vlotho\-Exter",
"493379", "Mahlow",
"497277", "Wörth\-Büchelberg",
"492636", "Burgbrohl",
"494491", "Friesoythe",
"4934262", "Falkenhain\ bei\ Wurzen",
"497748", "Grafenhausen\ Hochschwarzwald",
"496684", "Hofbieber\-Schwarzbach",
"497831", "Hausach",
"4936082", "Ershausen",
"494603", "Havetoft",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"496252", "Heppenheim\ Bergstrasse",
"496087", "Waldems",
"496283", "Hardheim\ Odenwald",
"496101", "Bad\ Vilbel",
"4934976", "Gröbzig",
"494204", "Thedinghausen",
"4936652", "Wurzbach",
"4933922", "Karwesee",
"4936784", "Stützerbach",
"499075", "Glött",
"4934207", "Zwochau",
"492484", "Mechernich\-Eiserfey",
"496441", "Wetzlar",
"498295", "Altenmünster\ Schwaben",
"4933231", "Pausin",
"494861", "Tönning",
"4939347", "Kade",
"496394", "Bundenthal",
"495457", "Hopsten\-Schale",
"492675", "Ediger\-Eller",
"4939058", "Uthmöden",
"492193", "Dabringhausen",
"499638", "Neualbenreuth",
"496436", "Dornburg\ Hessen",
"498561", "Pfarrkirchen\ Niederbayern",
"4933478", "Gross\ Neuendorf",
"496841", "Homburg\ Saar",
"497941", "Öhringen",
"495857", "Bleckede\-Brackede",
"495556", "Lindau\ Harz",
"495754", "Extertal\-Bremke",
"494461", "Jever",
"498253", "Pöttmes",
"497250", "Kraichtal",
"496836", "Überherrn",
"498654", "Freilassing",
"497936", "Schrozberg\-Bartenstein",
"494178", "Radbruch",
"494289", "Kirchtimke",
"498282", "Krumbach\ Schwaben",
"498057", "Aschau\-Sachrang",
"492588", "Harsewinkel\-Greffen",
"498265", "Pfaffenhausen\ Schwaben",
"494966", "Neubörger",
"492409", "Stolberg\-Gressenich",
"497975", "Untergröningen",
"496875", "Nonnweiler\-Primstal",
"498208", "Eurasburg\ bei\ Augsburg",
"492502", "Nottuln",
"494723", "Cuxhaven\-Altenwalde",
"497446", "Lossburg",
"496364", "Nussbach\ Pfalz",
"498348", "Bidingen",
"492372", "Hemer",
"4936849", "Kleinschmalkalden",
"497431", "Albstadt\-Ebingen",
"499260", "Wilhelmsthal\ Oberfranken",
"492163", "Schwalmtal\ Niederrhein",
"499973", "Furth\ im\ Wald",
"4938207", "Stäbelow",
"4934775", "Wippra",
"492676", "Ulmen",
"497237", "Neulingen\ Enzkreis",
"496550", "Irrhausen",
"495593", "Bovenden\-Lenglern",
"499869", "Wettringen\ Mittelfranken",
"495842", "Schnega",
"4933838", "Päwesin",
"497033", "Weil\ Der\ Stadt",
"492743", "Daaden",
"496435", "Wallmerod",
"493677", "Ilmenau\ Thüringen",
"4938375", "Koserow",
"498296", "Villenbach",
"4933603", "Falkenhagen\ bei\ Seelow",
"4935365", "Falkenberg\ Elster",
"498042", "Lenggries",
"4939771", "Ueckermünde",
"498134", "Odelzhausen",
"499843", "Burgbernheim",
"4939747", "Züsedom",
"4936607", "Niederpöllnitz",
"4935755", "Ortrand",
"499499", "Painten",
"499076", "Wittislingen",
"4935826", "Königshain\ bei\ Görlitz",
"496476", "Mengerskirchen",
"4933055", "Kremmen",
"494267", "Lauenbrück",
"494129", "Haseldorf",
"498122", "Erding",
"492635", "Rheinbrohl",
"4938874", "Lützow",
"497459", "Nagold\-Hochdorf",
"497583", "Bad\ Schussenried",
"499443", "Abensberg",
"499158", "Offenhausen\ Mittelfranken",
"495924", "Bad\ Bentheim\-Gildehaus",
"494480", "Ovelgönne\-Strückhausen",
"495563", "Kreiensen",
"496307", "Schopp",
"497552", "Pfullendorf",
"498266", "Kirchheim\ in\ Schwaben",
"494965", "Surwold",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"497976", "Sulzbach\-Laufen",
"496247", "Worms\-Pfeddersheim",
"495102", "Laatzen",
"496876", "Weiskirchen\ Saar",
"4939459", "Hasselfelde",
"497445", "Pfalzgrafenweiler",
"496043", "Nidda",
"495251", "Paderborn",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"493762", "Crimmitschau",
"495932", "Haren\ Ems",
"494953", "Bunde",
"49991", "Deggendorf",
"499562", "Sonnefeld",
"492324", "Hattingen\ Ruhr",
"496835", "Beckingen",
"4936962", "Vacha",
"497935", "Schrozberg",
"499469", "Roding\-Neubäu",
"493328", "Teltow",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4939263", "Unseburg",
"492156", "Willich\-Anrath",
"4936025", "Körner",
"4935451", "Dahme\ Brandenburg",
"494621", "Schleswig",
"499933", "Wallersdorf",
"495555", "Moringen\-Fredelsloh",
"497471", "Hechingen",
"494297", "Ottersberg\-Posthausen",
"496123", "Eltville\ am\ Rhein",
"492332", "Gevelsberg",
"499103", "Cadolzburg",
"499281", "Hof\ Saale",
"492164", "Jüchen\-Otzenrath",
"494732", "Stadland\-Rodenkirchen",
"497157", "Waldenbuch",
"495377", "Ehra\-Lessien",
"4935823", "Ostritz",
"495765", "Raddestorf",
"493935", "Tangerhütte",
"497328", "Königsbronn",
"499974", "Traitsching",
"4939428", "Pabstorf",
"4937609", "Wolkenburg\ Mulde",
"498426", "Walting\ Kreis\ Eichstätt",
"494526", "Ascheberg\ Holstein",
"494827", "Wacken",
"493471", "Bernburg\ Saale",
"496363", "Niederkirchen",
"495507", "Ebergötzen",
"498392", "Markt\ Rettenbach",
"498665", "Inzell",
"4934444", "Lützen",
"494740", "Loxstedt\-Dedesdorf",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"494724", "Cuxhaven\-Lüdingworth",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4934204", "Schkeuditz",
"498682", "Laufen\ Salzach",
"493583", "Zittau",
"4933606", "Müllrose",
"498254", "Altomünster",
"492977", "Schmallenberg\-Bödefeld",
"4934328", "Hartha\ bei\ Döbeln",
"499229", "Mainleus",
"496355", "Albisheim\ Pfrimm",
"496209", "Mörlenbach",
"499167", "Oberscheinfeld",
"4939344", "Güsen",
"496349", "Billigheim\-Ingenheim",
"4937431", "Mehltheuer\ Vogtland",
"493976", "Torgelow\ bei\ Ueckermünde",
"4939224", "Büden",
"4936761", "Heubisch",
"493445", "Naumburg\ Saale",
"495753", "Auetal\-Bernsen",
"492852", "Hamminkeln",
"497762", "Wehr\ Baden",
"499238", "Röslau",
"4938328", "Miltzow",
"495146", "Wietze",
"4939266", "Förderstedt",
"4939972", "Walkendorf",
"492545", "Rosendahl\-Darfeld",
"492275", "Kerpen\-Buir",
"494258", "Schwarme",
"495901", "Fürstenau\ bei\ Bramsche",
"496393", "Fischbach\ bei\ Dahn",
"492452", "Heinsberg\ Rheinland",
"498362", "Füssen",
"495131", "Garbsen",
"4936465", "Oberndorf\ bei\ Apolda",
"498385", "Hergatz",
"495026", "Steimbke",
"494604", "Grossenwiehe",
"496683", "Ehrenberg\ Rhön",
"499197", "Egloffstein",
"496652", "Hünfeld",
"494203", "Weyhe\ bei\ Bremen",
"492241", "Siegburg",
"494181", "Buchholz\ in\ der\ Nordheide",
"498728", "Geratskirchen",
"496284", "Mudau",
"492571", "Greven\ Westfalen",
"492236", "Wesseling\ Rheinland",
"492301", "Holzwickede",
"494343", "Laboe",
"4938204", "Broderstorf",
"495406", "Belm",
"4935953", "Burkau",
"493871", "Parchim",
"499681", "Windischeschenbach",
"4936648", "Dittersdorf\ bei\ Schleiz",
"499104", "Emskirchen",
"494221", "Delmenhorst",
"495337", "Kissenbrück",
"496124", "Bad\ Schwalbach",
"494772", "Oberndorf\ Oste",
"492323", "Herne",
"496132", "Ingelheim\ am\ Rhein",
"493431", "Döbeln",
"494954", "Moormerland",
"496356", "Carlsberg\ Pfalz",
"492447", "Dahlem\ bei\ Kall",
"499922", "Zwiesel",
"497802", "Oberkirch\ Baden",
"4939744", "Rothenklempenow",
"495651", "Eschwege",
"4936604", "Münchenbernsdorf",
"493941", "Halberstadt",
"4935930", "Seitschen",
"496647", "Herbstein\-Stockhausen",
"494525", "Ahrensbök",
"492937", "Arnsberg\-Oeventrop",
"496044", "Schotten\ Hessen",
"496020", "Heigenbrücken",
"495805", "Oetzen",
"4934973", "Osternienburg",
"498666", "Teisendorf",
"496400", "Mücke",
"498751", "Mainburg",
"499444", "Siegenburg",
"495923", "Schüttorf",
"499420", "Feldkirchen\ Niederbayern",
"497584", "Altshausen",
"495766", "Rehburg\-Loccum",
"4938300", "Insel\ Hiddensee",
"495564", "Dassel",
"499391", "Marktheidenfeld",
"492235", "Erftstadt",
"49811", "Hallbergmoos",
"495468", "Bramsche\-Engter",
"498825", "Krün",
"4936948", "Römhild",
"494667", "Dagebüll",
"497142", "Bietigheim\-Bissingen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4939889", "Boitzenburg",
"499548", "Mühlhausen\ Mittelfranken",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"499278", "Weidenberg",
"4938728", "Domsühl",
"495171", "Peine",
"4935021", "Königstein\ Sächsische\ Schweiz",
"499747", "Geroda\ Bayern",
"498386", "Oberstaufen",
"497351", "Biberach\ an\ der\ Riss",
"499844", "Obernzenn",
"495025", "Estorf\ Weser",
"499820", "Lehrberg",
"498133", "Haimhausen\ Oberbayern",
"497130", "Löwenstein\ Württemberg",
"497022", "Nürtingen",
"495159", "Coppenbrügge\-Bisperode",
"4939400", "Wefensleben",
"4934673", "Heldrungen",
"4939320", "Schinne",
"495145", "Beedenbostel",
"493831", "Stralsund",
"496781", "Idar\-Oberstein",
"497034", "Ehningen",
"4933848", "Raben",
"492744", "Herdorf",
"495594", "Bovenden\-Reyershausen",
"492546", "Coesfeld\-Lette",
"497402", "Fluorn\-Winzeln",
"4938841", "Neuhaus\ Elbe",
"4939382", "Kamern",
"499621", "Amberg\ Oberpfalz",
"499093", "Polsingen",
"494933", "Dornum\ Ostfriesland",
"4936071", "Teistungen",
"4934321", "Leisnig",
"493907", "Gardelegen",
"496855", "Freisen",
"4939926", "Grabowhöfe",
"494281", "Zeven",
"494103", "Wedel",
"4938783", "Dallmin",
"497955", "Wallhausen\ Württemberg",
"496184", "Langenselbold",
"494562", "Grömitz",
"49491", "Leer\ Ostfriesland",
"499953", "Pilsting",
"4937438", "Bad\ Brambach",
"497949", "Pfedelbach\-Untersteinbach",
"492383", "Bönen",
"496849", "Kirkel",
"492352", "Altena\ Westfalen",
"4934241", "Jesewitz",
"495535", "Polle",
"498462", "Berching",
"494469", "Wangerooge",
"499965", "Sankt\ Englmar",
"495246", "Verl",
"492294", "Morsbach\ Sieg",
"4934906", "Raguhn",
"495774", "Wagenfeld\-Ströhen",
"4939399", "Kleinau",
"499908", "Schöfweg",
"497532", "Meersburg",
"492693", "Antweiler",
"4933437", "Reichenberg\ bei\ Strausberg",
"492175", "Leichlingen\ Rheinland",
"497524", "Bad\ Waldsee",
"4936693", "Crossen\ an\ der\ Elster",
"4939421", "Osterwieck",
"499480", "Sünching",
"494158", "Roseburg",
"492401", "Baesweiler",
"497726", "Bad\ Dürrheim",
"494443", "Dinklage",
"498273", "Nordendorf",
"498543", "Aidenbach",
"495952", "Sögel",
"495306", "Cremlingen",
"4934639", "Wallendorf\ Luppe",
"497963", "Adelmannsfelden",
"494327", "Grossenaspe",
"495231", "Detmold",
"497839", "Schapbach",
"4936732", "Könitz",
"493501", "Pirna",
"4935267", "Diesbar\-Seusslitz",
"499129", "Wendelstein",
"4935202", "Klingenberg\ Sachsen",
"499267", "Nordhalben",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4937462", "Rothenkirchen\ Vogtland",
"497428", "Rosenfeld",
"494843", "Viöl",
"495085", "Burgdorf\-Ehlershausen",
"492801", "Xanten",
"4938482", "Warin",
"498326", "Fischen\ im\ Allgäu",
"493371", "Luckenwalde",
"4937327", "Rechenberg\-Bienenmühle",
"492655", "Weibern",
"4933204", "Beelitz\ Mark",
"494499", "Barssel",
"4938321", "Martensdorf\ bei\ Stralsund",
"492264", "Marienheide",
"497082", "Neuenbürg\ Württemberg",
"497257", "Bruchsal\-Untergrombach",
"4934606", "Teicha\ Sachsen\-Anhalt",
"497053", "Bad\ Teinach\-Zavelstein",
"492663", "Westerburg\ Westerwald",
"4934783", "Gerbstedt",
"496455", "Frankenau\ Hessen",
"4939292", "Biederitz",
"495062", "Holle\ bei\ Hildesheim",
"496449", "Ehringshausen\-Katzenfurt",
"4939856", "Beenz\ bei\ Prenzlau",
"495850", "Neetze",
"498862", "Steingaden\ Oberbayern",
"496893", "Saarbrücken\-Ensheim",
"496721", "Bingen\ am\ Rhein",
"496542", "Bullay",
"499701", "Sandberg\ Unterfranken",
"496272", "Hirschhorn\ Neckar",
"495368", "Parsau",
"4939084", "Lindstedt",
"494260", "Visselhövede\-Wittorf",
"497725", "Königsfeld\ im\ Schwarzwald",
"4934721", "Nienburg\ Saale",
"497388", "Pfronstetten",
"495259", "Bad\ Driburg\-Neuenheerse",
"494973", "Wittmund\-Burhafe",
"495305", "Sickte",
"4934293", "Naunhof\ bei\ Grimma",
"499966", "Wiesenfelden",
"497451", "Horb\ am\ Neckar",
"495245", "Herzebrock\-Clarholz",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"496703", "Wöllstein\ Rheinhessen",
"499723", "Röthlein",
"4937363", "Zöblitz",
"496061", "Michelstadt",
"49821", "Augsburg",
"496758", "Waldböckelheim",
"497572", "Mengen\ Württemberg",
"498622", "Tacherting\-Peterskirchen",
"497242", "Rheinstetten",
"493523", "Coswig\ bei\ Dresden",
"492905", "Bestwig\-Ramsbeck",
"495734", "Bergkirchen\ Westfalen",
"493964", "Bredenfelde\ bei\ Strasburg",
"499289", "Schwarzenbach\ am\ Wald",
"4938305", "Gingst",
"495837", "Sprakensehl",
"4933673", "Weichensdorf",
"495536", "Holzminden\-Neuhaus",
"499178", "Abenberg\ Mittelfranken",
"495271", "Höxter",
"495541", "Hann\.\ Münden",
"4939824", "Hohenzieritz",
"495722", "Bückeburg",
"492823", "Goch",
"4935935", "Kleinwelka",
"4938425", "Kirchdorf\ Poel",
"498233", "Kissing",
"496856", "St\ Wendel\-Niederkirchen",
"499461", "Roding",
"498634", "Garching\ an\ der\ Alz",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"496557", "Hallschlag",
"4936450", "Kranichfeld",
"492207", "Kürten\-Dürscheid",
"495602", "Hessisch\ Lichtenau",
"495437", "Menslage",
"493346", "Seelow",
"4936332", "Ellrich",
"494638", "Tarp",
"4939954", "Stavenhagen\ Reuterstadt",
"4934425", "Droyssig",
"4936873", "Themar",
"492423", "Langerwehe",
"4939483", "Ballenstedt",
"493331", "Angermünde",
"499861", "Rothenburg\ ob\ der\ Tauber",
"496456", "Haina\ Kloster",
"499658", "Georgenberg",
"4933841", "Belzig",
"4936206", "Grossfahner",
"4938848", "Vellahn",
"498702", "Wörth\ an\ der\ Isar",
"495086", "Celle\-Scheuen",
"499603", "Floss",
"496623", "Rotenburg\ an\ der\ Fulda",
"4939325", "Vinzelberg",
"4933877", "Nitzahn",
"4936941", "Wasungen",
"498325", "Oberstaufen\-Thalkirchdorf",
"4934383", "Trebsen\ Mulde",
"493994", "Malchin",
"4938293", "Kühlungsborn\ Ostseebad",
"494121", "Elmshorn",
"499204", "Plankenfels",
"492656", "Virneburg",
"496224", "Sandhausen\ Baden",
"497066", "Bad\ Rappenau\-Bonfeld",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4938721", "Ziegendorf",
"496232", "Speyer",
"499344", "Gerchsheim",
"4935028", "Krippen",
"492058", "Wülfrath",
"497668", "Ihringen",
"497851", "Kehl",
"492761", "Olpe\ Biggesee",
"4939405", "Hötensleben",
"495947", "Laar\ Vechte",
"494487", "Grossenkneten\-Huntlosen",
"4939245", "Loburg",
"499491", "Hemau",
"492822", "Emmerich",
"498232", "Schwabmünchen",
"492538", "Drensteinfurt\-Rinkerode",
"494239", "Dörverden\-Westen",
"4933762", "Zeuthen",
"495723", "Bad\ Nenndorf",
"496587", "Zerf",
"4938796", "Viesecke",
"497303", "Illertissen",
"499575", "Weismain",
"495966", "Meppen\-Apeldorn",
"499245", "Obertrubach",
"4936785", "Gräfinau\-Angstedt",
"497573", "Stetten\ am\ kalten\ Markt",
"498623", "Kirchweidach",
"498091", "Kirchseeon",
"493838", "Bergen\ auf\ Rügen",
"493741", "Plauen",
"497243", "Ettlingen",
"493522", "Grossenhain\ Sachsen",
"496325", "Lambrecht\ Pfalz",
"499305", "Estenfeld",
"498224", "Offingen\ Donau",
"497620", "Schopfheim\-Gersbach",
"492834", "Straelen",
"497644", "Kenzingen",
"496788", "Sien",
"492737", "Netphen\-Deuz",
"494754", "Bülkau",
"495461", "Bramsche\ Hase",
"494556", "Ahrensbök\-Gnissau",
"494857", "Barlt",
"498456", "Lenting",
"499271", "Thurnau\-Alladorf",
"492366", "Herten\ Westfalen",
"499722", "Werneck",
"499837", "Haundorf",
"497358", "Eberhardzell\-Füramoos",
"499536", "Kirchlauter",
"499734", "Burkardroth",
"497127", "Neckartenzlingen",
"497269", "Sulzfeld\ Baden",
"4936703", "Gräfenthal",
"494972", "Langeoog",
"496233", "Frankenthal\ Pfalz",
"495861", "Dannenberg\ Elbe",
"4937320", "Mulda\ Sachsen",
"495658", "Wehretal",
"4936481", "Neustadt\ an\ der\ Orla",
"498557", "Mauth",
"49214", "Leverkusen",
"496634", "Gemünden\ Felda",
"498856", "Penzberg",
"492944", "Rietberg\-Mastholte",
"492686", "Weyerbusch",
"49621", "Mannheim",
"498061", "Bad\ Aibling",
"499602", "Neustadt\ an\ der\ Waldnaab",
"496622", "Bebra",
"495056", "Winsen\-Meissendorf",
"4938731", "Lübz",
"499398", "Birkenfeld\ bei\ Würzburg",
"495491", "Damme\ Dümmer",
"4935726", "Gross\ Särchen",
"496486", "Katzenelnbogen",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"492422", "Kreuzau",
"492529", "Oelde\-Stromberg",
"49202", "Wuppertal",
"498703", "Essenbach",
"495344", "Lengede",
"495320", "Torfhaus",
"495204", "Steinhagen\ Westfalen",
"4934774", "Röblingen\ am\ See",
"492434", "Wegberg",
"499086", "Fremdingen",
"495603", "Gudensberg",
"499535", "Pfarrweisach",
"494442", "Lohne\ Oldenburg",
"493574", "Lauchhammer",
"49751", "Ravensburg",
"497962", "Fichtenau",
"4933362", "Liepe\ Kreis\ Barnim",
"493643", "Weimar\ Thüringen",
"498272", "Wertingen",
"4935601", "Peitz",
"498542", "Ortenburg",
"492248", "Hennef\-Uckerath",
"495953", "Börger",
"494188", "Welle\ Nordheide",
"498721", "Eggenfelden",
"496050", "Biebergemünd",
"492777", "Breitscheid\ Hessen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"492874", "Isselburg",
"492308", "Unna\-Hemmerde",
"495621", "Bad\ Wildungen",
"4937344", "Crottendorf\ Sachsen",
"4938374", "Lassan\ bei\ Wolgast",
"493304", "Velten",
"4935364", "Lebusa",
"492692", "Kelberg",
"497533", "Allensbach",
"492365", "Marl",
"492382", "Ahlen\ Westfalen",
"4935754", "Klettwitz",
"499231", "Marktredwitz",
"496599", "Weidenbach\ bei\ Gerolstein",
"496326", "Deidesheim",
"494563", "Scharbeutz\-Haffkrug",
"499306", "Kist",
"499952", "Eichendorf",
"4936423", "Orlamünde",
"494924", "Moormerland\-Oldersum",
"498463", "Greding",
"4935439", "Zinnitz",
"492353", "Halver",
"4935052", "Kipsdorf\ Kurort",
"499092", "Wemding",
"494932", "Norderney",
"494251", "Hoya",
"495908", "Wietmarschen\-Lohne",
"496154", "Ober\-Ramstadt",
"494102", "Ahrensburg",
"4933054", "Liebenwalde",
"499774", "Oberelsbach",
"495138", "Sehnde",
"499576", "Lichtenfels\-Isling",
"495965", "Klein\ Berssen",
"493735", "Marienberg\ Sachsen",
"499246", "Pegnitz\-Trockau",
"496674", "Friedewald\ Hessen",
"492750", "Diedenshausen",
"496543", "Büchenbeuren",
"4934929", "Straach",
"499085", "Alerheim",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4933338", "Stolpe\/Oder",
"497083", "Bad\ Herrenalb",
"4938859", "Alt\ Zachun",
"496485", "Nentershausen\ Westerwald",
"4938331", "Rakow\ Vorpom",
"495129", "Söhlde",
"495063", "Bad\ Salzdetfurth",
"497052", "Bad\ Liebenzell",
"492395", "Finnentrop\-Rönkhausen",
"492662", "Hachenburg",
"496569", "Bickendorf",
"492685", "Flammersfeld",
"494842", "Nordstrand",
"495055", "Fassberg",
"4939991", "Daberkow",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"496462", "Gladenbach",
"497321", "Heidenheim\ an\ der\ Brenz",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"492474", "Nideggen\-Schmidt",
"4935246", "Ziegenhain\ Sachsen",
"4933870", "Zollchow\ bei\ Rathenow",
"4936024", "Diedorf\ bei\ Mühlhausen",
"494830", "Süderhastedt",
"492991", "Marsberg\-Bredelar",
"494357", "Sehestedt\ Eider",
"495922", "Bad\ Bentheim",
"492567", "Ahaus\-Alstätte",
"498781", "Rottenburg\ an\ der\ Laaber",
"494128", "Kollmar",
"492866", "Dorsten\-Rhade",
"497554", "Heiligenberg\ Baden",
"4939006", "Miesterhorst",
"4939753", "Strasburg",
"499337", "Gaukönigshofen",
"492051", "Velbert",
"497661", "Kirchzarten",
"4934463", "Bad\ Kösen",
"493867", "Lübstorf",
"495681", "Homberg\ Efze",
"495934", "Haren\-Rütenbrock",
"496696", "Gilserberg",
"499498", "Laaber",
"493764", "Meerane",
"4938352", "Kemnitz\ bei\ Greifswald",
"496386", "Altenkirchen\ Pfalz",
"4935772", "Rietschen",
"499564", "Bad\ Rodach",
"499766", "Grosswenkheim",
"496133", "Oppenheim",
"4933435", "Rehfelde",
"4939363", "Angern",
"499923", "Teisnach",
"494631", "Glücksburg\ Ostsee",
"497803", "Gengenbach",
"495444", "Wagenfeld",
"496825", "Illingen\ Saar",
"49611", "Wiesbaden",
"499805", "Burgoberbach",
"494646", "Mohrkirch",
"493338", "Bernau\ Brandenburg",
"4936376", "Straussfurt",
"499651", "Vohenstrauss",
"499868", "Schillingsfürst",
"494773", "Lamstedt",
"492334", "Hagen\-Hohenlimburg",
"496751", "Bad\ Sobernheim",
"496068", "Beerfelden",
"492961", "Brilon",
"495820", "Suhlendorf",
"4939039", "Bonese",
"497403", "Dunningen",
"495844", "Clenze",
"4935265", "Glaubitz",
"4939452", "Ilsenburg",
"492597", "Senden\ Westfalen",
"499171", "Roth\ Mittelfranken",
"495278", "Höxter\-Ovenhausen",
"497023", "Weilheim\ an\ der\ Teck",
"499405", "Bad\ Abbach",
"4937325", "Niederbobritzsch",
"496425", "Rauschenberg\ Hessen",
"497227", "Lichtenau\ Baden",
"493596", "Neustadt\ in\ Sachsen",
"496666", "Freiensteinau",
"499468", "Zell\ Oberpfalz",
"493329", "Stahnsdorf",
"498020", "Weyarn",
"495361", "Wolfsburg",
"4939727", "Spantekow",
"494139", "Hohnstorf\ Elbe",
"492625", "Ochtendung",
"4962196", "Ludwigshafen",
"497381", "Münsingen",
"499145", "Solnhofen",
"497458", "Ebhausen",
"497143", "Besigheim",
"498124", "Forstern\ Oberbayern",
"4936969", "Merkers",
"4938738", "Karow\ bei\ Lübz",
"4935473", "Neu\ Lübbenau",
"4933731", "Trebbin",
"496826", "Bexbach",
"4937421", "Oelsnitz\ Vogtland",
"496527", "Oberweis",
"492853", "Schermbeck",
"4933929", "Gühlen\-Glienicke",
"497763", "Murg",
"495752", "Auetal\-Hattendorf",
"499639", "Mähring",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496385", "Reichenbach\-Steegen",
"498683", "Tittmoning",
"499765", "Trappstadt",
"498652", "Berchtesgaden",
"499377", "Freudenberg\-Boxtal",
"499708", "Bad\ Bocklet",
"498284", "Ziemetshausen",
"496728", "Ober\-Hilbersheim",
"494671", "Bredstedt",
"4938307", "Poseritz",
"4933396", "Klosterfelde",
"49471", "Bremerhaven",
"498393", "Holzgünz",
"492504", "Telgte",
"496173", "Kronberg\ im\ Taunus",
"4935608", "Gross\ Ossnig",
"496362", "Alsenz",
"496695", "Jesberg",
"494733", "Butjadingen\-Burhave",
"4937382", "Geringswalde",
"492374", "Iserlohn\-Letmathe",
"495167", "Walsrode\-Westenholz",
"4938427", "Blowatz",
"493378", "Ludwigsfelde",
"492865", "Raesfeld",
"497755", "Weilheim\ Kreis\ Waldshut",
"4935937", "Prischwitz",
"498349", "Stötten\ am\ Auerberg",
"494342", "Preetz\ Kreis\ Plön",
"499131", "Erlangen",
"4934362", "Mügeln\ bei\ Oschatz",
"4939998", "Loitz\ bei\ Demmin",
"499901", "Hengersberg\ Bayern",
"497821", "Lahr\ Schwarzwald",
"499350", "Eussenheim\-Hundsbach",
"4938453", "Mistorf",
"496682", "Tann\ Rhön",
"494151", "Schwarzenbek",
"492408", "Aachen\-Kornelimünster",
"496254", "Lautertal\ Odenwald",
"492626", "Selters\ Westerwald",
"494202", "Achim\ bei\ Bremen",
"4937292", "Oederan",
"494330", "Emkendorf",
"492465", "Inden",
"495238", "Nieheim\-Himmighausen",
"499146", "Markt\ Berolzheim",
"496653", "Burghaun",
"492482", "Hellenthal",
"499406", "Mintraching",
"4936842", "Oberhof\ Thüringen",
"499628", "Ursensollen",
"496426", "Fronhausen",
"498363", "Pfronten",
"4933875", "Rhinow",
"494179", "Winsen\-Tönnhausen",
"496665", "Sinntal\-Altengronau",
"496392", "Hauenstein\ Pfalz",
"492453", "Heinsberg\-Randerath",
"49208", "Oberhausen\ Rheinland",
"494288", "Horstedt\ Kreis\ Rotenburg",
"4939327", "Klietz",
"4933331", "Casekow",
"495197", "Soltau\-Frielingen",
"4939247", "Güterglück",
"4939407", "Seehausen\ Börde",
"49331", "Potsdam",
"494876", "Reher\ Holstein",
"494247", "Affinghausen",
"492755", "Bad\ Berleburg\-Schwarzenau",
"496138", "Mommenheim",
"499928", "Kirchdorf\ im\ Wald",
"495154", "Aerzen",
"497808", "Hohberg\ bei\ Offenburg",
"4935951", "Neukirch\ Lausitz",
"499080", "Harburg\ Schwaben",
"497374", "Uttenweiler",
"4936462", "Ossmannstedt",
"497706", "Oberbaldingen",
"492421", "Düren",
"497504", "Horgenzell",
"495492", "Steinfeld\ Oldenburg",
"498085", "Sankt\ Wolfgang",
"494307", "Raisdorf",
"494778", "Wingst",
"495326", "Langelsheim",
"4939959", "Dargun",
"492680", "Mündersbach",
"496621", "Bad\ Hersfeld",
"496093", "Laufach",
"4936730", "Sitzendorf",
"498062", "Bruckmühl\ Mangfall",
"499184", "Deining\ Oberpfalz",
"494123", "Barmstedt",
"4935200", "Arnsdorf\ bei\ Dresden",
"499855", "Dentlein\ am\ Forst",
"496297", "Ravenstein\ Baden",
"495862", "Hitzacker\ Elbe",
"4935456", "Terpt",
"497853", "Kehl\-Bodersweier",
"492763", "Drolshagen\-Bleche",
"4939975", "Thürkow",
"499493", "Beratzhausen",
"494835", "Albersdorf\ Holstein",
"4937433", "Gutenfürst",
"496049", "Kefenrod",
"494971", "Esens",
"497453", "Altensteig\ Württemberg",
"497148", "Grossbottwar",
"496055", "Freigericht",
"494550", "Bühnsdorf",
"498535", "Haarbach",
"495462", "Ankum",
"499272", "Fichtelberg",
"496701", "Sprendlingen\ Rheinhessen",
"4938788", "Gross\ Warnow",
"499721", "Schweinfurt",
"498450", "Ingolstadt\-Zuchering",
"499542", "Schesslitz",
"494435", "Grossenkneten",
"497482", "Horb\-Dettingen",
"4939776", "Hintersee",
"4939829", "Blankenförde",
"492360", "Haltern\-Lippramsdorf",
"496063", "Bad\ König",
"497465", "Emmingen\-Liptingen",
"498092", "Grafing\ bei\ München",
"493521", "Meissen",
"494945", "Grossefehn\-Timmel",
"495485", "Ladbergen",
"497626", "Kandern",
"498246", "Waal",
"4939089", "Bismark\ Altmark",
"496267", "Fahrenbach\ Baden",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"496129", "Schlangenbad",
"495273", "Beverungen",
"498306", "Ronsberg",
"495543", "Staufenberg\ Niedersachsen",
"494959", "Dollart",
"492821", "Kleve\ Niederrhein",
"4933702", "Wünsdorf",
"498231", "Königsbrunn\ bei\ Augsburg",
"4933767", "Friedersdorf\ bei\ Berlin",
"495674", "Grebenstein",
"499463", "Wald\ Oberpfalz",
"497334", "Deggingen",
"494609", "Eggebek",
"4939488", "Güntersberge",
"4937206", "Frankenberg\ Sachsen",
"4936878", "Oberland",
"4938843", "Bennin",
"492925", "Warstein\-Allagen",
"494836", "Hennstedt\ Dithmarschen",
"494537", "Sülfeld\ Holstein",
"492803", "Wesel\-Büderich",
"494841", "Husum\ Nordsee",
"495702", "Petershagen\-Lahde",
"496461", "Biedenkopf",
"497322", "Giengen\ an\ der\ Brenz",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"499856", "Dürrwangen",
"4936452", "Berlstedt",
"497705", "Wolterdingen\ Schwarzw",
"4935023", "Bad\ Gottleuba",
"497051", "Calw",
"498086", "Buchbach\ Oberbayern",
"492661", "Bad\ Marienberg\ Westerwald",
"492858", "Hünxe",
"4936330", "Grossberndten",
"495325", "Goslar\-Hahnenklee",
"4933209", "Caputh",
"494875", "Stafstedt",
"492554", "Laer\ Kreis\ Steinfurt",
"497567", "Leutkirch\-Friesenhofen",
"494364", "Dahme\ Kreis\ Ostholstein",
"4933978", "Segeletz",
"496723", "Oestrich\-Winkel",
"494252", "Bruchhausen\-Vilsen",
"498259", "Schiltberg",
"494931", "Norden",
"499091", "Monheim\ Schwaben",
"494684", "Langeness\ Hallig",
"4937368", "Deutschneudorf",
"4939394", "Hohenberg\-Krusemark",
"498368", "Halblech",
"494101", "Pinneberg",
"494283", "Tarmstedt",
"496204", "Viernheim",
"4935057", "Hermsdorf\ Erzgebirge",
"497466", "Beuron",
"499951", "Landau\ an\ der\ Isar",
"492381", "Hamm\ Westfalen",
"494475", "Molbergen",
"499232", "Wunsiedel",
"496344", "Schwegenheim",
"4934298", "Taucha\ bei\ Leipzig",
"497625", "Zell\ im\ Wiesental",
"494946", "Grossefehn\-Bagband",
"498245", "Türkheim\ Wertach",
"498734", "Reisbach\ Niederbayern",
"496056", "Bad\ Soden\-Salmünster",
"492227", "Bornheim\-Merten",
"498536", "Kösslarn",
"49521", "Bielefeld",
"492691", "Adenau",
"495622", "Fritzlar",
"495037", "Bad\ Rehburg",
"495634", "Waldeck\-Sachsenhausen",
"4933367", "Friedrichswalde\ Brandenburg",
"492403", "Eschweiler\ Rheinland",
"494441", "Vechta",
"4933678", "Storkow\ Mark",
"498271", "Meitingen",
"498541", "Vilshofen\ Niederbayern",
"4934494", "Ehrenhain",
"494394", "Bokhorst",
"498722", "Gangkofen",
"497961", "Ellwangen\ Jagst",
"496658", "Poppenhausen\ Wasserkuppe",
"496861", "Merzig",
"495233", "Steinheim\ Westfalen",
"492985", "Winterberg\-Niedersfeld",
"498146", "Moorenweis",
"496167", "Modautal",
"499209", "Emtmannsberg",
"499355", "Frammersbach",
"496229", "Neckarsteinach",
"495173", "Uetze",
"497353", "Schwendi",
"495695", "Twistetal",
"495362", "Wolfsburg\-Fallersleben",
"499349", "Werbach\-Wenkheim",
"498131", "Dachau",
"4938323", "Prohn",
"494335", "Hohn\ bei\ Rendsburg",
"49355", "Cottbus",
"4939722", "Sarnow\ bei\ Anklam",
"4939295", "Zuchau",
"4934781", "Greifenhagen",
"497382", "Römerstein",
"4938485", "Dabel",
"497365", "Essingen\ Württemberg",
"492533", "Münster\-Nienberge",
"4939884", "Hassleben\ bei\ Prenzlau",
"49381", "Rostock",
"497308", "Nersingen",
"498026", "Hausham",
"497777", "Sauldorf",
"496660", "Steinau\-Marjoss",
"497248", "Marxzell",
"498406", "Böhmfeld",
"4936735", "Probstzella",
"498628", "Kienberg\ Oberbayern",
"497578", "Wald\ Hohenz",
"496752", "Kirn\ Nahe",
"4939457", "Benneckenstein\ Harz",
"49251", "Münster",
"492962", "Olsberg",
"4935205", "Ottendorf\-Okrilla",
"499172", "Georgensgmünd",
"496783", "Baumholder",
"495527", "Duderstadt",
"495826", "Suderburg",
"4989", "Munich",
"494704", "Drangstedt",
"494506", "Stockelsdorf\-Krumbeck",
"499363", "Arnstein\ Unterfranken",
"4937465", "Tannenbergsthal\ Vogtland",
"498765", "Bruckberg\ Niederbayern",
"499683", "Friedenfels",
"494624", "Kropp",
"4939423", "Wegeleben",
"4936691", "Eisenberg\ Thüringen",
"49341", "Leipzig",
"499284", "Schwarzenbach\ an\ der\ Saale",
"494223", "Ganderkesee\-Bookholzberg",
"498708", "Weihmichl\-Unterneuhausen",
"4939749", "Grambow\ bei\ Pasewalk",
"497474", "Haigerloch",
"499652", "Waidhaus",
"498377", "Unterthingau",
"493969", "Siedenbollentin",
"4935828", "Reichenbach\ OL",
"493433", "Borna\ Stadt",
"498507", "Neuburg\ am\ Inn",
"495665", "Guxhagen",
"498806", "Utting\ am\ Ammersee",
"494407", "Wardenburg",
"498639", "Neumarkt\-Sankt\ Veit",
"494632", "Steinbergkirche",
"495426", "Glandorf",
"497685", "Gutach\-Bleibach",
"495608", "Söhrewald",
"492052", "Velbert\-Langenberg",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"497395", "Ehingen\-Dächingen",
"495653", "Sontra",
"493943", "Wernigerode",
"496238", "Dirmstein",
"495682", "Borken\ Hessen",
"4934243", "Bad\ Düben",
"4933836", "Butzow\ bei\ Brandenburg",
"495254", "Paderborn\-Schloss\ Neuhaus",
"498753", "Elsendorf\ Niederbayern",
"495921", "Nordhorn",
"492992", "Marsberg",
"4938781", "Mellen",
"498782", "Pfeffenhausen",
"499393", "Rothenfels\ Unterfranken",
"498405", "Stammham\ bei\ Ingolstadt",
"492269", "Kierspe\-Rönsahl",
"4939402", "Völpke",
"49511", "Hannover",
"498468", "Altmannstein\-Pondorf",
"4939242", "Prödel",
"495825", "Wieren",
"494505", "Stockelsdorf\-Curau",
"499647", "Kirchenthumbach",
"492358", "Meinerzhagen\-Valbert",
"497366", "Abtsgmünd",
"4934381", "Colditz",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"4939322", "Tangermünde",
"4936943", "Bettenhausen\ Thüringen",
"496444", "Bischoffen",
"496420", "Lahntal",
"4938209", "Sanitz\ bei\ Rostock",
"495903", "Emsbüren",
"498171", "Wolfratshausen",
"494767", "Bremervörde\-Bevern",
"496391", "Dahn",
"4938723", "Kladrum",
"4933971", "Kyritz\ Brandenburg",
"4936847", "Steinbach\-Hallenberg",
"498025", "Miesbach",
"494864", "Oldenswort",
"494152", "Geesthacht",
"4934422", "Osterfeld",
"4933476", "Neuhardenberg",
"4939481", "Hedersleben\ bei\ Aschersleben",
"497834", "Wolfach",
"4937297", "Thum\ Sachsen",
"492620", "Neuhäusel\ Westerwald",
"495696", "Bad\ Arolsen\-Landau",
"4936871", "Bad\ Colberg\-Heldburg",
"492644", "Linz\ am\ Rhein",
"496681", "Hilders",
"493987", "Templin",
"494336", "Owschlag",
"492243", "Eitorf",
"494183", "Jesteburg",
"4933843", "Niemegk",
"496104", "Heusenstamm",
"492573", "Nordwalde",
"492303", "Unna",
"499132", "Herzogenaurach",
"494494", "Bösel\ Oldenburg",
"498145", "Mammendorf",
"4936335", "Grosswechsungen",
"499356", "Burgsinn",
"497822", "Ettenheim",
"498337", "Altenstadt\ Iller",
"497434", "Winterlingen",
"4939349", "Parey\ Elbe",
"4935932", "Guttau",
"4938422", "Neukloster",
"4936643", "Thimmendorf",
"4939056", "Klüden",
"494672", "Langenhorn",
"498679", "Burgkirchen\ an\ der\ Alz",
"497529", "Waldburg\ Württemberg",
"497422", "Schramberg",
"4933671", "Lieberose",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"496361", "Rockenhausen",
"4938302", "Sagard",
"493581", "Görlitz",
"498805", "Hohenpeissenberg",
"4937361", "Neuhausen\ Erzgebirge",
"4933093", "Fürstenberg\ Havel",
"498651", "Bad\ Reichenhall",
"4938757", "Neustadt\-Glewe",
"495425", "Borgholzhausen",
"498868", "Schwabsoien",
"4935341", "Bad\ Liebenwerda",
"498766", "Gammelsdorf",
"497944", "Kupferzell",
"496844", "Blieskastel\-Altheim",
"4935793", "Elstra",
"498564", "Johanniskirchen",
"496747", "Emmelshausen",
"495068", "Elze\ Leine",
"4934978", "Radegast\ Kreis\ Köthen",
"4934291", "Borsdorf",
"495751", "Rinteln",
"4937604", "Mosel",
"494464", "Wittmund\-Carolinensiel",
"492302", "Witten",
"496766", "Kisselbach",
"499133", "Baiersdorf\ Mittelfranken",
"4934346", "Narsdorf",
"496564", "Neuerburg\ Eifel",
"499386", "Prosselsheim",
"499903", "Schöllnach",
"497823", "Seelbach\ Schutter",
"495647", "Lichtenau\-Kleinenberg",
"494153", "Lauenburg\ Elbe",
"49911", "Nuremberg",
"496805", "Kleinblittersdorf",
"4933966", "Dranse",
"497905", "Langenburg",
"499825", "Herrieden",
"495044", "Springe\-Eldagsen",
"498548", "Vilshofen\-Sandbach",
"492242", "Hennef\ Sieg",
"494182", "Tostedt",
"492572", "Emsdetten",
"496868", "Mettlach\-Tünsdorf",
"496651", "Rasdorf",
"497135", "Brackenheim",
"497176", "Spraitbach",
"495902", "Freren",
"495356", "Helmstedt\-Barmke",
"494938", "Hagermarsch",
"494165", "Hollenstedt\ Nordheide",
"498361", "Nesselwang",
"495132", "Lehrte",
"4935478", "Goyatz",
"4938733", "Karbow\-Vietlübbe",
"492451", "Geilenkirchen",
"494108", "Rosengarten\ Kreis\ Harburg",
"4939977", "Jördenstorf",
"496337", "Grossbundenbach",
"492388", "Hamm\-Uentrop",
"4939206", "Eichenbarleben",
"492725", "Lennestadt\-Oedingen",
"4934692", "Alsleben\ Saale",
"4936483", "Ziegenrück",
"492605", "Löf",
"496594", "Birresborn",
"492851", "Rees",
"496145", "Flörsheim\ am\ Main",
"497761", "Bad\ Säckingen",
"4936701", "Lichte",
"494929", "Ihlow\ Kreis\ Aurich",
"496159", "Messel",
"498681", "Waging\ am\ See",
"497656", "Schluchsee",
"492066", "Duisburg\-Homberg",
"498104", "Sauerlach",
"496898", "Völklingen",
"499779", "Nordheim\ von\ der\ Rhön",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"494673", "Joldelund",
"494195", "Hartenholm",
"497347", "Dietenheim",
"498444", "Schweitenkirchen",
"4933924", "Rägelin",
"494274", "Varrel\ bei\ Sulingen",
"494544", "Berkenthin",
"496171", "Oberursel\ Taunus",
"494746", "Hagen\ bei\ Bremerhaven",
"497423", "Oberndorf\ am\ Neckar",
"4936084", "Heuthen",
"494731", "Nordenham",
"496405", "Laubach\ Hessen",
"494848", "Rantrum",
"4933765", "Märkisch\ Buchholz",
"4938226", "Dierhagen\ Ostseebad",
"499666", "Illschwang",
"496468", "Dautphetal\-Mornshausen",
"4935386", "Prettin",
"496753", "Meisenheim",
"492963", "Brilon\-Messinghausen",
"493528", "Radeberg",
"4936840", "Trusetal",
"4934746", "Giersleben",
"499173", "Thalmässing",
"496782", "Birkenfeld\ Nahe",
"492524", "Ennigerloh",
"495209", "Gütersloh\-Friedrichsdorf",
"497175", "Leinzell",
"495355", "Frellstedt",
"4936964", "Dermbach\ Rhön",
"498238", "Gessertshausen",
"497021", "Kirchheim\ unter\ Teck",
"492532", "Ostbevern",
"492828", "Emmerich\-Elten",
"494166", "Ahlerstedt",
"4938458", "Zehna",
"493727", "Mittweida",
"4939993", "Hohenmocker",
"4933451", "Heckelberg",
"495363", "Wolfsburg\-Vorsfelde",
"498380", "Achberg",
"4938333", "Horst\ bei\ Grimmen",
"499527", "Knetzgau",
"496806", "Heusweiler",
"495172", "Ilsede",
"4936626", "Auma",
"496507", "Neumagen\-Dhron",
"499826", "Weidenbach\ Mittelfranken",
"4939034", "Fleetmark",
"497352", "Ochsenhausen",
"497906", "Braunsbach",
"496639", "Ottrau",
"497383", "Münsingen\-Buttenhausen",
"497136", "Bad\ Friedrichshall",
"492955", "Büren\-Wewelsburg",
"497141", "Ludwigsburg\ Württemberg",
"496765", "Gemünden\ Hunsrück",
"499385", "Kolitzheim",
"499728", "Wülfershausen\ Unterfranken",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"4938872", "Rehna",
"499426", "Oberschneiding",
"496628", "Oberaula",
"492993", "Marsberg\-Canstein",
"496406", "Lollar",
"499608", "Kohlberg\ Oberpfalz",
"498752", "Au\ in\ der\ Hallertau",
"4969", "Frankfurt\ am\ Main",
"498783", "Rohr\ in\ Niederbayern",
"499392", "Faulbach\ Unterfranken",
"499665", "Königstein\ Oberpfalz",
"495652", "Bad\ Sooden\-Allendorf",
"495284", "Schwalenberg",
"492053", "Velbert\-Neviges",
"497663", "Eichstetten",
"492257", "Reckerscheid",
"494745", "Bad\ Bederkesa",
"495683", "Wabern\ Hessen",
"496026", "Grossostheim",
"497264", "Bad\ Rappenau",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4936421", "Camburg",
"492065", "Duisburg\-Rheinhausen",
"497655", "Feldberg\-Altglashütten",
"496131", "Mainz",
"4936926", "Creuzburg",
"4933656", "Bahro",
"494234", "Dörverden",
"499921", "Regen",
"494633", "Satrup",
"4933086", "Grieben\ Kreis\ Oberhavel",
"499254", "Gefrees",
"492428", "Niederzier",
"4938750", "Malliss",
"492606", "Winningen\ Mosel",
"499682", "Erbendorf",
"496146", "Hochheim\ am\ Main",
"49461", "Flensburg",
"499653", "Eslarn",
"4935603", "Burg\ Spreewald",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"494222", "Ganderkesee",
"494771", "Hemmoor",
"498167", "Zolling",
"492839", "Straelen\-Herongen",
"493588", "Niesky",
"494295", "Emtinghausen",
"4933733", "Stülpe",
"496722", "Rüdesheim\ am\ Rhein",
"494174", "Stelle\ Kreis\ Harburg",
"496541", "Traben\-Trarbach",
"4938461", "Bützow",
"496271", "Eberbach\ Baden",
"4935471", "Birkenhainchen",
"492584", "Warendorf\-Milte",
"498861", "Schongau",
"498056", "Eggstätt",
"497081", "Bad\ Wildbad",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"496734", "Flonheim",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"496536", "Kleinich",
"497937", "Dörzbach",
"496837", "Wallerfangen",
"4936029", "Menteroda",
"4933989", "Sadenbeck",
"4936256", "Wechmar",
"495703", "Hille",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4934924", "Zahna",
"492802", "Alpen",
"498320", "Missen\-Wilhams",
"497447", "Baiersbronn\-Schwarzenberg",
"4937322", "Brand\-Erbisdorf",
"496245", "Biblis",
"496575", "Landscheid",
"494967", "Rhauderfehn\-Burlage",
"493372", "Jüterbog",
"497323", "Gerstetten",
"496305", "Hochspeyer",
"499325", "Kleinlangheim",
"4937467", "Klingenthal\ Sachsen",
"4935207", "Moritzburg",
"4939455", "Schierke",
"498204", "Mickhausen",
"4938854", "Redefin",
"4936737", "Drognitz",
"492637", "Weissenthurm",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"497546", "Oberteuringen",
"492402", "Stolberg\ Rheinland",
"4935434", "Altdöbern",
"497720", "Schwenningen\ am\ Neckar",
"497744", "Stühlingen",
"494265", "Fintel",
"4936042", "Tonna",
"495300", "Salzgitter\-Üfingen",
"4936744", "Remda",
"495232", "Lage\ Lippe",
"493641", "Jena",
"494208", "Grasberg",
"495951", "Werlte",
"492509", "Nottuln\-Appelhülsen",
"4939604", "Wildberg\ bei\ Altentreptow",
"498723", "Arnstorf",
"495224", "Enger\ Westfalen",
"493636", "Greussen",
"4935775", "Pechern",
"492379", "Menden\-Asbeck",
"4933432", "Müncheberg",
"494348", "Schönkirchen",
"495623", "Edertal",
"496086", "Grävenwiesbach",
"4939361", "Lüderitz",
"497531", "Konstanz",
"495456", "Westerkappeln\-Velpe",
"499233", "Arzberg\ Oberfranken",
"4939751", "Penkun",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"494561", "Neustadt\ in\ Holstein",
"4935694", "Gosda\ bei\ Klinge",
"499634", "Wiesau",
"498461", "Beilngries",
"492351", "Lüdenscheid",
"493675", "Sonneberg\ Thüringen",
"4938355", "Züssow",
"4934461", "Nebra\ Unstrut",
"499622", "Hirschau\ Oberpfalz",
"4938379", "Benz\ Usedom",
"49921", "Bayreuth",
"494253", "Asendorf\ Kreis\ Diepholz",
"4937349", "Scheibenberg",
"4939387", "Havelberg",
"494282", "Sittensen",
"498178", "Icking",
"496398", "Vorderweidenthal",
"497235", "Unterreichenbach\ Kreis\ Calw",
"496306", "Trippstadt",
"497852", "Willstätt",
"499326", "Markt\ Einersheim",
"492762", "Wenden\ Südsauerland",
"496231", "Hochdorf\-Assenheim",
"495863", "Zernien",
"4933333", "Tantow",
"494134", "Embsen\ Kreis\ Lüneburg",
"499492", "Parsberg",
"4935874", "Bernstadt\ an\ der\ Eigen",
"499154", "Pommelsbrunn",
"498063", "Feldkirchen\-Westerham",
"496092", "Heimbuchenthal",
"4936845", "Gehlberg",
"4933872", "Hohennauen",
"496246", "Eich\ Rheinhessen",
"4934779", "Abberode",
"497977", "Oberrot\ bei\ Gaildorf",
"494122", "Uetersen",
"496774", "Kaub",
"498267", "Dirlewang",
"498055", "Halfing",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"493332", "Schwedt\/Oder",
"496535", "Osann\-Monzel",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4937295", "Lugau\ Erzgebirge",
"495849", "Waddeweitz",
"4936337", "Schiedungen",
"494296", "Schwanewede\-Aschwarden",
"495184", "Freden\ Leine",
"495855", "Nahrendorf",
"4938451", "Hoppenrade\ bei\ Güstrow",
"492157", "Nettetal\-Kaldenkirchen",
"4933458", "Falkenberg\ Mark",
"495601", "Schauenburg",
"497164", "Boll\ Kreis\ Göppingen",
"495272", "Brakel\ Westfalen",
"495542", "Witzenhausen",
"49906", "Donauwörth",
"495721", "Stadthagen",
"499569", "Sesslach",
"4933746", "Werbig\ bei\ Jüterbog",
"499462", "Falkenstein\ Oberpfalz",
"497950", "Schnelldorf",
"497236", "Keltern",
"492677", "Lutzerath",
"498621", "Trostberg",
"498093", "Glonn\ Kreis\ Ebersberg",
"495455", "Tecklenburg\-Brochterbeck",
"497571", "Sigmaringen",
"496062", "Erbach\ Odenwald",
"492339", "Sprockhövel\-Hasslinghausen",
"493635", "Kölleda",
"499077", "Bachhagel",
"4938755", "Eldena",
"497452", "Nagold",
"499674", "Schönsee",
"4934956", "Zörbig",
"497483", "Horb\-Mühringen",
"496085", "Waldsolms",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"499543", "Hirschaid",
"497275", "Kandel",
"495109", "Ronnenberg",
"497545", "Immenstaad\ am\ Bodensee",
"498138", "Schwabhausen\ bei\ Dachau",
"4937423", "Adorf\ Vogtland",
"494266", "Brockel",
"495939", "Sustrum",
"4938826", "Dassow",
"497194", "Spiegelberg",
"496477", "Greifenstein\-Nenderoth",
"4936428", "Stadtroda",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;