package Daje::Sentinel::Api;
use Mojo::Base -base;

use Daje::Utils::Factory::Collection qw{load_collection};
use POSIX qw(strftime);
use Try::Tiny;

our $VERSION = '0.12';

has 'mango';

sub capture_message{ # void($source, $method, $message)
	my ($self, $source, $method, $message) = @_;

	my $classname = load_collection("Sentinel");

	my $result = try {
		return $classname->new(
			mango => $self->mango,
			query => {
				source      => $source,
				method 		=> $method,
				message     => $message,
				doc_updated => strftime ("%Y-%m-%d %H:%M:%S", localtime),
			}
		)->insert();
	} catch {
		say $_;
		return $_;
	};

	return $result;
}

1;




#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Sentinel::Api


=head1 DESCRIPTION

pod generated by Pod::Autopod - keep this line to make pod updates possible ####################


=head1 REQUIRES

L<Try::Tiny> 

L<POSIX> 

L<Daje::Utils::Factory::Collection> 

L<Mojo::Base> 


=head1 METHODS

=head2 capture_message

 capture_message($source, $method, $message);


=cut

