/* log-test.c generated by valac 0.43.6.10-d9d11, the Vala compiler
 * generated from log-test.vala, do not modify */

/* log-test.vala
 *
 * Copyright © 2012 Christian Dywan <christian@twotoasts.de>
 *
 * Based upon a C implementation (© 2010 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist.h"
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"
#include <glib-object.h>

#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	GArray* event_ids;
	GPtrArray* expected_events;
	GMainLoop* mainloop;
};

struct _Block3Data {
	int _ref_count_;
	GMainLoop* mainloop;
	GPtrArray* expected_events;
};

gint _vala_main (gchar** argv,
                 gint argv_length1);
void insert_get_delete_test (void);
static void _insert_get_delete_test_gtest_func (void);
void get_default_test (void);
static void _get_default_test_gtest_func (void);
void events_received (ZeitgeistLog* log,
                      GAsyncResult* res,
                      GPtrArray* expected_events,
                      GArray* event_ids,
                      GMainLoop* mainloop);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda6_ (Block1Data* _data1_);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
void events_inserted (ZeitgeistLog* log,
                      GAsyncResult* res,
                      GPtrArray* expected_events,
                      GMainLoop* mainloop);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_,
                 GObject* log,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
gboolean quit_main_loop (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void __lambda4_ (Block3Data* _data3_,
                 GObject* log,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static gboolean _quit_main_loop_gsource_func (gpointer self);

static void
_insert_get_delete_test_gtest_func (void)
{
#line 30 "log-test.vala"
	insert_get_delete_test ();
#line 112 "log-test.c"
}

static void
_get_default_test_gtest_func (void)
{
#line 31 "log-test.vala"
	get_default_test ();
#line 120 "log-test.c"
}

gint
_vala_main (gchar** argv,
            gint argv_length1)
{
	gint result = 0;
#line 28 "log-test.vala"
	g_test_init ((gint*) (&argv_length1), &argv, NULL);
#line 30 "log-test.vala"
	g_test_add_func ("/Log/InsertGetDelete", _insert_get_delete_test_gtest_func);
#line 31 "log-test.vala"
	g_test_add_func ("/Log/GetDefault", _get_default_test_gtest_func);
#line 33 "log-test.vala"
	result = g_test_run ();
#line 33 "log-test.vala"
	return result;
#line 138 "log-test.c"
}

int
main (int argc,
      char ** argv)
{
#line 26 "log-test.vala"
	return _vala_main (argv, argc);
#line 147 "log-test.c"
}

static gpointer
_g_main_loop_ref0 (gpointer self)
{
#line 36 "log-test.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 155 "log-test.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 36 "log-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 36 "log-test.vala"
	return _data1_;
#line 165 "log-test.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 36 "log-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 36 "log-test.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 36 "log-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 179 "log-test.c"
	}
}

static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
#line 5099 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5099 "glib-2.0.vapi"
	result = (gint) self->len;
#line 5099 "glib-2.0.vapi"
	return result;
#line 193 "log-test.c"
}

static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
#line 5100 "glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 5100 "glib-2.0.vapi"
	g_ptr_array_set_size (self, value);
#line 204 "log-test.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 54 "log-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 212 "log-test.c"
}

static void
__lambda6_ (Block1Data* _data1_)
{
#line 62 "log-test.vala"
	g_main_loop_quit (_data1_->mainloop);
#line 220 "log-test.c"
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 62 "log-test.vala"
	__lambda6_ (self);
#line 62 "log-test.vala"
	block1_data_unref (self);
#line 232 "log-test.c"
}

void
events_received (ZeitgeistLog* log,
                 GAsyncResult* res,
                 GPtrArray* expected_events,
                 GArray* event_ids,
                 GMainLoop* mainloop)
{
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	ZeitgeistResultSet* events = NULL;
	gint _tmp6_;
	gint _tmp7_;
	ZeitgeistResultSet* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 36 "log-test.vala"
	g_return_if_fail (log != NULL);
#line 36 "log-test.vala"
	g_return_if_fail (res != NULL);
#line 36 "log-test.vala"
	g_return_if_fail (expected_events != NULL);
#line 36 "log-test.vala"
	g_return_if_fail (event_ids != NULL);
#line 36 "log-test.vala"
	g_return_if_fail (mainloop != NULL);
#line 36 "log-test.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 36 "log-test.vala"
	_data1_->_ref_count_ = 1;
#line 36 "log-test.vala"
	_tmp0_ = _g_main_loop_ref0 (mainloop);
#line 36 "log-test.vala"
	_g_main_loop_unref0 (_data1_->mainloop);
#line 36 "log-test.vala"
	_data1_->mainloop = _tmp0_;
#line 269 "log-test.c"
	{
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistResultSet* _tmp2_;
		ZeitgeistResultSet* _tmp3_;
#line 43 "log-test.vala"
		_tmp2_ = zeitgeist_log_get_events_finish (log, res, &_inner_error0_);
#line 43 "log-test.vala"
		_tmp1_ = _tmp2_;
#line 43 "log-test.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 280 "log-test.c"
			goto __catch0_g_error;
		}
#line 43 "log-test.vala"
		_tmp3_ = _tmp1_;
#line 43 "log-test.vala"
		_tmp1_ = NULL;
#line 43 "log-test.vala"
		_g_object_unref0 (events);
#line 43 "log-test.vala"
		events = _tmp3_;
#line 42 "log-test.vala"
		_g_object_unref0 (_tmp1_);
#line 293 "log-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 42 "log-test.vala"
		_error_ = _inner_error0_;
#line 42 "log-test.vala"
		_inner_error0_ = NULL;
#line 46 "log-test.vala"
		_tmp4_ = _error_;
#line 46 "log-test.vala"
		_tmp5_ = _tmp4_->message;
#line 46 "log-test.vala"
		g_critical ("log-test.vala:46: Failed to get events: %s", _tmp5_);
#line 47 "log-test.vala"
		_g_error_free0 (_error_);
#line 47 "log-test.vala"
		_g_object_unref0 (events);
#line 47 "log-test.vala"
		block1_data_unref (_data1_);
#line 47 "log-test.vala"
		_data1_ = NULL;
#line 47 "log-test.vala"
		return;
#line 321 "log-test.c"
	}
	__finally0:
#line 42 "log-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 42 "log-test.vala"
		_g_object_unref0 (events);
#line 42 "log-test.vala"
		block1_data_unref (_data1_);
#line 42 "log-test.vala"
		_data1_ = NULL;
#line 42 "log-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 42 "log-test.vala"
		g_clear_error (&_inner_error0_);
#line 42 "log-test.vala"
		return;
#line 338 "log-test.c"
	}
#line 51 "log-test.vala"
	_tmp6_ = g_ptr_array_get_length (expected_events);
#line 51 "log-test.vala"
	_tmp7_ = _tmp6_;
#line 51 "log-test.vala"
	_tmp8_ = events;
#line 51 "log-test.vala"
	_vala_assert (((guint) _tmp7_) == zeitgeist_result_set_size (_tmp8_), "expected_events.length == events.size()");
#line 348 "log-test.c"
	{
		gint i = 0;
#line 52 "log-test.vala"
		i = 0;
#line 353 "log-test.c"
		{
			gboolean _tmp9_ = FALSE;
#line 52 "log-test.vala"
			_tmp9_ = TRUE;
#line 52 "log-test.vala"
			while (TRUE) {
#line 360 "log-test.c"
				ZeitgeistResultSet* _tmp10_;
				ZeitgeistEvent* exp_event = NULL;
				gconstpointer _tmp11_;
				ZeitgeistEvent* _tmp12_;
				ZeitgeistEvent* event = NULL;
				ZeitgeistResultSet* _tmp13_;
				ZeitgeistEvent* _tmp14_;
				ZeitgeistEvent* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				ZeitgeistEvent* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				ZeitgeistEvent* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				ZeitgeistEvent* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ZeitgeistEvent* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ZeitgeistEvent* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				ZeitgeistEvent* _tmp33_;
				ZeitgeistEvent* _tmp34_;
#line 52 "log-test.vala"
				if (!_tmp9_) {
#line 52 "log-test.vala"
					i = i + 1;
#line 392 "log-test.c"
				}
#line 52 "log-test.vala"
				_tmp9_ = FALSE;
#line 52 "log-test.vala"
				_tmp10_ = events;
#line 52 "log-test.vala"
				if (!(((guint) i) < zeitgeist_result_set_size (_tmp10_))) {
#line 52 "log-test.vala"
					break;
#line 402 "log-test.c"
				}
#line 54 "log-test.vala"
				_tmp11_ = g_ptr_array_index (expected_events, (guint) i);
#line 54 "log-test.vala"
				_tmp12_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp11_);
#line 54 "log-test.vala"
				exp_event = _tmp12_;
#line 55 "log-test.vala"
				_tmp13_ = events;
#line 55 "log-test.vala"
				_tmp14_ = zeitgeist_result_set_next_value (_tmp13_);
#line 55 "log-test.vala"
				event = _tmp14_;
#line 56 "log-test.vala"
				_tmp15_ = event;
#line 56 "log-test.vala"
				_tmp16_ = zeitgeist_event_get_interpretation (_tmp15_);
#line 56 "log-test.vala"
				_tmp17_ = _tmp16_;
#line 56 "log-test.vala"
				_tmp18_ = exp_event;
#line 56 "log-test.vala"
				_tmp19_ = zeitgeist_event_get_interpretation (_tmp18_);
#line 56 "log-test.vala"
				_tmp20_ = _tmp19_;
#line 56 "log-test.vala"
				_vala_assert (g_strcmp0 (_tmp17_, _tmp20_) == 0, "event.interpretation == exp_event.interpretation");
#line 57 "log-test.vala"
				_tmp21_ = event;
#line 57 "log-test.vala"
				_tmp22_ = zeitgeist_event_get_manifestation (_tmp21_);
#line 57 "log-test.vala"
				_tmp23_ = _tmp22_;
#line 57 "log-test.vala"
				_tmp24_ = exp_event;
#line 57 "log-test.vala"
				_tmp25_ = zeitgeist_event_get_manifestation (_tmp24_);
#line 57 "log-test.vala"
				_tmp26_ = _tmp25_;
#line 57 "log-test.vala"
				_vala_assert (g_strcmp0 (_tmp23_, _tmp26_) == 0, "event.manifestation == exp_event.manifestation");
#line 58 "log-test.vala"
				_tmp27_ = event;
#line 58 "log-test.vala"
				_tmp28_ = zeitgeist_event_get_actor (_tmp27_);
#line 58 "log-test.vala"
				_tmp29_ = _tmp28_;
#line 58 "log-test.vala"
				_tmp30_ = exp_event;
#line 58 "log-test.vala"
				_tmp31_ = zeitgeist_event_get_actor (_tmp30_);
#line 58 "log-test.vala"
				_tmp32_ = _tmp31_;
#line 58 "log-test.vala"
				_vala_assert (g_strcmp0 (_tmp29_, _tmp32_) == 0, "event.actor == exp_event.actor");
#line 59 "log-test.vala"
				_tmp33_ = event;
#line 59 "log-test.vala"
				_tmp34_ = exp_event;
#line 59 "log-test.vala"
				_vala_assert (zeitgeist_event_num_subjects (_tmp33_) == zeitgeist_event_num_subjects (_tmp34_), "event.num_subjects () == exp_event.num_subjects ()");
#line 52 "log-test.vala"
				_g_object_unref0 (event);
#line 52 "log-test.vala"
				_g_object_unref0 (exp_event);
#line 468 "log-test.c"
			}
		}
	}
#line 62 "log-test.vala"
	zeitgeist_log_delete_events (log, event_ids, NULL, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 36 "log-test.vala"
	_g_object_unref0 (events);
#line 36 "log-test.vala"
	block1_data_unref (_data1_);
#line 36 "log-test.vala"
	_data1_ = NULL;
#line 480 "log-test.c"
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
#line 65 "log-test.vala"
	return self ? g_ptr_array_ref (self) : NULL;
#line 488 "log-test.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 65 "log-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 65 "log-test.vala"
	return _data2_;
#line 498 "log-test.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 65 "log-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 65 "log-test.vala"
		_g_array_unref0 (_data2_->event_ids);
#line 65 "log-test.vala"
		_g_ptr_array_unref0 (_data2_->expected_events);
#line 65 "log-test.vala"
		_g_main_loop_unref0 (_data2_->mainloop);
#line 65 "log-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 516 "log-test.c"
	}
}

static void
__lambda5_ (Block2Data* _data2_,
            GObject* log,
            GAsyncResult* res)
{
	GArray* _tmp0_;
#line 80 "log-test.vala"
	g_return_if_fail (res != NULL);
#line 81 "log-test.vala"
	_tmp0_ = _data2_->event_ids;
#line 81 "log-test.vala"
	events_received (G_TYPE_CHECK_INSTANCE_CAST (log, ZEITGEIST_TYPE_LOG, ZeitgeistLog), res, _data2_->expected_events, _tmp0_, _data2_->mainloop);
#line 532 "log-test.c"
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 80 "log-test.vala"
	__lambda5_ (self, source_object, res);
#line 80 "log-test.vala"
	block2_data_unref (self);
#line 544 "log-test.c"
}

void
events_inserted (ZeitgeistLog* log,
                 GAsyncResult* res,
                 GPtrArray* expected_events,
                 GMainLoop* mainloop)
{
	Block2Data* _data2_;
	GPtrArray* _tmp0_;
	GMainLoop* _tmp1_;
	gint _tmp7_;
	gint _tmp8_;
	GArray* _tmp9_;
	GArray* _tmp10_;
	GError* _inner_error0_ = NULL;
#line 65 "log-test.vala"
	g_return_if_fail (log != NULL);
#line 65 "log-test.vala"
	g_return_if_fail (res != NULL);
#line 65 "log-test.vala"
	g_return_if_fail (expected_events != NULL);
#line 65 "log-test.vala"
	g_return_if_fail (mainloop != NULL);
#line 65 "log-test.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 65 "log-test.vala"
	_data2_->_ref_count_ = 1;
#line 65 "log-test.vala"
	_tmp0_ = _g_ptr_array_ref0 (expected_events);
#line 65 "log-test.vala"
	_g_ptr_array_unref0 (_data2_->expected_events);
#line 65 "log-test.vala"
	_data2_->expected_events = _tmp0_;
#line 65 "log-test.vala"
	_tmp1_ = _g_main_loop_ref0 (mainloop);
#line 65 "log-test.vala"
	_g_main_loop_unref0 (_data2_->mainloop);
#line 65 "log-test.vala"
	_data2_->mainloop = _tmp1_;
#line 585 "log-test.c"
	{
		GArray* _tmp2_ = NULL;
		GArray* _tmp3_;
		GArray* _tmp4_;
#line 72 "log-test.vala"
		_tmp3_ = zeitgeist_log_insert_events_finish (log, res, &_inner_error0_);
#line 72 "log-test.vala"
		_tmp2_ = _tmp3_;
#line 72 "log-test.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 596 "log-test.c"
			goto __catch1_g_error;
		}
#line 72 "log-test.vala"
		_tmp4_ = _tmp2_;
#line 72 "log-test.vala"
		_tmp2_ = NULL;
#line 72 "log-test.vala"
		_g_array_unref0 (_data2_->event_ids);
#line 72 "log-test.vala"
		_data2_->event_ids = _tmp4_;
#line 71 "log-test.vala"
		_g_array_unref0 (_tmp2_);
#line 609 "log-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 71 "log-test.vala"
		_error_ = _inner_error0_;
#line 71 "log-test.vala"
		_inner_error0_ = NULL;
#line 75 "log-test.vala"
		_tmp5_ = _error_;
#line 75 "log-test.vala"
		_tmp6_ = _tmp5_->message;
#line 75 "log-test.vala"
		g_critical ("log-test.vala:75: Failed to insert events: %s", _tmp6_);
#line 76 "log-test.vala"
		_g_error_free0 (_error_);
#line 76 "log-test.vala"
		block2_data_unref (_data2_);
#line 76 "log-test.vala"
		_data2_ = NULL;
#line 76 "log-test.vala"
		return;
#line 635 "log-test.c"
	}
	__finally1:
#line 71 "log-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 71 "log-test.vala"
		block2_data_unref (_data2_);
#line 71 "log-test.vala"
		_data2_ = NULL;
#line 71 "log-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 71 "log-test.vala"
		g_clear_error (&_inner_error0_);
#line 71 "log-test.vala"
		return;
#line 650 "log-test.c"
	}
#line 78 "log-test.vala"
	_tmp7_ = g_ptr_array_get_length (_data2_->expected_events);
#line 78 "log-test.vala"
	_tmp8_ = _tmp7_;
#line 78 "log-test.vala"
	_tmp9_ = _data2_->event_ids;
#line 78 "log-test.vala"
	_vala_assert (((guint) _tmp8_) == _tmp9_->len, "expected_events.length == event_ids.length");
#line 80 "log-test.vala"
	_tmp10_ = _data2_->event_ids;
#line 80 "log-test.vala"
	zeitgeist_log_get_events (log, _tmp10_, NULL, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
#line 65 "log-test.vala"
	block2_data_unref (_data2_);
#line 65 "log-test.vala"
	_data2_ = NULL;
#line 668 "log-test.c"
}

gboolean
quit_main_loop (void)
{
	gboolean result = FALSE;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GMainLoop* _tmp2_;
#line 87 "log-test.vala"
	_tmp0_ = g_main_context_default ();
#line 87 "log-test.vala"
	_tmp1_ = g_main_loop_new (_tmp0_, FALSE);
#line 87 "log-test.vala"
	_tmp2_ = _tmp1_;
#line 87 "log-test.vala"
	g_main_loop_quit (_tmp2_);
#line 87 "log-test.vala"
	_g_main_loop_unref0 (_tmp2_);
#line 88 "log-test.vala"
	result = FALSE;
#line 88 "log-test.vala"
	return result;
#line 692 "log-test.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 91 "log-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 91 "log-test.vala"
	return _data3_;
#line 702 "log-test.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 91 "log-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 91 "log-test.vala"
		_g_ptr_array_unref0 (_data3_->expected_events);
#line 91 "log-test.vala"
		_g_main_loop_unref0 (_data3_->mainloop);
#line 91 "log-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 718 "log-test.c"
	}
}

static void
_g_object_unref0_ (gpointer var)
{
#line 94 "log-test.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 727 "log-test.c"
}

static void
__lambda4_ (Block3Data* _data3_,
            GObject* log,
            GAsyncResult* res)
{
#line 113 "log-test.vala"
	g_return_if_fail (res != NULL);
#line 114 "log-test.vala"
	events_inserted (G_TYPE_CHECK_INSTANCE_CAST (log, ZEITGEIST_TYPE_LOG, ZeitgeistLog), res, _data3_->expected_events, _data3_->mainloop);
#line 739 "log-test.c"
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 112 "log-test.vala"
	__lambda4_ (self, source_object, res);
#line 112 "log-test.vala"
	block3_data_unref (self);
#line 751 "log-test.c"
}

static gboolean
_quit_main_loop_gsource_func (gpointer self)
{
	gboolean result;
	result = quit_main_loop ();
#line 118 "log-test.vala"
	return result;
#line 761 "log-test.c"
}

void
insert_get_delete_test (void)
{
	Block3Data* _data3_;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GPtrArray* _tmp2_;
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistSubject* su = NULL;
	ZeitgeistSubject* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistLog* _tmp6_;
	ZeitgeistLog* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 91 "log-test.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 91 "log-test.vala"
	_data3_->_ref_count_ = 1;
#line 93 "log-test.vala"
	_tmp0_ = g_main_context_default ();
#line 93 "log-test.vala"
	_tmp1_ = g_main_loop_new (_tmp0_, FALSE);
#line 93 "log-test.vala"
	_data3_->mainloop = _tmp1_;
#line 94 "log-test.vala"
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 94 "log-test.vala"
	_data3_->expected_events = _tmp2_;
#line 95 "log-test.vala"
	_tmp3_ = zeitgeist_event_new ();
#line 95 "log-test.vala"
	ev = _tmp3_;
#line 96 "log-test.vala"
	_tmp4_ = zeitgeist_subject_new ();
#line 96 "log-test.vala"
	su = _tmp4_;
#line 97 "log-test.vala"
	zeitgeist_event_add_subject (ev, su);
#line 98 "log-test.vala"
	_tmp5_ = _g_object_ref0 (ev);
#line 98 "log-test.vala"
	g_ptr_array_add (_data3_->expected_events, _tmp5_);
#line 99 "log-test.vala"
	zeitgeist_event_set_interpretation (ev, "foo://Interp");
#line 100 "log-test.vala"
	zeitgeist_event_set_manifestation (ev, "foo://Manif");
#line 101 "log-test.vala"
	zeitgeist_event_set_actor (ev, "app://firefox.desktop");
#line 103 "log-test.vala"
	zeitgeist_subject_set_uri (su, "file:///tmp/bar.txt");
#line 104 "log-test.vala"
	zeitgeist_subject_set_interpretation (su, "foo://TextDoc");
#line 105 "log-test.vala"
	zeitgeist_subject_set_manifestation (su, "foo://File");
#line 106 "log-test.vala"
	zeitgeist_subject_set_mimetype (su, "text/plain");
#line 107 "log-test.vala"
	zeitgeist_subject_set_origin (su, "file:///tmp");
#line 108 "log-test.vala"
	zeitgeist_subject_set_text (su, "bar.txt");
#line 109 "log-test.vala"
	zeitgeist_subject_set_storage (su, "bfb486f6-f5f8-4296-8871-0cc749cf8ef7");
#line 112 "log-test.vala"
	_tmp6_ = zeitgeist_log_get_default ();
#line 112 "log-test.vala"
	_tmp7_ = _tmp6_;
#line 112 "log-test.vala"
	zeitgeist_log_insert_events (_tmp7_, _data3_->expected_events, NULL, ___lambda4__gasync_ready_callback, block3_data_ref (_data3_));
#line 112 "log-test.vala"
	_g_object_unref0 (_tmp7_);
#line 116 "log-test.vala"
	_tmp8_ = g_ptr_array_get_length (_data3_->expected_events);
#line 116 "log-test.vala"
	_tmp9_ = _tmp8_;
#line 116 "log-test.vala"
	_vala_assert (_tmp9_ == 1, "expected_events.length == 1");
#line 118 "log-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _quit_main_loop_gsource_func, NULL, NULL);
#line 119 "log-test.vala"
	g_main_loop_run (_data3_->mainloop);
#line 91 "log-test.vala"
	_g_object_unref0 (su);
#line 91 "log-test.vala"
	_g_object_unref0 (ev);
#line 91 "log-test.vala"
	block3_data_unref (_data3_);
#line 91 "log-test.vala"
	_data3_ = NULL;
#line 854 "log-test.c"
}

void
get_default_test (void)
{
	ZeitgeistLog* log1 = NULL;
	ZeitgeistLog* _tmp0_;
	ZeitgeistLog* log2 = NULL;
	ZeitgeistLog* _tmp1_;
#line 124 "log-test.vala"
	_tmp0_ = zeitgeist_log_get_default ();
#line 124 "log-test.vala"
	log1 = _tmp0_;
#line 125 "log-test.vala"
	_tmp1_ = zeitgeist_log_get_default ();
#line 125 "log-test.vala"
	log2 = _tmp1_;
#line 126 "log-test.vala"
	_vala_assert (log1 == log2, "log1 == log2");
#line 122 "log-test.vala"
	_g_object_unref0 (log2);
#line 122 "log-test.vala"
	_g_object_unref0 (log1);
#line 878 "log-test.c"
}

