#! /bin/sh
#
# hyphenex.sh
#
# This small filter converts a hyphenation exception log article for
# TUGBoat to a real \hyphenation block.
#
# Written by Werner Lemberg <wl@gnu.org>.
#
# Version 1.5 (2008/05/20)
#
# Public domain.
#
#
# Usage:
#   sh hyphenex.sh < tugboat-article > hyphenation-exceptions

cat >/tmp/sed.$$ <<SED_EOF
1 i\\
% Hyphenation exceptions for US English,\\
% based on hyphenation exception log articles in TUGboat.\\
%\\
% Copyright 2021 TeX Users Group.\\
% You may freely use, modify and/or distribute this file.\\
%\\
% This is an automatically generated file.  Do not edit!\\
%\\
% Please contact the TUGboat editorial staff <tugboat@tug.org>\\
% for corrections and omissions.\\
\\
\\\\hyphenation{
\$ i\\
}\\
\\
% EOF
/^\\\\tabalign/ {
  s/{}//g
  s/[ 	][ 	]*/ /g
  s/ *\\\\[^ ][^ ]*\$//
  s/\\\\tabalign *[^ ][^ ]*.*& *\\(.*\\)\$/  \\1/p
  b
}
/^\\\\[123456]/ !d
s/\\\\4/\\\\1/
s/\\\\5/\\\\2/
s/\\\\6/\\\\3/
s/[ 	][ 	]*/ /g
s/^/  /
s/\\\\1 [^ ][^ ]* {\\(.*\\)}\$/\\1/
s/\\\\2 [^ ][^ ]* {\\(.*\\) \\(.*\\),\\(.*\\),\\(.*\\)}\$/\\1\\n  \\1\\2\\n  \\1\\3\\n  \\1\\4/
s/\\\\2 [^ ][^ ]* {\\(.*\\) \\(.*\\),\\(.*\\)}\$/\\1\\n  \\1\\2\\n  \\1\\3/
s/\\\\2 [^ ][^ ]* {\\(.*\\) \\(.*\\)}\$/\\1\\n  \\1\\2/
s/\\\\3 [^ ][^ ]* {\\(.*\\) \\(.*\\) \\(.*\\)}\$/\\1\\2\\n  \\1\\3/
s/\\\\1 [^ ][^ ]* {\\(.*\\)} .*\$/\\1/
s/\\\\2 [^ ][^ ]* {\\(.*\\) \\(.*\\),\\(.*\\),\\(.*\\)} .*\$/\\1\\n  \\1\\2\\n  \\1\\3\\n  \\1\\4/
s/\\\\2 [^ ][^ ]* {\\(.*\\) \\(.*\\),\\(.*\\)} .*\$/\\1\\n  \\1\\2\\n  \\1\\3/
s/\\\\2 [^ ][^ ]* {\\(.*\\) \\(.*\\)} .*\$/\\1\\n  \\1\\2/
s/\\\\3 [^ ][^ ]* {\\(.*\\) \\(.*\\) \\(.*\\)} .*\$/\\1\\2\\n  \\1\\3/
s/\\\\1 {.*} {\\(.*\\)}\$/\\1/
s/\\\\2 {.*} {\\(.*\\) \\(.*\\),\\(.*\\),\\(.*\\)}\$/\\1\\n  \\1\\2\\n  \\1\\3\\n  \\1\\4/
s/\\\\2 {.*} {\\(.*\\) \\(.*\\),\\(.*\\)}\$/\\1\\n  \\1\\2\\n  \\1\\3/
s/\\\\2 {.*} {\\(.*\\) \\(.*\\)}\$/\\1\\n  \\1\\2/
s/\\\\3 {.*} {\\(.*\\) \\(.*\\) \\(.*\\)}\$/\\1\\2\\n  \\1\\3/
s/\\\\1 {.*} {\\(.*\\)} .*\$/\\1/
s/\\\\2 {.*} {\\(.*\\) \\(.*\\),\\(.*\\),\\(.*\\)} .*\$/\\1\\n  \\1\\2\\n  \\1\\3\\n  \\1\\4/
s/\\\\2 {.*} {\\(.*\\) \\(.*\\),\\(.*\\)} .*\$/\\1\\n  \\1\\2\\n  \\1\\3/
s/\\\\2 {.*} {\\(.*\\) \\(.*\\)} .*\$/\\1\\n  \\1\\2/
s/\\\\3 {.*} {\\(.*\\) \\(.*\\) \\(.*\\)} .*\$/\\1\\2\\n  \\1\\3/
s/\\\\1 [^ ][^ ]* \\([^ ][^ ]*\\)\$/\\1/
s/\\\\2 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\),\\([^ ][^ ]*\\),\\([^ ][^ ]*\\)\$/\\1\\n  \\1\\2\\n  \\1\\3\\n  \\1\\4/
s/\\\\2 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\),\\([^ ][^ ]*\\)\$/\\1\\n  \\1\\2\\n  \\1\\3/
s/\\\\2 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\)\$/\\1\\n  \\1\\2/
s/\\\\3 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\) \\([^ ][^ ]*\\)\$/\\1\\2\\n  \\1\\3/
s/\\\\1 [^ ][^ ]* \\([^ ][^ ]*\\) .*\$/\\1/
s/\\\\2 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\),\\([^ ][^ ]*\\),\\([^ ][^ ]*\\) .*\$/\\1\\n  \\1\\2\\n  \\1\\3\\n  \\1\\4/
s/\\\\2 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\),\\([^ ][^ ]*\\) .*\$/\\1\\n  \\1\\2\\n  \\1\\3/
s/\\\\2 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\) .*\$/\\1\\n  \\1\\2/
s/\\\\3 [^ ][^ ]* \\([^ ][^ ]*\\) \\([^ ][^ ]*\\) \\([^ ][^ ]*\\) .*\$/\\1\\2\\n  \\1\\3/
s/\\*//
s/\\\\llap *{\\(.*\\)}/\\1/
s/\\\\[^ ]* //
s/\\\\[^ ][^ ]*\$//
s/{.*}//
p
SED_EOF

sed -n -f /tmp/sed.$$
rm /tmp/sed.$$

# EOF
