C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBTMX,SSI=0
                        SUBROUTINE MOBTMX
C                       *****************
C
C      ----------------------------------
     * (NBCOUS,NBICOR,NCBORS,NCOUPS,NUMA)
C      ----------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C     SOLIDES EN TRANSLATION : DETERMINER SI ON EST AU MAXIMUM DE LA   *
C                              TRANSLATION                             *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NBCOUS   !  E ! D  ! Nombre de noeuds solides couples             !
C !  NBICOR   !  E ! D  ! Nombre d'infos pour les correspondants       !
C !  NCBORS   ! TE ! D  ! Tableau  des correspondants                  !
C !  NCOUPS   ! TE ! D  ! Numeros globaux des noeuds solides couples   !
C !  NUMA     !  E ! R  ! Numero du maillage a decaler                 !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "mobil.h"
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NBCOUS,NBICOR,NCBORS(NBCOUS,NBICOR),NCOUPS(NBCOUS),NUMA
C
C.. Variables internes
      INTEGER N,N1,N2
C***********************************************************************
C
C
C     0- INITIALISATIONS
C     ==================
C
      NUMA = 0
      N1 = 0
      N2 = 0 
C
C     1- COMPTE DES NOEUDS QUI N'ONT PAS DE CORRESPONDANT
C     ===================================================
C
      DO 100 N=1,NBCOUS
C
        IF (NCBORS(N,1).EQ.-1) THEN
          IF (NCOUPS(N).LE.NBNMA1) THEN
            N1 = N1 + 1
          ELSE
            N2 = N2 + 1
          ENDIF
        ENDIF
C
  100 CONTINUE
C
C     2- MISE A JOUR DU MAILLAGE A DEPLACER
C     =====================================
C
      IF (N1 .EQ. NBCOUS/2) THEN
        NUMA = 1
      ELSEIF (N2 .EQ. NBCOUS/2) THEN
        NUMA = 2
      ELSE
        NUMA = 0
      ENDIF
C
C
C     3- IMPRESSIONS
C     ==============
      IF (NUMA .NE.0 .AND. NBLBLA.GE.2) THEN
        WRITE(NFECRA,3000) NUMA
      ENDIF
C
C--------
C FORMATS
C--------
 3000 FORMAT(' *** MOBTMX : Translation du maillage ',I1)
C
      RETURN
      END
