C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LIMFSO
C                       *****************
C
C      ------------------------------------------------------------
     * (NDIM,NPOINS,NELEMS,NDMATS,NREFS,COORDS,NODES,TMPSA,TMPS,
     *  NELEUS,NDMASS,NODEUS,NREFAL,
     *  NBFFLU,NFFLUS,VFFLUS,NBDIRS,NDIRS,VDIRS,NBFECH,NFECHS,VFECHS,
     *  NBFRAI,NFRAIS,VFRAIS,NELERC,NFRESC,VFRESC)
C      ------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            INITIALISATION DES CONDITIONS AUX LIMITES SUR LE SOLIDE   *
C            (Sous-programme utilisateur)                              *
C                                                                      *
C ATTENTION :                                                          *
C ===========                                                          *
C            A l'aide de ce sous programme, il est possible d'imposer  *
C            les conditions limites sur les faces, ce qui permet un    *
C            "meilleur" traitement des conditions limites discontinues.*
C            Le cas typique ou ce traitement peut avoir un interet est *
C            par exemple celui du coin affecte par des conditions aux  *
C            limites de type differentes sur chaque face, auquel cas,  *
C            le point de coin peut etre considere comme singulier.     *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     ! TE ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   ! TE ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   ! TE ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE SOLIDE         !
C !  NDMATS   ! TE ! D  ! NOMBRE DE NOEUDS PAR ELEMENT                 !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS SOLIDES               !
C !  NODES    ! TE ! D  ! CONNECTIVITE DU MAILLAGE SOLIDE              !
C !  TMPSA    ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  TMPS     ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  NFFLUS   ! TE ! D  ! No local de la face affecte par des flux     !
C !  VFFLUS   ! TR ! R  ! Valeur du flux aux points de la facette      !
C !  NBFFLU   ! E  ! R  ! Nombre de facettes de type flux              !
C !  NFECHS   ! TE ! D  ! No local de la facette avec  c.l. d'echange  ! 
C !  VFECHS   ! TR ! R  ! Valeur aux noeud de la face de type echange  !
C !           !    !    !    VFECHS(.,..,1) = temperature exterieure   !
C !           !    !    !    VFECHS(.,..,2) = coefficient d'echange    !
C !  NBFECH   ! E  ! D  ! Nombre de facette de type echange            !
C !  NFRAIS   ! TE ! D  ! No des facettes avec rayonnement infi        ! 
C !  VFRAIS   ! TR ! R  ! Valeurs aux noeuds des faces de type         !
C !           !    !    ! rayonnement infi.                            !
C !           !    !    !    VFRAIS(.,..,1) = temp exterieure equival  !
C !           !    !    !    VFRAIS(.,..,2) = coef d'echange equival   !
C !  NBFRAI   ! E  ! D  ! Nombre de facette de type rayonnement inf    !
C !  NFRESC   ! TE ! D  ! No des facettes avec resistance de contact   ! 
C !  VFRESC   ! TR ! R  ! Valeurs des resistances aux noeuds de la face!
C !  NELERC   ! E  ! D  ! Nombre de facette de type resistance         !
C !  NDIRS    ! TE ! D  ! NUMERO DES NOEUDS PORTANT UNE C.L. DIRICHLET !
C !  VDIRS    ! TR ! R  ! VALEUR DE LA CONDITION DE TYPE  DIRICHLET    !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "divct.h"
#include "syrthu.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NELEMS,NDMATS,NDMASS
      INTEGER NBFFLU,NBDIRS,NBFECH,NELERC,NBFRAI,NELEUS
      INTEGER NODEUS(NELEUS,NDMASS)
      INTEGER NREFS(NPOINS),NODES(NELEMS,NDMATS),NREFAL(NELEUS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM),TMPS(NPOINS),TMPSA(NPOINS)
      INTEGER NFFLUS(NBFFLU),NDIRS(NBDIRS),NFECHS(NBFECH)
      INTEGER NFRESC(NELERC),NFRAIS(NBFRAI)
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS),VDIRS(NBDIRS)
      DOUBLE PRECISION VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
C
C.. Variables internes
      INTEGER N,J,NUMFA,NUMREF,NNGLOB
      DOUBLE PRECISION T,XX,YY,ZZ,TT1,TT2
C
      LOGICAL LVERIF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
C
C***********************************************************************
C
C     INTERVENTION UTILISATEUR A PARTIR DE CETTE LIGNE 
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
C     Pour stopper l'execution proprement en cas de probleme
C     mettre LSTOPS a "TRUE" dans vos tests
C     LSTOPS = .FALSE.
C
C     =========================================================
C     2- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE FLUX
C     =========================================================
C 
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C
C     Exemple ...
C      
CUTI  DO N=1,NBFFLU
C
C        Numero global de la facette de bord
CUTI     NUMFA = NFFLUS(N)
C
C        References de la facette de bord
CUTI     NUMREF = NREFAL(NUMFA)
C
C        Il y a NDMASS noeuds par facette de bords
C        6 en 3D et en modele coque, 3 en 2D
C
CUTI     DO J=1,NDMASS
C
C           Coordonnees des noeuds sur la facette de bord
CUTI        NNGLOB = NODEUS(NUMFA,J)
CUTI        XX = COORDS(NNGLOB,1)
CUTI        YY = COORDS(NNGLOB,2)
CUTI        IF(NDIM.EQ.3) ZZ = COORDS(NNGLOB,3)
C
C           TT1 = Temperature au noeud courant
CUTI        TT1 = TMPS(NNGLOB)
C
C           Si la face porte la reference 3, le flux sur les neuds de
C           la face vaut 1000 W/M2
C           sinon, il vaut 10000 W/M2
C
CUTI        IF (NUMREF.EQ.3) THEN
CUTI           VFFLUS(N,J) = 1000.0D0
CUTI        ELSE
CUTI           VFLUSS(N,J) = 10000.0D0
CUTI        ENDIF
C
CUTI     ENDDO
C
CUTI  ENDDO
C
C     ==============================================================
C     3- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE DIRICHLET
C     ==============================================================
C
C     Exemple ...
C
CUTI  DO N=1,NBDIRS
C
C        On rappelle que les conditions de Dirichlet affecte des noeuds
C        et non pas des faces.
C
C        Numero global du noeud
CUTI     NUMNO = NDIRS(N)
C
C        References du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF(NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C
C        Si le noeud porte la reference 3, le dirichlet vaut 2 sinon 3
C
CUTI     IF (NUMREF.EQ.3) THEN
CUTI        VDIRS(N) = 2.0D0
CUTI     ELSE
CUTI        VDIRS(N) = 3.0D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C
C     ====================================================
C     4- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE 
C        COEFFICIENT D'ECHANGE
C     ====================================================
C
C     Exemple ...
C
CUTI  DO N=1,NBFECH
C
C        Numero global de la facette de bord
CUTI     NUMFA = NFECHS(N)
C
C        References de la facette de bord
CUTI     NUMREF = NREFAL(NUMFA)
C
C        Il y a NDMASS noeuds par facette de bords
C        6 en 3D et en modele coque, 3 en 2D
CUTI     DO J=1,NDMASS
C
C           Coordonnees des noeuds sur la facette de bord
CUTI        NNGLOB = NODEUS(NUMFA,J)
CUTI        XX = COORDS(NNGLOB,1)
CUTI        YY = COORDS(NNGLOB,2)
CUTI        IF(NDIM.EQ.3) ZZ = COORDS(NNGLOB,3)
C
C           Si le noeud porte la reference 6, la temperature exterieure
C           est de 20 et le coefficient d'echange de 10,
C           sinon, la temperature exterieure est de 40 C
C
CUTI        IF (NUMREF.EQ.6) THEN        
CUTI           VFECHS(N,J,1) = 20.0D0
CUTI           VFECHS(N,J,2) = 10.0D0
CUTI        ELSE
CUTI           VFECHS(N,J,1) = 40.0D0
CUTI           VFECHS(N,J,2) = 10.0D0
CUTI        ENDIF
C
CUTI     ENDDO
C
CUTI  ENDDO
C
C
C
C     ====================================================
C     5- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE 
C        RESISTANCE DE CONTACT
C     ====================================================
C     Il s'agit d'initialiser la resistance de contact
C
C     Exemple ...
C
CUTI  DO N=1,NELERC
C
C        Numero global de la facette de bord
CUTI     NUMFA = NFRESC(N)
C
C        References de la facette de bord
CUTI     NUMREF = NREFAL(NUMFA)
C
C        Il y a NDMASS noeuds par facette de bords
C        6 en 3D et en modele coque, 3 en 2D
CUTI     DO J=1,NDMASS
C
C           Coordonnees des noeuds sur la facette de bord
CUTI        NNGLOB = NODEUS(NUMFA,J)
CUTI        XX = COORDS(NNGLOB,1)
CUTI        YY = COORDS(NNGLOB,2)
CUTI        IF(NDIM.EQ.3) ZZ = COORDS(NNGLOB,3)
C
C
C           Si le noeud porte la reference 4 on a une resistance
C           de contact de 100. sinon de 1. (mauvaise transmission)
C      
C
CUTI        IF (NUMREF.EQ.4) THEN        
CUTI           VFRESC(N,J,2) = 100.0D0
CUTI        ELSE
CUTI           VFRESC(N,J,2) = 1.0D0
CUTI        ENDIF
C
CUTI    ENDDO
C
CUTI  ENDDO
C
C     ====================================================
C     4- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE 
C        COEFFICIENT D'ECHANGE
C     ====================================================
C
C     Exemple ...
C
CUTI  DO N=1,NBFRAI
C
C        Numero global de la facette de bord
CUTI     NUMFA = NFRAIS(N)
C
C        References de la facette de bord
CUTI     NUMREF = NREFAL(NUMFA)
C
C        Il y a NDMASS noeuds par facette de bords
C        6 en 3D et en modele coque, 3 en 2D
CUTI     DO J=1,NDMASS
C
C           Coordonnees des noeuds sur la facette de bord
CUTI        NNGLOB = NODEUS(NUMFA,J)
CUTI        XX = COORDS(NNGLOB,1)
CUTI        YY = COORDS(NNGLOB,2)
CUTI        IF(NDIM.EQ.3) ZZ = COORDS(NNGLOB,3)
C
C           Si le noeud porte la reference 6, la temperature exterieure
C           est de 20 C et l'emissivite de 0.8,
C           sinon, la temperature exterieure est de 10 C et epsilon 0.9
C
CUTI        IF (NUMREF.EQ.6) THEN        
CUTI           VFRAIS(N,J,1) = 20.0D0
CUTI           VFRAIS(N,J,2) = 0.8D0
CUTI        ELSE
CUTI           VFRAIS(N,J,1) = 10.0D0
CUTI           VFRAIS(N,J,2) = 0.9D0
CUTI        ENDIF
C
CUTI     ENDDO
C
CUTI  ENDDO
C
CC
C
C***********************************************************************
C
C     5- IMPRESSION DE CONTROLE
C     =========================
C
      IF (LVERIF) THEN
C
         IF (NBFFLU.GT.0 .OR. NBDIRS.GT.0 .OR. NBFECH.GT.0) THEN
            WRITE(NFECRA,5000)
         ELSE
            WRITE(NFECRA,5001)
         ENDIF
C
C        Impression des flux
         IF (NBFFLU.GT.0) THEN
           WRITE(NFECRA,5010)
           DO 5051 N=1,NBFFLU
              DO 5052 J=1,NDMASS
                 WRITE(NFECRA,5050) NFFLUS(N),VFFLUS(N,J)
 5052         CONTINUE
 5051      CONTINUE
         ENDIF
C
C        Impression des Dirichlets
         IF (NBDIRS.GT.0) THEN
           WRITE(NFECRA,5020)
           WRITE(NFECRA,5050) (NDIRS(N),VDIRS(N),N=1,NBDIRS)
         ENDIF
C
C        Impression des conditions d'echange
         IF (NBFECH.GT.0) THEN
           WRITE(NFECRA,5030)
           DO 5061 N=1,NBFECH
              DO 5062 J=1,NDMASS
                  WRITE(NFECRA,5060) 
     &                 NFECHS(N),VFECHS(N,J,1),VFECHS(N,J,2)
 5062         CONTINUE
 5061      CONTINUE
         ENDIF
C
C        Impression des conditions de rayonnement infini
         IF (NBFRAI.GT.0) THEN
           WRITE(NFECRA,5040)
           DO 5071 N=1,NBFRAI
              DO 5072 J=1,NDMASS
                 WRITE(NFECRA,5060) 
     &                 NFRAIS(N),J,VFRAIS(N,J,1),VFRAIS(N,J,2)
 5072         CONTINUE
 5071      CONTINUE
         ENDIF
C
C        Impression des conditions de resistance de contact
         IF (NELERC.GT.0) THEN
           WRITE(NFECRA,5045)
           DO 5081 N=1,NELERC
              DO 5082 J=1,NDMASS
                 WRITE(NFECRA,5060) 
     &                 NFRESC(N),J,VFRESC(N,J,2)
 5082         CONTINUE
 5081      CONTINUE
         ENDIF
C
      ENDIF
C
C--------
C FORMATS
C--------
C
 5000 FORMAT(/,'  *** LIMFSO : IMPRESSION DES CONDITIONS AUX LIMITES')
 5001 FORMAT(/,'  *** LIMFSO : CONDITIONS AUX LIMITES = FLUX NUL')
 5010 FORMAT(/,'   - Condition de type flux',
     &                              ' (face, noeud, flux)')
 5020 FORMAT(/,'   - Condition de type Dirichlet (noeud, valeur)')
 5030 FORMAT(/,'   - Condition de type coeff echange',
     &                                   ' (face, noeud, T, h)')
 5040 FORMAT(/,'   - Condition de type rayonnement inifni',
     &                                   ' (face, noeud, Tnoir, sigma)')
 5045 FORMAT(/,'   - Condition de type resistance', 
     &                                   ' (face, noeud, resistance)')
 5050 FORMAT('(',I6,'-',I2,'-',G10.3,')')
 5060 FORMAT(I6,'--',I2,'--',G10.3,'--',G10.3)
C
C----
C FIN
C----
      END
